/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.BizExceptionSubItemInfo;

public class ExceptionCodeWriter
extends CodeWriterBase {
    private BizExceptionInfo bizException;

    public ExceptionCodeWriter(BizExceptionInfo bizExceptionInfo) {
        this.bizException = bizExceptionInfo;
    }

    private void writePackage() {
        this.out.append(this.writeNote("output package name", new String[0], ""));
        this.out.append("package ");
        this.out.append(this.getPackageName(this.bizException.getClassName()) + ';' + '\n');
        this.out.append('\n');
        this.out.append("import com.kingdee.util.NumericExceptionSubItem;\n");
        this.out.append("import ");
        if (this.bizException.getBaseException() != null) {
            this.out.append(this.bizException.getBaseException().getClassName() + ';');
            this.out.append('\n');
        } else {
            this.out.append("com.kingdee.util.NumericException;");
            this.out.append('\n');
        }
        this.out.append('\n');
    }

    private void writeClass() {
        this.out.append(this.writeNote("output class name", new String[0], ""));
        this.out.append("public" + this.addBlank("class"));
        this.out.append(this.getClassName(this.bizException.getClassName()));
        this.out.append(this.addBlank("extends"));
        if (this.bizException.getBaseException() != null) {
            this.out.append(this.getClassName(this.bizException.getBaseException().getClassName()));
        } else {
            this.out.append("NumericException");
        }
        this.out.append('\n');
    }

    private void writeConstruct(String functionBody, String methodBody, boolean flag) {
        this.out.append(this.tab + "public" + ' ');
        this.out.append(this.addBracket(this.getClassName(this.bizException.getClassName()), functionBody));
        this.writeBegin();
        this.tabAdd();
        if (flag) {
            this.out.append(this.tab + this.addBracketMethod("super", methodBody) + ';' + '\n');
        } else {
            this.out.append(this.tab + this.addBracketMethod("this", methodBody) + ';' + '\n');
        }
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
    }

    private void writeMainCode() {
        this.tabAdd();
        this.out.append(this.tab + "private" + this.addBlank("static") + "final" + this.addBlank("String"));
        this.out.append("MAINCODE" + this.addBlank("=") + this.addMark(this.bizException.getMainCode()) + ';' + '\n');
        this.out.append('\n');
        this.tabSub();
    }

    private void writeVariable() {
        this.tabAdd();
        int length = this.bizException.getBizExceptionSubItems().size();
        for (int i = 0; i < length; ++i) {
            BizExceptionSubItemInfo info = this.bizException.getBizExceptionSubItems().get(i);
            this.out.append(this.tab + "public" + this.addBlank("static") + "final" + this.addBlank("NumericExceptionSubItem"));
            this.out.append(info.getName().toUpperCase() + this.addBlank("="));
            this.out.append("new " + this.addBracketMethod("NumericExceptionSubItem", this.addMark(info.getSubCode()) + ',' + this.addMark(info.getName())) + ';' + '\n');
        }
        this.out.append('\n');
        this.out.append('\n');
        this.tabSub();
    }

    private void writeGetMainCode() {
        String[] params = null;
        this.tabAdd();
        params = new String[]{};
        this.out.append(this.writeNote("getMainCode function", params, ""));
        this.out.append(this.tab + "public" + this.addBlank("String"));
        this.out.append(this.addBracket("getMainCode", ""));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + " MAINCODE" + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
        this.tabSub();
    }

    private void writeAllConstruce() {
        String function = "";
        String arguments = "";
        String[] params = null;
        this.tabAdd();
        function = "NumericExceptionSubItem info,Throwable cause,Object[] params";
        arguments = "info,cause,params";
        params = new String[]{"NumericExceptionSubItem info", "Throwable cause", "Object[] params"};
        this.out.append(this.writeNote("construct function", params, ""));
        this.writeConstruct(function, arguments, true);
        function = "NumericExceptionSubItem info,Object[] params";
        arguments = "info,null,params";
        params = new String[]{"NumericExceptionSubItem info,Object[] params"};
        this.out.append(this.writeNote("construct function", params, ""));
        this.writeConstruct(function, arguments, false);
        function = "NumericExceptionSubItem info,Throwable cause";
        arguments = "info,cause,null";
        params = new String[]{"NumericExceptionSubItem info,Throwable cause"};
        this.out.append(this.writeNote("construct function", params, ""));
        this.writeConstruct(function, arguments, false);
        function = "NumericExceptionSubItem info";
        arguments = "info,null,null";
        params = new String[]{"NumericExceptionSubItem info"};
        this.out.append(this.writeNote("construct function", params, ""));
        this.writeConstruct(function, arguments, false);
        this.tabSub();
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.writeMainCode();
        this.writeVariable();
        this.writeAllConstruce();
        this.writeGetMainCode();
        this.writeEnd();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    @Override
    protected String getClassName() {
        return this.getClassName(this.bizException.getClassName());
    }
}

