/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.BizExceptionSubItemCollection;
import com.kingdee.util.Assert;
import java.util.Locale;

public class ExceptionResourceWriter
extends CodeWriterBase {
    private BizExceptionInfo bizInfo;
    private Locale locale;
    private Locale defaultLocale;

    public ExceptionResourceWriter(BizExceptionInfo bizEnInfo, Locale defaultLocale) {
        this(bizEnInfo, null, defaultLocale);
    }

    public ExceptionResourceWriter(BizExceptionInfo bizEnInfo, Locale locale, Locale defaultLocale) {
        this.bizInfo = bizEnInfo;
        this.locale = locale;
        Assert.that((defaultLocale != null ? 1 : 0) != 0);
        this.defaultLocale = defaultLocale;
        this.suffix = this.locale == null ? ".properties" : "_" + BOSLocaleUtil.getShortCode(locale) + ".properties";
    }

    @Override
    protected String getClassName() {
        return this.getClassName(this.bizInfo.getClassName());
    }

    private void writeMessage() {
        BizExceptionSubItemCollection subClasses = this.bizInfo.getBizExceptionSubItems();
        if (subClasses != null) {
            int length = subClasses.size();
            for (int i = 0; i < length; ++i) {
                this.out.append(this.saveConvert(subClasses.get(i).getName(), true));
                this.out.append('=');
                if (this.locale == null) {
                    this.out.append(this.saveConvert(subClasses.get(i).getMessage(), false));
                } else {
                    subClasses.get(i).setDefaultLocale(this.defaultLocale);
                    this.out.append(this.saveConvert(subClasses.get(i).getMessage(this.locale), false));
                }
                this.out.append('\n');
            }
        }
        this.out.append('\n');
    }

    @Override
    public void write(StringBuffer in) {
        this.writeMessage();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }
}

