/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.util.StringUtils;

public class FactoryCodeWrite
extends CodeWriterBase {
    private final String imp1 = "import com.kingdee.bos.BOSException";
    private final String imp2 = "import com.kingdee.bos.BOSObjectFactory";
    private final String imp3 = "import com.kingdee.bos.util.BOSObjectType";
    private final String imp4 = "import com.kingdee.bos.Context";
    BusinessObjectInfo bo;
    private static final String m1 = "getRemoteInstance";
    private static final String m2 = "getLocalInstance";

    public FactoryCodeWrite(BusinessObjectInfo bo) {
        this.bo = bo;
    }

    private String getFullName() {
        return this.bo.getBusinessImplFactory() == null ? "" : this.bo.getBusinessImplFactory();
    }

    @Override
    protected String getClassName() {
        if (StringUtils.isEmpty((String)this.bo.getBusinessControllerName())) {
            return "";
        }
        return this.getClassName(this.getFullName());
    }

    private String getInterfaceName() {
        return this.bo.getBusinessInterface() == null ? "" : this.bo.getBusinessInterface();
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeConstructor();
        this.writeMethods();
        this.tabSub();
        this.writeEnd();
    }

    private void writePackage() {
        String pa = this.getPackageName(this.getFullName());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n' + '\n');
        }
        this.out.append("import com.kingdee.bos.BOSException;\n");
        this.out.append("import com.kingdee.bos.BOSObjectFactory;\n");
        this.out.append("import com.kingdee.bos.util.BOSObjectType;\n");
        this.out.append("import com.kingdee.bos.Context;\n\n");
    }

    private void writeClass() {
        this.out.append("public ");
        this.out.append("class " + this.getClassName());
        this.out.append("\n");
    }

    private void writeConstructor() {
        this.out.append(this.tab + "private" + ' ' + this.getClassName() + '(' + ')' + '\n');
        this.writeBegin();
        this.writeEnd();
    }

    private void writeMethods() {
        this.out.append(this.tab + "public" + this.addBlank("static") + this.getInterfaceName() + ' ' + m1 + '(' + ')');
        this.out.append("throws BOSException\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + '(' + this.getInterfaceName() + ')');
        this.out.append("BOSObjectFactory.createRemoteBOSObject");
        this.out.append("(new BOSObjectType(\"" + this.bo.getType().toString() + '\"' + ')');
        this.out.append(',' + this.getInterfaceName() + '.' + "class" + ')');
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "public" + this.addBlank("static") + this.getInterfaceName() + ' ' + m2);
        this.out.append("(");
        this.out.append("Context ctx");
        this.out.append(")throws BOSException\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + '(' + this.getInterfaceName() + ')');
        this.out.append("BOSObjectFactory.createBOSObject");
        this.out.append("(ctx,new BOSObjectType(\"" + this.bo.getType().toString() + '\"' + ')' + ')');
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "public" + this.addBlank("static") + this.getInterfaceName() + ' ' + m2);
        this.out.append("(");
        this.out.append("String sessionID");
        this.out.append(")throws BOSException\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + '(' + this.getInterfaceName() + ')');
        this.out.append("BOSObjectFactory.createBOSObject");
        this.out.append("(sessionID,new BOSObjectType(\"" + this.bo.getType().toString() + '\"' + ')' + ')');
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
    }
}

