/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;

public class InfoCodeWriter
extends CodeWriterBase {
    private EntityObjectInfo en;
    private static final String imp1 = "import java.io.Serializable";

    public InfoCodeWriter(EntityObjectInfo en) {
        this.en = en;
    }

    public InfoCodeWriter(StringBuffer out) {
        super(out);
    }

    @Override
    protected String getClassName() {
        return this.getClassName(this.en.getObjectValueClass());
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.writeConstructor();
        this.writePkConstructor();
        this.writeEnd();
    }

    private void writeConstructor() {
        this.tabAdd();
        this.out.append(this.tab + "public" + ' ' + this.getClassName() + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
    }

    private void writePkConstructor() {
        this.tabAdd();
        this.out.append(this.tab + "protected" + ' ' + this.getClassName() + '(' + "String pkField" + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + "pkField" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
    }

    private void writePackage() {
        String pa = this.getPackageName(this.en.getObjectValueClass());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n');
            this.out.append('\n');
        }
        this.out.append("import java.io.Serializable;\n\n");
    }

    private void writeClass() {
        String subMode;
        String accLevel = this.en.getAccessLevel() == null ? "public" : this.en.getAccessLevel().getName();
        String string = subMode = this.en.getSubClassingMode() == null ? "" : this.en.getSubClassingMode().getName();
        if (subMode.equals("normal")) {
            subMode = "";
        }
        if (subMode.length() != 0) {
            this.out.append(subMode + ' ');
        }
        this.out.append(accLevel + ' ' + "class" + ' ');
        this.out.append(this.getClassName() + ' ');
        this.writeExtend();
        this.out.append("implements");
        this.out.append(this.addBlank("Serializable") + '\n');
    }

    private void writeExtend() {
        String infoName = "Abstract" + this.getClassName(this.en.getObjectValueClass());
        this.out.append("extends");
        this.out.append(this.addBlank(infoName));
    }
}

