/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.resource.I18nResourceInfo;
import com.kingdee.bos.metadata.resource.ResourceItemCollection;
import com.kingdee.util.Assert;
import java.util.Locale;

public class MultiLanguageWriter
extends CodeWriterBase {
    private I18nResourceInfo multiLanguageInfo;
    private Locale locale;
    private Locale defaultLocale;

    public MultiLanguageWriter(I18nResourceInfo multiInfo, Locale defaultLocale) {
        this(multiInfo, null, defaultLocale);
    }

    public MultiLanguageWriter(I18nResourceInfo multiInfo, Locale locale, Locale defaultLocale) {
        this.multiLanguageInfo = multiInfo;
        this.locale = locale;
        Assert.that((defaultLocale != null ? 1 : 0) != 0);
        this.defaultLocale = defaultLocale;
        this.suffix = this.locale == null ? ".properties" : "_" + BOSLocaleUtil.getShortCode(locale) + ".properties";
    }

    @Override
    protected String getClassName() {
        return this.getClassName(this.multiLanguageInfo.getClassName());
    }

    private void writeResource() {
        ResourceItemCollection itemCol = this.multiLanguageInfo.getItems();
        if (itemCol != null) {
            int length = itemCol.size();
            for (int i = 0; i < length; ++i) {
                this.out.append(this.saveConvert(itemCol.get(i).getLabel(), true));
                this.out.append('=');
                if (this.locale == null) {
                    this.out.append(this.saveConvert(itemCol.get(i).getValue(), false));
                } else {
                    itemCol.get(i).setDefaultLocale(this.defaultLocale);
                    this.out.append(this.saveConvert(itemCol.get(i).getValue(this.locale), false));
                }
                this.out.append('\n');
            }
        }
        this.out.append('\n');
    }

    @Override
    public void write(StringBuffer in) {
        this.writeResource();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }
}

