/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.code.CtrlCodeWriter;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.util.StringUtils;

public class ProxyCodeWriter
extends CtrlCodeWriter {
    private final String imp1 = "import com.kingdee.bos.framework.ejb.EJBRemoteException";
    private final String imp2 = "import com.kingdee.bos.util.BOSObjectType";
    private final String imp3 = "import java.rmi.RemoteException";
    private final String imp4 = "import com.kingdee.bos.framework.AbstractBizCtrl";
    private final String imp5 = "import com.kingdee.bos.orm.template.ORMObject";
    protected static final String CC_REG = "registerInterface";
    protected static final String CC_GTC = "getController";
    protected static final String CC_GCN = "getContext";

    public ProxyCodeWriter(BusinessObjectInfo bo) {
        super(bo);
    }

    @Override
    protected void writePackage() {
        this.impMap.put("import com.kingdee.bos.framework.ejb.EJBRemoteException", null);
        this.impMap.put("import com.kingdee.bos.util.BOSObjectType", null);
        this.impMap.put("import java.rmi.RemoteException", null);
        this.impMap.put("import com.kingdee.bos.framework.AbstractBizCtrl", null);
        this.impMap.put("import com.kingdee.bos.orm.template.ORMObject", null);
        String pa = this.getEJBPackage();
        if (pa.length() != 0) {
            this.impMap.put("import " + pa + '.' + "*", null);
        }
        super.writePackage();
    }

    @Override
    protected void addInheritPackageName() {
        String fullName;
        if (this.getBaseCtrlfullName().length() != 0 && this.needAddNew(this.getPackageName(fullName = this.getBaseCtrlfullName()), fullName)) {
            this.impMap.put("import " + fullName, null);
        }
        super.addInheritPackageName();
    }

    @Override
    protected String getBaseCtrlfullName() {
        FacadeInfo en;
        String name = "";
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en2 = (EntityObjectInfo)this.bo;
            if (en2.getBaseEntity() != null) {
                name = en2.getBaseEntity().getBusinessImplName() == null ? "" : en2.getBaseEntity().getBusinessImplName();
            }
        } else if (this.bo instanceof FacadeInfo && (en = (FacadeInfo)this.bo).getBaseFacade() != null) {
            name = en.getBaseFacade().getBusinessImplName() == null ? "" : en.getBaseFacade().getBusinessImplName();
        }
        return name;
    }

    @Override
    public String getClassName() {
        if (StringUtils.isEmpty((String)this.bo.getBusinessImplName())) {
            return "";
        }
        return this.getClassName(MetaDataUtils.getClassName(this.bo.getBusinessImplName()));
    }

    private String getEJBPackage() {
        String fullName = this.bo.getBusinessControllerName();
        if (fullName == null || fullName.length() == 0) {
            fullName = this.bo.getBusinessImplName();
        }
        return this.getPackageName(fullName);
    }

    private String getCtrlName() {
        return this.bo.getBusinessControllerName() == null ? "" : this.getClassName(this.bo.getBusinessControllerName());
    }

    protected String getBaseName() {
        FacadeInfo en;
        String name = "";
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en2 = (EntityObjectInfo)this.bo;
            if (en2.getBaseEntity() != null) {
                name = en2.getBaseEntity().getName() == null ? "" : en2.getBaseEntity().getName();
            }
        } else if (this.bo instanceof FacadeInfo && (en = (FacadeInfo)this.bo).getBaseFacade() != null) {
            name = en.getBaseFacade().getName() == null ? "" : en.getBaseFacade().getName();
        }
        return name;
    }

    @Override
    protected void writeClass() {
        this.out.append(this.getSubClassMode());
        if (this.getSubClassMode().length() != 0) {
            this.out.append(" ");
        }
        this.out.append("public class");
        this.out.append(this.addBlank(this.getClassName()));
        if (this.getBaseName().length() == 0) {
            this.out.append("extends" + this.addBlank("AbstractBizCtrl"));
        } else {
            this.out.append("extends" + this.addBlank(this.getClassName(this.getBaseCtrlfullName())));
        }
        this.out.append("implements " + super.getClassName() + '\n');
    }

    @Override
    protected void writeConstructor() {
        this.out.append(this.tab + "public" + ' ' + this.getClassName() + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + ')' + ';' + '\n');
        this.out.append(this.tab + CC_REG + '(' + super.getClassName() + '.' + "class" + ',' + "this" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        String para = "Context ctx";
        this.out.append(this.tab + "public" + ' ' + this.getClassName() + '(' + para + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + "ctx" + ')' + ';' + '\n');
        this.out.append(this.tab + CC_REG + '(' + super.getClassName() + '.' + "class" + ',' + "this" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        String bosType = "BOSObjectType";
        this.out.append(this.tab + "public" + this.addBlank(bosType) + "getType" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + this.addBlank("new") + bosType + '(' + '\"' + this.bo.getType().toString() + '\"' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "private" + this.addBlank(this.getCtrlName()) + CC_GTC + '(' + ')' + "throws" + ' ' + "BOSException" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + '(' + this.getCtrlName() + ')' + "getBizController" + '(' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    @Override
    protected void writeMethod(MethodInfo method) {
        this.writeMethodNote(method);
        TypeReference tp = method.getReturnValueType(this.bo);
        String name = this.getMethodName(method, this.bo);
        this.out.append(this.tab + "public" + this.addBlank(this.getClassName(tp.toString())));
        this.out.append(name);
        this.out.append("(");
        this.writeParams(method.getParameters());
        this.out.append(")");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(method.getBizExceptions());
        this.out.append("\n");
        this.writeBegin();
        this.tabAdd();
        this.writeTryBody(method);
        this.writeCatchBody();
        this.tabSub();
        this.writeEnd();
    }

    protected void writeTryBody(MethodInfo method) {
        this.out.append(this.tab + "try" + '\n');
        this.writeBegin();
        this.tabAdd();
        if (!method.getReturnValueType(this.bo).toString().equals("void")) {
            this.out.append(this.tab + "return" + ' ');
        } else {
            this.out.append(this.tab + "");
        }
        this.out.append("getController()." + this.getMethodName(method, this.bo));
        this.out.append("(");
        this.writeParameterInner(method.getParameters());
        this.out.append(")");
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
    }

    protected void writeParameterInner(ParameterCollection params) {
        this.out.append("getContext()");
        for (int i = 0; i < params.size(); ++i) {
            this.out.append(",");
            this.out.append(params.get(i).getName());
        }
    }

    protected void writeCatchBody() {
        this.out.append(this.tab + "catch" + '(' + "RemoteException" + ' ' + "err" + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "throw" + this.addBlank("new") + "EJBRemoteException" + '(' + "err" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }
}

