/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.jdt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.code.jdt.IJdtCodeWriter;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;

public abstract class AbstractJdtCodeWriter
implements IJdtCodeWriter {
    protected static final char CLF = '\n';
    protected static final char SEI = ';';
    protected static final char QUT = '\"';
    protected static final char LBR = '{';
    protected static final char RBR = '}';
    protected static final char LCR = '(';
    protected static final char RCR = ')';
    protected static final char DOT = '.';
    protected static final char EQLS = '=';
    protected static final char COMMA = ',';
    protected static final char BLANK = ' ';
    protected static final char UNDERLINE = '_';
    protected static final String KEY_PACAKAGE = "package";
    protected static final String KEY_CLASS = "class";
    protected static final String KEY_INTERFACE = "interface";
    protected static final String KEY_ABSTRACT = "abstract";
    protected static final String KEY_VOID = "void";
    protected static final String KEY_IMPORT = "import";
    protected static final String KEY_EXTENDS = "extends";
    protected static final String KEY_IMPLEMENTS = "implements";
    protected static final String KEY_RETURN = "return";
    protected static final String KEY_NEW = "new";
    protected static final String KEY_THROW = "throw";
    protected static final String KEY_THROWS = "throws";
    protected static final String KEY_TRY = "try";
    protected static final String KEY_CATCH = "catch";
    protected static final String KEY_FINALLY = "finally";
    protected static final String KEY_NORMAL = "normal";
    protected static final String KEY_DEFAULT = "default";
    protected static final String KEY_PUBLIC = "public";
    protected static final String KEY_PRIVATE = "private";
    protected static final String KEY_PROTECTED = "protected";
    protected static final String KEY_STATIC = "static";
    protected static final String KEY_FINAL = "final";
    protected static final String KEY_SUPER = "super";
    protected static final String KEY_THIS = "this";
    protected static final String KEY_INT = "int";
    protected BusinessObjectInfo bo = null;
    protected AST ast = null;
    protected CompilationUnit unit = null;
    protected boolean isInterface = false;
    protected StringBuffer writer = null;

    public AbstractJdtCodeWriter(BusinessObjectInfo bo) throws BOSException {
        if (bo == null) {
            throw new BOSException("The BusinessObject is null to be generate code.");
        }
        this.bo = bo;
        this.ast = new AST();
        this.unit = this.ast.newCompilationUnit();
        this.writer = new StringBuffer();
    }

    @Override
    public void write() {
    }

    protected int getModifiers(AccessLevel accessLevel, SubClassingMode subClassingMode) {
        int modifiers = 0;
        if (accessLevel == null) {
            accessLevel = AccessLevel.PUBLIC;
        }
        if (subClassingMode == null) {
            subClassingMode = SubClassingMode.NORMAL;
        }
        if (accessLevel.equals((Object)AccessLevel.PUBLIC)) {
            ++modifiers;
        } else if (accessLevel.equals((Object)AccessLevel.PRIVATE)) {
            modifiers += 2;
        } else if (accessLevel.equals((Object)AccessLevel.PROTECTED)) {
            modifiers += 4;
        }
        if (subClassingMode.equals((Object)SubClassingMode.ABSTRACT)) {
            modifiers += 1024;
        } else if (subClassingMode.equals((Object)SubClassingMode.FINAL)) {
            modifiers += 16;
        }
        return modifiers;
    }
}

