/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.templates.compiled;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class IInfoGenerator {
    protected static String nl;
    protected final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL;
    protected final String TEXT_3 = this.NL + "import com.kingdee.bos.dao.IObjectValue;" + this.NL + "import java.util.Locale;" + this.NL + "import com.kingdee.util.TypeConversionUtils;";
    protected final String TEXT_4 = this.NL + "import ";
    protected final String TEXT_5 = ".";
    protected final String TEXT_6 = ";";
    protected final String TEXT_7 = this.NL + this.NL + "public interface ";
    protected final String TEXT_8 = " extends ";
    protected final String TEXT_9 = "IObjectValue" + this.NL + "{";
    protected final String TEXT_10 = this.NL + "    /**" + this.NL + "     * ";
    protected final String TEXT_11 = " " + this.NL + "     */" + this.NL + "    public ";
    protected final String TEXT_12 = " ";
    protected final String TEXT_13 = "();" + this.NL + "    public void set";
    protected final String TEXT_14 = "(";
    protected final String TEXT_15 = " item);";
    protected final String TEXT_16 = this.NL + "    public String get";
    protected final String TEXT_17 = "(Locale local);" + this.NL + "    public void set";
    protected final String TEXT_18 = "(String item, Locale local);";
    protected final String TEXT_19 = this.NL + "    /**" + this.NL + "     * ";
    protected final String TEXT_20 = " " + this.NL + "     */" + this.NL + "    public ";
    protected final String TEXT_21 = " get";
    protected final String TEXT_22 = "();";
    protected final String TEXT_23 = this.NL + "    public void set";
    protected final String TEXT_24 = "(";
    protected final String TEXT_25 = " item);";
    protected final String TEXT_26 = this.NL + "}";
    private EntityObjectInfo entity;
    private HashMap setMap;
    private HashMap getMap;
    private HashMap mulLinkMap;
    private Context ctx = null;

    public static synchronized IInfoGenerator create(String lineSeparator) {
        nl = lineSeparator;
        IInfoGenerator result = new IInfoGenerator();
        nl = null;
        return result;
    }

    public void init(EntityObjectInfo en) {
        this.entity = en;
        this.initSetMap();
        this.initGetMap();
        this.initMulLinkPropMap();
        this.ctx = ContextManager.getContext();
    }

    private void initSetMap() {
        this.setMap = new HashMap();
        this.setMap.put(DataType.BOSUUID, "setBOSUuid");
        this.setMap.put(DataType.UUID, "setUuid");
        this.setMap.put(DataType.STRING, "setString");
        this.setMap.put(DataType.DECIMAL, "setBigDecimal");
        this.setMap.put(DataType.BOOLEAN, "setBoolean");
        this.setMap.put(DataType.BYTE, "setByte");
        this.setMap.put(DataType.SHORT, "setShort");
        this.setMap.put(DataType.INTEGER, "setInt");
        this.setMap.put(DataType.LONG, "setLong");
        this.setMap.put(DataType.FLOAT, "setFloat");
        this.setMap.put(DataType.DOUBLE, "setDouble");
        this.setMap.put(DataType.DATE, "setDate");
        this.setMap.put(DataType.TIME, "setTime");
        this.setMap.put(DataType.TIMESTAMP, "setTimestamp");
    }

    private void initGetMap() {
        this.getMap = new HashMap();
        this.getMap.put(DataType.BOSUUID, "getBOSUuid");
        this.getMap.put(DataType.UUID, "getUuid");
        this.getMap.put(DataType.STRING, "getString");
        this.getMap.put(DataType.DECIMAL, "getBigDecimal");
        this.getMap.put(DataType.BOOLEAN, "getBoolean");
        this.getMap.put(DataType.BYTE, "getByte");
        this.getMap.put(DataType.SHORT, "getShort");
        this.getMap.put(DataType.INTEGER, "getInt");
        this.getMap.put(DataType.LONG, "getLong");
        this.getMap.put(DataType.FLOAT, "getFloat");
        this.getMap.put(DataType.DOUBLE, "getDouble");
        this.getMap.put(DataType.DATE, "getDate");
        this.getMap.put(DataType.TIME, "getTime");
        this.getMap.put(DataType.TIMESTAMP, "getTimestamp");
    }

    private void initMulLinkPropMap() {
        this.mulLinkMap = new HashMap();
        PropertyCollection props = this.entity.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            RelationshipInfo rel;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || (rel = ((LinkPropertyInfo)prop).getRelationship()) == null || rel.getSupplierCardinality() == null || !rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) continue;
            this.mulLinkMap.put(prop.getName(), prop);
        }
    }

    private String getOwnerPropType(OwnPropertyInfo prop) {
        DataType dtype = prop.getDataType();
        String type = "";
        String temp = prop.getMetaDataRef();
        if (dtype.equals(DataType.ENUM)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IBizEnumCtrl bizEnumCtrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.BIZENUM);
                    type = bizEnumCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getClassName();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else if (dtype.equals(DataType.OBJECTVALUE)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IEntityObjectCtrl enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.ENTITY);
                    type = enCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getObjectValueClass();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else if (dtype.equals(DataType.OBJECTCOLLECTION)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IEntityObjectCtrl enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.ENTITY);
                    type = enCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getObjectCollectionClass();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else {
            type = dtype.getJavaTypeName();
        }
        return type;
    }

    private String getGetMethod(DataType type) {
        if (!this.getMap.containsKey(type)) {
            return "get";
        }
        return (String)this.getMap.get(type);
    }

    private String getSetMethod(DataType type) {
        if (!this.setMap.containsKey(type)) {
            return "put";
        }
        return (String)this.setMap.get(type);
    }

    private String getEnumSetMethod(TypeReference et) {
        if (et == null) {
            return null;
        }
        String method = "put";
        if (et.getEnumValueType().equals((Object)BizEnumValueType.DOUBLE)) {
            method = this.getSetMethod(DataType.DOUBLE);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.FLOAT)) {
            method = this.getSetMethod(DataType.FLOAT);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.INTEGER)) {
            method = this.getSetMethod(DataType.INTEGER);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.LONG)) {
            method = this.getSetMethod(DataType.LONG);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.STRING)) {
            method = this.getSetMethod(DataType.STRING);
        }
        return method;
    }

    private String getEnumGetMethod(TypeReference et) {
        if (et == null) {
            return null;
        }
        String method = "get";
        if (et.getEnumValueType().equals((Object)BizEnumValueType.DOUBLE)) {
            method = this.getGetMethod(DataType.DOUBLE);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.FLOAT)) {
            method = this.getGetMethod(DataType.FLOAT);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.INTEGER)) {
            method = this.getGetMethod(DataType.INTEGER);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.LONG)) {
            method = this.getGetMethod(DataType.LONG);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.STRING)) {
            method = this.getGetMethod(DataType.STRING);
        }
        return method;
    }

    private boolean isClient(LinkPropertyInfo prop) {
        RelationshipInfo rel = prop.getRelationship();
        if (rel.getSupplierObject() == null || rel.getClientObject() == null) {
            return false;
        }
        return rel.getClientObject().getFullName().equals(this.entity.getFullName()) || !rel.getSupplierObject().getFullName().equals(this.entity.getFullName());
    }

    private boolean isAvalibleLink(LinkPropertyInfo prop) {
        boolean isAvali = prop.getRelationship().getClientObject() != null && prop.getRelationship().getClientObject().getFullName().equals(this.entity.getFullName());
        return isAvali && this.isMulti(prop) || this.isCross(prop);
    }

    private boolean isMulti(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private boolean isCross(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private String getKeyPropertyName() {
        int i;
        PropertyCollection props = this.entity.getInheritedNoDuplicatedProperties();
        if (this.entity.getLogicalKey() == null || this.entity.getLogicalKey().getKeyPropertys().size() != 1) {
            return "";
        }
        PropertyCollection ps = this.entity.getLogicalKey().getKeyPropertys();
        HashMap pcm = new HashMap(ps.size());
        for (i = 0; i < ps.size(); ++i) {
            pcm.put(ps.get(i).getName(), null);
        }
        for (i = 0; i < props.size(); ++i) {
            OwnPropertyInfo ow;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof OwnPropertyInfo) || (ow = (OwnPropertyInfo)prop).getDataType() == null || !pcm.containsKey(ow.getName())) continue;
            return ow.getName();
        }
        return "";
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Object arg = argument;
        EntityObjectInfo entity = (EntityObjectInfo)arg;
        this.init(entity);
        String fullName = entity.getObjectValueClass();
        String packageName = MetaDataUtils.getPackageName(fullName);
        String className = MetaDataUtils.getClassName(fullName);
        if (packageName.length() != 0) {
            stringBuffer.append("package ");
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
        }
        stringBuffer.append(this.TEXT_3);
        BusinessObjectCollection boc = entity.getExtendStereoTypes();
        String strSteroExts = "";
        if (boc != null && boc.size() > 0) {
            for (int i = 0; i < boc.size(); ++i) {
                BusinessObjectInfo currBo = boc.get(i);
                if (!(currBo instanceof EntityObjectInfo)) continue;
                EntityObjectInfo currEntity = (EntityObjectInfo)currBo;
                String fullName2 = currEntity.getObjectValueClass();
                String packageName2 = MetaDataUtils.getPackageName(fullName2);
                String className2 = MetaDataUtils.getClassName(fullName2);
                strSteroExts = strSteroExts + className2 + ", ";
                stringBuffer.append(this.TEXT_4);
                stringBuffer.append(packageName2);
                stringBuffer.append(".");
                stringBuffer.append(className2);
                stringBuffer.append(";");
            }
        }
        stringBuffer.append(this.TEXT_7);
        stringBuffer.append(className);
        stringBuffer.append(" extends ");
        stringBuffer.append(strSteroExts);
        stringBuffer.append(this.TEXT_9);
        PropertyCollection props = entity.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            LinkPropertyInfo linkProp;
            RelationshipInfo rel;
            PropertyInfo prop = props.get(i);
            String name = prop.getName();
            String upcastName = "";
            if (name != null && name.length() > 0) {
                upcastName = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
            }
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                DataType dtype = ownProp.getDataType();
                String type = this.getOwnerPropType(ownProp);
                boolean isBooleanProp = ownProp.getDataType().equals(DataType.BOOLEAN);
                boolean isEnum = dtype == DataType.ENUM;
                stringBuffer.append(this.TEXT_10);
                stringBuffer.append("Object:" + entity.getAlias() + "'s " + ownProp.getAlias() + "property");
                stringBuffer.append(this.TEXT_11);
                stringBuffer.append(type);
                stringBuffer.append(" ");
                stringBuffer.append(isBooleanProp ? "is" + upcastName : "get" + upcastName);
                stringBuffer.append(this.TEXT_13);
                stringBuffer.append(upcastName);
                stringBuffer.append("(");
                stringBuffer.append(type);
                stringBuffer.append(" item);");
                if (!ownProp.isMultilingual() || !ownProp.getDataType().equals(DataType.STRING)) continue;
                stringBuffer.append(this.TEXT_16);
                stringBuffer.append(upcastName);
                stringBuffer.append(this.TEXT_17);
                stringBuffer.append(upcastName);
                stringBuffer.append("(String item, Locale local);");
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo) || (rel = (linkProp = (LinkPropertyInfo)prop).getRelationship()).getSupplierObject() == null || rel.getClientObject() == null) continue;
            boolean isMulti = false;
            EntityObjectInfo se = rel.getSupplierObject();
            if (se == null) continue;
            String type = "";
            type = (rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) && this.isClient(linkProp) ? se.getObjectCollectionClass() : se.getObjectValueClass();
            isMulti = this.isCross(linkProp);
            if (isMulti) {
                type = se.getObjectCollectionClass();
            }
            stringBuffer.append(this.TEXT_19);
            stringBuffer.append("Object: " + entity.getAlias() + " 's " + linkProp.getAlias() + " property");
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append(type);
            stringBuffer.append(" get");
            stringBuffer.append(upcastName);
            stringBuffer.append("();");
            if (rel.getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && rel.getSupplierCardinality() != CardinalityType.ONE && this.isClient(linkProp) || isMulti) continue;
            stringBuffer.append(this.TEXT_23);
            stringBuffer.append(upcastName);
            stringBuffer.append("(");
            stringBuffer.append(type);
            stringBuffer.append(" item);");
        }
        stringBuffer.append(this.TEXT_26);
        return stringBuffer.toString();
    }
}

