/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.translate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.code.internal.ASTFlattener;
import com.kingdee.bos.metadata.code.translate.JdtBosTranslator;
import com.kingdee.bos.metadata.code.translate.TranslateException;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XField;
import xjavadoc.XMethod;
import xjavadoc.XTag;
import xjavadoc.filesystem.AbstractFile;

public class EntityTranslator
extends JdtBosTranslator {
    private XClass xClass;

    @Override
    protected AbstractMetaDataValue getMetaData(CompilationUnit unit) {
        EntityObjectInfo entity = new EntityObjectInfo();
        entity = this.assignEntity(unit, entity);
        return entity;
    }

    @Override
    public String transBos2Jdt(AbstractMetaDataValue metaData) throws TranslateException {
        EntityObjectInfo entity = null;
        String result = "";
        if (!(metaData instanceof EntityObjectInfo)) {
            return result;
        }
        entity = (EntityObjectInfo)metaData;
        try {
            CompilationUnit unit = this.constructClass(entity);
            ASTFlattener flattener = new ASTFlattener();
            flattener.visit(unit);
            result = flattener.getFormattedResult(0, "\r\n");
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
        return result;
    }

    private EntityObjectInfo assignEntity(CompilationUnit unit, EntityObjectInfo entity) {
        List types = unit.types();
        if (types.isEmpty()) {
            return null;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        if (typeDeclaration == null) {
            return null;
        }
        this.packageName = this.getPackageName(unit);
        entity.setPackage(this.packageName);
        this.imports = unit.imports();
        this.assignClass(typeDeclaration, entity);
        this.assignFields(typeDeclaration, entity);
        this.assignMethods(typeDeclaration, entity);
        return entity;
    }

    private void assignClass(TypeDeclaration typeDeclaration, EntityObjectInfo entity) {
        boolean isInterface = typeDeclaration.isInterface();
        int typeModifier = typeDeclaration.getModifiers();
        if (Modifier.isAbstract((int)typeModifier)) {
            entity.setAbstract(true);
        } else {
            entity.setAbstract(false);
        }
        entity.setAccessLevel(AccessLevel.getEnum(this.getAccessLevel(typeModifier)));
        entity.setSubClassingMode(SubClassingMode.getEnum(this.getSubClassingMode(typeModifier)));
        SimpleName typeName = typeDeclaration.getName();
        entity.setName(typeName.toString());
        String qName = this.packageName + "." + typeName.getIdentifier();
        super.getXJavaDoc().reset(false);
        super.getXJavaDoc().addAbstractFile(qName, (AbstractFile)this.xJavadocFile);
        this.xClass = super.getXJavaDoc().getXClass(qName);
        XDoc xDoc = this.xClass.getDoc();
        String comment = xDoc.getCommentText();
        if (comment != null) {
            entity.setDescription(comment);
        }
        for (XTag xTag : xDoc.getTags()) {
            String name = xTag.getName();
            String value = xTag.getValue();
            if (name.equalsIgnoreCase("alias")) {
                entity.setAlias(value);
                continue;
            }
            if (name.equalsIgnoreCase("stereotype")) continue;
            entity.setExtendedProperty("[Javadoc]" + name, value);
        }
        Name superName = typeDeclaration.getSuperclass();
        EntityObjectInfo baseEntity = new EntityObjectInfo();
        if (superName != null) {
            String sName = superName.toString();
            if (sName.indexOf(".") > 0) {
                baseEntity.setName(sName.substring(sName.lastIndexOf(".")));
                baseEntity.setPackage(sName.substring(0, sName.lastIndexOf(".")));
            } else {
                baseEntity.setName(sName);
                if (!this.imports.isEmpty()) {
                    for (ImportDeclaration importDeclaration : this.imports) {
                        String importName = importDeclaration.getName().toString();
                        if (importName.indexOf(sName) <= 0) continue;
                        baseEntity.setPackage(importName.substring(0, importName.length() - sName.length() - 1));
                    }
                }
            }
            entity.setBaseEntity(baseEntity);
        }
    }

    private void assignFields(TypeDeclaration typeDeclaration, EntityObjectInfo entity) {
        FieldDeclaration[] fields = typeDeclaration.getFields();
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                FieldDeclaration field = fields[i];
                int fieldModifier = field.getModifiers();
                Type fieldType = field.getType();
                List fieldNames = field.fragments();
                if (fieldNames.isEmpty()) continue;
                for (VariableDeclarationFragment var : fieldNames) {
                    XField xField;
                    String fieldName = var.toString();
                    int dimension = var.getExtraDimensions();
                    Expression initializer = var.getInitializer();
                    if (this.xClass == null || fieldName == null || (xField = this.xClass.getField(fieldName)) == null) continue;
                    XDoc xDoc = xField.getDoc();
                    if (xDoc.hasTag("clientCardinality") || xDoc.hasTag("supplierCardinality")) {
                        this.assignLinkPropertyInfo(xDoc, fieldName, fieldType, entity);
                        continue;
                    }
                    this.assignOwnPropertyInfo(xDoc, fieldName, fieldType, entity);
                }
            }
        }
    }

    private void assignLinkPropertyInfo(XDoc xDoc, String fieldName, Type fieldType, EntityObjectInfo entity) {
        EntityObjectInfo relationEntity;
        LinkPropertyInfo prop = new LinkPropertyInfo();
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.setPackage(this.packageName);
        String newFieldName = "";
        newFieldName = fieldName;
        String fType = "";
        if (fieldType != null) {
            fType = fieldType.toString();
        }
        relationshipInfo.setName("R_" + entity.getName() + "_" + fType + "_" + newFieldName);
        relationshipInfo.setType(RelationshipType.ASSOCIATION);
        String comment = xDoc.getCommentText();
        for (XTag xTag : xDoc.getTags()) {
            EntityObjectInfo relationEntity2;
            String value;
            String name = xTag.getName();
            String string = value = StringUtils.isEmpty((String)xTag.getValue()) ? "1" : xTag.getValue();
            if (name.equalsIgnoreCase("clientCardinality")) {
                relationshipInfo.setClientCardinality(CardinalityType.getEnum(value));
                relationEntity2 = new EntityObjectInfo();
                relationEntity2.setPackage(this.packageName);
                relationEntity2.setName(entity.getName());
                relationshipInfo.setClientObject(relationEntity2);
                continue;
            }
            if (name.equalsIgnoreCase("supplierCardinality")) {
                relationshipInfo.setSupplierCardinality(CardinalityType.getEnum(value));
                relationEntity2 = new EntityObjectInfo();
                relationEntity2.setPackage(this.packageName);
                relationEntity2.setName(fieldType.toString());
                relationshipInfo.setSupplierObject(relationEntity2);
                continue;
            }
            if (name.equalsIgnoreCase("link")) {
                if (value.equalsIgnoreCase("aggregation") || !value.equalsIgnoreCase("aggregationByValue")) continue;
                relationshipInfo.setType(RelationshipType.COMPOSITION);
                continue;
            }
            prop.setExtendedProperty("[Javadoc]" + name, value);
        }
        if (relationshipInfo.getSupplierObject() == null && relationshipInfo.getClientObject() != null) {
            relationshipInfo.setSupplierCardinality(CardinalityType.getEnum("1"));
            relationEntity = new EntityObjectInfo();
            relationEntity.setPackage(this.packageName);
            relationEntity.setName(fieldType.toString());
            relationshipInfo.setSupplierObject(relationEntity);
        }
        if (relationshipInfo.getClientObject() == null && relationshipInfo.getSupplierObject() != null) {
            relationshipInfo.setClientCardinality(CardinalityType.getEnum("1"));
            relationEntity = new EntityObjectInfo();
            relationEntity.setPackage(this.packageName);
            relationEntity.setName(entity.getName());
            relationshipInfo.setClientObject(relationEntity);
        }
        prop.setName(fieldName);
        prop.setRelationship(relationshipInfo);
        prop.setDescription(comment);
        entity.getProperties().add(prop);
    }

    private void assignOwnPropertyInfo(XDoc xDoc, String fieldName, Type fieldType, EntityObjectInfo entity) {
        OwnPropertyInfo prop = new OwnPropertyInfo();
        prop.setName(fieldName);
        prop.setDataType(DataType.getEnum(fieldType.toString()));
        String comment = xDoc.getCommentText();
        prop.setDescription(comment);
        for (XTag xTag : xDoc.getTags()) {
            String name = xTag.getName();
            String value = xTag.getValue();
            prop.setExtendedProperty("[Javadoc]" + name, value);
        }
        entity.getProperties().add(prop);
    }

    private void assignMethods(TypeDeclaration typeDeclaration, EntityObjectInfo entity) {
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        if (methods != null && methods.length > 0) {
            for (int i = 0; i < methods.length; ++i) {
                List exceptions;
                MethodInfo methodInfo = new MethodInfo();
                MethodDeclaration method = methods[i];
                int methodModifier = method.getModifiers();
                methodInfo.setAccessLevel(AccessLevel.getEnum(this.getAccessLevel(methodModifier)));
                methodInfo.setSubClassingMode(SubClassingMode.getEnum(this.getSubClassingMode(methodModifier)));
                Type methodType = method.getReturnType();
                int methodDimension = method.getExtraDimensions();
                String typeReference = this.constructDataTypeArray(methodType, methodDimension);
                methodInfo.setDataType(typeReference);
                SimpleName methodName = method.getName();
                methodInfo.setName(methodName.toString());
                boolean isConstructor = method.isConstructor();
                List parameters = method.parameters();
                if (!parameters.isEmpty()) {
                    for (SingleVariableDeclaration parameter : parameters) {
                        ParameterInfo parameterInfo = new ParameterInfo();
                        parameterInfo.setName(parameter.getName().toString());
                        int paramDimension = parameter.getExtraDimensions();
                        Type paramType = parameter.getType();
                        String paraType = this.constructDataTypeArray(paramType, paramDimension);
                        parameterInfo.setDataType(paraType);
                        methodInfo.getParameters().add(parameterInfo);
                    }
                }
                if (!(exceptions = method.thrownExceptions()).isEmpty()) {
                    for (Object o : exceptions) {
                        BizExceptionInfo exceptionInfo = new BizExceptionInfo();
                        exceptionInfo.setPackage(this.packageName);
                        exceptionInfo.setName(o.toString());
                        exceptionInfo.setClassName(this.packageName + "." + o.toString());
                        methodInfo.getBizExceptions().add(exceptionInfo);
                    }
                }
                entity.getMethods().add(methodInfo);
            }
            if (this.xClass != null && this.xClass.getMethods() != null) {
                for (XMethod xMethod : this.xClass.getMethods()) {
                    if (xMethod == null) continue;
                    XDoc xDoc = xMethod.getDoc();
                    MethodInfo methodInfo = this.getMethodInfoFrom(entity, xMethod);
                    if (methodInfo == null) continue;
                    String comment = xDoc.getCommentText();
                    for (XTag xTag : xDoc.getTags()) {
                        String name = xTag.getName();
                        String value = xTag.getValue();
                        if (!name.equalsIgnoreCase("alias")) continue;
                        methodInfo.setAlias(value);
                        break;
                    }
                    methodInfo.setDescription(comment);
                }
            }
        }
    }

    private MethodInfo getMethodInfoFrom(EntityObjectInfo entity, XMethod xMethod) {
        if (entity == null) {
            return null;
        }
        String mName = xMethod.getName();
        String signature = xMethod.getSignature(false);
        signature = signature.substring(1, signature.length() - 1) + ",";
        Iterator mInfos = entity.getMethods().iterator();
        while (mInfos.hasNext()) {
            MethodInfo mInfo = (MethodInfo)mInfos.next();
            if (!mInfo.getName().equals(mName)) continue;
            StringBuffer signature2 = new StringBuffer();
            Iterator it = mInfo.getParameters().iterator();
            while (it.hasNext()) {
                ParameterInfo p = (ParameterInfo)it.next();
                signature2.append(p.getDataType()).append(",");
            }
            if (signature.equals(signature2.toString())) {
                signature2 = null;
                return mInfo;
            }
            signature2 = null;
        }
        return null;
    }

    private CompilationUnit constructClass(EntityObjectInfo entity) throws TranslateException {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("org.eclipse.jdt.core.compiler.source", "1.4");
            AST ast = new AST(m);
            CompilationUnit unit = ast.newCompilationUnit();
            PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
            String[] packageNames = StringUtils.split((String)entity.getPackage(), (String)".");
            Object packageName = null;
            packageName = packageNames != null && packageNames.length > 1 ? ast.newName(packageNames) : (!entity.getPackage().equals("") ? ast.newSimpleName(entity.getPackage()) : ast.newSimpleName("default"));
            packageDeclaration.setName(packageName);
            unit.setPackage(packageDeclaration);
            TypeDeclaration type = ast.newTypeDeclaration();
            type.setInterface(false);
            String accessLevel = entity.getAccessLevel().getName();
            String subClassingMode = entity.getSubClassingMode().getName();
            int modifier = this.getModifiers(accessLevel, subClassingMode);
            type.setModifiers(modifier);
            type.setName(ast.newSimpleName(entity.getName()));
            EntityObjectInfo baseEntity = entity.getBaseEntity();
            if (baseEntity != null) {
                if (baseEntity.getName().indexOf(".") > 0) {
                    String[] baseNames = StringUtils.split((String)baseEntity.getName(), (String)".");
                    type.setSuperclass(ast.newName(baseNames));
                } else {
                    type.setSuperclass((Name)ast.newSimpleName(baseEntity.getName()));
                }
            }
            PropertyCollection propertys = entity.getProperties();
            Iterator itProp = propertys.iterator();
            while (itProp.hasNext()) {
                PropertyInfo propertyInfo = (PropertyInfo)itProp.next();
                this.addField(type, entity, propertyInfo);
            }
            MethodCollection methods = entity.getMethods();
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                MethodInfo methodInfo = (MethodInfo)it.next();
                this.addMethod(type, methodInfo);
            }
            Javadoc topComment = ast.newJavadoc();
            topComment.setComment(this.getTypeJavadoc(entity));
            type.setJavadoc(topComment);
            unit.types().add(type);
            return unit;
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
    }

    private void addField(TypeDeclaration type, EntityObjectInfo entity, PropertyInfo propertyInfo) throws TranslateException {
        try {
            String alias;
            AST ast = type.getAST();
            VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(ast.newSimpleName(propertyInfo.getName()));
            FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(variableDeclarationFragment);
            StringBuffer comment = new StringBuffer("\n\n/**");
            String description = propertyInfo.getDescription();
            if (description != null && description.length() > 0) {
                StringTokenizer st = new StringTokenizer(description);
                while (st.hasMoreTokens()) {
                    comment.append("\n* ").append(st.nextToken());
                }
            }
            if ((alias = propertyInfo.getAlias()) != null && alias.length() > 0) {
                comment.append("\n* @alias ").append(alias);
            }
            for (String key : propertyInfo.getExtendedProperties().keySet()) {
                if (!key.startsWith("[Javadoc]") || key.indexOf("_") != -1) continue;
                String tag = key.substring("[Javadoc]".length());
                String value = (String)entity.getExtendedProperties().get(key);
                if (value == null) {
                    value = "";
                }
                comment.append("\n* @").append(tag).append(" ").append(value);
            }
            if (propertyInfo instanceof OwnPropertyInfo) {
                DataType dataType = ((OwnPropertyInfo)propertyInfo).getDataType();
                fieldDeclaration.setType(this.getType(dataType.getName(), ast));
                comment.append("\n*").append("\n*/");
            } else if (propertyInfo instanceof LinkPropertyInfo) {
                RelationshipInfo relationshipInfo = ((LinkPropertyInfo)propertyInfo).getRelationship();
                if (relationshipInfo == null) {
                    return;
                }
                RelationshipType relationshipType = relationshipInfo.getType();
                String supplierType = relationshipInfo.getSupplierObject().getName();
                String clientType = relationshipInfo.getClientObject().getName();
                Type dataType = null;
                String clientCardinality = relationshipInfo.getClientCardinality().getName();
                String supplierCardinality = relationshipInfo.getSupplierCardinality().getName();
                if (relationshipType.equals((Object)RelationshipType.COMPOSITION)) {
                    comment.append("\n* @link aggregationByValue");
                }
                if (entity.getName().equals(supplierType)) {
                    dataType = this.getType(clientType, ast);
                    comment.append("\n* @clientCardinality ").append(supplierCardinality).append("\n* @supplierCardinality ").append(clientCardinality).append("\n*/");
                } else {
                    dataType = this.getType(supplierType, ast);
                    comment.append("\n* @clientCardinality ").append(clientCardinality).append("\n* @supplierCardinality ").append(supplierCardinality).append("\n*/");
                }
                fieldDeclaration.setType(dataType);
            }
            Javadoc javaDoc = ast.newJavadoc();
            javaDoc.setComment(comment.toString());
            fieldDeclaration.setJavadoc(javaDoc);
            fieldDeclaration.setModifiers(1);
            type.bodyDeclarations().add(fieldDeclaration);
        }
        catch (IllegalArgumentException e) {
            TranslateException se = new TranslateException("\u53c2\u6570\u9519\u8bef");
            throw se;
        }
    }

    private void addMethod(TypeDeclaration type, MethodInfo methodInfo) {
        AST ast = type.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String methodName = methodInfo.getName();
        String accessLevel = methodInfo.getAccessLevel().getName();
        String subClassingMode = methodInfo.getSubClassingMode().getName();
        String dataType = methodInfo.getDataType();
        if (methodName.equals(type.getName().toString())) {
            methodDeclaration.setConstructor(true);
        } else {
            methodDeclaration.setConstructor(false);
        }
        methodDeclaration.setModifiers(this.getModifiers(accessLevel, subClassingMode));
        methodDeclaration.setName(ast.newSimpleName(methodName));
        methodDeclaration.setReturnType(this.getType(dataType, ast));
        StringBuffer comment = this.getMethodJavadocHeader(methodInfo);
        ParameterCollection parameters = methodInfo.getParameters();
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)it.next();
            SingleVariableDeclaration variableDeclaration = ast.newSingleVariableDeclaration();
            variableDeclaration.setModifiers(0);
            variableDeclaration.setType(this.getType(parameterInfo.getDataType(), ast));
            variableDeclaration.setName(ast.newSimpleName(parameterInfo.getName()));
            methodDeclaration.parameters().add(variableDeclaration);
            comment.append("\n* @param " + parameterInfo.getName());
        }
        Iterator itException = methodInfo.getBizExceptions().iterator();
        while (itException.hasNext()) {
            BizExceptionInfo bizExceptionInfo = (BizExceptionInfo)itException.next();
            if (bizExceptionInfo.getName().indexOf(".") > 0) {
                String[] eName = StringUtils.split((String)bizExceptionInfo.getName(), (String)".");
                methodDeclaration.thrownExceptions().add(ast.newName(eName));
            } else {
                methodDeclaration.thrownExceptions().add(ast.newSimpleName(bizExceptionInfo.getName()));
            }
            comment.append("\n* @throws " + bizExceptionInfo.getName());
        }
        comment.append("\n*\n*/");
        Javadoc javaDoc = ast.newJavadoc();
        javaDoc.setComment(comment.toString());
        methodDeclaration.setJavadoc(javaDoc);
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        type.bodyDeclarations().add(methodDeclaration);
    }
}

