/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.ui;

import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.model.layout.BorderLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import java.awt.Rectangle;

public final class UICodeWriterHelper {
    private static final char CLF = '\n';
    private static UICodeWriterHelper instance;

    private UICodeWriterHelper() {
    }

    public static final UICodeWriterHelper getInstance() {
        if (instance == null) {
            instance = new UICodeWriterHelper();
        }
        return instance;
    }

    public void generateInitUIContentLayoutCode(StringBuffer out, UIObjectInfo model, String tab) {
        Object mainPanelCons;
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() != 3) {
            return;
        }
        ComponentInfo mainPanel = collection.get(0);
        if (mainPanel == null || !"com.kingdee.bos.ctrl.swing.KDPanel".equals(mainPanel.getClassType())) {
            return;
        }
        AbstractCodeWriter codeWriter = new AbstractCodeWriter(out);
        codeWriter.setTab(tab);
        LayoutInfo layoutInfo = mainPanel.getLayoutInfo();
        String layoutType = null;
        if (layoutInfo != null) {
            layoutType = layoutInfo.getType();
        }
        if ((mainPanelCons = mainPanel.getConstraint()) != null && mainPanelCons instanceof Rectangle) {
            Rectangle rect = (Rectangle)mainPanelCons;
            codeWriter.append(codeWriter.getTab() + "this.setBounds(new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));" + '\n');
        }
        this.generateLayoutCode(codeWriter, "this", mainPanel.getClassType(), layoutInfo, layoutType, mainPanel.getConstraint());
        this.generateChildControlCode(codeWriter, "this", mainPanel.getClassType(), mainPanel.getComponents(), layoutType);
        this.recursiveGenInitUIContentLayoutCode(codeWriter, mainPanel.getComponents());
    }

    public void generateInitUIToolBarLayoutCode(StringBuffer out, UIObjectInfo model, String tab) {
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() != 3) {
            return;
        }
        ComponentInfo toolBar = collection.get(1);
        if (toolBar == null || !"com.kingdee.bos.ctrl.swing.KDToolBar".equals(toolBar.getClassType())) {
            return;
        }
        AbstractCodeWriter codeWriter = new AbstractCodeWriter(out);
        codeWriter.setTab(tab);
        this.generateFlowLayoutCode(codeWriter, "this.toolBar", toolBar.getComponents(), "");
        this.recursiveGenInitUIBarLayoutCode(codeWriter, toolBar.getComponents());
    }

    public void generateInitUIMenuBarLayoutCode(StringBuffer out, UIObjectInfo model, String tab) {
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() != 3) {
            return;
        }
        ComponentInfo menuBar = collection.get(2);
        if (menuBar == null || !"com.kingdee.bos.ctrl.swing.KDMenuBar".equals(menuBar.getClassType())) {
            return;
        }
        AbstractCodeWriter codeWriter = new AbstractCodeWriter(out);
        codeWriter.setTab(tab);
        this.generateFlowLayoutCode(codeWriter, "this.menuBar", menuBar.getComponents(), "");
        this.recursiveGenInitUIBarLayoutCode(codeWriter, menuBar.getComponents());
    }

    private void recursiveGenInitUIContentLayoutCode(AbstractCodeWriter codeWriter, ComponentCollection childCollection) {
        if (childCollection == null || childCollection.size() == 0) {
            return;
        }
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (!childComponent.isContainer()) continue;
            LayoutInfo layoutInfo = childComponent.getLayoutInfo();
            String layoutType = null;
            if (layoutInfo != null) {
                layoutType = layoutInfo.getType();
            }
            codeWriter.append(codeWriter.getTab() + '\n');
            if (childComponent.isContainer() && childComponent.getComponents().size() > 0) {
                codeWriter.append(codeWriter.getTab() + "//" + childComponent.getName() + '\n');
            }
            this.generateLayoutCode(codeWriter, childComponent.getName(), childComponent.getClassType(), layoutInfo, layoutType, childComponent.getConstraint());
            this.generateChildControlCode(codeWriter, childComponent.getName(), childComponent.getClassType(), childComponent.getComponents(), layoutType);
            this.recursiveGenInitUIContentLayoutCode(codeWriter, childComponent.getComponents());
        }
    }

    private void recursiveGenInitUIBarLayoutCode(AbstractCodeWriter codeWriter, ComponentCollection childCollection) {
        if (childCollection == null || childCollection.size() == 0) {
            return;
        }
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (!childComponent.isContainer()) continue;
            LayoutInfo layoutInfo = childComponent.getLayoutInfo();
            String layoutType = null;
            if (layoutInfo != null) {
                layoutType = layoutInfo.getType();
            }
            if (childComponent.isContainer() && childComponent.getComponents().size() > 0) {
                codeWriter.append(codeWriter.getTab() + '\n');
                codeWriter.append(codeWriter.getTab() + "//" + childComponent.getName() + '\n');
            }
            this.generateFlowLayoutCode(codeWriter, childComponent.getName(), childComponent.getComponents(), "");
            this.recursiveGenInitUIBarLayoutCode(codeWriter, childComponent.getComponents());
        }
    }

    private void generateLayoutCode(AbstractCodeWriter codeWriter, String parentName, String parentClassType, LayoutInfo layoutInfo, String layoutType, Object constraint) {
        if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDTreeView".equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDSplitPane".equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(parentClassType)) {
            return;
        }
        if ("com.kingdee.bos.ctrl.swing.KDContainer".equals(parentClassType)) {
            this.generateLayoutCode(codeWriter, parentName, parentClassType, layoutInfo, layoutType, constraint, ".getContentPane()");
        } else {
            this.generateLayoutCode(codeWriter, parentName, parentClassType, layoutInfo, layoutType, constraint, "");
        }
    }

    private void generateLayoutCode(AbstractCodeWriter codeWriter, String parentName, String parentClassType, LayoutInfo layoutInfo, String layoutType, Object constraint, String specialStr) {
        if (layoutType == null || "XYLayout".equals(layoutType)) {
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".setLayout(null);\n");
        } else if ("KDLayout".equals(layoutType)) {
            Object tempCons = constraint;
            String strOriginalBounds = null;
            if (tempCons != null && (tempCons instanceof Rectangle || tempCons instanceof KDLayoutConstraint)) {
                if (tempCons instanceof Rectangle) {
                    strOriginalBounds = ".putClientProperty(\"OriginalBounds\", new Rectangle(" + ((Rectangle)tempCons).x + ", " + ((Rectangle)tempCons).y + ", " + ((Rectangle)tempCons).width + ", " + ((Rectangle)tempCons).height + "));";
                } else if (tempCons instanceof KDLayoutConstraint) {
                    strOriginalBounds = ".putClientProperty(\"OriginalBounds\", new Rectangle(" + ((KDLayoutConstraint)tempCons).x + ", " + ((KDLayoutConstraint)tempCons).y + ", " + ((KDLayoutConstraint)tempCons).width + ", " + ((KDLayoutConstraint)tempCons).height + "));";
                }
            }
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".setLayout(new KDLayout());\n");
            if (strOriginalBounds != null) {
                codeWriter.append(codeWriter.getTab() + parentName + specialStr + strOriginalBounds + '\n');
            } else {
                codeWriter.append(codeWriter.getTab() + "//TODO \u7531\u4e8e\u8be5\u5bb9\u5668\u91c7\u7528KDLayout\u5e03\u5c40\uff0c\u8bf7\u5728\u4e0b\u9762\u4e00\u6761\u8bed\u53e5\u4e2d\u4fee\u6b63\u8be5\u5bb9\u5668\u7684\u521d\u59cb\u5927\u5c0f\uff1a\n");
                codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".putClientProperty(\"OriginalBounds\", new Rectangle(0,0,1,1));\n");
            }
        } else if ("BorderLayout".equals(layoutType)) {
            Layout tempLayout = LayoutConverter.convertToLayoutObj(layoutInfo);
            int hgap = 0;
            int vgap = 0;
            if (tempLayout instanceof BorderLayout) {
                hgap = ((BorderLayout)tempLayout).getHgap();
                vgap = ((BorderLayout)tempLayout).getVgap();
            }
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".setLayout(new BorderLayout(" + hgap + ", " + vgap + "));\n");
        }
    }

    private void generateChildControlCode(AbstractCodeWriter codeWriter, String parentName, String parentClassType, ComponentCollection childCollection, String layoutType) {
        if (childCollection == null || childCollection.size() == 0) {
            return;
        }
        if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(parentClassType)) {
            this.generateChildControlCodeForScrollPane(codeWriter, parentName, childCollection);
        } else if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(parentClassType)) {
            this.generateTabbedPaneLayoutCode(codeWriter, parentName, childCollection);
        } else if ("com.kingdee.bos.ctrl.swing.KDTreeView".equals(parentClassType)) {
            this.generateTreeViewLayoutCode(codeWriter, parentName, childCollection);
        } else if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(parentClassType)) {
            this.generateSplitLayoutCode(codeWriter, parentName, childCollection);
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(parentClassType)) {
            this.generateLabelContainerLayoutCode(codeWriter, parentName, childCollection);
        } else if ("com.kingdee.bos.ctrl.swing.KDContainer".equals(parentClassType)) {
            this.generateChildControlLayout(codeWriter, parentName, childCollection, layoutType, ".getContentPane()");
        } else {
            this.generateChildControlLayout(codeWriter, parentName, childCollection, layoutType, "");
        }
    }

    private void generateChildControlLayout(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection, String layoutType, String specialStr) {
        if (layoutType == null || "XYLayout".equals(layoutType)) {
            this.generateXYLayoutCode(codeWriter, parentName, childCollection, specialStr);
        } else if ("KDLayout".equals(layoutType)) {
            this.generateKDLayoutCode(codeWriter, parentName, childCollection, specialStr);
        } else if ("SameGridLayout".equals(layoutType)) {
            this.generateSameGridLayoutCode(codeWriter, parentName, childCollection, specialStr);
        } else if ("BorderLayout".equals(layoutType)) {
            this.generateBorderLayoutCode(codeWriter, parentName, childCollection, specialStr);
        }
    }

    private void generateChildControlCodeForScrollPane(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            codeWriter.append(codeWriter.getTab() + parentName + ".getViewport().add(" + componentName + ", null);" + '\n');
        }
    }

    private void generateXYLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection, String specialStr) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            if (constraint != null && constraint instanceof Rectangle) {
                Rectangle rect = (Rectangle)constraint;
                codeWriter.append(codeWriter.getTab() + componentName + ".setBounds(new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));" + '\n');
            }
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".add(" + componentName + ", null);" + '\n');
        }
    }

    private void generateSameGridLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection, String specialStr) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            String tempConsCode = "null";
            if (constraint != null && constraint instanceof Rectangle) {
                Rectangle rect = (Rectangle)constraint;
                tempConsCode = "new SameGridConstraints(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + ")";
            }
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + '\n');
        }
    }

    private void generateKDLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection, String specialStr) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            String tempConsCode = "null";
            if (constraint != null && constraint instanceof KDLayoutConstraint) {
                tempConsCode = ((KDLayoutConstraint)constraint).toJavaCode();
            }
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + '\n');
        }
    }

    private void generateBorderLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection, String specialStr) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".add(" + componentName + ", BorderLayout." + constraint.toString().toUpperCase() + ");" + '\n');
        }
    }

    private void generateTabbedPaneLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            if (constraint == null || !(constraint instanceof String)) continue;
            codeWriter.append(codeWriter.getTab() + parentName + ".add(" + componentName + ", resHelper.getString(\"" + componentName + ".constraints\"));" + '\n');
        }
    }

    private void generateTreeViewLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (!"com.kingdee.bos.ctrl.swing.KDTree".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            codeWriter.append(codeWriter.getTab() + parentName + ".setTree(" + componentName + ");" + '\n');
        }
    }

    private void generateSplitLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            codeWriter.append(codeWriter.getTab() + parentName + ".add(" + componentName + ", " + codeWriter.addMark(constraint.toString()) + ");" + '\n');
        }
    }

    private void generateLabelContainerLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            codeWriter.append(codeWriter.getTab() + parentName + ".setBoundEditor(" + componentName + ");" + '\n');
        }
    }

    private void generateFlowLayoutCode(AbstractCodeWriter codeWriter, String parentName, ComponentCollection childCollection, String specialStr) {
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            codeWriter.append(codeWriter.getTab() + parentName + specialStr + ".add(" + componentName + ");" + '\n');
        }
    }

    private static class AbstractCodeWriter
    extends CodeWriterBase {
        private AbstractCodeWriter(StringBuffer out) {
            super(out);
        }

        protected void append(String str) {
            this.out.append(str);
        }

        @Override
        protected String getClassName() {
            throw new UnsupportedOperationException("No allow use it.");
        }

        @Override
        public void write(StringBuffer in) {
            throw new UnsupportedOperationException("No allow use it.");
        }

        @Override
        public void tabAdd() {
            super.tabAdd();
        }

        @Override
        public void tabSub() {
            super.tabSub();
        }

        public String getTab() {
            return this.tab;
        }

        public void setTab(String tab) {
            this.tab = tab;
        }

        @Override
        public String addMark(String item) {
            return super.addMark(item);
        }
    }
}

