/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.code.webui.AbstractWebUIGenerator;
import com.kingdee.bos.metadata.code.webui.model.Element;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class AbstractWebEditUIGenerator
extends AbstractWebUIGenerator {
    protected EntityObjectInfo entityInfo;
    protected String[] billEntries;
    protected boolean inherit;
    protected String rootPackage;
    protected String rootUrl;

    public AbstractWebEditUIGenerator(WebUIObjectInfo model, Object[] argument) {
        super(model, argument);
        this.entityInfo = (EntityObjectInfo)argument[0];
        this.billEntries = (String[])argument[1];
        this.inherit = (Boolean)argument[4];
        this.rootPackage = AbstractWebEditUIGenerator.rootPackage(this.entityInfo);
        this.rootUrl = AbstractWebEditUIGenerator.rootUrl(this.rootPackage);
    }

    @Override
    public String generate() {
        Element element = this.component2MBeanHelper.buildElementTree(this.model.getMainPanelComponent());
        StringBuffer sb = new StringBuffer();
        sb.append(this.genPackage() + "\n");
        sb.append(this.genImport() + "\n");
        sb.append(this.genClassDeclarationStart() + "\n");
        sb.append(this.genComponentDeclaration(element) + "\n");
        sb.append(this.genBizInterfaceDeclaration() + "\n");
        sb.append(this.genActionDeclaration() + "\n");
        sb.append(this.genInject() + "\n");
        sb.append(this.genConstructor() + "\n");
        sb.append(this.genPageOnload() + "\n");
        sb.append(this.genComponentConstruction(element) + "\n");
        sb.append(this.getCreateNewModel() + "\n");
        sb.append(this.genSaveModel() + "\n");
        sb.append(this.genSubmitModel() + "\n");
        sb.append(this.genUpdateModel() + "\n");
        sb.append(this.genMethod() + "\n");
        sb.append(this.genEntryRowAction() + "\n");
        sb.append(this.genBizInterface() + "\n");
        sb.append(this.genEntryPKName() + "\n");
        sb.append(this.genMetaDataPK() + "\n");
        sb.append(this.genSelectors() + "\n");
        sb.append(this.genTDTemplateName() + "\n");
        sb.append(this.genAction() + "\n");
        sb.append(this.genInitScript() + "\n");
        sb.append(this.genClassDeclarationEnd() + "\n");
        return sb.toString();
    }

    @Override
    protected String genImport() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.genImport());
        sb.append("import " + this.rootPackage + ".I" + this.entityInfo.getName() + ";" + "\n");
        sb.append("import " + AbstractWebEditUIGenerator.getInfoClass(this.entityInfo) + ";" + "\n");
        for (int i = 0; i < this.billEntries.length; ++i) {
            String entryName = this.billEntries[i];
            EntityObjectInfo childInfo = AbstractWebEditUIGenerator.getOne2ManyEntryType(this.entityInfo, entryName);
            if (childInfo == null) continue;
            sb.append("import " + AbstractWebEditUIGenerator.getInfoClass(childInfo) + ";" + "\n");
            sb.append("import " + AbstractWebEditUIGenerator.getCollectionClass(childInfo) + ";" + "\n");
        }
        return sb.toString();
    }

    protected String genBizInterfaceDeclaration() {
        StringBuffer sb = new StringBuffer();
        if (!this.inherit) {
            sb.append("\t@IBOSBizCtrl\n");
            sb.append("\tprotected I" + this.entityInfo.getName() + " service;" + "\n");
        }
        return sb.toString();
    }

    protected String genInject() {
        StringBuffer sb = new StringBuffer();
        if (!this.inherit) {
            for (int i = 0; i < this.billEntries.length; ++i) {
                String entryName = this.billEntries[i];
                EntityObjectInfo childInfo = AbstractWebEditUIGenerator.getOne2ManyEntryType(this.entityInfo, entryName);
                if (childInfo == null) continue;
                sb.append("\t@Inject(\"" + this.shortPackage + "." + childInfo.getName() + "Bean\")" + "\n");
                sb.append("\tprotected " + childInfo.getName() + "Bean " + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean;" + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    protected String genPageOnload() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tpublic void pageOnload() {\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "super.pageOnload();" + "\n");
        for (int i = 0; i < this.billEntries.length; ++i) {
            String entryName = this.billEntries[i];
            EntityObjectInfo childInfo = AbstractWebEditUIGenerator.getOne2ManyEntryType(this.entityInfo, entryName);
            if (childInfo == null) continue;
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + childInfo.getName() + "Collection entryCol_" + i + " = ((" + this.entityInfo.getName() + "Info) model).get" + StringUtils.headCharUpperCase((String)entryName) + "();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "List<CoreBaseInfo> listModel_" + i + " = new LinkedList<CoreBaseInfo>();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "if (entryCol_" + i + " != null) {" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "for (int i = 0, n = entryCol_" + i + ".size(); i < n; i++) {" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 4) + "listModel_" + i + ".add(entryCol_" + i + ".get(i));" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "}" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "}" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean.setListModel(listModel_" + i + ");" + "\n");
        }
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "if(OperateState.ADDNEW.equals(getOperateState())){" + "\n");
        String sTemplateType = ConvertUtils.getBimTemplateType(this.model.getBizUnitPK());
        if (!StringUtils.isEmpty((String)sTemplateType) && "TreeBase".equalsIgnoreCase(sTemplateType)) {
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "Map<String, Object> map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "Object parent = map.get(\"parent\");" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "model.put(\"parent\", parent);" + "\n");
        }
        if (!StringUtils.isEmpty((String)sTemplateType) && "TreeDetail".equalsIgnoreCase(sTemplateType)) {
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "Map<String, Object> map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "Object treeid = map.get(\"treeid\");" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "model.put(\"treeid\", treeid);" + "\n");
        }
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "}" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String getCreateNewModel() {
        StringBuffer sb = new StringBuffer();
        if (!this.inherit) {
            sb.append("\t@Override\n");
            sb.append("\tpublic void createNewModel() {\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "model = new " + this.entityInfo.getName() + "Info();" + "\n");
            sb.append("\t}\n");
        }
        return sb.toString();
    }

    protected String genSaveModel() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tpublic void saveModel() {\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "updateModel();" + "\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "super.saveModel();" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genSubmitModel() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tpublic void submitModel() {\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "updateModel();" + "\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "super.submitModel();" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genUpdateModel() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tprotected void updateModel() {\n");
        for (int i = 0; i < this.billEntries.length; ++i) {
            String entryName = this.billEntries[i];
            EntityObjectInfo childInfo = AbstractWebEditUIGenerator.getOne2ManyEntryType(this.entityInfo, entryName);
            if (childInfo == null) continue;
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "if (" + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean == null)" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean = (" + childInfo.getName() + "Bean) com.kingdee.bos.waf.util.BeanUtil.getBean(\"" + this.shortPackage + "." + childInfo.getName() + "Bean\");" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean.updataModel();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "List<CoreBaseInfo> entryModel_" + i + " = " + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean.getListModel();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "((" + this.entityInfo.getName() + "Info) model).get" + StringUtils.headCharUpperCase((String)entryName) + "().clear();" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "if (entryModel_" + i + " != null) {" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "for (CoreBaseInfo entryInfo : entryModel_" + i + ") {" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 4) + "((" + this.entityInfo.getName() + "Info) model).get" + StringUtils.headCharUpperCase((String)entryName) + "().add((" + childInfo.getName() + "Info) entryInfo);" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 3) + "}" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "}" + "\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genEntryRowAction() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.billEntries.length; ++i) {
            String entryName = this.billEntries[i];
            EntityObjectInfo childInfo = AbstractWebEditUIGenerator.getOne2ManyEntryType(this.entityInfo, entryName);
            if (childInfo == null) continue;
            sb.append("\t// entryName\n");
            sb.append("\tpublic void " + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean_apendRow() {" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean.appendRow();" + "\n");
            sb.append("\t}\n");
            sb.append("\tpublic void " + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean_removeRow() {" + "\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + StringUtils.headCharLowerCase((String)childInfo.getName()) + "Bean.removeRow();" + "\n");
            sb.append("\t}\n");
        }
        return sb.toString();
    }

    protected String genBizInterface() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected ICoreBase getBizInterface() {\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "return service;" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genEntryPKName() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected String getEntryPKName() {\n");
        if (this.billEntries.length > 0) {
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "return \"" + this.billEntries[0] + ".id\";" + "\n");
        } else {
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "return super.getEntryPKName();" + "\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genSelectors() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tpublic SelectorItemCollection getSelectors() {\n");
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "SelectorItemCollection sic = super.getSelectors();" + "\n");
        String componentName = null;
        if (this.model.getDataObjects().size() > 0) {
            componentName = this.model.getDataObjects().get(0).getName();
            IObjectValue obj = this.model.getDataObjects().get(0).getInstance();
            EntityObjectInfo entity = null;
            if (obj != null && obj instanceof EntityObjectInfo) {
                entity = (EntityObjectInfo)obj;
            }
            if ("D".equalsIgnoreCase(this.model.getExtendedProperty("controlType"))) {
                sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "sic.add(new SelectorItemInfo(\"adminCU.id\"));" + "\n");
            }
            ArrayList<String> bindingFields = new ArrayList<String>();
            int m = this.components.size();
            for (int i = 0; i < m; ++i) {
                ComponentInfo cInfo = this.components.get(i);
                int n = cInfo.getPropertyBindings().size();
                for (int j = 0; j < n; ++j) {
                    RelationshipInfo relationShipInfo;
                    PropertyInfo prop;
                    DataObjectInfo dataObjInfo;
                    IObjectValue eInfo;
                    PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
                    if (cInfo.isHerited() && !pbInfo.isOverride() || !componentName.equals(pbInfo.getBindingObject())) continue;
                    String fieldName = pbInfo.getBingdingField();
                    if (this.isLinkBind(cInfo) && "value".equals(pbInfo.getPropertyName())) {
                        fieldName = fieldName + ".*";
                    }
                    if (!bindingFields.contains(fieldName)) {
                        bindingFields.add(fieldName);
                        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "sic.add(new SelectorItemInfo(\"" + fieldName + "\"));" + "\n");
                    }
                    if (!this.isLinkBind(cInfo) || !((eInfo = (dataObjInfo = this.model.getDataObjects().get(0)).getInstance()) instanceof EntityObjectInfo) || !((prop = ((EntityObjectInfo)eInfo).getPropertyByName(fieldName)) instanceof LinkPropertyInfo) || !RelationshipType.ASSOCIATION.equals((Object)(relationShipInfo = ((LinkPropertyInfo)prop).getRelationship()).getType())) continue;
                    EntityObjectInfo supplyEntityInfo = relationShipInfo.getSupplierObject();
                    boolean bNumberExist = false;
                    boolean bNameExist = false;
                    int l = supplyEntityInfo.getInheritedNoDuplicatedProperties().size();
                    for (int k = 0; k < l; ++k) {
                        PropertyInfo propSuplly = supplyEntityInfo.getInheritedNoDuplicatedProperties().get(k);
                        if ("number".equalsIgnoreCase(propSuplly.getName())) {
                            bNumberExist = true;
                        }
                        if ("name".equalsIgnoreCase(propSuplly.getName())) {
                            bNameExist = true;
                        }
                        if (bNumberExist && bNameExist) break;
                    }
                    if (bNumberExist && !bindingFields.contains(fieldName + ".number")) {
                        bindingFields.add(fieldName);
                        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "sic.add(new SelectorItemInfo(\"" + fieldName + ".number\"));" + "\n");
                    }
                    if (bNameExist && !bindingFields.contains(fieldName + ".name")) {
                        bindingFields.add(fieldName);
                        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "sic.add(new SelectorItemInfo(\"" + fieldName + ".name\"));" + "\n");
                    }
                    bNumberExist = false;
                    bNameExist = false;
                }
            }
        }
        sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "return sic;" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genTDTemplateName() {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.model.getBizUnitPK()) && !StringUtils.isEmpty((String)ConvertUtils.getQueryPK(this.model.getBizUnitPK()))) {
            sb.append("\t@Override\n");
            sb.append("\tprotected String getTDTemplateName() {\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "return \"" + ConvertUtils.getTDFileName(this.model.getBizUnitPK()) + "\";" + "\n");
            sb.append("\t}\n");
            sb.append("\t@Override\n");
            sb.append("\tprotected com.kingdee.bos.metadata.IMetaDataPK getTDQueryPK() {\n");
            sb.append(AbstractWebEditUIGenerator.getSymbolTimes("\t", 2) + "return new com.kingdee.bos.metadata.MetaDataPK(\"" + ConvertUtils.getQueryPK(this.model.getBizUnitPK()) + "\");" + "\n");
            sb.append("\t}\n");
        }
        return sb.toString();
    }

    @Override
    protected boolean filterDeclaration(Element element) {
        if (element != null) {
            if ("org.operamasks.faces.component.html.HtmlPage".equals(element.getUIClazz())) {
                return false;
            }
            if ("org.operamasks.faces.component.widget.UIForm".equals(element.getUIClazz())) {
                return false;
            }
            ComponentInfo cInfo = element.getComponentInfo();
            if (cInfo != null && cInfo.isHerited()) {
                return true;
            }
        }
        return false;
    }
}

