/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.code.webui.AbstractWebUIGenerator;
import com.kingdee.bos.metadata.code.webui.Component2MBeanHelper;
import com.kingdee.bos.metadata.code.webui.model.Element;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.dtp.webevent.AjaxAction;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class AbstractWebListUIGenerator
extends AbstractWebUIGenerator {
    protected EntityObjectInfo entityInfo;
    protected String rootPackage;
    protected String rootUrl;
    protected IMetaDataPK queryPK;
    protected boolean inherit;
    protected JoinQueryInfo queryInfo;
    protected String templateType = "";
    protected String groupEntityInfo = "";
    protected String groupEntityInterface = "";

    public AbstractWebListUIGenerator(WebUIObjectInfo model, Object[] argument) {
        super(model, argument);
        this.entityInfo = (EntityObjectInfo)argument[0];
        this.queryPK = (IMetaDataPK)argument[1];
        this.inherit = (Boolean)argument[3];
        this.queryInfo = (JoinQueryInfo)argument[4];
        this.rootPackage = AbstractWebListUIGenerator.rootPackage(this.entityInfo);
        this.rootUrl = AbstractWebListUIGenerator.rootUrl(this.rootPackage);
        this.templateType = ConvertUtils.getBimTemplateType(model.getBizUnitPK());
        if (!StringUtils.isEmpty((String)this.templateType) && "TreeDetail".equalsIgnoreCase(this.templateType)) {
            this.groupEntityInfo = ConvertUtils.getBimGroupEntityName(model.getBizUnitPK());
            this.groupEntityInterface = ConvertUtils.getBimGroupEntityInterfaceName(model.getBizUnitPK());
        }
    }

    @Override
    public String generate() {
        Element element = this.component2MBeanHelper.buildElementTree(this.model.getMainPanelComponent());
        StringBuffer sb = new StringBuffer();
        sb.append(this.genPackage() + "\n");
        sb.append(this.genImport() + "\n");
        sb.append(this.genClassDeclarationStart() + "\n");
        sb.append(this.genComponentDeclaration(element) + "\n");
        sb.append(this.genBizInterfaceDeclaration() + "\n");
        sb.append(this.genActionDeclaration() + "\n");
        sb.append(this.genConstructor() + "\n");
        sb.append(this.genPageOnload() + "\n");
        sb.append(this.genComponentConstruction(element) + "\n");
        sb.append(this.genMethod() + "\n");
        sb.append(this.genBizInterface() + "\n");
        sb.append(this.genEntryPKName() + "\n");
        sb.append(this.genTree() + "\n");
        sb.append(this.genMetaDataPK() + "\n");
        sb.append(this.genEditBeanName() + "\n");
        sb.append(this.genEditUrl() + "\n");
        sb.append(this.genQueryPK() + "\n");
        sb.append(this.genAction() + "\n");
        sb.append(this.genInitScript() + "\n");
        sb.append(this.genClassDeclarationEnd() + "\n");
        return sb.toString();
    }

    @Override
    protected String genImport() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.genImport());
        sb.append("import " + this.rootPackage + ".I" + this.entityInfo.getName() + ";" + "\n");
        if (!StringUtils.isEmpty((String)this.templateType) && ("TreeDetail".equalsIgnoreCase(this.templateType) || "TreeBase".equalsIgnoreCase(this.templateType))) {
            sb.append("import " + this.rootPackage + "." + this.entityInfo.getName() + "Info" + ";" + "\n");
            sb.append("import com.kingdee.eas.framework.ITreeBase;\n");
        }
        return sb.toString();
    }

    protected String genBizInterfaceDeclaration() {
        StringBuffer sb = new StringBuffer();
        if (!this.inherit) {
            sb.append("\t@IBOSBizCtrl\n");
            sb.append("\tprotected I" + this.entityInfo.getName() + " service;" + "\n");
            if (!StringUtils.isEmpty((String)this.templateType) && "TreeDetail".equalsIgnoreCase(this.templateType) && !StringUtils.isEmpty((String)this.groupEntityInterface)) {
                sb.append("\t@IBOSBizCtrl\n");
                sb.append("\tprotected " + this.groupEntityInterface + " treeService;" + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    protected String genMethod() {
        StringBuffer sb = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            boolean isListGrid = CodeFactory.isWebListUIGrid(this.model, cInfo);
            EventBindingCollection evbs = cInfo.getEventBindings();
            for (int j = 0; j < evbs.size(); ++j) {
                String methodSignature;
                EventBindingInfo ebInfo = evbs.get(j);
                if (ebInfo.isHerited()) continue;
                String methodName = ebInfo.getMethodName();
                AjaxAction action = Component2MBeanHelper.parseAjaxAction(methodName);
                if (action == null) {
                    methodSignature = methodName + "(" + (StringUtils.isEmpty((String)ebInfo.getEventType()) ? "" : ebInfo.getEventType() + " event") + ")";
                    if (set.contains(methodSignature)) continue;
                    sb.append("\tpublic void " + methodSignature + " {" + "\n");
                    if (isListGrid && "onselectionchange".equals(ebInfo.getEventName())) {
                        sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "super.grid_onselectionchange_actionPerformed(event);//call ListBean's grid_onselectionchange_actionPerformed" + "\n");
                    }
                    sb.append("\t}\n");
                    set.add(methodSignature);
                    continue;
                }
                if (!StringUtils.isEmpty((String)action.getActionListener()) && !set.contains(methodSignature = action.getActionListener() + "(javax.faces.event.ActionEvent event)")) {
                    sb.append("\tpublic void " + methodSignature + " {}" + "\n");
                }
                if (StringUtils.isEmpty((String)action.getAction()) || set.contains(methodSignature = action.getAction() + "()")) continue;
                sb.append("\tpublic void " + methodSignature + " {" + "\n");
                if (isListGrid && "onselectionchange".equals(ebInfo.getEventName())) {
                    sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "super.grid_onselectionchange_actionPerformed(null);//call ListBean's grid_onselectionchange_actionPerformed" + "\n");
                } else if (this.isTreeType(this.templateType) && this.isUITree(cInfo) && cInfo.isHerited() && "onselect".equals(ebInfo.getEventName())) {
                    sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "super.tree_onselect();//call TreeListBean's tree_onselect" + "\n");
                } else if (this.isTreeType(this.templateType) && this.isUICheckBox(cInfo) && cInfo.isHerited() && "oncheck".equals(ebInfo.getEventName())) {
                    sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "super.chkIncludeLowerLevel_oncheck();//call TreeDetailListBean's chkIncludeLowerLevel_oncheck" + "\n");
                }
                sb.append("\t}\n");
            }
        }
        return sb.toString();
    }

    protected String genEditBeanName() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected String getEditBeanName() {\n");
        String editUIName = ConvertUtils.getWebEditUIName(this.model);
        if (editUIName != null && !"".equals(editUIName.trim())) {
            String _packageName = editUIName;
            if (editUIName.lastIndexOf(".") >= 0) {
                _packageName = editUIName.substring(0, editUIName.lastIndexOf("."));
            }
            String _className = editUIName.substring(editUIName.lastIndexOf(".") + 1) + "Bean";
            String _shortPackage = CodeFactory.getWebUIShortPackage(_packageName);
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"" + _shortPackage + "." + _className + "\";" + "\n");
        } else {
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"" + this.shortPackage + "." + this.entityInfo.getName() + "EditBean" + "\";" + "\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genEditUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected String getEditUrl() {\n");
        String editUIName = ConvertUtils.getWebEditUIName(this.model);
        if (editUIName != null && !"".equals(editUIName.trim())) {
            String _packageName = editUIName;
            if (editUIName.lastIndexOf(".") >= 0 && (_packageName = editUIName.substring(0, editUIName.lastIndexOf("."))).lastIndexOf(".") >= 0) {
                _packageName = _packageName.substring(0, _packageName.lastIndexOf("."));
            }
            String _className = editUIName.substring(editUIName.lastIndexOf(".") + 1);
            String _rootUrl = AbstractWebListUIGenerator.rootUrl(_packageName);
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"" + _rootUrl + StringUtils.headCharLowerCase((String)_className) + ".jsf" + "\";" + "\n");
        } else {
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"" + this.rootUrl + StringUtils.headCharLowerCase((String)this.entityInfo.getName()) + "Edit.jsf" + "\";" + "\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genBizInterface() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected ICoreBase getBizInterface() {\n");
        sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return service;" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genQueryPK() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected IMetaDataPK getQueryPK() {\n");
        sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return new MetaDataPK(\"" + this.queryPK.toString().replace('\\', '.') + "\");" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genEntryPKName() {
        QueryFieldCollection fields;
        QueryPKInfo pkInfo;
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tprotected String getEntryPKName() {\n");
        boolean hasValue = false;
        if (this.queryInfo != null && (pkInfo = this.queryInfo.getQueryPK()) != null && (fields = pkInfo.getKeyPropertys()) != null && fields.size() >= 2) {
            hasValue = true;
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"" + fields.get(1).getPropertyRefs().get(0).getSubEntity().getName() + ".id\";" + "\n");
        }
        if (!hasValue) {
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return super.getEntryPKName();" + "\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genTree() {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.templateType) && "TreeDetail".equalsIgnoreCase(this.templateType)) {
            sb.append("\tprotected String getQueryFieldName() {\n");
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"treeid.id\";" + "\n");
            sb.append("\t}\n");
            if (!StringUtils.isEmpty((String)this.groupEntityInfo)) {
                sb.append("\t@Override\n");
                sb.append("\tprotected void createGroupNewModel() {\n");
                sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "groupValue = new " + this.groupEntityInfo + "();" + "\n");
                sb.append("\t}\n");
            }
            if (!StringUtils.isEmpty((String)this.groupEntityInterface)) {
                sb.append("\t@Override\n");
                sb.append("\tprotected ITreeBase getTreeInterface() throws Exception {\n");
                sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return treeService;" + "\n");
                sb.append("\t}\n");
            }
        }
        if (!StringUtils.isEmpty((String)this.templateType) && "TreeBase".equalsIgnoreCase(this.templateType)) {
            sb.append("\t@Override\n");
            sb.append("\tprotected ITreeBase getTreeInterface() throws Exception {\n");
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return service;" + "\n");
            sb.append("\t}\n");
        }
        if (!StringUtils.isEmpty((String)this.templateType) && ("TreeDetail".equalsIgnoreCase(this.templateType) || "TreeBase".equalsIgnoreCase(this.templateType))) {
            sb.append("\t@Override\n");
            sb.append("\tprotected String getRootName() {\n");
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "return \"" + this.entityInfo.getName() + "\";" + "\n");
            sb.append("\t}\n");
        }
        return sb.toString();
    }

    @Override
    protected void genSpecialAfterComponentInitialize(StringBuffer sb) {
        if (this.isTreeType(this.templateType)) {
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "// " + "special process;" + "\n");
            sb.append(AbstractWebListUIGenerator.getSymbolTimes("\t", 2) + "this.refreshTree();" + "\n");
        }
    }

    @Override
    protected boolean filterDeclaration(Element element) {
        if (element != null) {
            if ("org.operamasks.faces.component.html.HtmlPage".equals(element.getUIClazz())) {
                return false;
            }
            if ("org.operamasks.faces.component.widget.UIForm".equals(element.getUIClazz())) {
                return false;
            }
            ComponentInfo cInfo = element.getComponentInfo();
            if (cInfo != null && cInfo.isHerited()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String elementDeclarationName(Element element) {
        boolean isListGrid = CodeFactory.isWebListUIGrid(this.model, element.getComponentInfo());
        if (isListGrid) {
            return "grid";
        }
        return element.getDeclarName();
    }
}

