/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.code.webui.CodeWriter;
import com.kingdee.bos.metadata.code.webui.Component2MBeanHelper;
import com.kingdee.bos.metadata.code.webui.model.ConvertorAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELActionAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELActionBindingAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELActionListenerAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELAjaxActionElement;
import com.kingdee.bos.metadata.code.webui.model.ELMethodAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELValueAttribute;
import com.kingdee.bos.metadata.code.webui.model.Element;
import com.kingdee.bos.metadata.code.webui.model.LayoutPanelElement;
import com.kingdee.bos.metadata.code.webui.model.UserTagElement;
import com.kingdee.bos.metadata.code.webui.model.ValidatorAttribute;
import com.kingdee.bos.metadata.code.webui.model.ValueAttribute;
import com.kingdee.bos.metadata.code.webui.util.PropertyDescriptor;
import com.kingdee.bos.metadata.code.webui.util.UIComponentMapping;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.webui.ScriptCollection;
import com.kingdee.bos.metadata.webui.ScriptInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.dtp.webevent.AjaxAction;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractWebUIGenerator
extends CodeWriter {
    protected WebUIObjectInfo model;
    protected Component2MBeanHelper component2MBeanHelper;
    protected String packageName;
    protected String className;
    protected String fullClassName;
    protected String shortPackage;
    protected String shortClassName;
    protected ComponentCollection components;
    protected String baseClass;

    public AbstractWebUIGenerator(WebUIObjectInfo model, Object[] nothing) {
        this.model = model;
        this.component2MBeanHelper = new Component2MBeanHelper(model);
        this.packageName = model.getReleasePackage();
        this.className = model.getReleaseClass() + "Bean";
        this.fullClassName = this.packageName + "." + this.className;
        this.shortPackage = CodeFactory.getWebUIShortPackage(this.packageName);
        this.shortClassName = this.shortPackage + "." + this.className;
        this.components = model.getComponents();
        this.components = UIObjectCtrl.treeToCol(this.components);
        this.baseClass = CodeFactory.getParentReleaseClass(model);
    }

    @Override
    public String generate() {
        Element element = this.component2MBeanHelper.buildElementTree(this.model.getMainPanelComponent());
        StringBuffer sb = new StringBuffer();
        sb.append(this.genPackage() + "\n");
        sb.append(this.genImport() + "\n");
        sb.append(this.genClassDeclarationStart() + "\n");
        sb.append(this.genComponentDeclaration(element) + "\n");
        sb.append(this.genActionDeclaration() + "\n");
        sb.append(this.genConstructor() + "\n");
        sb.append(this.genPageOnload() + "\n");
        sb.append(this.genComponentConstruction(element) + "\n");
        sb.append(this.genMethod() + "\n");
        sb.append(this.genMetaDataPK() + "\n");
        sb.append(this.genAction() + "\n");
        sb.append(this.genInitScript() + "\n");
        sb.append(this.genClassDeclarationEnd() + "\n");
        return sb.toString();
    }

    protected String genPackage() {
        return "package " + this.packageName + ";" + "\n";
    }

    protected String genImport() {
        StringBuffer sb = new StringBuffer();
        sb.append("import java.util.LinkedList;\n");
        sb.append("import java.util.List;\n");
        sb.append("import java.util.Map;\n");
        sb.append("import org.operamasks.faces.annotation.Bind;\n");
        sb.append("import org.operamasks.faces.annotation.Inject;\n");
        sb.append("import org.operamasks.faces.annotation.ManagedBean;\n");
        sb.append("import org.operamasks.faces.annotation.ManagedBeanScope;\n");
        sb.append("import org.operamasks.faces.annotation.Accessible;\n");
        sb.append("import org.operamasks.faces.component.form.impl.*;\n");
        sb.append("import org.operamasks.faces.component.action.ActionEvent;\n");
        sb.append("import javax.faces.component.UIViewRoot;\n");
        sb.append("import javax.faces.context.FacesContext;\n");
        sb.append("import org.operamasks.faces.component.html.HtmlPage;\n");
        sb.append("import com.kingdee.bos.metadata.IMetaDataPK;\n");
        sb.append("import com.kingdee.bos.metadata.MetaDataPK;\n");
        sb.append("import com.kingdee.bos.metadata.entity.SelectorItemCollection;\n");
        sb.append("import com.kingdee.bos.metadata.entity.SelectorItemInfo;\n");
        sb.append("import com.kingdee.bos.waf.annotation.IBOSBizCtrl;\n");
        sb.append("import com.kingdee.bos.waf.winlet.edit.EditBean;\n");
        sb.append("import com.kingdee.bos.waf.winlet.list.ListBean;\n");
        sb.append("import com.kingdee.bos.waf.util.OperateState;\n");
        sb.append("import com.kingdee.bos.web.resource.*;\n");
        sb.append("import com.kingdee.bos.waf.ctx.*;\n");
        sb.append("import com.kingdee.eas.framework.CoreBaseInfo;\n");
        sb.append("import com.kingdee.eas.framework.ICoreBase;\n");
        sb.append("import com.kingdee.bos.waf.action.AbstractWebAction;\n");
        sb.append("import javax.faces.event.AbortProcessingException;\n");
        sb.append("import com.kingdee.bos.waf.winlet.BaseBean;\n");
        sb.append("import com.kingdee.bos.waf.util.UIComponentUtil;\n");
        sb.append("import com.kingdee.bos.ui.util.ResourceBundleHelper;\n");
        sb.append("import com.kingdee.util.StringUtils;\n");
        sb.append("import java.awt.Rectangle;\n");
        return sb.toString();
    }

    protected String genClassDeclarationStart() {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.baseClass)) {
            sb.append("public abstract class Abstract" + this.className + " extends " + this.baseClass + " {" + "\n");
        } else {
            sb.append("public abstract class Abstract" + this.className + " extends BaseBean {" + "\n");
        }
        return sb.toString();
    }

    protected String genClassDeclarationEnd() {
        return "}\n";
    }

    protected String genComponentDeclaration(Element element) {
        StringBuffer sb = new StringBuffer();
        this.genComponentDeclaration(element, sb);
        return sb.toString();
    }

    protected void genComponentDeclaration(Element element, StringBuffer sb) {
        if (!this.filterDeclaration(element)) {
            sb.append("\t@Bind(id=\"" + element.getId() + "\")" + "\n");
            sb.append("\tprotected " + element.getUIClazz() + " " + element.getDeclarName() + ";" + "\n");
        }
        Iterator iter = element.iterator();
        while (iter.hasNext()) {
            this.genComponentDeclaration((Element)iter.next(), sb);
        }
    }

    protected String genConstructor() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tpublic Abstract" + this.className + "() {" + "\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "super();" + "\n");
        int n = this.model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo aInfo = this.model.getActions().get(i);
            if (aInfo.isHerited()) continue;
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "this." + aInfo.getName() + " = (" + aInfo.getClassName() + ")com.kingdee.bos.waf.action.WebActionFactory.createWebAction(\"" + aInfo.getName() + "\", " + aInfo.getClassName() + ".class,getServiceContext());" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "this." + aInfo.getName() + ".setBaseBean(this);" + "\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genPageOnload() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tpublic void pageOnload() {\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "super.pageOnload();" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genComponentConstruction(Element element) {
        StringBuffer sb = new StringBuffer();
        sb.append("\tprotected void componentInitialize() {\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "this.resHelper = new ResourceBundleHelper(Abstract" + this.className + ".class.getName(), this.getLocale(), Abstract" + this.className + ".class.getClassLoader());" + "\n");
        this.genComponentConstruction(element, sb);
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\n", 2));
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + "generate param setting" + "\n");
        this.genParamSetting(element, sb);
        this.genRelationTree(element, sb);
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "genInnerWindow(\"" + this.shortClassName + "\",UIComponentUtil.getViewPage());" + "\n");
        this.genSpecialAfterComponentInitialize(sb);
        sb.append("\t}\n");
        return sb.toString();
    }

    private void genComponentConstruction(Element element, StringBuffer sb) {
        if (element.getUIClazz().equals("org.operamasks.faces.component.html.HtmlPage")) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + element.getId() + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + " " + "=" + " ");
            sb.append("(" + element.getUIClazz() + ")");
            sb.append("UIComponentUtil.getViewPage();\n");
        } else if (element instanceof LayoutPanelElement) {
            LayoutPanelElement le = (LayoutPanelElement)element;
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + le.getId() + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + le.getDeclarName() + " " + "=" + " ");
            sb.append("UIComponentUtil.createKDLayoutPanel(");
            sb.append("\"" + le.getId() + "\"");
            sb.append(",new Rectangle(" + le.getX() + "," + le.getY() + "," + le.getWidth() + "," + le.getHeight() + ")");
            sb.append("," + le.getAnchor());
            sb.append(",\"" + (le.getChildItem() == null ? "" : le.getChildItem()) + "\"");
            sb.append(",\"" + (le.getClassType() == null ? "" : le.getClassType()) + "\"");
            sb.append(");\n");
        } else if (element instanceof ELAjaxActionElement) {
            ELAjaxActionElement ajax = (ELAjaxActionElement)element;
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + ajax.getId() + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + ajax.getDeclarName() + " " + "=" + " ");
            sb.append("UIComponentUtil.createAjaxAction(");
            sb.append("\"" + ajax.getId() + "\"");
            sb.append("," + ajax.isImmediate());
            sb.append("," + ajax.isRendered());
            sb.append(",\"" + ajax.getEvent() + "\"");
            sb.append("," + (ajax.getParent() != null ? ajax.getParent().getDeclarName() : "null"));
            sb.append(");\n");
        } else if (element instanceof UserTagElement) {
            String value;
            UserTagElement userTag = (UserTagElement)element;
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + userTag.getId() + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + userTag.getDeclarName() + " " + "=" + " ");
            sb.append("(" + userTag.getUIClazz() + ")");
            sb.append("UIComponentUtil.createComponent(\"");
            sb.append(userTag.getUIComponentType());
            sb.append("\");\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + userTag.getDeclarName() + ".setTagName(\"" + userTag.getTagName() + "\");" + "\n");
            Map attributes = userTag.getUserAttributes();
            Set keys = attributes.keySet();
            for (String key : keys) {
                value = (String)attributes.get(key);
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + userTag.getDeclarName() + ".putUserAttribute(\"" + key + "\",\"" + value + "\");" + "\n");
            }
            attributes = userTag.getUserValueRefAttributes();
            keys = attributes.keySet();
            for (String key : keys) {
                value = (String)attributes.get(key);
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + userTag.getDeclarName() + ".putUserAttribute(\"" + key + "\"," + value + ");" + "\n");
            }
        } else {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + element.getId() + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + " " + "=" + " ");
            sb.append("(" + element.getUIClazz() + ")");
            sb.append("UIComponentUtil.createComponent(\"");
            sb.append(element.getUIComponentType());
            sb.append("\");\n");
            String superDeclarationName = this.elementDeclarationName(element);
            if (superDeclarationName != null && element.getDeclarName() != null && !superDeclarationName.equals(element.getDeclarName())) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + "set reference to parent ctrl" + "\n");
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "super." + superDeclarationName + " " + "=" + " " + element.getDeclarName() + ";" + "\n");
            }
        }
        Iterator iter = element.iterator();
        while (iter.hasNext()) {
            this.genComponentConstruction((Element)iter.next(), sb);
        }
    }

    private void genParamSetting(Element element, StringBuffer sb) {
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + element.getId() + "\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".setId(\"" + element.getId() + "\");" + "\n");
        sb.append(this.genValueAttribute(element));
        sb.append(this.genElValueAttribute(element));
        sb.append(this.genElActionAttribute(element));
        sb.append(this.genElActionListenerAttribute(element));
        sb.append(this.genElActionBindingAttribute(element));
        sb.append(this.genELMethodAttribute(element));
        sb.append(this.genValidatorAttribute(element));
        sb.append(this.genConvertorAttribute(element));
        sb.append(this.genStyleSheet(element));
        Iterator iter = element.iterator();
        while (iter.hasNext()) {
            this.genParamSetting((Element)iter.next(), sb);
        }
    }

    private void genRelationTree(Element element, StringBuffer sb) {
        int i = 0;
        Iterator iter = element.iterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            if ("org.operamasks.faces.component.html.HtmlPage".equals(element.getUIClazz())) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".getChildren().add(" + i + ", " + child.getDeclarName() + ");" + "\n");
            } else {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".getChildren().add(" + child.getDeclarName() + ");" + "\n");
            }
            ++i;
        }
        iter = element.iterator();
        while (iter.hasNext()) {
            this.genRelationTree((Element)iter.next(), sb);
        }
    }

    protected void genSpecialAfterComponentInitialize(StringBuffer sb) {
    }

    protected String genValueAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getValueAttributes();
        UIComponentMapping mapping = UIComponentMapping.getInstance();
        for (ValueAttribute att : list) {
            if (att.isWeakRef()) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".getAttributes().put(\"" + att.getName() + "\"," + att.getValue() + ");" + "\n");
                continue;
            }
            PropertyDescriptor descriptor = mapping.getPropertyDescriptor(att.getUIClass(), att.getName());
            if (descriptor == null) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "// " + "FIXME: can't found property'" + att.getName() + "'" + "\n");
                continue;
            }
            String writeMethod = descriptor.getWriteMethod();
            String paramType = descriptor.getPropertyType();
            if (StringUtils.isEmpty((String)writeMethod)) continue;
            if (att.isValueRef()) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + "." + writeMethod + "(" + att.getValue() + ");" + "\n");
                continue;
            }
            if (StringUtils.isEmpty((String)paramType)) continue;
            if (String.class.getName().equals(paramType) || Object.class.getName().equals(paramType)) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + "." + writeMethod + "(\"" + att.getValue() + "\");" + "\n");
                continue;
            }
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + "." + writeMethod + "(new " + AbstractWebUIGenerator.translate2ObjectType(paramType) + "(" + att.getValue() + "));" + "\n");
        }
        return sb.toString();
    }

    protected String genElActionAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getELActionAttributes();
        for (ELActionAttribute att : list) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".setActionExpression(UIComponentUtil.createMethodExpression(\"" + att.getEl() + "\", Void.class, new Class[] {}));" + "\n");
        }
        return sb.toString();
    }

    protected String genELMethodAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getELMethodAttributes();
        for (ELMethodAttribute att : list) {
            String[] params = att.getParamClazzs();
            StringBuffer sp = new StringBuffer();
            sp.append("new Class[] {");
            for (int i = 0; i < params.length; ++i) {
                sp.append(params[i]);
                if (i == params.length - 1) continue;
                sp.append(",");
            }
            sp.append("}");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + "." + att.getMethodName() + "(UIComponentUtil.createMethodExpression(\"" + att.getEl() + "\", " + att.getReturnClazz() + ", " + sp.toString() + "));" + "\n");
        }
        return sb.toString();
    }

    protected String genElActionListenerAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getELActionListenerAttributes();
        for (ELActionListenerAttribute att : list) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".addActionListener(UIComponentUtil.createActionListener(\"" + att.getEl() + "\"));" + "\n");
        }
        return sb.toString();
    }

    protected String genElActionBindingAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getELActionBindingAttributes();
        for (ELActionBindingAttribute att : list) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".setValueExpression(\"actionBinding\", UIComponentUtil.createValueExpression(\"" + att.getValue() + "\", " + att.getName() + ".getClass()));" + "\n");
        }
        return sb.toString();
    }

    protected String genElValueAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getELValueAttributes();
        for (ELValueAttribute att : list) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".setValueExpression(\"" + att.getName() + "\",UIComponentUtil.createValueExpression(\"" + att.getEl() + "\", Object.class));" + "\n");
        }
        return sb.toString();
    }

    protected String genValidatorAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getValidatorAttributes();
        for (ValidatorAttribute att : list) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".addValidator(new ClientValidatorImpl(" + att.getMsg() + "," + att.getScript() + "));" + "\n");
        }
        return sb.toString();
    }

    protected String genConvertorAttribute(Element element) {
        StringBuffer sb = new StringBuffer();
        List list = element.getConvertorAttributes();
        for (ConvertorAttribute att : list) {
            String convertorName = element.getDeclarName() + "$ConvertorAttribute";
            if (!StringUtils.isEmpty((String)att.getConvertorID())) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "javax.faces.convert.Converter " + convertorName + " = UIComponentUtil.createConverter(\"" + att.getConvertorID() + "\");" + "\n");
            } else {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + att.getClazz() + " " + convertorName + " = new " + att.getClazz() + "();" + "\n");
            }
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".setConverter(" + convertorName + ");" + "\n");
            if (element.getComponentInfo() != null && ("com.kingdee.bos.ctrl.web.Column".equals(element.getComponentInfo().getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equals(element.getComponentInfo().getClassType()))) {
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + ".getAttributes().put(\"converterLiteral\",\"" + att.getConvertorID() + "\");" + "\n");
            }
            if (!StringUtils.isEmpty((String)att.getConvertorID())) continue;
            Map params = att.getParam();
            Set keys = params.keySet();
            for (String method : keys) {
                String value = (String)params.get(method);
                sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + convertorName + "." + method + "(\"" + value + "\");" + "\n");
            }
        }
        return sb.toString();
    }

    protected String genStyleSheet(Element element) {
        StringBuffer sb = new StringBuffer();
        Map styles = element.getStyleSheet();
        UIComponentMapping mapping = UIComponentMapping.getInstance();
        for (String key : styles.keySet()) {
            String writeMethod;
            String value = (String)styles.get(key);
            PropertyDescriptor descriptor = mapping.getPropertyDescriptor(element.getUIClazz(), key);
            if (descriptor == null || StringUtils.isEmpty((String)(writeMethod = descriptor.getWriteMethod()))) continue;
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + element.getDeclarName() + "." + writeMethod + "(\"" + value + "\");" + "\n");
        }
        return sb.toString();
    }

    protected String genMethod() {
        StringBuffer sb = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            PropertyCollection properties = cInfo.getProperties();
            int n = properties.size();
            for (int j = 0; j < n; ++j) {
                PropertyInfo property = properties.get(j);
                if (!"uploadListener".equals(property.getName()) || AbstractWebUIGenerator.isEL(property.getValue())) continue;
                String methodSignature = property.getValue() + "(org.operamasks.faces.component.widget.fileupload.FileUploadItem fileUploadItem)";
                sb.append("\tpublic void " + methodSignature + " {}" + "\n");
                set.add(methodSignature);
            }
            EventBindingCollection evbs = cInfo.getEventBindings();
            int n2 = evbs.size();
            for (int j = 0; j < n2; ++j) {
                String methodSignature;
                EventBindingInfo ebInfo = evbs.get(j);
                if (ebInfo.isHerited()) continue;
                String methodName = ebInfo.getMethodName();
                AjaxAction action = Component2MBeanHelper.parseAjaxAction(methodName);
                if (action == null) {
                    if (Component2MBeanHelper.isEL(methodName)) continue;
                    methodSignature = methodName + "(" + (StringUtils.isEmpty((String)ebInfo.getEventType()) ? "" : ebInfo.getEventType() + " event") + ")";
                    if (set.contains(methodSignature)) continue;
                    sb.append("\tpublic void " + methodSignature + " {}" + "\n");
                    set.add(methodSignature);
                    continue;
                }
                if (!StringUtils.isEmpty((String)action.getActionListener()) && !set.contains(methodSignature = action.getActionListener() + "(javax.faces.event.ActionEvent event)")) {
                    sb.append("\tpublic void " + methodSignature + " {}" + "\n");
                    set.add(methodSignature);
                }
                if (StringUtils.isEmpty((String)action.getAction()) || set.contains(methodSignature = action.getAction() + "()")) continue;
                sb.append("\tpublic void " + methodSignature + " {}" + "\n");
                set.add(methodSignature);
            }
        }
        return sb.toString();
    }

    protected String genMetaDataPK() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t@Override\n");
        sb.append("\tpublic IMetaDataPK getMetaDataPK() {\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "return new MetaDataPK(\"" + this.model.getFullName() + "\");" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected String genActionDeclaration() {
        StringBuffer sb = new StringBuffer();
        int n = this.model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo aInfo = this.model.getActions().get(i);
            if (aInfo.isHerited()) continue;
            sb.append("\t@Accessible\n");
            sb.append("\tprotected " + aInfo.getClassName() + " " + aInfo.getName() + " " + "= null;" + "\n");
        }
        return sb.toString();
    }

    protected String genAction() {
        StringBuffer sb = new StringBuffer();
        int n = this.model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo aInfo = this.model.getActions().get(i);
            if (aInfo.isHerited()) continue;
            sb.append("\tprotected void " + StringUtils.headCharLowerCase((String)aInfo.getClassName()) + "_actionPerformed(ActionEvent event) throws AbortProcessingException {}" + "\n");
            sb.append("\tpublic static class " + aInfo.getClassName() + " extends AbstractWebAction {" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "private BaseBean baseBean;" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "public BaseBean getBaseBean() {" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 3) + "return baseBean;" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "}" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "public void setBaseBean(BaseBean baseBean) {" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 3) + "this.baseBean = baseBean;" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "}" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "@Override" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "public void processAction(ActionEvent event) throws AbortProcessingException {" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 3) + "try {" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 4) + "((Abstract" + this.className + ")baseBean)." + StringUtils.headCharLowerCase((String)aInfo.getClassName()) + "_actionPerformed(event);" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 3) + "} catch (Exception e) {" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 4) + "e.printStackTrace();" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 4) + "throw new AbortProcessingException(e);" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 3) + "}" + "\n");
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "}" + "\n");
            sb.append("\t}\n");
        }
        return sb.toString();
    }

    protected String genInitScript() {
        ScriptCollection col = this.model.getScripts();
        boolean hasCommonJS = false;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            ScriptInfo script = col.get(i);
            if (script.getReference().indexOf("resource/common.js") < 0) continue;
            hasCommonJS = true;
            break;
        }
        if (!hasCommonJS) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\tprotected String getInitializeScript() {\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "StringBuffer sb = new StringBuffer();" + "\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "String _super = super.getInitializeScript();" + "\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "if(!StringUtils.isEmpty(_super))" + "\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 3) + "sb.append(_super);" + "\n");
        String script = this.component2MBeanHelper.getSmartLayoutScript();
        String[] scripts = script.split("\n");
        for (int i = 0; i < scripts.length; ++i) {
            sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "sb.append(\"" + StringUtils.replace((String)scripts[i], (String)"\"", (String)"\\\"") + "\");" + "\n");
        }
        script = this.component2MBeanHelper.getOtherScript();
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "sb.append(\"" + StringUtils.replace((String)script, (String)"\"", (String)"\\\"") + "\");" + "\n");
        sb.append(AbstractWebUIGenerator.getSymbolTimes("\t", 2) + "return sb.toString();" + "\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    protected boolean filterDeclaration(Element element) {
        ComponentInfo cInfo;
        return element != null && (cInfo = element.getComponentInfo()) != null && cInfo.isHerited();
    }

    protected String elementDeclarationName(Element element) {
        return element.getDeclarName();
    }

    public boolean isLinkBind(ComponentInfo cInfo) {
        if (cInfo != null) {
            if ("com.kingdee.bos.ctrl.web.PromptBox".equalsIgnoreCase(cInfo.getClassType())) {
                return true;
            }
            if ("com.kingdee.bos.ctrl.web.EditableColumn".equalsIgnoreCase(cInfo.getClassType()) && cInfo.getComponents().size() > 0 && "com.kingdee.bos.ctrl.web.PromptBox".equalsIgnoreCase(cInfo.getComponents().get(0).getClassType())) {
                return true;
            }
        }
        return false;
    }

    protected boolean isTreeType(String templateType) {
        return !StringUtils.isEmpty((String)templateType) && ("TreeDetail".equalsIgnoreCase(templateType) || "TreeBase".equalsIgnoreCase(templateType));
    }

    protected boolean isUITree(ComponentInfo cInfo) {
        return "com.kingdee.bos.ctrl.web.Tree".equals(cInfo.getClassType());
    }

    protected boolean isUICheckBox(ComponentInfo cInfo) {
        return "com.kingdee.bos.ctrl.web.CheckBox".equals(cInfo.getClassType());
    }
}

