/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.metadata.entity.EntityHelper;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public abstract class CodeWriter {
    public static final Logger logger = Logger.getLogger(CodeWriter.class);
    protected static final String TAB = "\t";
    protected static final String NL = "\n";
    protected static final String SP = " ";
    protected static final String CE = ";";
    protected static final String EQ = "=";
    protected static final String AN = "// ";

    public abstract String generate();

    protected static String getSymbolTimes(String symbol, int times) {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= times; ++i) {
            sb.append(symbol);
        }
        return sb.toString();
    }

    protected static String translate2ObjectType(String baseType) {
        if ("int".equals(baseType) || Integer.class.getName().equals(baseType)) {
            return "java.lang.Integer";
        }
        if ("boolean".equals(baseType) || Boolean.class.getName().equals(baseType)) {
            return "java.lang.Boolean";
        }
        if ("long".equals(baseType) || Long.class.getName().equals(baseType)) {
            return "java.lang.Long";
        }
        if ("float".equals(baseType) || Float.class.getName().equals(baseType)) {
            return "java.lang.Float";
        }
        if ("double".equals(baseType) || Double.class.getName().equals(baseType)) {
            return "java.lang.Double";
        }
        return baseType;
    }

    public static String rootPackage(EntityObjectInfo entityInfo) {
        String str = entityInfo.getPackage();
        int index = str.lastIndexOf(".");
        if (index == -1) {
            return str;
        }
        return str.substring(0, index);
    }

    public static String rootUrl(String packageName) {
        String url;
        String prefix = "com.kingdee.eas";
        if (packageName.startsWith(prefix)) {
            packageName = packageName.substring(prefix.length());
        }
        if (!(url = packageName.replace('.', '/')).startsWith("/")) {
            url = "/" + url;
        }
        return url + "/";
    }

    public static String shortPackage(String packageName) {
        String prefix = "com.kingdee.eas";
        if (packageName.startsWith(prefix)) {
            packageName = packageName.substring(prefix.length() + 1);
        }
        return packageName;
    }

    public static EntityObjectInfo getOne2ManyEntryType(EntityObjectInfo parent, String entryName) {
        return EntityHelper.getEntryEntity(parent, entryName);
    }

    private PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null && prop instanceof LinkPropertyInfo; ++i) {
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    public static String getInfoClass(EntityObjectInfo info) {
        return CodeWriter.rootPackage(info) + "." + info.getName() + "Info";
    }

    public static String getCollectionClass(EntityObjectInfo info) {
        return CodeWriter.rootPackage(info) + "." + info.getName() + "Collection";
    }

    protected static boolean isEL(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.trim().startsWith("#{") && str.trim().endsWith("}");
    }
}

