/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.resource.BizEnumCtrl;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.util.StringUtils;

public class QueryFieldHelper {
    private QueryFieldInfo queryFieldInfo;
    private DataType dataType;
    private ConstDataType underlyingDataType;
    private String displayName;
    private String fieldName;
    private BizEnumInfo enumInfo;

    public QueryFieldHelper(Context ctx, QueryFieldInfo queryFieldInfo) throws BOSException {
        this.queryFieldInfo = queryFieldInfo;
        PropertyRefInfo propertyRef = queryFieldInfo.getPropertyRefs().get(0);
        PropertyInfo property = propertyRef.getRefProperty();
        this.underlyingDataType = queryFieldInfo.getReturnType();
        this.fieldName = queryFieldInfo.getName();
        this.displayName = queryFieldInfo.getDisplayName();
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo p = (OwnPropertyInfo)property;
            this.dataType = p.getDataType();
            if (DataType.ENUM.equals(this.dataType)) {
                String mdName = p.getMetaDataRef();
                this.enumInfo = new BizEnumCtrl(ctx).getValue(MetaDataPK.create(mdName));
            }
        }
    }

    public ConstDataType getUnderlyingDataType() {
        return this.underlyingDataType;
    }

    public BizEnumInfo getEnumInfo() {
        return this.enumInfo;
    }

    public QueryFieldInfo getQueryFieldInfo() {
        return this.queryFieldInfo;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldNameAsID() {
        if (this.fieldName != null && this.fieldName.length() > 0) {
            return StringUtils.replace((String)this.fieldName, (String)".", (String)"_");
        }
        return this.fieldName;
    }
}

