/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.IORWException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.code.webui.AbstractWebEditUIGenerator;
import com.kingdee.bos.metadata.code.webui.AbstractWebListUIGenerator;
import com.kingdee.bos.metadata.code.webui.AbstractWebUIEntryGenerator;
import com.kingdee.bos.metadata.code.webui.AbstractWebUIGenerator;
import com.kingdee.bos.metadata.code.webui.CodeWriter;
import com.kingdee.bos.metadata.code.webui.WebEditUIGenerator;
import com.kingdee.bos.metadata.code.webui.WebListUIGenerator;
import com.kingdee.bos.metadata.code.webui.WebUICodeGeneratorHelper;
import com.kingdee.bos.metadata.code.webui.WebUIEntryGenerator;
import com.kingdee.bos.metadata.code.webui.WebUIGenerator;
import com.kingdee.bos.metadata.code.webui.XHTMLGenerator;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.service.netfile.InvalidateNetFileSourceException;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom.Document;

public class WebCodeFactory {
    private static Logger logger = Logger.getLogger(WebCodeFactory.class);
    private static NetFileSource fileSrc = null;
    private static NetFileFactory fileFactory = null;
    private static OutputStreamWriter ow = null;
    private static NetFile file = null;
    private static CodeWriterBase iw = null;

    private WebCodeFactory() {
    }

    public static void createWebUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model) throws IORWException {
        XHTMLGenerator generator = new XHTMLGenerator(model);
        Document doc = generator.generate(true);
        String fileName = StringUtils.headCharLowerCase((String)model.getReleaseClass()) + ".xhtml";
        String packageName = model.getReleasePackage();
        try {
            CodeFactory.generateXHTML(doc, CodeFactory.getWebUIShortPackage(packageName), pageRepository, fileName);
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
        DataObjectCollection dataCol = model.getDataObjects();
        if (dataCol.size() > 0) {
            DataObjectInfo dataObj = dataCol.get(0);
            boolean inherit = dataObj.isHerited();
            if ("enty".equals(dataObj.getObjectType())) {
                if (CodeFactory.isWebEditUI(model)) {
                    WebCodeFactory.createWebEditUICode(ctx, javaRepository, null, model, MetaDataPK.create(dataObj.getType()), inherit);
                } else {
                    WebCodeFactory.createCommonWebUICode(ctx, javaRepository, null, model, inherit);
                }
            } else if ("jqye".equals(dataObj.getObjectType())) {
                if (CodeFactory.isWebListUI(model)) {
                    WebCodeFactory.createWebListUICode(ctx, javaRepository, null, model, MetaDataPK.create(dataObj.getType()), inherit);
                } else {
                    WebCodeFactory.createCommonWebUICode(ctx, javaRepository, null, model, inherit);
                }
            }
        } else {
            WebCodeFactory.createCommonWebUICode(ctx, javaRepository, null, model, false);
        }
    }

    public static void createWebListUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, IMetaDataPK queryPK, boolean inherit) throws IORWException {
        try {
            JoinQueryInfo info = null;
            try {
                info = new JoinQueryCtrl(ctx).getValue(queryPK);
            }
            catch (Exception e) {
                throw new IORWException(e);
            }
            SubObjectInfo subObject = info.getMainObject();
            while (subObject instanceof SubQueryInfo) {
                SubQueryInfo subQuery = (SubQueryInfo)subObject;
                subObject = subQuery.getQueryRef().getMainObject();
            }
            SubEntityInfo subEntity = (SubEntityInfo)subObject;
            EntityObjectInfo entityInfo = subEntity.getEntityRef();
            String packageName = model.getReleasePackage();
            String className = model.getReleaseClass() + "Bean";
            JoinQueryInfo query = WebUICodeGeneratorHelper.getQueryFieldByPK(ctx, queryPK);
            String[][] files = new String[][]{{AbstractWebListUIGenerator.class.getName(), "Abstract" + className + ".java", "true"}, {WebListUIGenerator.class.getName(), className + ".java", "false"}};
            WebCodeFactory.generateWebCode(ctx, new Object[]{entityInfo, queryPK, model, inherit, query}, model, packageName, javaRepository, files);
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            Properties[] langProperties = new Properties[locales.length];
            int n = locales.length;
            for (int k = 0; k < n; ++k) {
                langProperties[k] = new Properties();
            }
            ComponentCollection col = WebUICodeGeneratorHelper.allComponents(model);
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                ComponentInfo component = col.get(i);
                int size = component.getProperties().size();
                for (int j = 0; j < size; ++j) {
                    PropertyInfo p = component.getProperties().get(j);
                    if (!p.isMultiLanguage()) continue;
                    for (int k = 0; k < locales.length; ++k) {
                        if (CodeFactory.generateSpecialResource(component, p, langProperties[k], locales[k])) continue;
                        String key = component.getName() + "." + p.getName();
                        String value = p.getValue(locales[k]);
                        if (value == null) {
                            value = "";
                        }
                        langProperties[k].setProperty(key, value);
                    }
                }
            }
            int n2 = locales.length;
            for (int i = 0; i < n2; ++i) {
                String shortCode = BOSLocaleUtil.getShortCode(locales[i]);
                if (StringUtils.isEmpty((String)shortCode)) continue;
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", "Abstract" + className + "_" + shortCode + ".properties", "true"}};
                CodeFactory.generateCode(new Object[]{langProperties[i]}, packageName, javaRepository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e.getMessage(), e);
        }
    }

    public static void createWebEditUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, IMetaDataPK entityPK, boolean inherit) throws IORWException {
        EntityObjectInfo entityInfo = null;
        try {
            entityInfo = new EntityObjectCtrl(ctx).getValue(entityPK);
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
        PropertyCollection col = entityInfo.getInheritedProperties();
        ArrayList<String> list = new ArrayList<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            LinkPropertyInfo link;
            com.kingdee.bos.metadata.entity.PropertyInfo p = col.get(i);
            if (!(p instanceof LinkPropertyInfo) || !(link = (LinkPropertyInfo)p).getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !link.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) continue;
            list.add(link.getName());
        }
        String[] strs = new String[list.size()];
        list.toArray(strs);
        WebCodeFactory.createWebEditUICode(ctx, javaRepository, pageRepository, model, entityPK, strs, inherit);
    }

    public static void createWebEditUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, IMetaDataPK entityPK, String[] entries, boolean inherit) throws IORWException {
        try {
            EntityObjectInfo entityInfo = null;
            try {
                entityInfo = new EntityObjectCtrl(ctx).getValue(entityPK);
            }
            catch (Exception e) {
                throw new IORWException(e);
            }
            String packageName = model.getReleasePackage();
            String className = model.getReleaseClass() + "Bean";
            String fullClassName = packageName + "." + className;
            String rootUrl = WebUICodeGeneratorHelper.rootUrl(packageName);
            List list = WebUICodeGeneratorHelper.getEntityPropertyList(ctx, entityInfo);
            String[][] files = new String[][]{{AbstractWebEditUIGenerator.class.getName(), "Abstract" + className + ".java", "true"}, {WebEditUIGenerator.class.getName(), className + ".java", "false"}};
            WebCodeFactory.generateWebCode(ctx, new Object[]{entityInfo, entries, list, model, inherit}, model, packageName, javaRepository, files);
            for (int i = 0; i < entries.length; ++i) {
                String entry = entries[i];
                EntityObjectInfo childInfo = WebUICodeGeneratorHelper.getOne2ManyEntryType(entityInfo, entry);
                if (childInfo == null) {
                    logger.info((Object)("can not found EntityObjectInfo named '" + entry + "'"));
                    continue;
                }
                files = new String[][]{{AbstractWebUIEntryGenerator.class.getName(), "Abstract" + childInfo.getName() + "Bean.java", "true"}, {WebUIEntryGenerator.class.getName(), childInfo.getName() + "Bean.java", "false"}};
                WebCodeFactory.generateWebCode(ctx, new Object[]{entityInfo, entry, model}, model, packageName, javaRepository, files);
            }
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            Properties[] langProperties = new Properties[locales.length];
            int n = locales.length;
            for (int k = 0; k < n; ++k) {
                langProperties[k] = new Properties();
            }
            ComponentCollection col = WebUICodeGeneratorHelper.allComponents(model);
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                ComponentInfo component = col.get(i);
                int size = component.getProperties().size();
                for (int j = 0; j < size; ++j) {
                    PropertyInfo p = component.getProperties().get(j);
                    if (!p.isMultiLanguage()) continue;
                    for (int k = 0; k < locales.length; ++k) {
                        if (CodeFactory.generateSpecialResource(component, p, langProperties[k], locales[k])) continue;
                        String key = component.getName() + "." + p.getName();
                        String value = p.getValue(locales[k]);
                        if (value == null) {
                            value = "";
                        }
                        langProperties[k].setProperty(key, value);
                    }
                }
            }
            int n2 = locales.length;
            for (int i = 0; i < n2; ++i) {
                String shortCode = BOSLocaleUtil.getShortCode(locales[i]);
                if (StringUtils.isEmpty((String)shortCode)) continue;
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", "Abstract" + className + "_" + shortCode + ".properties", "true"}};
                CodeFactory.generateCode(new Object[]{langProperties[i]}, packageName, javaRepository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e.getMessage(), e);
        }
    }

    private static void init(String repository, String packageName) throws InvalidateNetFileSourceException, MalformedURLException {
        if (packageName != null && !packageName.equals("")) {
            packageName = packageName.replace('.', File.separatorChar);
            repository = repository + File.separatorChar + packageName;
        }
        fileSrc = new NetFileSource(new File(repository).toURL().toString());
        fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        ow = null;
        file = null;
        iw = null;
    }

    public static void generateWebCode(Context ctx, Object arg, WebUIObjectInfo uiModel, String pkgName, String repository, String[][] files) throws Exception {
        WebCodeFactory.init(repository, pkgName);
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i] == null || files[i][0] == null || files[i][1] == null) continue;
                if (files[i][2] == null) {
                }
            }
            catch (RuntimeException e) {}
            continue;
            String templateFilePath = files[i][0];
            String generatedText = WebCodeFactory.generateWebCodeStr(arg, uiModel, templateFilePath, ctx);
            boolean needOverwrite = new Boolean(files[i][2]);
            CodeFactory.writeStreamToFile(fileFactory, file, files[i][1], generatedText, needOverwrite);
            String fileName = files[i][1];
            if (pkgName != null && !pkgName.equals("")) {
                pkgName = pkgName.replace('.', File.separatorChar);
                fileName = pkgName + File.separatorChar + fileName;
            }
            CodeFactory.recorder.fileGenerated(fileName);
        }
    }

    public static void createCommonWebUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, boolean inherit) throws IORWException {
        try {
            String packageName = model.getReleasePackage();
            String className = model.getReleaseClass() + "Bean";
            String fullClassName = packageName + "." + className;
            String rootUrl = WebUICodeGeneratorHelper.rootUrl(packageName);
            String[][] files = new String[][]{{AbstractWebUIGenerator.class.getName(), "Abstract" + className + ".java", "true"}, {WebUIGenerator.class.getName(), className + ".java", "false"}};
            WebCodeFactory.generateWebCode(ctx, new Object[]{model, inherit}, model, packageName, javaRepository, files);
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            Properties[] langProperties = new Properties[locales.length];
            int n = locales.length;
            for (int k = 0; k < n; ++k) {
                langProperties[k] = new Properties();
            }
            ComponentCollection col = WebUICodeGeneratorHelper.allComponents(model);
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                ComponentInfo component = col.get(i);
                int size = component.getProperties().size();
                for (int j = 0; j < size; ++j) {
                    PropertyInfo p = component.getProperties().get(j);
                    if (!p.isMultiLanguage()) continue;
                    for (int k = 0; k < locales.length; ++k) {
                        if (CodeFactory.generateSpecialResource(component, p, langProperties[k], locales[k])) continue;
                        String key = component.getName() + "." + p.getName();
                        String value = p.getValue(locales[k]);
                        if (value == null) {
                            value = "";
                        }
                        langProperties[k].setProperty(key, value);
                    }
                }
            }
            int n2 = locales.length;
            for (int i = 0; i < n2; ++i) {
                String shortCode = BOSLocaleUtil.getShortCode(locales[i]);
                if (StringUtils.isEmpty((String)shortCode)) continue;
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", "Abstract" + className + "_" + shortCode + ".properties", "true"}};
                CodeFactory.generateCode(new Object[]{langProperties[i]}, packageName, javaRepository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e.getMessage(), e);
        }
    }

    public static String generateWebCodeStr(Object arg, WebUIObjectInfo uiModel, String generator, Context ctx) {
        if (arg instanceof WebUIObjectInfo) {
            uiModel = (WebUIObjectInfo)arg;
            DataObjectCollection dataCol = uiModel.getDataObjects();
            if (dataCol.size() > 0) {
                DataObjectInfo dataObj = dataCol.get(0);
                boolean inherit = dataObj.isHerited();
                if ("enty".equals(dataObj.getObjectType())) {
                    if (CodeFactory.isWebEditUI(uiModel)) {
                        IObjectValue objectValue = dataObj.getInstance();
                        PropertyCollection col = ((EntityObjectInfo)objectValue).getInheritedProperties();
                        ArrayList<String> list = new ArrayList<String>(col.size());
                        for (int i = 0; i < col.size(); ++i) {
                            LinkPropertyInfo link;
                            com.kingdee.bos.metadata.entity.PropertyInfo p = col.get(i);
                            if (!(p instanceof LinkPropertyInfo) || !(link = (LinkPropertyInfo)p).getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !link.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) continue;
                            list.add(link.getName());
                        }
                        String[] entries = new String[list.size()];
                        List proList = WebUICodeGeneratorHelper.getEntityPropertyList(ctx, (EntityObjectInfo)objectValue);
                        arg = new Object[]{objectValue, entries, proList, uiModel, inherit};
                        generator = AbstractWebEditUIGenerator.class.getName();
                    } else {
                        arg = null;
                        generator = AbstractWebUIGenerator.class.getName();
                    }
                } else if ("jqye".equals(dataObj.getObjectType())) {
                    if (CodeFactory.isWebListUI(uiModel)) {
                        JoinQueryInfo info = null;
                        try {
                            info = new JoinQueryCtrl(ctx).getValue(MetaDataPK.create(dataObj.getType()));
                            SubObjectInfo subObject = info.getMainObject();
                            while (subObject instanceof SubQueryInfo) {
                                SubQueryInfo subQuery = (SubQueryInfo)subObject;
                                subObject = subQuery.getQueryRef().getMainObject();
                            }
                            SubEntityInfo subEntity = (SubEntityInfo)subObject;
                            EntityObjectInfo entityInfo = subEntity.getEntityRef();
                            arg = new Object[]{entityInfo, MetaDataPK.create(dataObj.getType()), uiModel, inherit, info};
                            generator = AbstractWebListUIGenerator.class.getName();
                        }
                        catch (BOSException e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    } else {
                        arg = null;
                        generator = AbstractWebUIGenerator.class.getName();
                    }
                }
            } else {
                arg = null;
                generator = AbstractWebUIGenerator.class.getName();
            }
        }
        String code = "no.";
        try {
            Constructor<?> constructor = Class.forName(generator).getConstructor(WebUIObjectInfo.class, Object[].class);
            Object instance = constructor.newInstance(uiModel, arg);
            code = ((CodeWriter)instance).generate();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            code = StringUtils.stackToString((Exception)e);
        }
        return code;
    }
}

