/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.code.webui.PropertyHelper;
import com.kingdee.bos.metadata.code.webui.QueryFieldHelper;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityHelper;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WebUICodeGeneratorHelper {
    private static Logger logger = Logger.getLogger(WebUICodeGeneratorHelper.class);

    public static ComponentCollection allComponents(WebUIObjectInfo info) {
        ComponentCollection col = new ComponentCollection();
        WebUICodeGeneratorHelper.addComponents(col, info.getComponents());
        return col;
    }

    private static void addComponents(ComponentCollection target, ComponentCollection src) {
        int count = src.size();
        for (int i = 0; i < count; ++i) {
            target.add(src.get(i));
            if (src.get(i).getComponents() == null || src.get(i).getComponents().size() <= 0) continue;
            WebUICodeGeneratorHelper.addComponents(target, src.get(i).getComponents());
        }
    }

    public static String rootPackage(EntityObjectInfo entityInfo) {
        String str = entityInfo.getPackage();
        int index = str.lastIndexOf(".");
        if (index == -1) {
            return str;
        }
        return str.substring(0, index);
    }

    public static String rootUrl(String packageName) {
        String url;
        String prefix = "com.kingdee.eas";
        if (packageName.startsWith(prefix)) {
            packageName = packageName.substring(prefix.length());
        }
        if (!(url = packageName.replace('.', '/')).startsWith("/")) {
            url = "/" + url;
        }
        return url + "/";
    }

    public static String startLowerCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String startUpperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static JoinQueryInfo getQueryFieldByPK(Context ctx, IMetaDataPK queryPK) {
        JoinQueryInfo info = null;
        try {
            info = new JoinQueryCtrl(ctx).getValue(queryPK);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public static List getQueryFieldList(Context ctx, JoinQueryInfo info) {
        if (info == null) {
            return new ArrayList();
        }
        PropertyUnitCollection col = info.getUnits();
        ArrayList<QueryFieldHelper> list = new ArrayList<QueryFieldHelper>(col.size());
        try {
            for (int i = 0; i < col.size(); ++i) {
                PropertyUnitInfo unitInfo = col.get(i);
                if (!(unitInfo instanceof QueryFieldInfo)) continue;
                list.add(new QueryFieldHelper(ctx, (QueryFieldInfo)unitInfo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static List getQueryFieldList(Context ctx, IMetaDataPK queryPK) {
        JoinQueryInfo info = null;
        try {
            info = new JoinQueryCtrl(ctx).getValue(queryPK);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (info == null) {
            return new ArrayList();
        }
        PropertyUnitCollection col = info.getUnits();
        ArrayList<QueryFieldHelper> list = new ArrayList<QueryFieldHelper>(col.size());
        try {
            for (int i = 0; i < col.size(); ++i) {
                PropertyUnitInfo unitInfo = col.get(i);
                if (!(unitInfo instanceof QueryFieldInfo)) continue;
                list.add(new QueryFieldHelper(ctx, (QueryFieldInfo)unitInfo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static EntityObjectInfo getOne2ManyEntryType(EntityObjectInfo parent, String entryName) {
        return EntityHelper.getEntryEntity(parent, entryName);
    }

    public static List getEntityPropertyList(Context ctx, EntityObjectInfo info) {
        PropertyCollection col = info.getInheritedProperties();
        ArrayList<PropertyHelper> list = new ArrayList<PropertyHelper>(col.size());
        try {
            for (int i = 0; i < col.size(); ++i) {
                LinkPropertyInfo linkProp;
                CardinalityType cType;
                PropertyInfo propertyInfo = col.get(i);
                if (propertyInfo instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownInfo = (OwnPropertyInfo)propertyInfo;
                    if (ownInfo.getDataType().equals(DataType.BOSUUID) || ownInfo.getDataType().equals(DataType.BYTEARRAY) || ownInfo.getDataType().equals(DataType.OBJECTCOLLECTION) || ownInfo.getDataType().equals(DataType.OBJECTPK) || ownInfo.getDataType().equals(DataType.OBJECTVALUE) || ownInfo.getDataType().equals(DataType.ROWSET) || ownInfo.getDataType().equals(DataType.UUID)) continue;
                    list.add(new PropertyHelper(ctx, propertyInfo));
                    continue;
                }
                if (!(propertyInfo instanceof LinkPropertyInfo) || !(cType = (linkProp = (LinkPropertyInfo)propertyInfo).getRelationship().getSupplierCardinality()).equals((Object)CardinalityType.ZERO_TO_ONE) && !cType.equals((Object)CardinalityType.ONE)) continue;
                list.add(new PropertyHelper(ctx, propertyInfo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

