/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.code.webui.CodeWriter;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;

public class WebUIGenerator
extends CodeWriter {
    protected WebUIObjectInfo model;
    protected String packageName;
    protected String className;
    protected String shortPackage;
    protected String shortClassName;
    protected ComponentCollection components;

    public WebUIGenerator(WebUIObjectInfo model, Object[] nothing) {
        this.model = model;
        this.packageName = model.getReleasePackage();
        this.className = model.getReleaseClass() + "Bean";
        this.shortPackage = CodeFactory.getWebUIShortPackage(this.packageName);
        this.shortClassName = this.shortPackage + "." + this.className;
    }

    @Override
    public String generate() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.genPackage() + "\n");
        sb.append(this.genImport() + "\n");
        sb.append(this.genClassDeclarationStart() + "\n");
        sb.append(this.genClassDeclarationEnd() + "\n");
        return sb.toString();
    }

    protected String genPackage() {
        return "package " + this.packageName + ";" + "\n";
    }

    protected String genImport() {
        StringBuffer sb = new StringBuffer();
        sb.append("import java.util.LinkedList;\n");
        sb.append("import java.util.List;\n");
        sb.append("import org.operamasks.faces.annotation.Inject;\n");
        sb.append("import org.operamasks.faces.annotation.ManagedBean;\n");
        sb.append("import org.operamasks.faces.annotation.ManagedBeanScope;\n");
        sb.append("import com.kingdee.bos.ui.util.ResourceBundleHelper;\n");
        return sb.toString();
    }

    protected String genClassDeclarationStart() {
        StringBuffer sb = new StringBuffer();
        sb.append("@ManagedBean(name = \"" + this.shortClassName + "\", scope = ManagedBeanScope.SESSION)" + "\n");
        sb.append("public class " + this.className + " extends Abstract" + this.className + " {" + "\n");
        return sb.toString();
    }

    protected String genClassDeclarationEnd() {
        return "}\n";
    }
}

