/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.webui.ScriptCollection;
import com.kingdee.bos.metadata.webui.ScriptInfo;
import com.kingdee.bos.metadata.webui.StyleSheetCollection;
import com.kingdee.bos.metadata.webui.StyleSheetInfo;
import com.kingdee.bos.metadata.webui.WebMetaCollection;
import com.kingdee.bos.metadata.webui.WebMetaInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.Component2XmlHelper;
import com.kingdee.bos.metadata.webui.transfer.WebUIModelMapper;
import com.kingdee.bos.metadata.webui.xhtml.WebTag;
import com.kingdee.bos.metadata.webui.xhtml.WebTags;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;

public class XHTMLGenerator {
    private WebUIObjectInfo model;
    private WebUIModelMapper modelMapper = null;
    boolean hasImportCommonJS = false;
    boolean is4DynBean = false;

    public XHTMLGenerator(WebUIObjectInfo model) {
        this.model = model;
    }

    private WebUIModelMapper getModelMapper() {
        if (this.modelMapper == null) {
            this.modelMapper = new WebUIModelMapper(this.model);
        }
        return this.modelMapper;
    }

    public Document generate(boolean is4DynBean) {
        ComponentInfo mainPanel;
        this.is4DynBean = is4DynBean;
        Document doc = this.createDocument();
        Element root = doc.getRootElement();
        this.addBoundleElements(root, this.model);
        Element kd = new Element("kd", WebTags.DEFAULTNS);
        root.addContent(kd);
        root.addContent(this.createHeadElement());
        if (!is4DynBean) {
            mainPanel = this.createMainPanelElement(this.model, this.model.getMainPanelComponent());
            root.addContent((Element)mainPanel);
        } else {
            mainPanel = this.model.getMainPanelComponent();
            WebTag webTag = WebUIModelMapper.getElementWebTag(mainPanel);
            Element page = Component2XmlHelper.createElementWithID(webTag, mainPanel.getName());
            root.addContent(page);
        }
        ScriptCollection scripts = this.model.getScripts();
        int n = scripts.size();
        for (int i = 0; i < n; ++i) {
            ScriptInfo script = scripts.get(i);
            if (!"end".equals(script.getLocation())) continue;
            Element scriptElement = new Element("script", WebTags.WNS);
            scriptElement.setAttribute("language", script.getType());
            if (!StringUtils.isEmpty((String)script.getReference())) {
                scriptElement.setAttribute("src", script.getReference());
            } else {
                scriptElement.setText(script.getScript());
            }
            root.addContent(scriptElement);
        }
        if (!is4DynBean && this.hasImportCommonJS) {
            Element smartLayoutScript = this.getSmartLayoutScriptElement();
            root.addContent(smartLayoutScript);
        }
        return doc;
    }

    public Document generate() {
        return this.generate(false);
    }

    private Document createDocument() {
        Document doc = new Document();
        doc.setRootElement(this.createViewElement());
        return doc;
    }

    private Element createViewElement() {
        Element root = new Element("view", WebTags.FNS);
        root.addNamespaceDeclaration(WebTags.AJAXNS);
        root.addNamespaceDeclaration(WebTags.BIZNS);
        root.addNamespaceDeclaration(WebTags.DEFAULTNS);
        root.addNamespaceDeclaration(WebTags.OMNS);
        root.addNamespaceDeclaration(WebTags.KDNS);
        root.addNamespaceDeclaration(WebTags.UINS);
        root.addNamespaceDeclaration(WebTags.LAYOUTNS);
        root.addNamespaceDeclaration(WebTags.HNS);
        root.addNamespaceDeclaration(WebTags.WNS);
        root.setAttribute("renderKitId", "AJAX");
        return root;
    }

    private Element createMainPanelElement(WebUIObjectInfo ui, ComponentInfo component) {
        return this.getModelMapper().createElement(component);
    }

    private Element getSmartLayoutScriptElement() {
        return this.getModelMapper().getSmartLayoutScriptElement();
    }

    private void addBoundleElements(Element root, WebUIObjectInfo ui) {
        Element msgsBundle = new Element("loadBundle", WebTags.FNS);
        msgsBundle.setAttribute("basename", "com.kingdee.bos.waf.winlet.resources.LocalStrings");
        msgsBundle.setAttribute("var", "msgs");
        root.addContent(msgsBundle);
        if (!this.is4DynBean) {
            Element extraMsgsBundle = new Element("loadBundle", WebTags.FNS);
            extraMsgsBundle.setAttribute("basename", ui.getPackage() + "." + ui.getName() + "Bean");
            extraMsgsBundle.setAttribute("var", "extraMsgs");
            root.addContent(extraMsgsBundle);
        }
    }

    private Element createHeadElement() {
        StyleSheetCollection cssCol;
        Element head = new Element("head", WebTags.WNS);
        boolean contentType = false;
        this.hasImportCommonJS = false;
        WebMetaCollection col = this.model.getMetas();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                WebMetaInfo info = col.get(i);
                if ("content-type".equalsIgnoreCase(info.getHttpEquiv())) {
                    contentType = true;
                }
                Element meta = new Element("meta", WebTags.DEFAULTNS);
                meta.setAttribute("http-equiv", info.getHttpEquiv());
                meta.setAttribute("content", info.getContent());
                head.addContent(meta);
            }
        }
        if (!contentType) {
            Element meta = new Element("meta", WebTags.DEFAULTNS);
            meta.setAttribute("http-equiv", "Content-Type");
            meta.setAttribute("content", "text/html; charset=UTF-8");
            head.addContent(meta);
        }
        if ((cssCol = this.model.getStyleSheets()) != null) {
            ArrayList<String> css = new ArrayList<String>();
            for (int i = 0; i < cssCol.size(); ++i) {
                StyleSheetInfo info = cssCol.get(i);
                String ref = info.getReference();
                if (css.contains(ref)) continue;
                css.add(ref);
                Element elem = null;
                if (ref == null || ref.indexOf("skin.getSkinReourceURL") >= 0) {
                    elem = new Element("link", WebTags.DEFAULTNS);
                    elem.setAttribute("rel", "stylesheet");
                    elem.setAttribute("type", "text/css");
                    elem.setAttribute("href", info.getReference());
                } else {
                    elem = new Element("stylesheet", WebTags.WNS);
                    elem.setAttribute("src", info.getReference());
                }
                head.addContent(elem);
            }
        }
        ScriptCollection scripts = this.model.getScripts();
        ArrayList<String> js = new ArrayList<String>();
        int n = scripts.size();
        for (int i = 0; i < n; ++i) {
            ScriptInfo script = scripts.get(i);
            if ("end".equals(script.getLocation()) || js.contains(script.getReference())) continue;
            js.add(script.getReference());
            Element scriptElement = new Element("script", WebTags.WNS);
            scriptElement.setAttribute("language", script.getType());
            if (!StringUtils.isEmpty((String)script.getReference())) {
                scriptElement.setAttribute("src", script.getReference());
                if (script.getReference().indexOf("resource/common.js") >= 0) {
                    this.hasImportCommonJS = true;
                }
            } else {
                scriptElement.setText(script.getScript());
            }
            head.addContent(scriptElement);
        }
        return head;
    }

    public static void main(String[] args) {
    }
}

