/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui.model;

import com.kingdee.bos.metadata.code.webui.model.Attribute;
import com.kingdee.bos.metadata.code.webui.model.ConvertorAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELActionAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELActionBindingAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELActionListenerAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELMethodAttribute;
import com.kingdee.bos.metadata.code.webui.model.ELValueAttribute;
import com.kingdee.bos.metadata.code.webui.model.InvokeAttribute;
import com.kingdee.bos.metadata.code.webui.model.ValidatorAttribute;
import com.kingdee.bos.metadata.code.webui.model.ValueAttribute;
import com.kingdee.bos.metadata.code.webui.util.UIComponentMapping;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Element {
    private ComponentInfo cInfo;
    private String uiClazz;
    private String uiComponentType;
    private String id;
    private String declarName;
    private Map styleSheet = new HashMap();
    private List valueAttributes = new ArrayList();
    private List invokeAttributes = new ArrayList();
    private List elActionAttributes = new ArrayList();
    private List elActionBindingAttributes = new ArrayList();
    private List elActionListenerAttributes = new ArrayList();
    private List elMethodAttributes = new ArrayList();
    private List elValueAttributes = new ArrayList();
    private List validatorAttributes = new ArrayList();
    private List convertorAttributes = new ArrayList();
    private List children = new ArrayList();
    private Element parent;

    public Element(ComponentInfo cInfo, String id, String uiClazz) {
        this.id = id;
        this.cInfo = cInfo;
        this.setUIClazz(uiClazz);
    }

    public void addElement(Element element) {
        if (element == null) {
            return;
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Element ele = (Element)iter.next();
            if (!ele.getId().equals(element.getId())) continue;
            iter.remove();
            break;
        }
        element.setParent(this);
        this.children.add(element);
    }

    public void removeElement(Element element) {
        if (element == null) {
            return;
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Element ele = (Element)iter.next();
            if (!ele.getId().equals(element.getId())) continue;
            ele.setParent(null);
            iter.remove();
            break;
        }
    }

    public void removeAllElement() {
        this.children.clear();
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDeclarName() {
        ComponentInfo parent;
        if (StringUtils.isEmpty((String)this.id)) {
            return this.id;
        }
        if (!StringUtils.isEmpty((String)this.declarName)) {
            return this.declarName;
        }
        this.declarName = this.id;
        if ((this.isColumn(this.cInfo) || this.isColumnEditor(this.cInfo)) && (parent = this.getParentByClassType(this.cInfo, new String[]{"com.kingdee.bos.ctrl.web.DataGrid", "com.kingdee.bos.ctrl.web.EditDataGrid"})) != null) {
            this.declarName = parent.getName() + "_" + this.id;
        }
        return this.declarName;
    }

    public void setDeclarName(String declarName) {
        this.declarName = declarName;
    }

    public String getUIClazz() {
        return this.uiClazz;
    }

    public void setUIClazz(String uiClazz) {
        this.uiClazz = uiClazz;
        UIComponentMapping mapping = UIComponentMapping.getInstance();
        this.uiComponentType = mapping.getUIComponentType(uiClazz);
    }

    public ComponentInfo getComponentInfo() {
        return this.cInfo;
    }

    public void setComponentInfo(ComponentInfo info) {
        this.cInfo = info;
    }

    public String getUIComponentType() {
        return this.uiComponentType;
    }

    public void setUIComponentType(String uiComponentType) {
        this.uiComponentType = uiComponentType;
    }

    public void mergeStyleSheet(String css) {
        this.mergeStyleSheet("style", css);
    }

    public void mergeStyleSheet(String styleAttr, String css) {
        Object obj = this.styleSheet.get(styleAttr);
        String style = obj != null ? (obj.toString().trim().endsWith(";") ? obj.toString() + css : obj.toString() + ";" + css) : css;
        this.styleSheet.put(styleAttr, style);
    }

    public Map getStyleSheet() {
        return this.styleSheet;
    }

    public ValueAttribute getValueAttribute(String name) {
        return (ValueAttribute)this.getAttribute(this.valueAttributes, name);
    }

    public InvokeAttribute getInvokeAttribute(String name) {
        return (InvokeAttribute)this.getAttribute(this.invokeAttributes, name);
    }

    public ELValueAttribute getELValueAttribute(String name) {
        return (ELValueAttribute)this.getAttribute(this.elValueAttributes, name);
    }

    public ELActionAttribute getELActionAttribute(String name) {
        return (ELActionAttribute)this.getAttribute(this.elActionAttributes, name);
    }

    public ELActionBindingAttribute getELActionBindingAttribute(String name) {
        return (ELActionBindingAttribute)this.getAttribute(this.elActionBindingAttributes, name);
    }

    public ELActionListenerAttribute getELActionListenerAttribute(String name) {
        return (ELActionListenerAttribute)this.getAttribute(this.elActionListenerAttributes, name);
    }

    public ELMethodAttribute getELMethodAttribute(String name) {
        return (ELMethodAttribute)this.getAttribute(this.elMethodAttributes, name);
    }

    public ValidatorAttribute getValidatorAttribute(String name) {
        return (ValidatorAttribute)this.getAttribute(this.validatorAttributes, name);
    }

    public ConvertorAttribute getConvertorAttribute(String name) {
        return (ConvertorAttribute)this.getAttribute(this.convertorAttributes, name);
    }

    private Attribute getAttribute(List list, String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        for (Attribute va : list) {
            if (!name.equals(va.getName())) continue;
            return va;
        }
        return null;
    }

    public List getValueAttributes() {
        return this.valueAttributes;
    }

    public void addValueAttribute(ValueAttribute value) {
        if (value == null) {
            return;
        }
        Iterator iterator = this.valueAttributes.iterator();
        while (iterator.hasNext()) {
            ValueAttribute att = (ValueAttribute)iterator.next();
            if (!att.getName().equalsIgnoreCase(value.getName())) continue;
            iterator.remove();
            break;
        }
        this.valueAttributes.add(value);
    }

    public List getInvokeAttributes() {
        return this.invokeAttributes;
    }

    public void addInvokeAttribute(InvokeAttribute value) {
        if (value == null) {
            return;
        }
        Iterator iterator = this.invokeAttributes.iterator();
        while (iterator.hasNext()) {
            InvokeAttribute att = (InvokeAttribute)iterator.next();
            if (!att.getName().equalsIgnoreCase(value.getName())) continue;
            iterator.remove();
            break;
        }
        this.invokeAttributes.add(value);
    }

    public List getELActionAttributes() {
        return this.elActionAttributes;
    }

    public void addELActionAttribute(ELActionAttribute el) {
        if (el == null) {
            return;
        }
        Iterator iterator = this.elActionAttributes.iterator();
        while (iterator.hasNext()) {
            ELActionAttribute att = (ELActionAttribute)iterator.next();
            if (!att.getEl().equals(el.getEl())) continue;
            iterator.remove();
            break;
        }
        this.elActionAttributes.add(el);
    }

    public List getELActionBindingAttributes() {
        return this.elActionBindingAttributes;
    }

    public void addELActionBindingAttribute(ELActionBindingAttribute el) {
        if (el == null) {
            return;
        }
        Iterator iterator = this.elActionBindingAttributes.iterator();
        while (iterator.hasNext()) {
            ELActionBindingAttribute att = (ELActionBindingAttribute)iterator.next();
            if (!att.getValue().equals(el.getValue())) continue;
            iterator.remove();
            break;
        }
        this.elActionBindingAttributes.add(el);
    }

    public List getELActionListenerAttributes() {
        return this.elActionListenerAttributes;
    }

    public void addELActionListenerAttribute(ELActionListenerAttribute el) {
        if (el == null) {
            return;
        }
        Iterator iterator = this.elActionListenerAttributes.iterator();
        while (iterator.hasNext()) {
            ELActionListenerAttribute att = (ELActionListenerAttribute)iterator.next();
            if (!att.getEl().equals(el.getEl())) continue;
            iterator.remove();
            break;
        }
        this.elActionListenerAttributes.add(el);
    }

    public List getELMethodAttributes() {
        return this.elMethodAttributes;
    }

    public void addELMethodAttribute(ELMethodAttribute el) {
        if (el == null) {
            return;
        }
        Iterator iterator = this.elMethodAttributes.iterator();
        while (iterator.hasNext()) {
            ELMethodAttribute att = (ELMethodAttribute)iterator.next();
            if (!att.getMethodName().equals(el.getMethodName()) || !att.getEl().equals(el.getEl())) continue;
            iterator.remove();
            break;
        }
        this.elMethodAttributes.add(el);
    }

    public List getELValueAttributes() {
        return this.elValueAttributes;
    }

    public void addELValueAttribute(ELValueAttribute el) {
        if (el == null) {
            return;
        }
        Iterator iterator = this.elValueAttributes.iterator();
        while (iterator.hasNext()) {
            ELValueAttribute att = (ELValueAttribute)iterator.next();
            if (!att.getName().equalsIgnoreCase(el.getName()) || !att.getEl().equals(el.getEl())) continue;
            iterator.remove();
            break;
        }
        this.elValueAttributes.add(el);
    }

    public List getValidatorAttributes() {
        return this.validatorAttributes;
    }

    public void addValidatorAttribute(ValidatorAttribute validator) {
        if (validator == null) {
            return;
        }
        this.validatorAttributes.add(validator);
    }

    public List getConvertorAttributes() {
        return this.convertorAttributes;
    }

    public void addConvertorAttribute(ConvertorAttribute convertor) {
        if (convertor == null) {
            return;
        }
        this.convertorAttributes.add(convertor);
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    protected boolean isColumn(ComponentInfo cInfo) {
        return cInfo != null && ("com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equals(cInfo.getClassType()));
    }

    protected boolean isColumnEditor(ComponentInfo cInfo) {
        return cInfo != null && this.isColumn(cInfo.getParent());
    }

    protected ComponentInfo getParentByClassType(ComponentInfo cInfo, String[] classTypes) {
        if (cInfo == null) {
            return null;
        }
        ComponentInfo parent = null;
        if (cInfo != null && classTypes != null) {
            parent = cInfo.getParent();
            for (int i = 0; i < classTypes.length; ++i) {
                String classType = classTypes[i];
                if (StringUtils.isEmpty((String)classType) || parent == null || !classType.equals(parent.getClassType())) continue;
                return parent;
            }
            return this.getParentByClassType(parent, classTypes);
        }
        return null;
    }
}

