/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.HostType;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MDHostTypes;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.DynamicMD;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DynamicMDContainer {
    private static final Map<String, List<DynamicMD>> dmds = new HashMap<String, List<DynamicMD>>(4);
    private static String mdPath = Utils.getMetadataSrc(ConfigMDUtil.getContext());

    public static List<DynamicMD> getDynamicMDs(Context ctx, Project.Projects depends) {
        String key = Project.Projects.getKey(depends);
        List<DynamicMD> list = dmds.get(key);
        if (list != null) {
            return list;
        }
        list = new ArrayList<DynamicMD>();
        Map<BOSObjectType, Set<IMetaDataPK>> type2Pks = MDContextFactory.getSystemMDContext().pkIndexs.getMetaDataPKsFromDB(depends);
        if (type2Pks != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ctx);
            SolutionInfo si = loader.getSolution();
            LanguageCollection lc = si.getLanguages();
            for (Map.Entry<BOSObjectType, Set<IMetaDataPK>> entry : type2Pks.entrySet()) {
                BOSObjectType type = entry.getKey();
                Set<IMetaDataPK> pks = entry.getValue();
                if (pks == null) continue;
                for (IMetaDataPK pk : pks) {
                    DynamicMD dmd = new DynamicMD(pk, type);
                    for (int i = 0; i < lc.size(); ++i) {
                        Locale locale = lc.get(i).getOriginalLocale();
                        AbstractMetaDataValue mdv = (AbstractMetaDataValue)loader.get(type, pk, depends);
                        if (mdv == null) continue;
                        String alias = mdv.getAlias(locale);
                        dmd.setAlias(alias, locale);
                    }
                    list.add(dmd);
                }
            }
            dmds.put(key, list);
        }
        return list;
    }

    public static void clearDynamicMDs(Context ctx) {
        String ais = ConfigMDUtil.getAIS(ctx);
        Iterator<Map.Entry<String, List<DynamicMD>>> iterator = dmds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<DynamicMD>> entry = iterator.next();
            String key = entry.getKey();
            if (!key.startsWith(ais)) continue;
            iterator.remove();
        }
    }

    public static List<MetaDataPK2> getAssociatedMDPKs(Context ctx, MetaDataPK2 pk2) throws BOSException {
        return DynamicMDContainer.getAssociatedMDPKs(ctx, new MetaDataPK2[]{pk2});
    }

    public static List<MetaDataPK2> getAssociatedMDPKs(Context ctx, MetaDataPK2[] pks) throws BOSException {
        return DynamicMDContainer.getAssociatedMDPKs(ctx, pks, null);
    }

    public static List<MetaDataPK2> getAssociatedMDPKs(Context ctx, MetaDataPK2[] pks, Project.Projects depends) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ctx);
        HashSet<MetaDataPK2> associatedPks = new HashSet<MetaDataPK2>();
        HashSet<MetaDataPK2> visted = new HashSet<MetaDataPK2>();
        for (int i = 0; i < pks.length; ++i) {
            BOSObjectType type = BOSObjectType.create((String)pks[i].getType());
            MetaDataPK pk = MetaDataPK.create(pks[i].getFullName());
            AbstractMetaDataValue metadata = (AbstractMetaDataValue)loader.get(type, pk, depends);
            if (MetaDataTypeList.BIZUNIT.equals((Object)type)) {
                DynamicMDContainer.getBizUnitAssociatedMDPKs(ctx, (BizUnitInfo)metadata, associatedPks, visted, depends);
                continue;
            }
            DynamicMDContainer.getAssociatedMDPKs0(ctx, metadata, associatedPks, visted, depends);
        }
        return new ArrayList<MetaDataPK2>(associatedPks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBizUnitAssociatedMDPKs(Context ctx, BizUnitInfo bizUnit, Set<MetaDataPK2> associatedPks, Set<MetaDataPK2> visted, Project.Projects depends) throws BOSException {
        DynamicMDContainer.getAssociatedMDPKs0(ctx, bizUnit, associatedPks, visted, depends);
        Object c1 = ctx.get((Object)"DEVMETADATALOADER");
        Object c2 = ctx.get(HostType.class);
        Object c3 = ctx.get((Object)"METADATAPATH");
        ctx.put((Object)"DEVMETADATALOADER", null);
        ctx.put(HostType.class, (Object)new MDHostTypes(new MDHostType[]{MDHostType.RUNTIME, MDHostType.SPECIFY_METAMETA}));
        ctx.put((Object)"METADATAPATH", (Object)mdPath);
        try {
            BizUnitCtrl buCtrl = new BizUnitCtrl(ctx);
            buCtrl.loadAll(bizUnit);
        }
        finally {
            ctx.put((Object)"DEVMETADATALOADER", c1);
            ctx.put(HostType.class, c2);
            ctx.put((Object)"METADATAPATH", c3);
        }
        List list = BizUnitHelper.getRelatedMetadatas(bizUnit, false);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                AbstractMetaDataValue metadata = (AbstractMetaDataValue)list.get(i);
                DynamicMDContainer.getAssociatedMDPKs0(ctx, metadata, associatedPks, visted, depends);
            }
        }
    }

    private static void getAssociatedMDPKs0(Context ctx, AbstractMetaDataValue metadata, Set<MetaDataPK2> pks, Set<MetaDataPK2> visted, Project.Projects depends) throws BOSException {
        BOSObjectType type = metadata.getBOSType();
        MetaDataPK2 pk2 = new MetaDataPK2(metadata.getFullName(), type.toString());
        if (visted.contains(pk2)) {
            return;
        }
        visted.add(pk2);
        if (!DynamicMDContainer.isDynamicMD(MetaDataPK.create(metadata.getFullName()), type, depends)) {
            return;
        }
        pks.add(pk2);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ctx);
        EntityObjectInfo meta = loader.loadMetameta(type);
        PropertyCollection props = meta.getInheritedPropertiesRuntime();
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = linkProp.getRelationship();
            CardinalityType car = relation.getSupplierCardinality();
            if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)car) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)car)) {
                IObjectCollection coll = (IObjectCollection)metadata.get(prop.getName());
                if (coll == null) continue;
                int size = coll.size();
                for (int j = 0; j < size; ++j) {
                    IObjectValue temp = coll.getObject(j);
                    if (temp instanceof AbstractMetaDataValue) {
                        DynamicMDContainer.getAssociatedMDPKs1(ctx, pks, visted, depends, temp);
                        continue;
                    }
                    if (!(temp instanceof AbstractMDElement)) continue;
                    Enumeration enu = temp.keys();
                    while (enu.hasMoreElements()) {
                        Object o = temp.get((String)enu.nextElement());
                        if (!(o instanceof AbstractMetaDataValue)) continue;
                        AbstractMetaDataValue child = (AbstractMetaDataValue)o;
                        DynamicMDContainer.getAssociatedMDPKs1(ctx, pks, visted, depends, child);
                    }
                }
                continue;
            }
            IObjectValue temp = (IObjectValue)metadata.get(prop.getName());
            DynamicMDContainer.getAssociatedMDPKs1(ctx, pks, visted, depends, temp);
        }
    }

    private static void getAssociatedMDPKs1(Context ctx, Set<MetaDataPK2> pks, Set<MetaDataPK2> visted, Project.Projects depends, IObjectValue ov) throws BOSException {
        AbstractMetaDataValue child;
        if (ov instanceof AbstractMetaDataValue && (child = (AbstractMetaDataValue)ov) != null) {
            BOSObjectType type1 = child.getBOSType();
            MetaDataPK2 childPK2 = new MetaDataPK2(child.getFullName(), type1.toString());
            if (!visted.contains(childPK2)) {
                DynamicMDContainer.getAssociatedMDPKs0(ctx, child, pks, visted, depends);
            }
        }
    }

    private static boolean isDynamicMD(IMetaDataPK pk, BOSObjectType type, Project.Projects depends) {
        return MDContextFactory.getSystemMDContext().pkIndexs.isExistInDB(type, pk, depends);
    }
}

