/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.metadata.configure.MetadataDeleteListener;
import com.kingdee.bos.metadata.configure.MetadataDeleteRefListener;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetadataDeleteListenerManager {
    private static Logger logger = Logger.getLogger(MetadataDeleteListenerManager.class);
    private static List listeners = new ArrayList();

    private static void init() {
        listeners.add(new MetadataDeleteRefListener());
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("mdDeleteListeners");
        if (ci == null) {
            logger.info((Object)"Can't find mdDeleteListeners configItem");
            return;
        }
        Map map = ci.getProperties();
        for (String className : map.values()) {
            try {
                Class<?> c = Class.forName(className);
                MetadataDeleteListener lis = (MetadataDeleteListener)c.newInstance();
                listeners.add(lis);
            }
            catch (Exception e) {
                logger.info((Object)e, (Throwable)e);
            }
        }
    }

    public static synchronized void register(MetadataDeleteListener listener) {
        listeners.add(listener);
    }

    public static synchronized void unregister(MetadataDeleteListener listener) {
        listeners.remove(listener);
    }

    public static synchronized ValidateList validate(EntityObjectInfo entity, PropertyInfo[] props) {
        ValidateMetaData vld = new ValidateMetaData();
        for (MetadataDeleteListener listener : listeners) {
            vld.addValidateList(listener.validate(entity, props));
        }
        return vld.getValidateList();
    }

    public static synchronized void delete(EntityObjectInfo entity, PropertyInfo[] props) {
        for (MetadataDeleteListener listener : listeners) {
            listener.delete(entity, props);
        }
    }

    static {
        try {
            MetadataDeleteListenerManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

