/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.configure.ChangeType;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.DynamicMD;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MdsDoc;
import com.kingdee.bos.metadata.configure.MetadataChangeListenerManager;
import com.kingdee.bos.metadata.configure.MetadataDeleteListenerManager;
import com.kingdee.bos.metadata.configure.MetadataStoreUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.Saver4;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class MetadataStore
implements IMetadataStore {
    private static final Logger logger = Logger.getLogger(MetadataStore.class);
    private static final JDOMFactory jdfactory = new DefaultJDOMFactory();
    private final Context ctx;
    private final IMetaDataLoader loader;
    private final Saver4 saver;
    private static String configureDir;
    private String configureJar;
    private String tempDir;
    private IServerMetadataStore serverStore;
    private Document dc = null;

    public MetadataStore(Context ctx) {
        this.ctx = ctx != null ? ctx : ConfigMDUtil.getContext();
        this.loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.saver = new Saver4(this.loader);
        this.initConfigureDir();
    }

    public void addProperty(EntityObjectInfo entity, PropertyInfo[] props) throws Exception {
        MetaDataPK pk = MetaDataPK.create(entity.getFullName());
        this.lock(MetaDataTypeList.ENTITY, pk);
        MdsDoc[] docs = null;
        try {
            docs = this.save(entity, props);
            String[] eles = new String[props.length];
            for (int i = 0; i < props.length; ++i) {
                eles[i] = props[i].getName();
            }
            this.getServerStore().save(MetaDataTypeList.ENTITY, pk, eles, docs);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.rollback(docs);
            throw e;
        }
        finally {
            this.load(MetaDataTypeList.ENTITY, pk);
            MetadataChangeListenerManager.notify(entity, props, ChangeType.ADDNEW);
        }
    }

    private void lock(BOSObjectType bosType, IMetaDataPK pk) throws Exception {
        boolean lock = this.getServerStore().lock(bosType, pk);
        if (!lock) {
            throw new Exception("Can't get lock on " + pk);
        }
    }

    private void rollback(MdsDoc[] docs) throws Exception {
        if (docs == null) {
            logger.warn((Object)"MdsDos is null");
            return;
        }
        String mdPath = Utils.getMetadataSrc(this.ctx);
        mdPath = MetadataStore.getFirstPath(mdPath);
        for (MdsDoc doc : docs) {
            if (doc == null) continue;
            StringBuffer bf = new StringBuffer(mdPath);
            bf.append(doc.getPk()).append(Utils.getMetaDataSuffix(doc.getBosType()));
            File file = new File(bf.toString());
            file.delete();
            File bak = new File(bf.toString() + ".cfgbak");
            if (!bak.exists() || !bak.isFile()) continue;
            bak.renameTo(file);
        }
    }

    private void load(BOSObjectType bosType, IMetaDataPK pk) {
        if (bosType == null || pk == null) {
            return;
        }
        if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
            EntityObjectInfo entity = this.loader.getEntity(pk);
            PropertyCollection pc = entity.getPropertiesRuntime();
            int size = pc.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo pi = pc.get(i);
                if (!(pi instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo lpi = (LinkPropertyInfo)pi;
                RelationshipInfo rsi = lpi.getRelationship();
                this.loader.clear(rsi.getBOSType(), MetaDataPK.create(rsi.getRealFullName()));
                if (rsi.getClientObject() != null && !pk.getFullName().equals(rsi.getClientObject().getFullName())) {
                    this.loader.clear(MetaDataTypeList.ENTITY, MetaDataPK.create(rsi.getClientObject().getFullName()));
                }
                if (rsi.getSupplierObject() == null || pk.getFullName().equals(rsi.getSupplierObject().getFullName())) continue;
                this.loader.clear(MetaDataTypeList.ENTITY, MetaDataPK.create(rsi.getSupplierObject().getFullName()));
            }
        }
        this.loader.clear(bosType, pk);
        if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
            try {
                ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
            }
            catch (CannotCreateServiceManagerException e) {
                logger.warn((Object)e, (Throwable)((Object)e));
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
    }

    private void load(BOSObjectType bosType) {
        this.loader.clear(bosType);
    }

    private MdsDoc[] save(EntityObjectInfo entity, PropertyInfo[] props) throws MDSaveException, IOException {
        ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
        String mdPath = Utils.getMetadataSrc(this.ctx);
        mdPath = MetadataStore.getFirstPath(mdPath);
        for (int i = 0; i < props.length; ++i) {
            if (props[i] instanceof LinkPropertyInfo) {
                LinkPropertyInfo lp = (LinkPropertyInfo)props[i];
                RelationshipInfo rs = lp.getRelationship();
                Document doc = this.saver.store(rs);
                docList.add(new MdsDoc(MetaDataTypeList.RELATIONSHIP, MetaDataPK.create(rs.getFullName()), doc));
                StringBuffer bf = new StringBuffer(mdPath);
                bf.append(rs.getFullName().replace('.', File.separatorChar)).append(Utils.getMetaDataSuffix(MetaDataTypeList.RELATIONSHIP));
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bf.toString()));
                XmlUtils.output(doc, os);
                ((OutputStream)os).close();
                logger.info((Object)bf);
            }
            entity.getProperties().add(props[i]);
        }
        Document doc = this.saver.store(entity);
        docList.add(new MdsDoc(MetaDataTypeList.ENTITY, MetaDataPK.create(entity.getFullName()), doc));
        StringBuffer bf = new StringBuffer(mdPath);
        bf.append(entity.getFullName().replace('.', File.separatorChar)).append(Utils.getMetaDataSuffix(MetaDataTypeList.ENTITY));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bf.toString()));
        XmlUtils.output(doc, os);
        ((OutputStream)os).close();
        return docList.toArray(new MdsDoc[0]);
    }

    static String getFirstPath(String mdPath) {
        String ret = null;
        int index = mdPath.indexOf(";");
        ret = index > 0 ? mdPath.substring(0, index) : mdPath;
        return ret;
    }

    public void deleteProperty(EntityObjectInfo entity, PropertyInfo[] props) throws Exception {
        MetaDataPK pk = MetaDataPK.create(entity.getPackage(), entity.getName());
        this.lock(MetaDataTypeList.ENTITY, pk);
        MdsDoc[] docs = null;
        try {
            docs = this.delete(entity, props);
            String[] eles = new String[props.length];
            for (int i = 0; i < props.length; ++i) {
                eles[i] = props[i].getName();
            }
            this.getServerStore().delete(MetaDataTypeList.ENTITY, pk, eles, docs);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.rollback(docs);
            throw e;
        }
        finally {
            this.load(MetaDataTypeList.ENTITY, pk);
            MetadataChangeListenerManager.notify(entity, props, ChangeType.ADDNEW);
        }
    }

    private MdsDoc[] delete(EntityObjectInfo entity, PropertyInfo[] props) throws MDSaveException, IOException {
        ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
        String mdPath = Utils.getMetadataSrc(this.ctx);
        mdPath = MetadataStore.getFirstPath(mdPath);
        for (int i = 0; i < props.length; ++i) {
            entity.getProperties().remove(props[i]);
        }
        Document doc = this.saver.store(entity);
        docList.add(new MdsDoc(MetaDataTypeList.ENTITY, MetaDataPK.create(entity.getFullName()), doc));
        StringBuffer bf = new StringBuffer(mdPath);
        bf.append(entity.getFullName().replace('.', File.separatorChar)).append(Utils.getMetaDataSuffix(MetaDataTypeList.ENTITY));
        File file = new File(bf.toString());
        if (file.exists() && file.isFile()) {
            file.renameTo(new File(bf.toString() + ".cfgbak"));
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bf.toString()));
        logger.info((Object)("save " + entity.getFullName() + "." + "entity" + "  to  " + bf));
        XmlUtils.output(doc, os);
        ((OutputStream)os).close();
        for (int i = 0; i < props.length; ++i) {
            File relation;
            if (!(props[i] instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lp = (LinkPropertyInfo)props[i];
            RelationshipInfo rs = lp.getRelationship();
            bf = new StringBuffer(mdPath);
            bf.append(rs.getFullName().replace('.', File.separatorChar)).append(Utils.getMetaDataSuffix(MetaDataTypeList.RELATIONSHIP));
            file = new File(bf.toString());
            if (file.exists() && file.isFile()) {
                file.renameTo(new File(bf.toString() + ".cfgbak"));
            }
            if ((relation = new File(bf.toString())).exists()) {
                logger.info((Object)("delete: " + relation.getAbsolutePath()));
                relation.delete();
            } else {
                logger.warn((Object)("file " + bf + " not exists"));
            }
            docList.add(new MdsDoc(MetaDataTypeList.RELATIONSHIP, MetaDataPK.create(rs.getPackage(), rs.getName()), null));
        }
        return docList.toArray(new MdsDoc[0]);
    }

    private ValidateList validateAddProperties(EntityObjectInfo entity, PropertyInfo[] props) {
        ValidateMetaData vld = new ValidateMetaData();
        for (int i = 0; i < props.length; ++i) {
            ValidateList vl = this.validateAddProperty(entity, props[i]);
            vld.addValidateList(vl);
        }
        return vld.getValidateList();
    }

    private ValidateList validateAddProperty(EntityObjectInfo entity, PropertyInfo prop) {
        ValidateMetaData vld = new ValidateMetaData();
        if (!prop.isConfigured()) {
            vld.addError(prop.getName() + " should be configured");
        }
        HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>();
        PropertyCollection propCol = entity.getProperties();
        int size = propCol.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo temp = propCol.get(i);
            if (temp.getName().equalsIgnoreCase(prop.getName())) {
                vld.addError("Duplicated Property: " + prop.getName());
            } else {
                map.put(temp.getName(), temp);
            }
            MetadataStore.validateProperty(vld, entity, prop);
        }
        map.put(prop.getName(), prop);
        if (entity.getLogicalKey() != null) {
            PropertyCollection pcol = entity.getLogicalKey().getKeyPropertys();
            for (int i = 0; i < pcol.size(); ++i) {
                map.remove(pcol.get(i).getName());
            }
        }
        MetadataStore.validateInherite(vld, entity, map);
        MetadataStore.validEnumExist(vld, prop);
        return vld.getValidateList();
    }

    private static void validateProperty(ValidateMetaData vld, EntityObjectInfo entity, PropertyInfo prop) {
        vld.validateJavaIdentifier("Property: ", prop.getName());
        vld.addValidateList(prop.validate());
        if (!entity.isAbstract() && prop instanceof OwnPropertyInfo) {
            String errMsg = "Property '" + prop.getName() + "': invalid mapping field.";
            if (prop.getMappingField() == null && prop.getExtendedField() == null) {
                return;
            }
            if (prop.getMappingField() != null && prop.getExtendedField() != null) {
                vld.addError(errMsg);
            }
            if (entity.getTable() != null) {
                if (prop.getMappingField() != null && !entity.getTable().existsColumn(prop.getMappingField())) {
                    vld.addError(errMsg);
                }
                if (prop.getExtendedField() != null) {
                    ExtendedTableInfo extTable = prop.getExtendedField().getExtendedTable();
                    ColumnInfo extColumn = prop.getExtendedField().getExtendedColumn();
                    if (extTable == null || extColumn == null) {
                        vld.addError(errMsg);
                    } else {
                        if (!entity.getTable().existsExtendedTable(extTable)) {
                            vld.addError(errMsg);
                        }
                        if (!extTable.existsColumn(extColumn)) {
                            vld.addError(errMsg);
                        }
                    }
                }
            }
        }
        if (prop instanceof OwnPropertyInfo) {
            ColumnInfo column = null;
            if (entity.getTable() != null) {
                if (prop.getMappingField() != null) {
                    column = prop.getMappingField();
                } else if (prop.getExtendedField() != null) {
                    column = prop.getExtendedField().getExtendedColumn();
                }
            }
            if (column != null && ((OwnPropertyInfo)prop).isMultilingual() != column.isMultilingual()) {
                vld.addError("OwnProperty '" + prop.getName() + "': Invalid 'isMultilingual'.");
            }
        } else if (prop instanceof LinkPropertyInfo) {
            RelationshipInfo rel = ((LinkPropertyInfo)prop).getRelationship();
            if (rel == null) {
                vld.addError("LinkProperty '" + prop.getName() + "': missing relationship.");
            } else {
                String clientName = null;
                String supplierName = null;
                if (rel.getClientObject() != null) {
                    clientName = rel.getClientObject().getFullName();
                }
                if (rel.getSupplierObject() != null) {
                    supplierName = rel.getSupplierObject().getFullName();
                }
                if (!entity.getFullName().equals(clientName) && !entity.getFullName().equals(supplierName)) {
                    vld.addError("LinkProperty '" + prop.getName() + "': invalid relationship.");
                }
            }
        } else assert (false);
    }

    private static void validateInherite(ValidateMetaData vld, EntityObjectInfo entity, HashMap<String, PropertyInfo> map) {
        if (entity.getBaseEntity() != null) {
            boolean isAbstract = entity.isAbstract();
            LogicalKeyInfo logicalKey = null;
            for (EntityObjectInfo temp = entity.getBaseEntity(); temp != null; temp = temp.getBaseEntity()) {
                PropertyCollection propCol = temp.getProperties();
                int size = propCol.size();
                for (int i = 0; i < size; ++i) {
                    PropertyInfo prop = propCol.get(i);
                    if (map.containsKey(prop.getName())) {
                        vld.addError("Duplicated Property in inherited entity: " + prop.getName());
                        continue;
                    }
                    map.put(prop.getName(), prop);
                }
                if (temp.getLogicalKey() != null) {
                    PropertyCollection pcol = temp.getLogicalKey().getKeyPropertys();
                    for (int i = 0; i < pcol.size(); ++i) {
                        map.remove(pcol.get(i).getName());
                    }
                }
                if (isAbstract = temp.isAbstract()) continue;
                if (logicalKey == null && (logicalKey = entity.getLogicalKey()) != null && !logicalKey.supportsInherit()) {
                    vld.addError("LogicalKey cannot supports Inherit.");
                }
                if ((logicalKey = temp.getLogicalKey()) == null || logicalKey.supportsInherit()) continue;
                vld.addError("LogicalKey cannot supports Inherit.");
            }
        }
    }

    private static void validEnumExist(ValidateMetaData vld, PropertyInfo prop) {
        if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).getDataType().equals(DataType.ENUM)) {
            try {
                String mdr = ((OwnPropertyInfo)prop).getMetaDataRef();
                if (mdr == null) {
                    vld.addError(prop.getName() + " property's reference enumeration can't be null !");
                } else {
                    BizEnumInfo bizenum = ((OwnPropertyInfo)prop).getEnumType();
                    if (bizenum == null) {
                        vld.addError("Enum type '" + ((OwnPropertyInfo)prop).getMetaDataRef() + "' not found");
                    }
                }
            }
            catch (Exception e) {
                vld.addError(" e = " + e.toString());
            }
        }
    }

    public ValidateList validateDeleteProperties(EntityObjectInfo entity, PropertyInfo[] props) {
        ValidateMetaData vld = new ValidateMetaData();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].isConfigured()) continue;
            vld.addError(props[i].getName() + " should be configured");
        }
        ValidateList vl = MetadataDeleteListenerManager.validate(entity, props);
        vld.addValidateList(vl);
        return vld.getValidateList();
    }

    @Override
    public ValidateList validate(EntityObjectInfo mainEntity) {
        ValidateMetaData vld = new ValidateMetaData();
        vld.addValidateList(this.validate0(mainEntity));
        HashSet<IMetaDataPK> worked = new HashSet<IMetaDataPK>();
        this.validateLinkedEntity(mainEntity, vld, worked);
        return vld.getValidateList();
    }

    private void validateLinkedEntity(EntityObjectInfo mainEntity, ValidateMetaData vld, Set<IMetaDataPK> worked) {
        MetaDataPK pk = MetaDataPK.create(mainEntity.getFullName());
        if (worked.contains(pk)) {
            logger.error((Object)("Entity " + pk + " has processed! Entity and Entry is a circle!"), (Throwable)new Exception());
            return;
        }
        worked.add(pk);
        PropertyCollection pc = mainEntity.getProperties();
        Iterator iterator = pc.iterator();
        while (iterator.hasNext()) {
            LinkPropertyInfo lpi;
            RelationshipInfo rsi;
            CardinalityType ct;
            PropertyInfo prop = (PropertyInfo)iterator.next();
            if (!(prop instanceof LinkPropertyInfo) || !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)(ct = (rsi = (lpi = (LinkPropertyInfo)prop).getRelationship()).getSupplierCardinality())) && !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ct)) continue;
            EntityObjectInfo entity = rsi.getSupplierObject();
            vld.addValidateList(this.validate0(entity));
            if (worked.contains(MetaDataPK.create(entity.getPackage(), entity.getName()))) continue;
            this.validateLinkedEntity(entity, vld, worked);
        }
    }

    private ValidateList validate0(EntityObjectInfo entity) {
        MetaDataPK pk = MetaDataPK.create(entity.getPackage(), entity.getName());
        EntityObjectInfo entityRt = this.loader.getEntity(pk);
        PropertyCollection pcRt = entityRt.getProperties();
        PropertyCollection pc = entity.getProperties();
        AduOperation adu = this.compare(pc, pcRt);
        ValidateMetaData vld = new ValidateMetaData();
        ValidateList vl = this.validateAddProperties(entityRt, adu.add.toArray(new PropertyInfo[0]));
        vld.addValidateList(vl);
        if (adu.delete.size() > 0) {
            vl = this.validateDeleteProperties(entityRt, adu.delete.toArray(new PropertyInfo[0]));
            vld.addValidateList(vl);
        }
        return vld.getValidateList();
    }

    private AduOperation compare(PropertyCollection pc, PropertyCollection pcRt) {
        Iterator iterator2;
        boolean found;
        String name;
        ArrayList<PropertyInfo> add = new ArrayList<PropertyInfo>();
        ArrayList<PropertyInfo> delete = new ArrayList<PropertyInfo>();
        ArrayList<PropertyInfo> update = new ArrayList<PropertyInfo>();
        Iterator iterator = pc.iterator();
        while (iterator.hasNext()) {
            PropertyInfo prop = (PropertyInfo)iterator.next();
            if (!prop.isConfigured()) continue;
            name = prop.getName();
            found = false;
            iterator2 = pcRt.iterator();
            while (iterator2.hasNext()) {
                PropertyInfo propRt = (PropertyInfo)iterator2.next();
                if (!name.equalsIgnoreCase(propRt.getName())) continue;
                found = true;
                if (!propRt.isConfigured()) {
                    add.add(prop);
                    break;
                }
                String alias = prop.getAlias();
                String aliasRt = propRt.getAlias();
                if ((alias != null || aliasRt == null) && (alias == null || alias.equals(aliasRt))) break;
                update.add(prop);
                break;
            }
            if (found) continue;
            add.add(prop);
        }
        iterator = pcRt.iterator();
        while (iterator.hasNext()) {
            PropertyInfo propRt = (PropertyInfo)iterator.next();
            if (!propRt.isConfigured()) continue;
            name = propRt.getName();
            found = false;
            iterator2 = pc.iterator();
            while (iterator2.hasNext()) {
                PropertyInfo prop = (PropertyInfo)iterator2.next();
                if (!prop.isConfigured() || !name.equalsIgnoreCase(prop.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            delete.add(propRt);
        }
        return new AduOperation(add, delete, update);
    }

    private void initConfigureDir() {
        configureDir = System.getProperty("configure.path");
        String eas_home = System.getProperty("EAS_HOME");
        if (configureDir == null && eas_home == null) {
            throw new RuntimeException("not set EAS_HOME and not set configure Dir. please set -DEAS_HOME or -Dconfigure.path");
        }
        if (configureDir == null) {
            configureDir = eas_home + "/client/metas/" + "configure";
        }
        logger.info((Object)("MetadataStore configure dir is " + configureDir));
        this.configureJar = configureDir + "/" + ConfigMDUtil.getAIS(this.ctx) + "/" + "dynamic-configure-metas.jar";
        this.tempDir = configureDir + "/" + ConfigMDUtil.getAIS(this.ctx) + "_temp";
    }

    private synchronized IServerMetadataStore getServerStore() throws BOSException {
        if (this.serverStore == null) {
            this.serverStore = (IServerMetadataStore)BOSObjectFactory.createRemoteObject("com.kingdee.bos.metadata.configure.RemoteMetadataStore", IServerMetadataStore.class, new Class[]{Context.class}, new Object[]{this.ctx});
        }
        return this.serverStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntity(EntityObjectInfo mainEntity) throws Exception {
        MetaDataPK pk = MetaDataPK.create(mainEntity.getPackage(), mainEntity.getName());
        this.lock(MetaDataTypeList.ENTITY, pk);
        try {
            File temp;
            if (new File(this.configureJar).exists()) {
                ZipFileUtils.unJarFile(this.configureJar, this.tempDir);
            }
            if (!(temp = new File(this.tempDir)).exists()) {
                temp.mkdirs();
            }
            ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
            ArrayList<IMetaDataPK> relationPKList = new ArrayList<IMetaDataPK>();
            HashSet<IMetaDataPK> worked = new HashSet<IMetaDataPK>();
            this.updateLinkedEntity(mainEntity, docList, relationPKList, worked);
            docList.addAll(this.updateEntity0(mainEntity));
            MdsDoc[] docs = docList.toArray(new MdsDoc[0]);
            try {
                this.update(temp, docList);
                this.getServerStore().update(docs, relationPKList);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.updateRollback(docs);
                throw e;
            }
            finally {
                MetadataStoreUtil.zip(this.configureJar, this.ctx);
                FileUtil.deleteDir(new File(this.tempDir));
                for (int i = 0; i < docs.length; ++i) {
                    this.load(docs[i].getBosType(), docs[i].getPk());
                }
                for (IMetaDataPK tmp : relationPKList) {
                    this.load(MetaDataTypeList.RELATIONSHIP, tmp);
                }
                this.notify(docs);
            }
        }
        finally {
            try {
                this.getServerStore().unlock(MetaDataTypeList.ENTITY, pk);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void updateLinkedEntity(EntityObjectInfo mainEntity, List<MdsDoc> docList, List<IMetaDataPK> relationPKList, Set<IMetaDataPK> worked) throws Exception {
        MetaDataPK pk = MetaDataPK.create(mainEntity.getFullName());
        if (worked.contains(pk)) {
            logger.error((Object)("Entity " + pk + " has processed! Entity and Entry is a circle!"), (Throwable)new Exception());
            return;
        }
        worked.add(pk);
        PropertyCollection pc = mainEntity.getProperties();
        Iterator iterator = pc.iterator();
        while (iterator.hasNext()) {
            EntityObjectInfo entity;
            LinkPropertyInfo lpi;
            RelationshipInfo rsi;
            CardinalityType ct;
            PropertyInfo prop = (PropertyInfo)iterator.next();
            if (!(prop instanceof LinkPropertyInfo) || !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)(ct = (rsi = (lpi = (LinkPropertyInfo)prop).getRelationship()).getSupplierCardinality())) && !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ct) || worked.contains(MetaDataPK.create((entity = rsi.getSupplierObject()).getPackage(), entity.getName()))) continue;
            docList.addAll(this.updateEntity0(entity));
            relationPKList.add(MetaDataPK.create(rsi.getPackage(), rsi.getName()));
            this.updateLinkedEntity(entity, docList, relationPKList, worked);
        }
    }

    private void update(File temp, List<MdsDoc> docList) throws FileNotFoundException, IOException {
        for (MdsDoc md : docList) {
            Document doc = md.getDocument();
            String relative = this.getRelativePath(md);
            File file = new File(temp, relative);
            if (file.exists()) {
                file.renameTo(new File(temp, relative + ".cfgbak"));
            }
            if (file.exists() && doc == null) {
                logger.info((Object)(temp.getAbsolutePath() + File.separatorChar + relative + " is deleted"));
                continue;
            }
            if (doc == null) continue;
            file = new File(temp, relative);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            XmlUtils.output(doc, os);
            ((OutputStream)os).close();
            logger.info((Object)(temp.getAbsolutePath() + File.separatorChar + relative + " is added or updated"));
        }
    }

    private String getRelativePath(MdsDoc md) {
        String relative = md.getBosType() != null ? md.getPk().toString() + Utils.getMetaDataSuffix(md.getBosType()) : md.getPk().toString();
        return relative;
    }

    private List<MdsDoc> updateEntity0(EntityObjectInfo entity) throws Exception {
        MetaDataPK pk = MetaDataPK.create(entity.getPackage(), entity.getName());
        EntityObjectInfo entityNoConfigure = this.loader.getEntityNoConfigure(pk);
        PropertyCollection pcNoConfigure = entityNoConfigure.getProperties();
        PropertyCollection pc = entity.getProperties();
        AduOperation adu = this.compare(pc, pcNoConfigure);
        ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
        for (PropertyInfo prop : adu.add) {
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lp = (LinkPropertyInfo)prop;
            RelationshipInfo rs = lp.getRelationship();
            Document doc = this.saver.store(rs);
            docList.add(new MdsDoc(MetaDataTypeList.RELATIONSHIP, MetaDataPK.create(rs.getPackage(), rs.getName()), doc));
        }
        EntityObjectInfo entityConfigure = this.loader.getEntity(pk);
        PropertyCollection pcConfigure = entityConfigure.getProperties();
        adu = this.compare(pc, pcConfigure);
        for (PropertyInfo prop : adu.delete) {
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lp = (LinkPropertyInfo)prop;
            RelationshipInfo rs = lp.getRelationship();
            docList.add(new MdsDoc(MetaDataTypeList.RELATIONSHIP, MetaDataPK.create(rs.getPackage(), rs.getName()), null));
        }
        MetadataDeleteListenerManager.delete(entityConfigure, adu.delete.toArray(new PropertyInfo[0]));
        Document doc = this.saver.diffStore(entity, entityNoConfigure);
        docList.add(new MdsDoc(MetaDataTypeList.ENTITY, pk, doc));
        return docList;
    }

    private void updateRollback(MdsDoc[] docs) {
        logger.info((Object)"ServerMetadataStore updateRollback.");
        if (docs == null) {
            logger.warn((Object)"MdsDos is null");
            return;
        }
        File temp = new File(this.tempDir);
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc md = docs[i];
            if (md == null) continue;
            String relative = this.getRelativePath(md);
            File file = new File(temp, relative);
            File bak = new File(temp, relative + ".cfgbak");
            if (!bak.exists()) {
                file.delete();
                continue;
            }
            bak.renameTo(file);
        }
    }

    private void notify(MdsDoc[] docs) {
        ArrayList<EntityObjectInfo> list = new ArrayList<EntityObjectInfo>();
        for (MdsDoc md : docs) {
            BOSObjectType type = md.getBosType();
            if (!MetaDataTypeList.ENTITY.equals((Object)type)) continue;
            EntityObjectInfo entity = this.loader.getEntity(md.getPk());
            list.add(entity);
        }
        MetadataChangeListenerManager.notify(list.toArray(new AbstractMetaDataValue[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateQuery(QueryInfo query) throws Exception {
        MetaDataPK pk = MetaDataPK.create(query.getPackage(), query.getName());
        this.lock(MetaDataTypeList.BASEQUERY, pk);
        try {
            File temp;
            if (new File(this.configureJar).exists()) {
                ZipFileUtils.unJarFile(this.configureJar, this.tempDir);
            }
            if (!(temp = new File(this.tempDir)).exists()) {
                temp.mkdirs();
            }
            ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
            docList.addAll(this.updateQuery0(query));
            MdsDoc[] docs = docList.toArray(new MdsDoc[0]);
            try {
                this.update(temp, docList);
                this.getServerStore().update(docs);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.updateRollback(docs);
                throw e;
            }
            finally {
                MetadataStoreUtil.zip(this.configureJar, this.ctx);
                FileUtil.deleteDir(new File(this.tempDir));
                for (int i = 0; i < docs.length; ++i) {
                    this.load(docs[i].getBosType(), docs[i].getPk());
                }
                this.notify(docs);
            }
        }
        finally {
            try {
                this.getServerStore().unlock(MetaDataTypeList.BASEQUERY, pk);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private List<MdsDoc> updateQuery0(QueryInfo query) throws Exception {
        MetaDataPK pk = MetaDataPK.create(query.getPackage(), query.getName());
        QueryInfo queryNoConfigure = (QueryInfo)this.loader.getNoConfigure(MetaDataTypeList.BASEQUERY, pk);
        Document doc = this.saver.diffStore(query, queryNoConfigure);
        ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
        docList.add(new MdsDoc(MetaDataTypeList.BASEQUERY, pk, doc));
        return docList;
    }

    public void updateBizUnit(BizUnitInfo info) throws Exception {
        this.update(MetaDataTypeList.BIZUNIT, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(BOSObjectType type, AbstractMetaDataValue md) throws Exception {
        MetaDataPK pk = MetaDataPK.create(md.getPackage(), md.getName());
        this.lock(type, pk);
        try {
            File temp;
            if (new File(this.configureJar).exists()) {
                ZipFileUtils.unJarFile(this.configureJar, this.tempDir);
            }
            if (!(temp = new File(this.tempDir)).exists()) {
                temp.mkdirs();
            }
            ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
            docList.addAll(this.update0(type, md));
            MdsDoc[] docs = docList.toArray(new MdsDoc[0]);
            try {
                this.update(temp, docList);
                this.getServerStore().update(docs);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.updateRollback(docs);
                throw e;
            }
            finally {
                MetadataStoreUtil.zip(this.configureJar, this.ctx);
                FileUtil.deleteDir(new File(this.tempDir));
                for (int i = 0; i < docs.length; ++i) {
                    this.load(docs[i].getBosType(), docs[i].getPk());
                }
                this.notify(docs);
            }
        }
        finally {
            try {
                this.getServerStore().unlock(type, pk);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private Change processAlias(File temp, AbstractMetaDataValue[] mds) throws Exception {
        SolutionInfo solution = this.loader.getSolution();
        Locale[] ls = solution.getSupportedLocales();
        Change change = new Change();
        for (AbstractMetaDataValue md : mds) {
            MetaDataPK pk = MetaDataPK.create(md.getFullName());
            AbstractMetaDataValue mdOld = (AbstractMetaDataValue)this.loader.get(md.getBOSType(), pk);
            for (Locale lc : ls) {
                String aliasOld;
                String alias = md.getAlias(lc);
                if (StringUtils.isEmpty((String)alias) || alias.equals(aliasOld = mdOld.getAlias(lc))) continue;
                change.aliasChanged = true;
                Document doc = this.getConfigureDocument();
                MetaDataPK2 pk2 = new MetaDataPK2(md.getPackage(), md.getName(), md.getBOSType().toString());
                boolean b = this.addElement(doc, pk2.getPath2());
                if (change.fileChanged) continue;
                change.fileChanged = b;
            }
        }
        if (change.fileChanged) {
            new File(temp, "dynamic-configure.xml").renameTo(new File(temp, "dynamic-configure.xml.cfgbak"));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(temp, "dynamic-configure.xml")));
            XmlUtils.output(this.getConfigureDocument(), os);
        }
        return change;
    }

    private Document getConfigureDocument() throws Exception {
        if (this.dc == null) {
            ConfigureResourceLoader crl = ConfigureResourceLoader.getInstance(this.ctx);
            InputStream is = crl.getResourceAsStream("dynamic-configure.xml");
            if (is == null) {
                Element root = jdfactory.element("dynamic-configure", "com.kingdee.bos.metadata");
                Comment cmt = jdfactory.comment("record alias changed. by mgl 2009-4-25");
                this.dc = jdfactory.document(root);
                this.dc.addContent(cmt);
            } else {
                this.dc = XMLParser.parseXML((InputStream)is);
                is.close();
            }
        }
        return this.dc;
    }

    private boolean addElement(Document dc, String mdPk) {
        Element root = dc.getRootElement();
        List mds = root.getChildren("metadata", root.getNamespace());
        boolean find = false;
        for (Element md : mds) {
            String pk = md.getAttributeValue("pk");
            if (!mdPk.equals(pk)) continue;
            find = true;
            break;
        }
        if (!find) {
            Element ele = jdfactory.element("metadata", "com.kingdee.bos.metadata");
            ele.setAttribute("pk", mdPk);
            root.addContent(ele);
        }
        return !find;
    }

    private List<MdsDoc> update0(BOSObjectType type, AbstractMetaDataValue md) throws Exception {
        MetaDataPK pk = MetaDataPK.create(md.getPackage(), md.getName());
        AbstractMetaDataValue mdNoConfigure = (AbstractMetaDataValue)this.loader.getNoConfigure(type, pk);
        Document doc = this.saver.diffStore(md, mdNoConfigure);
        ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
        docList.add(new MdsDoc(type, pk, doc));
        return docList;
    }

    @Override
    public boolean unlock(BOSObjectType bosType, IMetaDataPK pk) {
        try {
            return this.getServerStore().unlock(bosType, pk);
        }
        catch (BOSException e) {
            logger.error((Object)"MetaDataStore unlock error.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void unlockAll() {
        try {
            this.getServerStore().unlockAll();
        }
        catch (BOSException e) {
            logger.error((Object)"MetaDataStore unlockAll error.", (Throwable)e);
        }
    }

    @Override
    public AbstractMetaDataValue getConfigureMetadata(BOSObjectType bosType, IMetaDataPK pk) {
        return (AbstractMetaDataValue)this.loader.getConfigure(bosType, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveConfigureMetadata(AbstractMetaDataValue[] mds, boolean merge) throws Exception {
        MetaDataPK2[] pks = new MetaDataPK2[mds.length];
        for (int i = 0; i < mds.length; ++i) {
            pks[i] = new MetaDataPK2(mds[i].getFullName(), mds[i].getBOSType().toString());
        }
        this.lock(pks);
        try {
            File temp;
            if (new File(this.configureJar).exists()) {
                ZipFileUtils.unJarFile(this.configureJar, this.tempDir);
            }
            if (!(temp = new File(this.tempDir)).exists()) {
                temp.mkdirs();
            }
            ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
            Change change = this.processAlias(temp, mds);
            if (change.fileChanged) {
                MdsDoc dcx = new MdsDoc(null, MetaDataPK.create(null, "dynamic-configure.xml"), this.getConfigureDocument());
                docList.add(dcx);
            }
            for (int i = 0; i < mds.length; ++i) {
                AbstractMetaDataValue metadata = mds[i];
                MetaDataPK pk = MetaDataPK.create(metadata.getPackage(), metadata.getName());
                Document doc = this.saver.storeConfigure(metadata, this.ctx, merge);
                docList.add(new MdsDoc(metadata.getBOSType(), pk, doc));
            }
            MdsDoc[] docs = docList.toArray(new MdsDoc[0]);
            try {
                this.update(temp, docList);
                this.getServerStore().update(docs, change.aliasChanged);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.updateRollback(docs);
                throw e;
            }
            finally {
                MetadataStoreUtil.zip(this.configureJar, this.ctx);
                FileUtil.deleteDir(new File(this.tempDir));
                for (int j = 0; j < docs.length; ++j) {
                    this.load(docs[j].getBosType(), docs[j].getPk());
                }
                if (change.aliasChanged) {
                    this.load(MetaDataTypeList.METADATABRIEFVIEW);
                }
                this.notify(docs);
            }
        }
        finally {
            try {
                this.getServerStore().unlock(pks);
            }
            catch (Exception e) {
                logger.error((Object)"unluck error.", (Throwable)e);
            }
        }
    }

    @Override
    public void saveConfigureMetadata(AbstractMetaDataValue metadata, boolean merge) throws Exception {
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{metadata};
        this.saveConfigureMetadata(mds, merge);
    }

    private void lock(MetaDataPK2[] pks) throws Exception {
        MetaDataPK2 pk = this.getServerStore().lock(pks);
        if (pk != null) {
            throw new Exception("Can't get lock on " + pk);
        }
    }

    @Override
    public void saveConfigureMetadata(AbstractMetaDataValue metadata) throws Exception {
        this.saveConfigureMetadata(metadata, true);
    }

    @Override
    public void saveConfigureMetadata(AbstractMetaDataValue[] mds) throws Exception {
        this.saveConfigureMetadata(mds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigureMetadata(MetaDataPK2[] pks) throws Exception {
        if (pks == null || pks.length == 0) {
            return;
        }
        this.lock(pks);
        try {
            File temp;
            if (new File(this.configureJar).exists()) {
                ZipFileUtils.unJarFile(this.configureJar, configureDir + "/temp");
            }
            if (!(temp = new File(configureDir + "/temp")).exists()) {
                temp.mkdirs();
            }
            ArrayList<MdsDoc> docList = new ArrayList<MdsDoc>();
            for (int i = 0; i < pks.length; ++i) {
                MetaDataPK2 pk2 = pks[i];
                MetaDataPK pk = MetaDataPK.create(pk2.getFullName());
                docList.add(new MdsDoc(BOSObjectType.create((String)pk2.getType()), pk, null));
            }
            MdsDoc[] docs = docList.toArray(new MdsDoc[0]);
            try {
                this.update(temp, docList);
                this.getServerStore().update(docs);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.updateRollback(docs);
                throw e;
            }
            finally {
                MetadataStoreUtil.zip(this.configureJar, this.ctx);
                FileUtil.deleteDir(new File(configureDir + "/temp"));
                for (int j = 0; j < docs.length; ++j) {
                    this.load(docs[j].getBosType(), docs[j].getPk());
                }
                this.notify(docs);
            }
        }
        finally {
            try {
                this.getServerStore().unlock(pks);
            }
            catch (Exception e) {
                logger.error((Object)"unlock error.", (Throwable)e);
            }
        }
    }

    @Override
    public void saveMetadata(AbstractMetaDataValue metadata, String projectID) throws Exception {
        this.saveMetadata(new AbstractMetaDataValue[]{metadata}, projectID);
    }

    @Override
    public void saveMetadata(AbstractMetaDataValue[] mds, String projectID) throws Exception {
        this.saveMetadata(mds, projectID, null);
    }

    private void afterSave(AbstractMetaDataValue[] mds, String projectID, boolean isAffectMdbview, boolean[] finds, Project[] depends) throws BOSException {
        for (int i = 0; i < mds.length; ++i) {
            AbstractMetaDataValue amd = mds[i];
            BOSObjectType bosType = amd.getBOSType();
            MetaDataPK pk = MetaDataPK.create(amd.getRealFullName());
            if (!finds[i]) {
                MDContext mdContext = MDLoader.getInstance().cl.getMDContext();
                mdContext.pkIndexs.addPK(bosType, pk, Project.Projects.getProjects(depends));
                if (MetaDataTypeList.ENTITY.equals((Object)bosType) || MetaDataTypeList.FACADE.equals((Object)bosType)) {
                    ((BusinessObjectInfo)amd).clearType();
                }
                this.saver.fill(amd);
                if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
                    mdContext.entityMapping.addPKMapping(((EntityObjectInfo)amd).getType(), pk);
                } else if (MetaDataTypeList.FACADE.equals((Object)bosType)) {
                    mdContext.facadeMapping.addPKMapping(((FacadeInfo)amd).getType(), pk);
                }
                if (ConfigMDUtil.getOrderedProjects() != null && ConfigMDUtil.getOrderedProjects().contains(new Project(projectID)) || "always_on".equals(projectID)) {
                    if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
                        MDReferenceFactory.clearPermission();
                        ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
                    } else if (MetaDataTypeList.LOG.equals((Object)bosType)) {
                        MDReferenceFactory.clearLog();
                        ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
                    }
                }
            }
            this.load(amd.getBOSType(), pk);
            if (ConfigMDUtil.getOrderedProjects() != null && ConfigMDUtil.getOrderedProjects().contains(new Project(projectID)) || "always_on".equals(projectID)) {
                MetadataChangeListenerManager.notify(new AbstractMetaDataValue[]{amd});
            }
            if (!isAffectMdbview) continue;
            this.load(MetaDataTypeList.METADATABRIEFVIEW);
        }
    }

    @Override
    public void setProjects(Project[] ps) throws BOSException {
        ConfigMDUtil.clearProjects();
        this.loader.clearAll();
        XMLAccessEngine.clearEngines();
        this.getServerStore().setProjects(ps);
        MetadataChangeListenerManager.notifyClearAll();
    }

    @Override
    public void deleteMetadata(MetaDataPK2[] pks, String projectID) throws Exception {
        this.getServerStore().deleteMetadata(pks, projectID);
        this.afterDelete(pks, projectID);
    }

    private void afterDelete(MetaDataPK2[] pks, String projectID) throws Exception {
        Project prj = new Project(projectID);
        MDContextFactory.getSystemMDContext().clear(Project.Projects.getProjects(prj));
        List<Project> orderedProjects = ConfigMDUtil.getOrderedProjects();
        if (orderedProjects != null && orderedProjects.contains(prj) || "always_on".equals(projectID)) {
            for (int i = 0; i < pks.length; ++i) {
                this.load(BOSObjectType.create((String)pks[i].getType()), MetaDataPK.create(pks[i].getFullName()));
            }
        }
    }

    @Override
    public void saveMetadata(AbstractMetaDataValue metadata, String projectID, Project[] depends) throws Exception {
        this.saveMetadata(new AbstractMetaDataValue[]{metadata}, projectID, depends);
    }

    private boolean[] beforeSave(AbstractMetaDataValue[] mds, Project[] depends) {
        boolean[] rt = new boolean[mds.length];
        for (int i = 0; i < mds.length; ++i) {
            AbstractMetaDataValue amd = mds[i];
            BOSObjectType bosType = amd.getBOSType();
            rt[i] = MDLoader.getInstance().cl.getMDContext().pkIndexs.isExist(bosType, MetaDataPK.create(amd.getRealFullName()), Project.Projects.getProjects(depends));
        }
        return rt;
    }

    @Override
    public void saveMetadata(AbstractMetaDataValue[] mds, String projectID, Project[] depends) throws Exception {
        Project.Projects prjs = Project.Projects.getProjects(new Project[]{new Project(projectID)});
        MDContextFactory.getSystemMDContext().clear(prjs);
        boolean[] finds = this.beforeSave(mds, depends);
        boolean[] tc = new boolean[mds.length];
        for (int i = 0; i < mds.length; ++i) {
            tc[i] = mds[i].isTrueClone();
            mds[i].setTrueClone(true);
        }
        boolean isAffectMdbview = this.getServerStore().saveMetadata(mds, projectID, depends);
        for (int i = 0; i < mds.length; ++i) {
            mds[i].setTrueClone(tc[i]);
        }
        this.afterSave(mds, projectID, isAffectMdbview, finds, depends);
        MDContextFactory.getSystemMDContext().clear(prjs);
    }

    @Override
    public String getXml(AbstractMetaDataValue amd) throws Exception {
        Document doc = this.saver.store(amd);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtils.output(doc, baos);
        return baos.toString("UTF-8");
    }

    @Override
    public String getXml(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        if (this.ctx != null && !StringUtils.isEmpty((String)this.ctx.getAIS())) {
            ConfigMDUtil.setContextToThread(this.ctx);
        }
        return DBConfigureResourceLoader.getResource(p, pk, type);
    }

    @Override
    public void deleteMetadata(Project p, IMetaDataPK pk, BOSObjectType bosType) throws Exception {
        MetaDataPK2 pk2 = new MetaDataPK2(pk.getFullName(), bosType.toString());
        this.deleteMetadata(new MetaDataPK2[]{pk2}, p.getId());
    }

    @Override
    public void saveXml(Project p, IMetaDataPK pk, BOSObjectType type, String xml) throws Exception {
        if (!StringUtils.isEmpty((String)xml)) {
            XmlUtils.verify(xml);
        }
        this.getServerStore().saveXml(p, pk, type, xml);
        MDContextFactory.getSystemMDContext().clear(Project.Projects.getProjects(p));
        MDLoader.getInstance().clear(new MetaDataPK2(pk.getFullName(), type.toString()));
    }

    @Override
    public void upgrade(Project p) throws Exception {
        this.getServerStore().upgrade(p);
        new File(this.configureJar).delete();
        ConfigureResourceLoader.removeLoader(ConfigMDUtil.getAIS());
        MDLoader.getInstance().clearAll();
    }

    @Override
    public List<DynamicMD> getDynamicMDs() {
        return this.getDynamicMDs(null);
    }

    @Override
    public List<DynamicMD> getDynamicMDs(Project[] depends) {
        try {
            return this.getServerStore().getDynamicMDs(depends);
        }
        catch (BOSException e) {
            logger.error((Object)"Get dynamic metadata error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<MetaDataPK2> getAssociatedMDPKs(MetaDataPK2 pk2) throws BOSException {
        return this.getServerStore().getAssociatedMDPKs(pk2);
    }

    @Override
    public List<MetaDataPK2> getAssociatedMDPKs(MetaDataPK2[] pks) throws BOSException {
        return this.getServerStore().getAssociatedMDPKs(pks);
    }

    @Override
    public List<MetaDataPK2> getAssociatedMDPKs(MetaDataPK2[] pks, Project[] depends) throws BOSException {
        return this.getServerStore().getAssociatedMDPKs(pks, depends);
    }

    private static class Change {
        boolean fileChanged;
        boolean aliasChanged;

        private Change() {
        }
    }

    private static class AduOperation {
        List<PropertyInfo> add;
        List<PropertyInfo> delete;
        List<PropertyInfo> update;

        AduOperation(List<PropertyInfo> add, List<PropertyInfo> delete, List<PropertyInfo> update) {
            this.add = add;
            this.delete = delete;
            this.update = update;
        }
    }
}

