/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.metadata.configure.ConfigMDDownloader;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class MetadataStoreUtil {
    private static Logger logger = Logger.getLogger(MetadataStoreUtil.class);
    private static List special = new ArrayList();

    public static void zip(String configureJar, Context ctx) throws Exception {
        MetadataStoreUtil.zip(configureJar, ctx, new File(configureJar).getParent() + "_temp");
    }

    public static void zip(String configureJar, Context ctx, boolean server) throws Exception {
        MetadataStoreUtil.zip(configureJar, ctx, new File(configureJar).getParent() + "_temp", server);
    }

    public static void zip(String configureJar, Context ctx, String srcDir) throws Exception {
        MetadataStoreUtil.zip(configureJar, ctx, srcDir, -1L);
    }

    public static void zip(String configureJar, Context ctx, String srcDir, boolean server) throws Exception {
        MetadataStoreUtil.zip(configureJar, ctx, srcDir, -1L, server);
    }

    public static void zip(String configureJar, Context ctx, String srcDir, long time) throws Exception {
        MetadataStoreUtil.zip(configureJar, ctx, srcDir, time, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String configureJar, Context ctx, String srcDir, long time, boolean server) throws Exception {
        ConfigureResourceLoader loader;
        File cj = new File(configureJar);
        ConfigureResourceLoader configureResourceLoader = loader = ConfigureResourceLoader.getInstance(ctx);
        synchronized (configureResourceLoader) {
            loader.clear();
            if (cj.exists()) {
                cj.renameTo(new File(configureJar + ".bak"));
            }
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    return MetadataStoreUtil.acceptSuffix(pathname.getName());
                }
            };
            File temp = new File(srcDir);
            if (!temp.exists()) {
                logger.warn((Object)(temp + " not exists!"));
                return;
            }
            if (temp.listFiles() == null) {
                logger.warn((Object)(temp + " has't files!"));
                return;
            }
            if (temp.exists() && temp.listFiles() != null) {
                Manifest man = new Manifest();
                String info = "Manifest-Version: 1.0\r\nFrom-BOS-Version: 6.1\r\nAuthor: mgl\r\nAIS: " + ConfigMDUtil.getAIS() + "\r\n";
                byte[] ba = info.getBytes();
                ByteArrayInputStream bis = new ByteArrayInputStream(ba);
                man.read(bis);
                ZipFileUtils.jarFile(srcDir, configureJar, man, filter, time);
            }
            loader.init();
        }
        if (server) {
            ConfigMDDownloader.init();
        }
    }

    public static boolean acceptSuffix(String fileName) {
        if (Utils.acceptSuffix(fileName)) {
            return true;
        }
        for (String suf : special) {
            if (!fileName.endsWith(suf)) continue;
            return true;
        }
        return false;
    }

    static {
        special.add(".xml");
        special.add(".properties");
    }
}

