/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.XMLDAO;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.engine.DevMDError;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.engine.impl.MetadataXMLAssembler;
import com.kingdee.bos.engine.impl.XMLException;
import com.kingdee.bos.metadata.AbstractMetaDataCache;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairCollection;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.IndexColumnCollection;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.service.log.define.LogBizRefCollection;
import com.kingdee.bos.service.log.define.LogBizRefInfo;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class Saver4 {
    private static JDOMFactory jdfactory = new DefaultJDOMFactory();
    private Set<String> localeNames = new HashSet<String>();
    private IMetaDataLoader loader;
    private MetadataXMLAssembler assembler;
    private XMLLoader metametaLoader;

    public Saver4(IMetaDataLoader loader) {
        this.loader = loader;
        this.metametaLoader = ((AbstractMetaDataCache)loader).getMetametaLoader();
        this.assembler = new MetadataXMLAssembler(this.metametaLoader);
        this.init();
    }

    private void init() {
        SolutionInfo sln = this.loader.getSolution();
        LanguageCollection langs = sln.getLanguages();
        if (langs != null) {
            for (int i = 0; i < langs.size(); ++i) {
                LanguageInfo lang = langs.get(i);
                String pf = lang.getPostfix();
                LocaleUtils.getLocale((String)pf);
                LocaleUtils.addShortCode((Locale)lang.getOriginalLocale(), (String)pf);
                this.localeNames.add(lang.getLocaleString());
            }
        }
    }

    public Document store(AbstractMetaDataValue vo) throws MDSaveException {
        EntityObjectInfo realMeta = null;
        try {
            realMeta = this.loader.loadMetameta(vo.getBOSType());
        }
        catch (MissingDAOMetaDataException e) {
            throw new DevMDError("\u5728\u5b58\u50a8\u5143\u6570\u636e\u7684\u65f6\u5019\u65e0\u6cd5\u83b7\u5f97\u5143\u5143\u6570\u636e\u7c7b\u578b[" + vo.getBOSType() + "]");
        }
        this.fill(vo);
        Element root = this.generateRoot(vo, realMeta);
        Document doc = root.getDocument();
        if (doc == null) {
            doc = Saver4.getJDOMFactory().document(root);
        }
        return doc;
    }

    public void fill(AbstractMetaDataValue vo) throws DevMDError {
        EntityObjectInfo realMeta = null;
        try {
            realMeta = this.loader.loadMetameta(vo.getBOSType());
        }
        catch (MissingDAOMetaDataException e) {
            throw new DevMDError("\u5728\u5b58\u50a8\u5143\u6570\u636e\u7684\u65f6\u5019\u65e0\u6cd5\u83b7\u5f97\u5143\u5143\u6570\u636e\u7c7b\u578b[" + vo.getBOSType() + "]");
        }
        BOSObjectType type = vo.getBOSType();
        if (type.equals((Object)MetaDataTypeList.ENTITY) || type.equals((Object)MetaDataTypeList.FACADE)) {
            XMLDAO.fillBusinessObject((BusinessObjectInfo)vo);
        } else if (type.equals((Object)MetaDataTypeList.PERMISSION)) {
            this.fillPermissionID((PermissionInfo)vo);
        }
        this.fixLogicalKey(realMeta.getType(), vo);
    }

    private void fillPermissionID(PermissionInfo ov) {
        PermissionItemCollection its = ov.getPermissionItems();
        for (int i = 0; i < its.size(); ++i) {
            PermissionItemInfo pm = its.get(i);
            BizRefCollection brs = pm.getBizRefs();
            for (int j = 0; j < brs.size(); ++j) {
                BizRefInfo br = brs.get(j);
                if (!StringUtils.isEmpty((String)br.getString("id"))) continue;
                br.setString("id", Uuid.create().toString());
            }
        }
    }

    private Element generateRoot(AbstractMetaDataValue vo, EntityObjectInfo meta) throws MDSaveException {
        Hashtable<String, Map<String, String>> resource = new Hashtable<String, Map<String, String>>();
        Element root = this.generateDoc(vo, meta, resource);
        Element rs = this.getResource(resource);
        root.addContent(rs);
        return root;
    }

    private Element generateDoc(AbstractMetaDataValue vo, EntityObjectInfo meta, Map<String, Map<String, String>> rs) throws MDSaveException {
        Element root = Saver4.getJDOMFactory().element(meta.getName(), "com.kingdee.bos.metadata");
        this.generateVO(root, vo, rs);
        return root;
    }

    private void generateVO(Element root, AbstractMDValue vo, Map<String, Map<String, String>> rs) throws MDSaveException {
        EntityObjectInfo realMeta = null;
        try {
            realMeta = this.loader.loadMetameta(vo.getBOSType());
        }
        catch (MissingDAOMetaDataException e) {
            throw new DevMDError("\u5728\u5b58\u50a8\u5143\u6570\u636e\u7684\u65f6\u5019\u65e0\u6cd5\u83b7\u5f97\u5143\u5143\u6570\u636e\u7c7b\u578b[" + vo.getBOSType() + "]");
        }
        PropertyCollection props = realMeta.getInheritedPropertiesRuntime();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            PropertyInfo prop = (PropertyInfo)it.next();
            if (prop instanceof OwnPropertyInfo) {
                this.generateOwnPropElem(root, (OwnPropertyInfo)prop, vo, rs);
                continue;
            }
            if (prop instanceof LinkPropertyInfo) {
                this.generateLinkPropElem(root, (LinkPropertyInfo)prop, vo, rs);
                continue;
            }
            throw new MDSaveException("\u975e\u6cd5\u7684\u5c5e\u6027\u7c7b\u578bprop=" + prop.getName());
        }
        if (!vo.isExtendedPropertiesEmpty()) {
            OwnPropertyInfo extendedProp = new OwnPropertyInfo();
            extendedProp.setName("extendedProperty");
            extendedProp.setDataType(DataType.STRING);
            this.generateExtendedProps(root, vo, rs);
        }
    }

    private void generateExtendedProps(Element root, AbstractMDValue vo, Map<String, Map<String, String>> rs) {
        if (vo.isExtendedPropertiesEmpty()) {
            return;
        }
        String key = Saver4.getMutlilingualKey(root) + "extendedProperty.";
        Iterator it = vo.getExtendedProperties().keySet().iterator();
        while (it.hasNext()) {
            String name = null;
            String value = null;
            name = (String)it.next();
            value = vo.getExtendedProperty(name);
            HashMap<String, String> hash = new HashMap<String, String>();
            Iterator<String> locales = this.localeNames.iterator();
            while (locales.hasNext()) {
                hash.put(locales.next(), value);
            }
            rs.put(key + name, hash);
        }
    }

    private void generateOwnPropElem(Element root, OwnPropertyInfo ownProp, AbstractMDValue vo, Map<String, Map<String, String>> rs) {
        String name = ownProp.getName();
        if (vo.get(name) == null) {
            return;
        }
        DataType dataType = ownProp.getDataType();
        Element node = Saver4.getJDOMFactory().element(name, "com.kingdee.bos.metadata");
        String value = null;
        if (dataType.equals(DataType.BOOLEAN)) {
            node.setText(vo.getBoolean(name) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        } else if (dataType.equals(DataType.INTEGER)) {
            value = vo.getString(name);
            if (value == null) {
                value = "0";
            }
            node.setText(value);
        } else if (dataType.equals(DataType.STRING)) {
            if (ownProp.isMultilingual()) {
                String key = Saver4.getMutlilingualKey(root) + name;
                HashMap<String, String> hash = new HashMap<String, String>();
                for (String longLocale : this.localeNames) {
                    value = (String)vo.get(name, LocaleUtils.getLocale((String)longLocale));
                    hash.put(longLocale, value);
                }
                node.setText(key);
                rs.put(key, hash);
            } else {
                String s = "package".equals(name) ? vo.getRealPackage() : ("name".equals(name) ? vo.getRealName() : vo.getString(name));
                if (s == null) {
                    node.setText("");
                } else {
                    node.setText(s);
                }
            }
        } else if (vo.getString(name) == null) {
            node.setText("");
        } else {
            node.setText(vo.getString(name));
        }
        root.addContent(node);
    }

    private void generateLinkPropElem(Element root, LinkPropertyInfo linkProp, AbstractMDValue vo, Map<String, Map<String, String>> rs) throws MDSaveException {
        boolean isRef;
        RelationshipInfo relationship = linkProp.getRelationship();
        RelationshipType type = relationship.getType();
        CardinalityType spCty = relationship.getSupplierCardinality();
        if (type.equals((Object)RelationshipType.COMPOSITION)) {
            isRef = false;
        } else if (type.equals((Object)RelationshipType.ASSOCIATION)) {
            isRef = true;
        } else {
            throw new MDSaveException("\u65e0\u6cd5\u8bc6\u522b\u7684\u5173\u7cfb\u7c7b\u578b " + type.getName());
        }
        if (spCty.equals((Object)CardinalityType.ZERO_TO_ONE) || spCty.equals((Object)CardinalityType.ONE)) {
            AbstractMDValue temp = (AbstractMDValue)vo.get(linkProp.getName());
            this.generateLinkSub(root, linkProp, temp, rs, isRef, linkProp.getName());
        } else if (spCty.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || spCty.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
            this.generateCollection(root, linkProp, vo, rs, isRef);
        } else {
            throw new MDSaveException("\u65e0\u6cd5\u8bc6\u522b\u7684\u5173\u7cfb\u591a\u91cd\u6027 " + spCty.getName());
        }
    }

    private void generateLinkSub(Element root, LinkPropertyInfo linkProp, AbstractMDValue vo, Map<String, Map<String, String>> rs, boolean isRef, String name) throws MDSaveException {
        if (vo == null) {
            return;
        }
        Element elem = Saver4.getJDOMFactory().element(name, "com.kingdee.bos.metadata");
        root.addContent(elem);
        RelationshipInfo relationship = linkProp.getRelationship();
        EntityObjectInfo supObj = relationship.getSupplierObject();
        if (isRef) {
            LogicalKeyInfo logicalKey = supObj.getLogicalKey();
            Iterator it = logicalKey.getKeyPropertys().iterator();
            while (it.hasNext()) {
                PropertyInfo prop = (PropertyInfo)it.next();
                String attName = prop.getName();
                String attValue = "name".equals(attName) ? vo.getRealName() : ("package".equals(attName) ? vo.getRealPackage() : vo.getString(attName));
                if (attValue == null) {
                    attValue = "";
                }
                Element key = Saver4.getJDOMFactory().element("key", "com.kingdee.bos.metadata");
                key.setAttribute(Saver4.getJDOMFactory().attribute("name", attName));
                key.setAttribute(Saver4.getJDOMFactory().attribute("value", attValue));
                elem.addContent(key);
            }
        } else {
            this.generateVO(elem, vo, rs);
        }
    }

    private void generateCollection(Element root, LinkPropertyInfo linkProp, AbstractMDValue vo, Map<String, Map<String, String>> rs, boolean isRef) throws MDSaveException {
        IObjectCollection temp = (IObjectCollection)vo.get(linkProp.getName());
        if (temp == null || temp.size() <= 0) {
            return;
        }
        Iterator it = temp.iterator();
        AbstractMDValue child = null;
        Element elem = Saver4.getJDOMFactory().element(linkProp.getName(), "com.kingdee.bos.metadata");
        root.addContent(elem);
        RelationshipInfo relationship = linkProp.getRelationship();
        String name = null;
        while (it.hasNext()) {
            child = (AbstractMDValue)it.next();
            if (isRef) {
                name = relationship.getSupplierObject().getName();
            } else {
                BOSObjectType bosType = child.getBOSType();
                EntityObjectInfo entity = null;
                try {
                    entity = this.loader.loadMetameta(bosType);
                }
                catch (MissingDAOMetaDataException e) {
                    throw new MDSaveException("\u65e0\u6cd5\u89e3\u6790\u51fa\u96c6\u5408\u4e2d\u805a\u5408\u5143\u7d20\u7684\u5143\u5143\u6570\u636e " + bosType);
                }
                name = entity.getName();
            }
            this.generateLinkSub(elem, linkProp, child, rs, isRef, name);
        }
    }

    private Element getResource(Map<String, Map<String, String>> hash) {
        Iterator<String> it = new TreeSet<String>(hash.keySet()).iterator();
        Element resource = Saver4.getJDOMFactory().element("resource", "com.kingdee.bos.metadata");
        Element rs = null;
        while (it.hasNext()) {
            String key = it.next();
            rs = Saver4.getJDOMFactory().element("rs", "com.kingdee.bos.metadata");
            rs.setAttribute(Saver4.getJDOMFactory().attribute("key", key));
            Map<String, String> locales = hash.get(key);
            TreeSet<String> sorted = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            sorted.addAll(locales.keySet());
            for (String o : sorted) {
                Element lang = Saver4.getJDOMFactory().element("lang", "com.kingdee.bos.metadata");
                lang.setAttribute(Saver4.getJDOMFactory().attribute("locale", o.toString()));
                String value = locales.get(o);
                lang.setAttribute(Saver4.getJDOMFactory().attribute("value", value == null ? "null" : value.toString()));
                rs.addContent(lang);
            }
            resource.addContent(rs);
        }
        return resource;
    }

    static String getMutlilingualKey(Element root) {
        Element temp = root;
        String key = "";
        do {
            String pgName = temp.getChildText("package", temp.getNamespace());
            String name = temp.getChildText("name", temp.getNamespace());
            String instanceName = null;
            if ("action".equalsIgnoreCase(temp.getName()) && !StringUtils.isEmpty((String)(instanceName = temp.getChildText("instanceName", temp.getNamespace())))) {
                name = instanceName;
            }
            if (StringUtils.isEmpty((String)pgName) && StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)instanceName)) {
                key = !StringUtils.isEmpty((String)key) ? temp.getName() + "." + key : temp.getName();
                temp = temp.getParent();
                continue;
            }
            String str = temp.getName() + "[";
            if (pgName != null) {
                str = str + pgName + ".";
            }
            if (name != null) {
                str = str + name;
            }
            str = str + "].";
            key = str + key;
            temp = temp.getParent();
        } while (temp != null);
        return key;
    }

    private void fixLogicalKey(BOSObjectType bosType, AbstractMetaDataValue ov) {
        if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
            PermissionInfo per = (PermissionInfo)ov;
            DependenceCollection dc = per.getDependences();
            if (null != dc) {
                for (int i = 0; i < dc.size(); ++i) {
                    DependenceInfo dep = dc.get(i);
                    PermissionItemInfo pii = dep.getReferedItem();
                    if (null == pii) continue;
                    dep.setString("id", pii.getInnerID());
                }
            }
        } else if (MetaDataTypeList.LOG.equals((Object)bosType)) {
            LogInfo log = (LogInfo)ov;
            LogItemCollection logs = log.getLogItems();
            if (null != logs) {
                for (int i = 0; i < logs.size(); ++i) {
                    LogItemInfo logItem = logs.get(i);
                    LogBizRefCollection bizs = logItem.getLogBizRefCollection();
                    if (null == bizs) continue;
                    for (int j = 0; j < bizs.size(); ++j) {
                        LogBizRefInfo biz = bizs.get(j);
                        MetaDataInfo ref = biz.getMetadataRef();
                        if (null == ref) continue;
                        MetaDataPK2 pk2 = new MetaDataPK2(ref.getPackage(), ref.getName(), ref.getMetaDataType());
                        biz.setString("id", pk2.toString());
                    }
                }
            }
        } else if (MetaDataTypeList.JOINQUERY.equals((Object)bosType) || MetaDataTypeList.UNIONQUERY.equals((Object)bosType) || MetaDataTypeList.BASEQUERY.equals((Object)bosType)) {
            JoinQueryInfo joinQuery;
            JoinCollection joins;
            QueryInfo query = (QueryInfo)ov;
            PropertyUnitCollection propUnits = query.getUnits();
            if (propUnits != null) {
                for (int i = 0; i < propUnits.size(); ++i) {
                    PropertyUnitInfo propUnit = propUnits.get(i);
                    PropertyRefCollection refs = propUnit.getPropertyRefs();
                    if (refs == null) continue;
                    for (int j = 0; j < refs.size(); ++j) {
                        PropertyRefInfo prop = refs.get(j);
                        String key = prop.getString("key");
                        if (key != null && key.length() != 0) continue;
                        prop.setString("key", Uuid.create().toString());
                    }
                }
            }
            if (MetaDataTypeList.JOINQUERY.equals((Object)bosType) && (joins = (joinQuery = (JoinQueryInfo)ov).getJoins()) != null) {
                for (int i = 0; i < joins.size(); ++i) {
                    JoinInfo join = joins.get(i);
                    JoinItemCollection joinItems = join.getJoinItems();
                    if (joinItems == null) continue;
                    for (int j = 0; j < joinItems.size(); ++j) {
                        JoinItemInfo item = joinItems.get(j);
                        String name = item.getName();
                        if (name != null && name.length() != 0) continue;
                        item.setName(Uuid.create().toString());
                    }
                }
            }
        } else if (MetaDataTypeList.DATATABLE.equals((Object)bosType) || MetaDataTypeList.EXTENDEDTABLE.equals((Object)bosType) || MetaDataTypeList.CROSSTABLE.equals((Object)bosType) || MetaDataTypeList.ABSTRACTTABLE.equals((Object)bosType)) {
            ForeignKeyCollection fks;
            PKColumnCollection pkcs;
            PrimaryKeyInfo pk;
            AbstractTableInfo table = (AbstractTableInfo)ov;
            IndexCollection indexs = table.getIndexes();
            if (indexs != null) {
                for (int i = 0; i < indexs.size(); ++i) {
                    IndexInfo index = indexs.get(i);
                    IndexColumnCollection ics = index.getIndexColumns();
                    if (ics == null) continue;
                    for (int j = 0; j < ics.size(); ++j) {
                        IndexColumnInfo ic = ics.get(j);
                        ic.setString("indexID", String.valueOf(j));
                    }
                }
            }
            if ((pk = table.getPrimaryKey()) != null && (pkcs = pk.getPKColumns()) != null) {
                for (int i = 0; i < pkcs.size(); ++i) {
                    PKColumnInfo pkc = pkcs.get(i);
                    pkc.setString("indexID", String.valueOf(i));
                }
            }
            if ((fks = table.getForeignKeys()) != null) {
                for (int i = 0; i < fks.size(); ++i) {
                    ForeignKeyInfo fk = fks.get(i);
                    FKColumnPairCollection fkcs = fk.getFKColumnPairs();
                    if (fkcs == null) continue;
                    for (int j = 0; j < fkcs.size(); ++j) {
                        FKColumnPairInfo fkc = fkcs.get(j);
                        fkc.setString("sequence", String.valueOf(j));
                    }
                }
            }
        } else if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
            PropertyInfo pi;
            EntityObjectInfo entity = (EntityObjectInfo)ov;
            PropertyCollection pc = null;
            if (entity.getLogicalKey() != null) {
                pc = entity.getLogicalKey().getKeyPropertys();
            }
            if (pc != null && pc.size() == 1 && ((pi = pc.get(0)) == null || StringUtils.isEmpty((String)pi.getName()))) {
                pc.removeObject(0);
                pc.add(entity.getPropertyByName("id"));
            }
        }
    }

    static String getMutlilingualKey2(Element root) {
        Element temp = root;
        String key = "";
        do {
            String pgName = temp.getChildText("package", temp.getNamespace());
            String name = temp.getChildText("name", temp.getNamespace());
            String instanceName = null;
            if ("action".equalsIgnoreCase(temp.getName()) && !StringUtils.isEmpty((String)(instanceName = temp.getChildText("instanceName", temp.getNamespace())))) {
                name = instanceName;
            }
            if (StringUtils.isEmpty((String)pgName) && StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)instanceName)) {
                temp = temp.getParent();
                continue;
            }
            String str = temp.getName() + "[";
            if (pgName != null) {
                str = str + pgName + ".";
            }
            if (name != null) {
                str = str + name;
            }
            str = str + "].";
            key = str + key;
            temp = temp.getParent();
        } while (temp != null);
        return key;
    }

    private static JDOMFactory getJDOMFactory() {
        return jdfactory;
    }

    public Document diffStore(AbstractMetaDataValue newVo, AbstractMetaDataValue oldVo) throws MDSaveException, MissingDAOMetaDataException, XMLException {
        if (newVo == null || newVo.isNull()) {
            return this.store(oldVo);
        }
        if (oldVo == null || oldVo.isNull()) {
            return this.store(newVo);
        }
        Document bigDom = this.store(newVo);
        Document baseDom = this.store(oldVo);
        Document saveDom = this.assembler.diff(this.metametaLoader.loadMeta(newVo.getBOSType()), bigDom, baseDom, false);
        return saveDom;
    }

    public Document storeConfigure(AbstractMetaDataValue metadata, Context ctx) throws Exception {
        return this.storeConfigure(metadata, ctx, true);
    }

    public Document storeConfigure(AbstractMetaDataValue metadata, Context ctx, boolean merge) throws Exception {
        MetaDataPK2 pk2;
        Document docNew = this.store(metadata);
        if (!merge) {
            return docNew;
        }
        ConfigureResourceLoader crl = ConfigureResourceLoader.getInstance(ctx);
        InputStream isFrag = crl.getResourceAsStream((pk2 = new MetaDataPK2(metadata.getPackage(), metadata.getName(), metadata.getBOSType().toString())).getPath2());
        if (isFrag == null) {
            return docNew;
        }
        Document docOld = XMLParser.parseXML((InputStream)isFrag);
        Document docMerged = this.assembler.merge(this.metametaLoader.loadMeta(metadata.getBOSType()), docOld, docNew);
        return docMerged;
    }
}

