/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.deployfile;

import com.kingdee.bos.metadata.deployfile.DeployFileGenerateException;
import com.kingdee.bos.metadata.deployfile.EarInfo;
import com.kingdee.bos.metadata.deployfile.EjbInfo;
import com.kingdee.bos.metadata.deployfile.EjbModuleInfo;
import com.kingdee.bos.metadata.deployfile.J2eeStdDeployFileGenerator;
import com.kingdee.bos.metadata.deployfile.WebModuleInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.service.netfile.NetFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ApusicDeployFileGenerator
extends J2eeStdDeployFileGenerator {
    private static final String APUSICAPPLICATION = "apusic-application.xml";
    static final String SYSTEMID_APUSIC_APPLICATION = "http://www.apusic.com/dtds/apusic-application_2_0.dtd";
    static final String PUBLICID_APUSIC_APPLICATION = "-//Apusic//DTD Apusic Application 2.0//EN";

    public ApusicDeployFileGenerator(EarInfo earInfo, String deployPath, boolean isOverride) throws DeployFileGenerateException {
        super(earInfo, deployPath, isOverride);
    }

    @Override
    public void generateEar() throws DeployFileGenerateException {
        super.generateEar();
        NetFile apusicApplication = this.fileFactory.createNetFile("META-INF\\apusic-application.xml");
        OutputStream os = null;
        try {
            int i;
            Element root = null;
            if (apusicApplication.exists()) {
                if (!this.isOverride) {
                    SAXBuilder builder = new SAXBuilder(false);
                    builder.setEntityResolver((EntityResolver)this);
                    root = builder.build(this.fileFactory.createNetFileInputStream(apusicApplication)).getRootElement();
                } else {
                    root = this.jdomFactory.element("apusic-application");
                }
            } else {
                NetFile metaInf = this.fileFactory.createNetFile("META-INF");
                metaInf.mkdirs();
                root = this.jdomFactory.element("apusic-application");
            }
            if (root.getChild("display-name") == null) {
                Element displayName = this.jdomFactory.element("display-name");
                displayName.addContent(this.earInfo.getDisplayName());
                root.addContent(displayName);
            }
            if (root.getChild("description") == null) {
                Element description = this.jdomFactory.element("description");
                description.addContent(this.earInfo.getDescription());
                root.addContent(description);
            }
            for (i = 0; i < this.earInfo.getEjbModules().length; ++i) {
                EjbModuleInfo ejbModuleInfo = this.earInfo.getEjbModules()[i];
                Element ejb = null;
                if (!this.isOverride) {
                    String ejbModulePath = "//module/ejb[ejb-uri=\"" + ejbModuleInfo.getEjbUri() + "\"]";
                    ejb = (Element)XPath.selectSingleNode((Object)root, (String)ejbModulePath);
                }
                if (ejb == null) {
                    Element module = this.jdomFactory.element("module");
                    ejb = this.jdomFactory.element("ejb");
                    Element ejbUri = this.jdomFactory.element("ejb-uri");
                    ejbUri.addContent(ejbModuleInfo.getEjbUri());
                    ejb.addContent(ejbUri);
                    module.addContent(ejb);
                    root.addContent(module);
                }
                for (int j = 0; j < ejbModuleInfo.getEjbs().length; ++j) {
                    EjbInfo ejbInfo = ejbModuleInfo.getEjbs()[j];
                    this.generateEarEjb(ejb, ejbInfo);
                }
            }
            for (i = 0; i < this.earInfo.getWebModules().length; ++i) {
                WebModuleInfo webModuleInfo = this.earInfo.getWebModules()[i];
                Element webModule = null;
                if (!this.isOverride) {
                    String webModulePath = "//module[web/web-uri=\"" + webModuleInfo.getWebUri() + "\"]";
                    webModule = (Element)XPath.selectSingleNode((Object)root, (String)webModulePath);
                }
                if (webModule != null) continue;
                webModule = this.jdomFactory.element("module");
                Element web = this.jdomFactory.element("web");
                Element weburi = this.jdomFactory.element("web-uri");
                Element contextRoot = this.jdomFactory.element("context-root");
                weburi.addContent(webModuleInfo.getWebUri());
                contextRoot.addContent(webModuleInfo.getContextRoot());
                web.addContent(weburi);
                web.addContent(contextRoot);
                webModule.addContent(web);
                root.addContent(webModule);
            }
            NetFile metaInf = this.fileFactory.createNetFile("META-INF");
            if (!metaInf.exists()) {
                metaInf.mkdir();
            }
            os = this.fileFactory.createNetFileOutputStream(apusicApplication);
            Document doc = root.getDocument();
            if (doc == null) {
                DocType docType = new DocType("apusic-application");
                docType.setSystemID(SYSTEMID_APUSIC_APPLICATION);
                docType.setPublicID(PUBLICID_APUSIC_APPLICATION);
                doc = new Document(root, docType);
            }
            XmlUtils.output(doc, os);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {}
        }
    }

    private void generateEarEjb(Element ejb, EjbInfo ejbInfo) throws JDOMException {
        Element session = null;
        if (!this.isOverride) {
            String ejbPath = "//session[@ejb-name=\"" + ejbInfo.getEjbName() + "\"]";
            session = (Element)XPath.selectSingleNode((Object)ejb, (String)ejbPath);
        }
        if (session != null) {
            return;
        }
        session = this.jdomFactory.element("session");
        session.setAttribute(this.jdomFactory.attribute("ejb-name", ejbInfo.getEjbName()));
        Element localJndiName = this.jdomFactory.element("local-jndi-name");
        localJndiName.addContent(ejbInfo.getJndiLocalName());
        session.addContent(localJndiName);
        ejb.addContent(session);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inSrc = super.resolveEntity(publicId, systemId);
        if (inSrc != null) {
            return inSrc;
        }
        inSrc = new InputSource();
        if (PUBLICID_APUSIC_APPLICATION.equals(publicId) && SYSTEMID_APUSIC_APPLICATION.equals(systemId)) {
            inSrc.setSystemId(systemId);
            inSrc.setPublicId(publicId);
            InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/metadata/deployfile/apusic-application_2_0.dtd");
            if (is == null) {
                throw new IllegalStateException("please add apusic-aplication_2_0.dtd to classpath");
            }
            inSrc.setByteStream(is);
            return inSrc;
        }
        return null;
    }
}

