/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.deployfile;

import com.kingdee.bos.metadata.deployfile.DeployFileGenerateException;
import com.kingdee.bos.metadata.deployfile.EarInfo;
import com.kingdee.bos.metadata.deployfile.EjbInfo;
import com.kingdee.bos.metadata.deployfile.EjbMethodInfo;
import com.kingdee.bos.metadata.deployfile.EjbModuleInfo;
import com.kingdee.bos.metadata.deployfile.IDeployFileGenerator;
import com.kingdee.bos.metadata.deployfile.MethodIntf;
import com.kingdee.bos.metadata.deployfile.WebModuleInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class J2eeStdDeployFileGenerator
implements IDeployFileGenerator,
EntityResolver {
    protected final EarInfo earInfo;
    protected final String deployPath;
    protected final JDOMFactory jdomFactory;
    protected final NetFileFactory fileFactory;
    protected final boolean isOverride;
    protected final boolean isGenerateID;
    protected final boolean isGenerateLocal;
    protected static final String APPLICATION = "application.xml";
    protected static final String EJB = "ejb-jar.xml";
    protected static final String WEB = "web.xml";
    protected static final String METAINF = "META-INF";
    protected static final String WEBINF = "WEB-INF";
    protected static final String PUBLICID_EJB20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    protected static final String SYSTEMID_EJB20 = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    protected static final String PUBLICID_APPLICATION = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    protected static final String SYSTEMID_APPLICATION = "http://java.sun.com/dtd/application_1_3.dtd";
    protected static final String PUBLICID_WEB = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    protected static final String SYSTEMID_WEB = "http://java.sun.com/dtd/web-app_2_3.dtd";

    public J2eeStdDeployFileGenerator(EarInfo earInfo, String deployPath, boolean isOverride) throws DeployFileGenerateException {
        this(earInfo, deployPath, isOverride, false, true);
    }

    public J2eeStdDeployFileGenerator(EarInfo earInfo, String deployPath, boolean isOverride, boolean isGenerateLocal) throws DeployFileGenerateException {
        this(earInfo, deployPath, isOverride, false, isGenerateLocal);
    }

    public J2eeStdDeployFileGenerator(EarInfo earInfo, String deployPath, boolean isOverride, boolean isGenerateID, boolean isGenerateLocal) throws DeployFileGenerateException {
        this.earInfo = earInfo;
        this.deployPath = deployPath;
        this.jdomFactory = new DefaultJDOMFactory();
        this.isOverride = isOverride;
        this.isGenerateID = isGenerateID;
        this.isGenerateLocal = isGenerateLocal;
        try {
            this.fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)new NetFileSource(new File(deployPath).toURL().toString()));
        }
        catch (Exception e) {
            throw new DeployFileGenerateException("Error netfile src" + deployPath, e);
        }
    }

    @Override
    public void generate() throws DeployFileGenerateException {
        this.generateEar();
    }

    public void generateEar() throws DeployFileGenerateException {
        NetFile application = this.fileFactory.createNetFile("META-INF\\application.xml");
        Element root = this.jdomFactory.element("application");
        if (this.isGenerateID) {
            root.setAttribute(this.jdomFactory.attribute("id", "Application_" + this.earInfo.hashCode()));
        }
        Element displayName = this.jdomFactory.element("display-name");
        displayName.addContent(this.earInfo.getDisplayName());
        Element description = this.jdomFactory.element("description");
        description.addContent(this.earInfo.getDescription());
        root.addContent(displayName);
        root.addContent(description);
        EjbModuleInfo[] ejbModules = this.earInfo.getEjbModules();
        for (int i = 0; i < ejbModules.length; ++i) {
            Element ejbModule = this.jdomFactory.element("module");
            Element ejb = this.jdomFactory.element("ejb");
            ejb.addContent(ejbModules[i].getEjbUri());
            ejbModule.addContent(ejb);
            if (this.isGenerateID) {
                ejbModule.setAttribute(this.jdomFactory.attribute("id", "EjbModule_" + ejbModules[i].hashCode()));
            }
            root.addContent(ejbModule);
            this.generateEjbModule(ejbModules[i]);
        }
        WebModuleInfo[] webModules = this.earInfo.getWebModules();
        for (int i = 0; i < webModules.length; ++i) {
            Element webModule = this.jdomFactory.element("module");
            Element web = this.jdomFactory.element("web");
            Element weburi = this.jdomFactory.element("web-uri");
            Element contextRoot = this.jdomFactory.element("context-root");
            weburi.addContent(webModules[i].getWebUri());
            contextRoot.addContent(webModules[i].getContextRoot());
            web.addContent(weburi);
            web.addContent(contextRoot);
            webModule.addContent(web);
            if (this.isGenerateID) {
                webModule.setAttribute(this.jdomFactory.attribute("id", "WebModule_" + webModules[i].hashCode()));
            }
            root.addContent(webModule);
            this.generateWebModule(webModules[i]);
        }
        NetFile metaInf = this.fileFactory.createNetFile(METAINF);
        if (!metaInf.exists()) {
            metaInf.mkdir();
        }
        OutputStream os = null;
        try {
            os = this.fileFactory.createNetFileOutputStream(application);
            Document doc = root.getDocument();
            if (doc == null) {
                DocType docType = new DocType("application");
                docType.setSystemID(SYSTEMID_APPLICATION);
                docType.setPublicID(PUBLICID_APPLICATION);
                doc = new Document(root, docType);
            }
            XmlUtils.output(doc, os);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public void generateEjbModule(EjbModuleInfo ejbModuleInfo) throws DeployFileGenerateException {
        NetFile ejb = this.fileFactory.createNetFile(ejbModuleInfo.getEjbUri() + "\\" + METAINF + "\\" + EJB);
        Element root = null;
        OutputStream os = null;
        try {
            if (ejb.exists()) {
                if (this.isOverride) {
                    root = this.jdomFactory.element("ejb-jar");
                } else {
                    SAXBuilder builder = new SAXBuilder(false);
                    builder.setEntityResolver((EntityResolver)this);
                    root = builder.build(this.fileFactory.createNetFileInputStream(ejb)).getRootElement();
                }
            } else {
                NetFile ejbModule = this.fileFactory.createNetFile(ejbModuleInfo.getEjbUri() + "\\" + METAINF);
                ejbModule.mkdirs();
                root = this.jdomFactory.element("ejb-jar");
            }
            if (this.isGenerateID) {
                root.setAttribute(this.jdomFactory.attribute("id", "EJBJar_" + ejbModuleInfo.hashCode()));
            }
            if (root.getChild("description") == null) {
                Element description = this.jdomFactory.element("description");
                description.addContent(ejbModuleInfo.getDescription());
                root.addContent(description);
            }
            if (root.getChild("display-name") == null) {
                Element displayName = this.jdomFactory.element("display-name");
                displayName.addContent(ejbModuleInfo.getDisplayName());
                root.addContent(displayName);
            }
            Element ejbs = null;
            if (root.getChild("enterprise-beans") == null) {
                ejbs = this.jdomFactory.element("enterprise-beans");
                root.addContent(ejbs);
            } else {
                ejbs = root.getChild("enterprise-beans");
            }
            Element assembly = null;
            if (root.getChild("assembly-descriptor") == null) {
                assembly = this.jdomFactory.element("assembly-descriptor");
                root.addContent(assembly);
            } else {
                assembly = root.getChild("assembly-descriptor");
            }
            for (int i = 0; i < ejbModuleInfo.getEjbs().length; ++i) {
                this.generateEJB0(ejbs, ejbModuleInfo.getEjbs()[i]);
                this.generateEJB1(assembly, ejbModuleInfo.getEjbs()[i]);
            }
            os = this.fileFactory.createNetFileOutputStream(ejb);
            Document doc = root.getDocument();
            if (doc == null) {
                DocType docType = new DocType("ejb-jar");
                docType.setSystemID(SYSTEMID_EJB20);
                docType.setPublicID(PUBLICID_EJB20);
                doc = new Document(root, docType);
            }
            XmlUtils.output(doc, os);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {}
        }
    }

    private void generateEJB0(Element ejbs, EjbInfo ejbInfo) throws JDOMException {
        Element ejb = null;
        String ejbPath = "//session[ejb-name=\"" + ejbInfo.getEjbName() + "\"]";
        if (!this.isOverride && (ejb = (Element)XPath.selectSingleNode((Object)ejbs, (String)ejbPath)) != null) {
            ejbs.removeContent(ejb);
        }
        ejb = this.jdomFactory.element("session");
        if (this.isGenerateID) {
            ejb.setAttribute(this.jdomFactory.attribute("id", "Session_" + ejbInfo.getEjbName().hashCode()));
        }
        Element description = this.jdomFactory.element("description");
        description.addContent(ejbInfo.getEjbClass());
        Element displayName = this.jdomFactory.element("display-name");
        displayName.addContent(ejbInfo.getEjbClass());
        Element ejbName = this.jdomFactory.element("ejb-name");
        ejbName.addContent(ejbInfo.getEjbName());
        Element home = this.jdomFactory.element("home");
        home.addContent(ejbInfo.getHome());
        Element remote = this.jdomFactory.element("remote");
        remote.addContent(ejbInfo.getRemote());
        Element localName = this.jdomFactory.element("local-home");
        localName.addContent(ejbInfo.getLocalHome());
        Element local = this.jdomFactory.element("local");
        local.addContent(ejbInfo.getLocal());
        Element ejbClass = this.jdomFactory.element("ejb-class");
        ejbClass.addContent(ejbInfo.getEjbClass());
        Element sessionType = this.jdomFactory.element("session-type");
        sessionType.addContent(ejbInfo.getSessionType().getName());
        Element transactionType = this.jdomFactory.element("transaction-type");
        transactionType.addContent(ejbInfo.getTransactionType().getName());
        ejb.addContent(description);
        ejb.addContent(displayName);
        ejb.addContent(ejbName);
        ejb.addContent(home);
        ejb.addContent(remote);
        if (this.isGenerateLocal) {
            ejb.addContent(localName);
            ejb.addContent(local);
        }
        ejb.addContent(ejbClass);
        ejb.addContent(sessionType);
        ejb.addContent(transactionType);
        ejbs.addContent(ejb);
    }

    private void generateEJB1(Element assembly, EjbInfo ejbInfo) throws JDOMException {
        if (!this.isOverride) {
            String transactionPath = "//container-transaction[method/ejb-name=\"" + ejbInfo.getEjbName() + "\"]";
            for (Element ct : XPath.selectNodes((Object)assembly, (String)transactionPath)) {
                assembly.removeContent(ct);
            }
        }
        EjbMethodInfo[] ejbMethodInfos = ejbInfo.getmethdos();
        for (int i = 0; i < ejbMethodInfos.length; ++i) {
            this.generateMethodTrasaction(assembly, ejbInfo.getEjbName(), ejbMethodInfos[i]);
        }
    }

    private void generateMethodTrasaction(Element assembly, String ejbName, EjbMethodInfo ejbMethod) {
        if (!this.isGenerateLocal) {
            ejbMethod.removeMethodIntf(MethodIntf.LOCAL);
        }
        for (int i = 0; i < ejbMethod.getMethodIntfs().length; ++i) {
            Element containerTransaction = this.jdomFactory.element("container-transaction");
            Element method = this.jdomFactory.element("method");
            Element ejbNameElem = this.jdomFactory.element("ejb-name");
            ejbNameElem.addContent(ejbName);
            Element methodIntf = this.jdomFactory.element("method-intf");
            methodIntf.addContent(ejbMethod.getMethodIntfs()[i].getName());
            Element methodName = this.jdomFactory.element("method-name");
            methodName.addContent(ejbMethod.getEjbUri());
            method.addContent(ejbNameElem);
            method.addContent(methodIntf);
            method.addContent(methodName);
            Element methodParams = this.jdomFactory.element("method-params");
            for (int j = 0; j < ejbMethod.getParameters().length; ++j) {
                Element methodParam = this.jdomFactory.element("method-param");
                methodParam.addContent(ejbMethod.getParameters()[j]);
                methodParams.addContent(methodParam);
            }
            method.addContent(methodParams);
            Element transAttribute = this.jdomFactory.element("trans-attribute");
            transAttribute.addContent(ejbMethod.getTsAtt().getName());
            containerTransaction.addContent(method);
            containerTransaction.addContent(transAttribute);
            assembly.addContent(containerTransaction);
        }
    }

    public void generateWebModule(WebModuleInfo webModuleInfo) throws DeployFileGenerateException {
        NetFile web = this.fileFactory.createNetFile(webModuleInfo.getWebUri() + "\\" + WEBINF + "\\" + WEB);
        Element root = null;
        OutputStream os = null;
        try {
            if (web.exists()) {
                return;
            }
            NetFile webModule = this.fileFactory.createNetFile(webModuleInfo.getWebUri() + "\\" + WEBINF);
            webModule.mkdirs();
            root = this.jdomFactory.element("web-app");
            if (this.isGenerateID) {
                root.setAttribute(this.jdomFactory.attribute("id", "WebApp_" + webModuleInfo.hashCode()));
            }
            os = this.fileFactory.createNetFileOutputStream(web);
            Document doc = root.getDocument();
            if (root.getDocument() == null) {
                DocType docType = new DocType("web-app");
                docType.setSystemID(SYSTEMID_WEB);
                docType.setPublicID(PUBLICID_WEB);
                doc = new Document(root, docType);
            }
            XmlUtils.output(doc, os);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inSrc = new InputSource();
        if (PUBLICID_EJB20.equals(publicId) && SYSTEMID_EJB20.equals(systemId)) {
            inSrc.setSystemId(systemId);
            inSrc.setPublicId(publicId);
            InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/metadata/deployfile/ejb-jar_2_0.dtd");
            if (is == null) {
                throw new IllegalStateException("please add ejb-jar_2_0.dtd to classpath");
            }
            inSrc.setByteStream(is);
            return inSrc;
        }
        if (PUBLICID_APPLICATION.equals(publicId) && SYSTEMID_APPLICATION.equals(systemId)) {
            inSrc.setSystemId(systemId);
            inSrc.setPublicId(publicId);
            InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/metadata/deployfile/application_1_3.dtd");
            if (is == null) {
                throw new IllegalStateException("please add application_1_3.dtd to classpath");
            }
            inSrc.setByteStream(is);
            return inSrc;
        }
        if (PUBLICID_WEB.equals(publicId) && SYSTEMID_WEB.equals(systemId)) {
            inSrc.setSystemId(systemId);
            inSrc.setPublicId(publicId);
            InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/metadata/deployfile/web-app_2_3.dtd");
            if (is == null) {
                throw new IllegalStateException("please add web-app_2_3.dtd to classpath");
            }
            inSrc.setByteStream(is);
            return inSrc;
        }
        return null;
    }
}

