/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.deployfile;

import com.kingdee.bos.metadata.deployfile.DeployFileGenerateException;
import com.kingdee.bos.metadata.deployfile.EarInfo;
import com.kingdee.bos.metadata.deployfile.EjbInfo;
import com.kingdee.bos.metadata.deployfile.EjbModuleInfo;
import com.kingdee.bos.metadata.deployfile.J2eeStdDeployFileGenerator;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.service.netfile.NetFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebLogicDeployFileGenerator
extends J2eeStdDeployFileGenerator {
    protected static final String WEBLOGICAPPLICATION = "weblogic-application.xml";
    protected static final String WEBLOGICEJBJAR = "weblogic-ejb-jar.xml";
    static final String PUBLICID_WEBLOGIC_EJB = "-//BEA Systems, Inc.//DTD WebLogic 7.0.0 EJB//EN";
    static final String SYSTEMID_WEBLOGIC_EJB = "http://www.bea.com/servers/wls700/dtd/weblogic-ejb-jar.dtd";

    public WebLogicDeployFileGenerator(EarInfo earInfo, String deployPath, boolean isOverride) throws DeployFileGenerateException {
        super(earInfo, deployPath, isOverride, false);
    }

    @Override
    public void generateEar() throws DeployFileGenerateException {
        super.generateEar();
    }

    @Override
    public void generateEjbModule(EjbModuleInfo ejbModuleInfo) throws DeployFileGenerateException {
        super.generateEjbModule(ejbModuleInfo);
        this.generateEjbModule0(ejbModuleInfo);
    }

    private void generateEjbModule0(EjbModuleInfo ejbModuleInfo) throws DeployFileGenerateException {
        NetFile weblogicEjbJar = this.fileFactory.createNetFile(ejbModuleInfo.getEjbUri() + "\\" + "META-INF" + "\\" + WEBLOGICEJBJAR);
        OutputStream os = null;
        try {
            NetFile metaInf;
            Element root = null;
            if (weblogicEjbJar.exists()) {
                if (!this.isOverride) {
                    SAXBuilder builder = new SAXBuilder(false);
                    builder.setEntityResolver((EntityResolver)this);
                    root = builder.build(this.fileFactory.createNetFileInputStream(weblogicEjbJar)).getRootElement();
                } else {
                    root = this.jdomFactory.element("weblogic-ejb-jar");
                }
            } else {
                metaInf = this.fileFactory.createNetFile("META-INF");
                metaInf.mkdirs();
                root = this.jdomFactory.element("weblogic-ejb-jar");
            }
            metaInf = this.fileFactory.createNetFile(ejbModuleInfo.getEjbUri() + "\\" + "META-INF");
            if (!metaInf.exists()) {
                metaInf.mkdir();
            }
            this.generateEjbModule1(root, ejbModuleInfo);
            os = this.fileFactory.createNetFileOutputStream(weblogicEjbJar);
            Document doc = root.getDocument();
            if (doc == null) {
                DocType docType = new DocType("weblogic-ejb-jar");
                docType.setPublicID(PUBLICID_WEBLOGIC_EJB);
                docType.setSystemID(SYSTEMID_WEBLOGIC_EJB);
                doc = new Document(root, docType);
            }
            XmlUtils.output(doc, os);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {}
        }
    }

    private void generateEjbModule1(Element root, EjbModuleInfo ejbModule) throws JDOMException {
        EjbInfo[] ejbs = ejbModule.getEjbs();
        for (int i = 0; i < ejbs.length; ++i) {
            Element tempElem;
            EjbInfo ejb = ejbs[i];
            String ejbPath = "//weblogic-enterprise-bean[ejb-name=\"" + ejb.getEjbName() + "\"]";
            Element ejbElem = null;
            if (!this.isOverride && (tempElem = (Element)XPath.selectSingleNode((Object)root, (String)ejbPath)) != null) {
                root.removeContent(tempElem);
            }
            ejbElem = this.jdomFactory.element("weblogic-enterprise-bean");
            Element ejbName = this.jdomFactory.element("ejb-name");
            ejbName.addContent(ejb.getEjbName());
            Element jndiName = this.jdomFactory.element("jndi-name");
            jndiName.addContent(ejb.getJndiRemoteName());
            ejbElem.addContent(ejbName);
            ejbElem.addContent(jndiName);
            root.addContent(ejbElem);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inSrc = super.resolveEntity(publicId, systemId);
        if (inSrc != null) {
            return inSrc;
        }
        inSrc = new InputSource();
        if (PUBLICID_WEBLOGIC_EJB.equals(publicId) && SYSTEMID_WEBLOGIC_EJB.equals(systemId)) {
            inSrc.setSystemId(systemId);
            inSrc.setPublicId(publicId);
            InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/metadata/deployfile/weblogic-ejb-jar.dtd");
            if (is == null) {
                throw new IllegalStateException("please add weblogic-ejb-jar.dtd to classpath");
            }
            inSrc.setByteStream(is);
            return inSrc;
        }
        return null;
    }
}

