/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.deployfile;

import com.kingdee.bos.metadata.deployfile.DeployFileGenerateException;
import com.kingdee.bos.metadata.deployfile.EarInfo;
import com.kingdee.bos.metadata.deployfile.EjbInfo;
import com.kingdee.bos.metadata.deployfile.EjbModuleInfo;
import com.kingdee.bos.metadata.deployfile.IDeployFileGenerator;
import com.kingdee.bos.metadata.deployfile.J2eeStdDeployFileGenerator;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.service.netfile.NetFile;
import java.io.OutputStream;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class WebSphereDeployFileGenerator
extends J2eeStdDeployFileGenerator
implements IDeployFileGenerator {
    protected final String IBM_EJB_JAR_BND = "ibm-ejb-jar-bnd.xmi";
    protected final String IBM_WEB_BND = "ibm-web-bnd.xmi";
    protected final String IBM_WEB_EXT = "ibm-web-ext.xmi";
    protected final String IBM_MODULEMAPS = ".modulemap";
    protected static final Namespace xmiNS = Namespace.getNamespace((String)"xmi", (String)"http://www.omg.org/XMI");
    protected static final Namespace xsiNS = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    protected static final Namespace commonNS = Namespace.getNamespace((String)"common", (String)"common.xmi");
    protected static final Namespace commonbndNS = Namespace.getNamespace((String)"commonbnd", (String)"commonbnd.xmi");
    protected static final Namespace ejbbndNS = Namespace.getNamespace((String)"ejbbnd", (String)"ejbbnd.xmi");
    protected static final Namespace ejbNS = Namespace.getNamespace((String)"ejb", (String)"ejb.xmi");
    protected static final Namespace webbndNS = Namespace.getNamespace((String)"webappbnd", (String)"webappbnd.xmi");
    protected static final Namespace webappextNS = Namespace.getNamespace((String)"webappext", (String)"webappext.xmi");
    protected static final Namespace webapplicationNS = Namespace.getNamespace((String)"webapplication", (String)"webapplication.xmi");
    protected static final Namespace modulemapNS = Namespace.getNamespace((String)"modulemap", (String)"modulemap.xmi");
    protected static final Namespace applicationNS = Namespace.getNamespace((String)"application", (String)"application.xmi");

    public WebSphereDeployFileGenerator(EarInfo earInfo, String deployPath, boolean isOverride) throws DeployFileGenerateException {
        super(earInfo, deployPath, isOverride, true, true);
    }

    @Override
    public void generateEjbModule(EjbModuleInfo ejbModuleInfo) throws DeployFileGenerateException {
        super.generateEjbModule(ejbModuleInfo);
        this.generateEjbBnd(ejbModuleInfo);
    }

    private void generateEjbBnd(EjbModuleInfo ejbModuleInfo) throws DeployFileGenerateException {
        NetFile ejbBind = this.fileFactory.createNetFile(ejbModuleInfo.getEjbUri() + "\\" + "META-INF" + "\\" + "ibm-ejb-jar-bnd.xmi");
        Element root = null;
        OutputStream os = null;
        try {
            if (ejbBind.exists()) {
                if (this.isOverride) {
                    root = this.jdomFactory.element("EJBJarBinding", ejbbndNS);
                } else {
                    SAXBuilder builder = new SAXBuilder(false);
                    root = builder.build(this.fileFactory.createNetFileInputStream(ejbBind)).getRootElement();
                }
            } else {
                NetFile ejbModule = this.fileFactory.createNetFile(ejbModuleInfo.getEjbUri() + "\\" + "META-INF");
                ejbModule.mkdirs();
                root = this.jdomFactory.element("EJBJarBinding", ejbbndNS);
            }
            root.addNamespaceDeclaration(xmiNS);
            root.addNamespaceDeclaration(ejbbndNS);
            root.addNamespaceDeclaration(ejbNS);
            root.addNamespaceDeclaration(commonbndNS);
            root.addNamespaceDeclaration(commonNS);
            root.setAttribute(this.createAttribute("version", "2.0", xmiNS));
            root.setAttribute(this.createAttribute("id", "EJBJarBinding_" + ejbModuleInfo.hashCode(), xmiNS));
            Element ejbJar = null;
            if (this.isOverride) {
                root.removeChild("ejbJar");
                ejbJar = this.jdomFactory.element("ejbJar");
            } else {
                ejbJar = root.getChild("ejbJar");
                if (ejbJar == null) {
                    ejbJar = this.jdomFactory.element("ejbJar");
                } else {
                    root.removeChild("ejbJar");
                }
            }
            ejbJar.setAttribute(this.jdomFactory.attribute("href", "META-INF/ejb-jar.xml#EJBJar_" + ejbModuleInfo.hashCode()));
            root.addContent(ejbJar);
            Element ejbBindings = null;
            Element enterpriseBean = null;
            EjbInfo ejbInfo = null;
            for (int i = 0; i < ejbModuleInfo.getEjbs().length; ++i) {
                ejbInfo = ejbModuleInfo.getEjbs()[i];
                ejbBindings = null;
                String ejbBindingsPath = "/ejbbnd:EJBJarBinding/ejbBindings[@jndiName=\"" + ejbInfo.getJndiRemoteName() + "\"]";
                if (!this.isOverride) {
                    XPath xp = XPath.newInstance((String)ejbBindingsPath);
                    xp.addNamespace(ejbbndNS);
                    ejbBindings = (Element)xp.selectSingleNode((Object)root);
                    if (ejbBindings != null) {
                        root.removeContent(ejbBindings);
                    }
                }
                ejbBindings = this.jdomFactory.element("ejbBindings");
                ejbBindings.setAttribute(this.createAttribute("id", "EnterpriseBeanBinding_" + ejbInfo.hashCode(), xmiNS));
                ejbBindings.setAttribute(this.jdomFactory.attribute("jndiName", ejbInfo.getJndiRemoteName()));
                enterpriseBean = this.jdomFactory.element("enterpriseBean");
                enterpriseBean.setAttribute(this.createAttribute("type", "ejb:Session", xmiNS));
                enterpriseBean.setAttribute(this.jdomFactory.attribute("href", "META-INF/ejb-jar.xml#Session_" + ejbInfo.getEjbName().hashCode()));
                ejbBindings.addContent(enterpriseBean);
                root.addContent(ejbBindings);
            }
            os = this.fileFactory.createNetFileOutputStream(ejbBind);
            Document doc = root.getDocument();
            if (doc == null) {
                doc = this.jdomFactory.document(root);
            }
            XmlUtils.output(doc, os);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (Exception e) {}
        }
    }

    private Attribute createAttribute(String name, String value, Namespace namespace) throws JDOMException {
        return this.jdomFactory.attribute(name, value, namespace);
    }
}

