/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.eai;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.eai.ActivityCollection;
import com.kingdee.bos.metadata.eai.ActivityInfo;
import com.kingdee.bos.metadata.eai.RoutePolicyCollection;
import com.kingdee.bos.metadata.eai.RoutePolicyInfo;
import com.kingdee.bos.metadata.eai.TaskCollection;
import com.kingdee.bos.metadata.eai.TaskInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;

public class IntegrationInfo
extends AbstractMetaDataValue
implements Serializable {
    public IntegrationInfo() {
        this.put("tasks", new TaskCollection());
        this.put("routePolicies", new RoutePolicyCollection());
    }

    protected IntegrationInfo(boolean init) {
        super(init);
        this.put("tasks", new TaskCollection());
        this.put("routePolicies", new RoutePolicyCollection());
    }

    public TaskCollection getTasks() {
        return (TaskCollection)this.get("tasks");
    }

    public RoutePolicyCollection getRoutePolicies() {
        return (RoutePolicyCollection)this.get("routePolicies");
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.INTEGRATION_TYPE;
    }

    @Override
    public ValidateList validate() {
        int i;
        super.validate();
        ValidateMetaData vld = super.getValidate();
        TaskCollection tasks = this.getTasks();
        RoutePolicyCollection rps = this.getRoutePolicies();
        if (tasks != null) {
            for (i = 0; i < tasks.size(); ++i) {
                TaskInfo task = tasks.get(i);
                ActivityCollection activities = task.getActivities();
                if (activities == null) continue;
                for (int j = 0; j < activities.size(); ++j) {
                    ActivityInfo activity = activities.get(j);
                    if (activity.getRoutePolicy() == null) {
                        vld.addError("Activity " + activity.getName() + " don't define route policy.");
                        continue;
                    }
                    if (rps != null && rps.contains(activity.getRoutePolicy())) continue;
                    vld.addError("Activity " + activity.getName() + "'s route policy is wrong.");
                }
            }
        }
        if (rps != null) {
            for (i = 0; i < rps.size(); ++i) {
                RoutePolicyInfo rp = rps.get(i);
                if (rp.getSourceNode() == null) {
                    vld.addError("Don't define source application node.");
                }
                if (rp.getSourceApp() == null) {
                    vld.addError("Don't define source application.");
                }
                if (rp.getTargetNode() == null) {
                    vld.addError("Don't define target application node.");
                }
                if (rp.getTargetApp() != null) continue;
                vld.addError("Don't define target application.");
            }
        }
        return vld.getValidateList();
    }
}

