/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

class ColumnFactory {
    private static Map<String, String> map = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger(ColumnFactory.class);
    private static final String CONFIG_FILE_NAME = "BaseEntityTable.properties";
    private static Properties props;

    ColumnFactory() {
    }

    public static void init() {
        map.put("com.kingdee.eas.framework.app.BillBase", "com.kingdee.eas.framework.app.T_FW_BillBase");
        map.put("com.kingdee.eas.framework.app.BillEntryBase", "com.kingdee.eas.framework.app.T_FW_BillEntryBase");
        map.put("com.kingdee.eas.framework.app.CoreBillBase", "com.kingdee.eas.framework.app.T_FW_CoreBillBase");
        map.put("com.kingdee.eas.framework.app.CoreBillEntryBase", "com.kingdee.eas.framework.app.T_FW_CoreBillEntryBase");
        map.put("com.kingdee.eas.framework.app.DataBase", "com.kingdee.eas.framework.app.T_FW_DataBase");
        map.put("com.kingdee.eas.framework.app.HRDataBase", "com.kingdee.eas.framework.app.T_FW_HRDataBase");
        map.put("com.kingdee.eas.framework.app.HRObjectBase", "com.kingdee.eas.framework.app.T_FW_HRObjectBase");
        map.put("com.kingdee.eas.framework.app.HRTreeBase", "com.kingdee.eas.framework.app.T_FW_HRTreeBase");
        map.put("com.kingdee.eas.framework.app.ObjectBase", "com.kingdee.eas.framework.app.T_FW_ObjectBase");
        map.put("com.kingdee.eas.framework.app.TreeBase", "com.kingdee.eas.framework.app.T_FW_TreeBase");
        ColumnFactory.loadConfig();
    }

    public static void loadConfig() {
        try {
            File f = new File(System.getProperty("EAS_HOME") + "/server/properties/" + CONFIG_FILE_NAME);
            if (f.exists()) {
                props = new Properties();
                props.load(new FileInputStream(f));
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = StringUtils.cnulls((Object)entry.getKey());
                    String value = StringUtils.cnulls((Object)entry.getValue());
                    ColumnFactory.register(key, value);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static String getProperty(String propertyName) {
        if (props != null) {
            return props.getProperty(propertyName);
        }
        return null;
    }

    public static String getProperty(String propertyName, String _default) {
        String value = ColumnFactory.getProperty(propertyName);
        if (value == null || value.trim().length() < 1) {
            value = _default;
        }
        return value;
    }

    public static ColumnInfo getColumn(EntityObjectInfo bo, String colName, String propName) {
        ColumnInfo column = ColumnFactory._getColumn2(bo, colName, propName);
        if (column != null) {
            return column;
        }
        DataTableInfo table = bo.getTable();
        if (table != null) {
            return table.getColumnByNameRuntime(colName);
        }
        return null;
    }

    private static ColumnInfo _getColumn2(EntityObjectInfo bo, String colName, String propName) {
        try {
            if (map.containsKey(bo.getFullName())) {
                String tableName = map.get(bo.getFullName());
                DataTableInfo table = (DataTableInfo)MDLoader.getInstance().loadMD(new MetaDataPK2(tableName, "datb"));
                if (table != null) {
                    return table.getColumnByNameRuntime(colName);
                }
            } else {
                PropertyInfo prop = bo.getPropertyByName(propName, false);
                if (prop == null) {
                    return ColumnFactory._getColumn2(bo.getBaseEntity(), colName, propName);
                }
            }
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static void register(String enty, String tableName) {
        map.put(enty, tableName);
    }

    public static Map<String, String> getMap() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.putAll(map);
        return map2;
    }

    private static ColumnInfo _getColumn(EntityObjectInfo bo, String colName, String propName) {
        EntityObjectInfo baseEntity = bo.getBaseEntity();
        ColumnInfo column = null;
        if (baseEntity != null) {
            column = ColumnFactory._getColumn(baseEntity, colName, propName);
        }
        if (column != null) {
            return column;
        }
        PropertyCollection props = bo.getProperties();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            if (!props.get(i).getName().equalsIgnoreCase(propName) || !map.containsKey(bo.getFullName())) continue;
            String tableName = map.get(bo.getFullName());
            DataTableInfo table = (DataTableInfo)MDLoader.getInstance().loadMD(new MetaDataPK2(tableName, "datb"));
            if (table == null) {
                logger.error((Object)("Fail to find DataTableInfo.bo is " + bo.getFullName() + " and tableName is " + tableName));
                continue;
            }
            return table.getColumnByNameRuntime(colName);
        }
        return null;
    }

    static {
        ColumnFactory.init();
    }

    private static class DataBaseHandler
    extends ColumnHandler {
        private static final String DATABASE = "com.kingdee.eas.framework.app.DataBase";
        private static final MetaDataPK2 PERSON = new MetaDataPK2("com.kingdee.eas.basedata.person.app.Person", MetaDataTypeList.ENTITY.toString());
        private static final Set<String> props = new HashSet<String>(4);
        private final EntityObjectInfo bo;
        private final String colName;
        private final String propName;

        DataBaseHandler(EntityObjectInfo bo, String colName, String propName) {
            this.bo = bo;
            this.colName = colName;
            this.propName = propName;
        }

        @Override
        ColumnInfo innerGetColumn() {
            EntityObjectInfo person;
            boolean isDataBase = false;
            for (EntityObjectInfo tmp = this.bo.getBaseEntity(); tmp != null && tmp.isAbstract(); tmp = tmp.getBaseEntity()) {
                if (!DATABASE.equals(tmp.getFullName())) continue;
                isDataBase = true;
                break;
            }
            if (isDataBase && props.contains(this.propName) && (person = (EntityObjectInfo)MDLoader.getInstance().loadMD(PERSON)) != null) {
                return person.getTable().getColumnByNameRuntime(this.colName);
            }
            return null;
        }

        static {
            props.add("name");
            props.add("simpleName");
            props.add("description");
        }
    }

    private static class CommonColumnHandler
    extends ColumnHandler {
        private final EntityObjectInfo bo;
        private final String colName;

        CommonColumnHandler(EntityObjectInfo bo, String colName) {
            this.bo = bo;
            this.colName = colName;
        }

        @Override
        ColumnInfo innerGetColumn() {
            DataTableInfo table = this.bo.getTable();
            if (table != null) {
                return table.getColumnByNameRuntime(this.colName);
            }
            return null;
        }
    }

    private static abstract class ColumnHandler {
        private ColumnHandler next = null;

        private ColumnHandler() {
        }

        ColumnInfo getColumn() {
            ColumnInfo column = this.innerGetColumn();
            if (column == null && this.next != null) {
                column = this.next.innerGetColumn();
            }
            return column;
        }

        ColumnHandler setNext(ColumnHandler next) {
            this.next = next;
            return this;
        }

        abstract ColumnInfo innerGetColumn();
    }
}

