/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.webrelease.ReleaseBridgeManager;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import java.util.Map;

public class EntityObjectCtrl
extends AbstractMetaDataCtrl
implements IEntityObjectCtrl {
    public EntityObjectCtrl() {
        this.init();
    }

    public EntityObjectCtrl(Context ctx) {
        super(ctx);
        this.init();
    }

    private void init() {
        super.registerInterface(IEntityObjectCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "ownProperty"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "linkProperty"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "entityObject"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "constraint"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "numericConstraint"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "regexConstraint"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "scriptConstraint"));
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.ENTITY;
    }

    @Override
    public void addnew(IMetaDataPK pk, EntityObjectInfo info) throws BOSException {
        this.getDAO().addnew(pk, info);
    }

    @Override
    public IMetaDataPK addnew(EntityObjectInfo info) throws BOSException {
        return (IMetaDataPK)this.getDAO().addnew(info);
    }

    @Override
    public void remove(IMetaDataPK metaType) throws BOSException {
        this.getDAO().delete(metaType);
    }

    @Override
    public boolean exists(IMetaDataPK metaType) throws BOSException {
        return this.getDAO().exists(metaType);
    }

    @Override
    public EntityObjectInfo getValue(IMetaDataPK metaType) throws BOSException {
        EntityObjectInfo entity = (EntityObjectInfo)this.getDAO().getValue(metaType);
        this.fillEntityEventMethodRef(entity);
        EntityObjectCtrl.fillEntityLogicalKey(entity);
        return entity;
    }

    private void fillEntityEventMethodRef(EntityObjectInfo entity) {
        EventCollection eventCol = entity.getEvents();
        int size = eventCol.size();
        for (int i = 0; i < size; ++i) {
            EventInfo event = eventCol.get(i);
            EventMethodCollection eventMethodCol = event.getEventMethods();
            int length = eventMethodCol.size();
            for (int j = 0; j < length; ++j) {
                FacadeInfo facade;
                FacadeInfo tempFacade;
                String innerID;
                MethodInfo method;
                EventMethodInfo eventMethod = eventMethodCol.get(j);
                if (eventMethod.getFacadeRef() == null) {
                    EntityObjectInfo tempEntity;
                    method = eventMethod.getEntityMethod();
                    if (method == null) continue;
                    innerID = method.getInnerID();
                    for (tempEntity = entity; tempEntity != null && !tempEntity.getMethods().containsKey(innerID); tempEntity = (EntityObjectInfo)tempEntity.getParent()) {
                    }
                    if (tempEntity != null) {
                        MethodInfo completeMethod = (MethodInfo)tempEntity.getMethods().getObject(innerID);
                        eventMethod.setEntityMethod(completeMethod);
                        continue;
                    }
                    eventMethod.setEntityMethod(null);
                    continue;
                }
                method = eventMethod.getFacadeMethod();
                if (method == null) continue;
                innerID = method.getInnerID();
                for (tempFacade = facade = eventMethod.getFacadeRef(); tempFacade != null && !tempFacade.getMethods().containsKey(innerID); tempFacade = (FacadeInfo)tempFacade.getParent()) {
                }
                if (tempFacade != null) {
                    MethodInfo completeMethod = (MethodInfo)tempFacade.getMethods().getObject(innerID);
                    eventMethod.setFacadeMethod(completeMethod);
                    continue;
                }
                eventMethod.setFacadeMethod(null);
            }
        }
    }

    @Override
    public void update(IMetaDataPK metaType, EntityObjectInfo info) throws BOSException {
        this.getDAO().update(metaType, info);
    }

    @Override
    public EntityObjectCollection getCollection() throws BOSException {
        return (EntityObjectCollection)this.getDAO().getCollection();
    }

    @Override
    public EntityObjectCollection getCollection(String pgName) throws BOSException {
        return (EntityObjectCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
    }

    @Override
    public IMetaDataPK[] getPKList() throws BOSException {
        return (IMetaDataPK[])this.getDAO().getPKList();
    }

    @Override
    public IMetaDataPK[] getPKList(String pgName) throws BOSException {
        return (IMetaDataPK[])((IXMLDAO)this.getDAO()).getPKList(pgName);
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        super.deploy(pk, options);
        EntityObjectInfo entity = this.getValue(pk);
        if (options.getBoolean("GENENTITYIMPLEMENTCODE")) {
            entity.setExtendedProperty("genImplementCode", "true");
        }
        if (options.isDeployCode()) {
            Context ctx = this.getContext();
            ctx.put((Object)"deployOptionInfo", (Object)options);
            if (options.get("ForNewWebFramework") != null) {
                try {
                    ReleaseBridgeManager.getInstance().getReleaseBridge().appServerCodeRender(this.getContext(), entity, options);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                CodeFactory.setGenRPCCode(options.isDeployRPC());
                CodeFactory.createEntityCode(ctx, options.getDevLevel(), options.getJavaOutputDir(), entity, options.needToGenAgent(MetaDataTypeList.ENTITY, MetaDataPK.create(entity.getFullName())));
            }
        }
    }

    public static void fillEntityLogicalKey(EntityObjectInfo entity) {
        EntityObjectCtrl.verifyEntity(new HashMap(), entity);
    }

    private static void verifyEntity(Map noDup, EntityObjectInfo entity) {
        PropertyCollection props;
        if (entity == null || noDup.get(entity.getFullName()) != null) {
            return;
        }
        noDup.put(entity.getFullName(), Boolean.TRUE);
        EntityObjectInfo baseEntity = entity.getBaseEntity();
        if (baseEntity != null) {
            EntityObjectCtrl.verifyEntity(noDup, baseEntity);
            EntityObjectCtrl.processEntity(baseEntity);
        }
        if ((props = entity.getProperties()) != null) {
            PropertyInfo prop = null;
            LinkPropertyInfo linkProp = null;
            for (int i = 0; i < props.size(); ++i) {
                prop = props.get(i);
                if (!(prop instanceof LinkPropertyInfo) || (linkProp = (LinkPropertyInfo)prop).getRelationship() == null) continue;
                EntityObjectCtrl.verifyEntity(noDup, linkProp.getRelationship().getSupplierObject());
                EntityObjectCtrl.processEntity(linkProp.getRelationship().getSupplierObject());
            }
        }
    }

    private static void processEntity(EntityObjectInfo entity) {
        if (entity == null) {
            return;
        }
        LogicalKeyInfo lgkInfo = entity.getLogicalKey();
        if (lgkInfo == null) {
            return;
        }
        if (lgkInfo.getKeyPropertys().size() != 1) {
            return;
        }
        PropertyInfo prop = lgkInfo.getKeyPropertys().get(0);
        if (prop.get("_state_") != null) {
            String name = prop.getName();
            PropertyInfo tmp = null;
            PropertyInfo rightProp = null;
            PropertyCollection props = entity.getInheritedProperties();
            for (int i = 0; i < props.size(); ++i) {
                prop = props.get(i);
                if (prop.getName().equalsIgnoreCase(name) && prop.get("_state_") != null) {
                    tmp = prop;
                    continue;
                }
                if (!prop.getName().equalsIgnoreCase(name) || prop.get("_state_") != null) continue;
                rightProp = prop;
            }
            if (rightProp == null) {
                return;
            }
            lgkInfo.getKeyPropertys().clear();
            lgkInfo.getKeyPropertys().add(rightProp);
            props.remove(tmp);
        }
    }
}

