/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.xml.impl.AccessQueue;
import com.kingdee.bos.metadata.MDMonitor;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.ColumnFactory;
import com.kingdee.bos.metadata.entity.CommonEntityManager;
import com.kingdee.bos.metadata.entity.DAOFunction;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EntityObjectInfo
extends BusinessObjectInfo
implements Serializable {
    private static final String DYNAMIC_METADATA = "com.kingdee.bos.config.app.DynamicMetadata";
    private static final InnerCacheFactory innerCacheFactory = new InnerCacheFactory(3500);
    private transient Boolean isAbstract = null;
    private transient DataTableInfo table = null;
    private transient Boolean isGenerateCode = null;
    private transient String businessImplName = null;
    private transient String businessControllerName = null;
    private final transient InnerCacheReference ref;
    private static final String MutiLANGUAGE_FLAG = "_L";
    private static final EntityObjectInfo NULL = new EntityObjectInfo();
    public static final String IS_GENERATE_CODE = "isGenerateCode";
    public static final String TEMPLATE_ENTITY_PK = "template_entity_pk";
    private static final List<String> baseEnties = new ArrayList<String>(8);

    protected EntityObjectInfo(boolean init) {
        super(init);
        this.ref = new InnerCacheReference(this, 2);
    }

    public EntityObjectInfo() {
        this.put("events", new EventCollection());
        this.put("properties", new PropertyCollection());
        this.put("extendStereoTypes", new EntityObjectCollection());
        this.ref = new InnerCacheReference(this, 2);
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("isAbstract".equals(key) || "stereoType".equals(key)) {
            this.isAbstract = null;
            return;
        }
        if ("table".equals(key)) {
            this.table = null;
            return;
        }
        if ("businessImplName".equals(key)) {
            this.businessImplName = null;
            return;
        }
        if ("businessControllerName".equals(key)) {
            this.businessControllerName = null;
            return;
        }
    }

    public EventCollection getEvents() {
        return (EventCollection)this.get("events");
    }

    public String getObjectValueClass() {
        String baseName = this.getBusinessImplName();
        if (StringUtils.isEmpty((String)baseName)) {
            return "";
        }
        if (!this.isStereoType()) {
            return baseName + "Info";
        }
        int index = baseName.lastIndexOf(46);
        if (index != -1) {
            return baseName.substring(0, index + 1) + "I" + baseName.substring(index + 1) + "Info";
        }
        return "I" + baseName + "Info";
    }

    private InnerCache getCache() {
        return this.ref.get(ConfigMDUtil.getAIS());
    }

    public String getObjectValueClassRuntime() {
        InnerCache cache = this.getCache();
        if (cache.objectValueClass == null) {
            cache.objectValueClass = this.getObjectValueClass();
        }
        return cache.objectValueClass;
    }

    public Class<IObjectValue> getObjectValueClazzRuntime() throws ClassNotFoundException {
        InnerCache cache = this.getCache();
        if (cache.objectValueClazz == null) {
            String className = this.getObjectValueClassRuntime();
            cache.objectValueClazz = Class.forName(className);
        }
        return cache.objectValueClazz;
    }

    public String getObjectCollectionClass() {
        String impl = this.getBusinessImplName();
        if (StringUtils.isEmpty((String)impl)) {
            return "";
        }
        return impl + "Collection";
    }

    public String getObjectCollectionClassRuntime() {
        InnerCache cache = this.getCache();
        if (cache.objectCollectionClass == null) {
            cache.objectCollectionClass = this.getObjectCollectionClass();
        }
        return cache.objectCollectionClass;
    }

    public Class<IObjectCollection> getObjectCollectionClazzRuntime() throws ClassNotFoundException {
        InnerCache cache = this.getCache();
        if (cache.objectCollectionClazz == null) {
            String className = this.getObjectCollectionClassRuntime();
            cache.objectCollectionClazz = Class.forName(className);
        }
        return cache.objectCollectionClazz;
    }

    public String getObjectCollectionAgentClass() {
        return this.getObjectCollectionClass() + "Agent";
    }

    public DataTableInfo getTable() {
        if (this.table == null) {
            if (DYNAMIC_METADATA.equals(this.getFullName())) {
                try {
                    this.table = MetaDataLoaderFactory.getMetaDataLoader(null).getDataTable(MetaDataPK.create("com.kingdee.bos.config.app.T_CON_DynamicMetadata"));
                    return this.table;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.table = (DataTableInfo)this.get("table");
        }
        return this.table;
    }

    public void setTable(DataTableInfo table) {
        this.put("table", table);
    }

    public EntityObjectInfo getBaseEntity() {
        return (EntityObjectInfo)this.get("baseEntity");
    }

    public void setBaseEntity(EntityObjectInfo baseEntity) {
        this.put("baseEntity", baseEntity);
    }

    public boolean isAbstract() {
        if (this.isAbstract == null) {
            this.isAbstract = this.isStereoType() ? Boolean.TRUE : Boolean.valueOf(this.getBoolean("isAbstract"));
        }
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.setBoolean("isAbstract", isAbstract);
    }

    @Override
    public void setStereoType(boolean stereoType) {
        super.setStereoType(stereoType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyCollection getLogicalKeyPropertiesRuntime() {
        InnerCache cache = this.getCache();
        if (cache.logicalKeyProps != null) {
            return cache.logicalKeyProps;
        }
        InnerCache innerCache = cache;
        synchronized (innerCache) {
            if (cache.logicalKeyProps == null) {
                LogicalKeyInfo logicKey = this.getLogicalKey();
                if (logicKey == null) {
                    throw new RuntimeException("Can't find logic key, check whether entity exist and config logic key. entity:" + this.getFullName());
                }
                cache.logicalKeyProps = logicKey.getKeyPropertys();
            }
        }
        return cache.logicalKeyProps;
    }

    public boolean isNeedHistory() {
        String flag = this.getExtendedProperty(HistoryConstant.enableHistoryFlag);
        if (StringUtils.isEmpty((String)flag)) {
            return false;
        }
        return "true".equalsIgnoreCase(flag.trim());
    }

    public String getHisEntity() {
        String historyEntity = this.getExtendedProperty(HistoryConstant.hisEntity);
        if (StringUtils.isEmpty((String)historyEntity)) {
            return "";
        }
        return historyEntity;
    }

    public PropertyInfo getBusinessHistoryColumn() {
        String businessHistoryProperty = this.getExtendedProperty(HistoryConstant.businessHistoryProperty);
        if (StringUtils.isEmpty((String)businessHistoryProperty)) {
            return null;
        }
        return this.getPropertyByName(businessHistoryProperty);
    }

    public LogicalKeyInfo getLogicalKey() {
        return (LogicalKeyInfo)this.get("logicalKey");
    }

    public void setLogicalKey(LogicalKeyInfo logicalKey) {
        this.put("logicalKey", logicalKey);
    }

    public PropertyCollection getInheritedDuplicatedProperties() {
        try {
            this.validateCircle();
            return this.innerGetInheritedDuplicatedProperties();
        }
        catch (BOSException e) {
            PropertyCollection pc = new PropertyCollection();
            pc.addObjectCollection(this.getProperties());
            this.addST2Properties(pc);
            return pc;
        }
    }

    public PropertyCollection innerGetInheritedDuplicatedProperties() {
        if (this.getBaseEntity() == null) {
            PropertyCollection pc = new PropertyCollection();
            pc.addObjectCollection(this.getProperties());
            this.addST2Properties(pc);
            return pc;
        }
        EntityObjectInfo baseEntity = this.getBaseEntity();
        PropertyCollection baseProperty = baseEntity.innerGetInheritedDuplicatedProperties();
        PropertyCollection selfProperty = this.getProperties();
        if (selfProperty == null) {
            return baseProperty;
        }
        PropertyCollection propColl = new PropertyCollection();
        int size = baseProperty.size();
        for (int i = 0; i < size; ++i) {
            propColl.add(baseProperty.get(i));
        }
        size = selfProperty.size();
        for (int j = 0; j < size; ++j) {
            propColl.add(selfProperty.get(j));
        }
        this.addST2Properties(propColl);
        return propColl;
    }

    public PropertyCollection getInheritedProperties() {
        try {
            this.validateCircle();
        }
        catch (BOSException bose) {
            return this.getProperties();
        }
        return this.innerGetInheritedProperties();
    }

    private PropertyCollection innerGetInheritedProperties() {
        PropertyCollection propColl = new PropertyCollection();
        EntityObjectInfo baseEntity = this.getBaseEntity();
        if (baseEntity == null) {
            propColl.addObjectCollection(this.getProperties());
            this.addST2Properties(propColl);
            return propColl;
        }
        PropertyCollection baseProperty = baseEntity.innerGetInheritedProperties();
        PropertyCollection selfProperty = this.getProperties();
        if (selfProperty == null) {
            return baseProperty;
        }
        int size = baseProperty.size();
        for (int i = 0; i < size; ++i) {
            propColl.add(baseProperty.get(i));
        }
        size = selfProperty.size();
        for (int j = 0; j < size; ++j) {
            propColl.add(selfProperty.get(j));
        }
        this.addST2Properties(propColl);
        propColl.trimToSize();
        return propColl;
    }

    public PropertyCollection getInheritedNoDuplicatedProperties() {
        try {
            this.validateCircle();
        }
        catch (BOSException bose) {
            return this.getProperties();
        }
        return this.innerGetInheritedNoDuplicatedProperties2();
    }

    private PropertyCollection innerGetInheritedNoDuplicatedProperties2() {
        int i;
        PropertyCollection propColl = new PropertyCollection();
        EntityObjectInfo baseEntity = this.getBaseEntity();
        if (baseEntity == null) {
            propColl.addObjectCollection(this.getProperties());
            this.addST2Properties(propColl);
            return propColl;
        }
        PropertyCollection baseProperties = baseEntity.innerGetInheritedNoDuplicatedProperties2();
        PropertyCollection selfProperties = this.getProperties();
        if (selfProperties == null) {
            return baseProperties;
        }
        PropertyInfo prop = null;
        int size = selfProperties.size();
        for (i = 0; i < size; ++i) {
            prop = selfProperties.get(i);
            if (this.containtsProperty(propColl, prop)) continue;
            propColl.add(prop);
        }
        this.addST2Properties(propColl);
        size = baseProperties.size();
        for (i = 0; i < size; ++i) {
            prop = baseProperties.get(i);
            if (this.containtsProperty(propColl, prop)) continue;
            propColl.add(prop);
        }
        propColl.trimToSize();
        return propColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyCollection getInheritedPropertiesRuntime() {
        InnerCache cache = this.getCache();
        if (cache.inheritedDuplicatedProperties != null) {
            return cache.inheritedDuplicatedProperties;
        }
        InnerCache innerCache = cache;
        synchronized (innerCache) {
            if (cache.inheritedDuplicatedProperties == null) {
                cache.inheritedDuplicatedProperties = this.getInheritedProperties();
            }
            return cache.inheritedDuplicatedProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyCollection getInheritedNoDuplicatedPropertiesRuntime() {
        InnerCache cache = this.getCache();
        if (cache.inheritedNoDuplicatedProperties != null) {
            return cache.inheritedNoDuplicatedProperties;
        }
        InnerCache innerCache = cache;
        synchronized (innerCache) {
            if (cache.inheritedNoDuplicatedProperties == null) {
                cache.inheritedNoDuplicatedProperties = this.getInheritedNoDuplicatedProperties();
            }
            return cache.inheritedNoDuplicatedProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyCollection getPropertiesRuntime() {
        InnerCache cache = this.getCache();
        if (cache.selfAndAbstractParentproperties != null) {
            return cache.selfAndAbstractParentproperties;
        }
        InnerCache innerCache = cache;
        synchronized (innerCache) {
            if (cache.selfAndAbstractParentproperties == null) {
                cache.selfAndAbstractParentproperties = this.getEntityProperties();
            }
            return cache.selfAndAbstractParentproperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyInfo getPropertyByNameRuntime(String propName) {
        PropertyInfo prop;
        InnerCache cache = this.getCache();
        if (cache.namePropMap != null && (prop = (PropertyInfo)cache.namePropMap.get(propName)) != null) {
            return prop.cvalue();
        }
        prop = PropertyInfo.cnulls(this.getPropertyByName(propName, true, true));
        InnerCache innerCache = cache;
        synchronized (innerCache) {
            if (cache.namePropMap == null) {
                cache.namePropMap = new HashMap();
            }
            cache.namePropMap.put(propName, prop);
        }
        return prop.cvalue();
    }

    public PropertyCollection getOwnerAndExtendedProperties() {
        PropertyCollection props = new PropertyCollection();
        props.addObjectCollection(this.getProperties());
        this.addST2Properties(props);
        return props;
    }

    public PropertyCollection getEntityProperties() {
        try {
            this.validateCircle();
        }
        catch (BOSException bose) {
            return this.getProperties();
        }
        return this.innerGetEntityProperties();
    }

    private PropertyCollection innerGetEntityProperties() {
        PropertyCollection propColl = new PropertyCollection();
        EntityObjectInfo baseEntity = this.getBaseEntity();
        if (baseEntity == null || !baseEntity.isAbstract()) {
            propColl.addObjectCollection(this.getProperties());
            this.addST2Properties(propColl);
            return propColl;
        }
        PropertyCollection baseProperty = baseEntity.innerGetEntityProperties();
        PropertyCollection selfProperty = this.getProperties();
        if (selfProperty == null) {
            return baseProperty;
        }
        propColl.addObjectCollection(baseProperty);
        propColl.addObjectCollection(selfProperty);
        this.addST2Properties(propColl);
        propColl.trimToSize();
        return propColl;
    }

    public PropertyCollection getDuplicatedEntityProperties() {
        try {
            this.validateCircle();
            return this.innerGetDuplicatedEntityProperties();
        }
        catch (BOSException e) {
            PropertyCollection pc = new PropertyCollection();
            pc.addObjectCollection(this.getProperties());
            this.addST2Properties(pc);
            return pc;
        }
    }

    public PropertyCollection innerGetDuplicatedEntityProperties() {
        EntityObjectInfo baseEntity = this.getBaseEntity();
        if (baseEntity == null || !baseEntity.isAbstract()) {
            PropertyCollection pc = new PropertyCollection();
            pc.addObjectCollection(this.getProperties());
            this.addST2Properties(pc);
            return pc;
        }
        PropertyCollection baseProperty = baseEntity.innerGetDuplicatedEntityProperties();
        PropertyCollection selfProperty = this.getProperties();
        PropertyCollection propColl = new PropertyCollection();
        if (selfProperty == null) {
            return baseProperty;
        }
        int size = baseProperty.size();
        for (int i = 0; i < size; ++i) {
            propColl.add(baseProperty.get(i));
        }
        size = selfProperty.size();
        for (int j = 0; j < size; ++j) {
            propColl.add(selfProperty.get(j));
        }
        this.addST2Properties(propColl);
        return propColl;
    }

    public PropertyCollection getInheritedPropertyFromSelf() {
        try {
            this.validateCircle();
        }
        catch (Exception e) {
            return this.getProperties();
        }
        PropertyCollection props = new PropertyCollection();
        for (EntityObjectInfo baseEntity = this; baseEntity != null; baseEntity = baseEntity.getBaseEntity()) {
            props.addObjectCollection(baseEntity.getProperties());
            baseEntity.addST2Properties(props);
        }
        return props;
    }

    private boolean containtsProperty(PropertyCollection c, PropertyInfo p) {
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            if (!c.get(i).equals(p)) continue;
            return true;
        }
        return false;
    }

    public PropertyCollection getProperties() {
        return (PropertyCollection)this.get("properties");
    }

    public EntityViewInfo getDefaultView() {
        return (EntityViewInfo)this.get("defaultView");
    }

    public void setDefaultView(EntityViewInfo defaultView) {
        this.put("defaultView", defaultView);
    }

    public void initDefaultEntity() {
        OwnPropertyInfo prop = new OwnPropertyInfo();
        prop.setName("id");
        prop.setDataType(DataType.BOSUUID);
        this.getProperties().add(prop);
        LogicalKeyInfo key = new LogicalKeyInfo();
        key.setName("id");
        key.setKeyClass(IObjectPK.class.getName());
        key.getKeyPropertys().add(prop);
        this.setLogicalKey(key);
    }

    @Override
    public boolean isSystemMethod(MethodInfo method) {
        return DAOFunction.isDAOFunction(this, method);
    }

    public EntityObjectInfo getRootEntity() {
        if (this.getBaseEntity() == null) {
            return null;
        }
        EntityObjectInfo entity = this;
        while (entity.getBaseEntity() != null) {
            entity = entity.getBaseEntity();
        }
        return entity;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.ENTITY;
    }

    public PropertyInfo getPropertyByName(String name) {
        return this.getPropertyByName(name, true);
    }

    public PropertyInfo getPropertyByName(String name, boolean includeParent) {
        return this.getPropertyByName(name, includeParent, false);
    }

    private PropertyInfo getPropertyByName(String name, boolean includeParent, boolean isRuntime) {
        PropertyCollection props = isRuntime ? (includeParent ? this.getInheritedPropertiesRuntime() : this.getPropertiesRuntime()) : (includeParent ? this.getInheritedProperties() : this.getProperties());
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            if (!props.get(i).getName().equalsIgnoreCase(name)) continue;
            return props.get(i);
        }
        return null;
    }

    public MethodInfo getMethodByName(String name) {
        MethodCollection methods = this.getMethods();
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            if (!methods.get(i).getName().equalsIgnoreCase(name)) continue;
            return methods.get(i);
        }
        return null;
    }

    public OwnPropertyInfo getSequenceProperty() {
        InnerCache cache = this.getCache();
        if (cache.hasSetSequence) {
            return cache.sequenceProperty;
        }
        OwnPropertyInfo seqProp = null;
        PropertyCollection props = this.getInheritedPropertiesRuntime();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof OwnPropertyInfo) || !"{SEQUENCE}".equals(((OwnPropertyInfo)prop).getFormula())) continue;
            seqProp = (OwnPropertyInfo)prop;
            break;
        }
        cache.sequenceProperty = seqProp;
        cache.hasSetSequence = true;
        return seqProp;
    }

    private void validateCircle() throws BOSException {
        if (DYNAMIC_METADATA.equals(this.getFullName())) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getFullName());
        for (EntityObjectInfo temp = this.getBaseEntity(); temp != null; temp = temp.getBaseEntity()) {
            if (!set.contains(temp.getFullName())) continue;
            throw new InvalidMetaDataException("The inherited tree is a circle![" + temp.getFullName() + "," + this.getFullName() + "]");
        }
    }

    @Override
    public ValidateList validate() {
        super.validate();
        ValidateMetaData vld = this.getValidate();
        if (!this.isAbstract() && !this.isStereoType()) {
            if (this.getTable() == null) {
                vld.addError("Missing table definition.");
                return vld.getValidateList();
            }
            if (this.getLogicalKey() == null) {
                vld.addError("Missing LogicKey definition.");
                return vld.getValidateList();
            }
            vld.addValidateList(this.getLogicalKey().validate());
        } else if (this.getTable() != null) {
            vld.addError("AbstractInherited Entity can't define table.");
            return vld.getValidateList();
        }
        HashSet<String> set = new HashSet<String>();
        PropertyCollection properties = this.getProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo prop = properties.get(i);
            if (set.contains(prop.getName())) {
                vld.addError("Duplicated Property: " + prop.getName());
            } else {
                set.add(prop.getName());
            }
            this.validateProperty(vld, prop);
        }
        if (this.getLogicalKey() != null) {
            PropertyCollection pcol = this.getLogicalKey().getKeyPropertys();
            for (int i = 0; i < pcol.size(); ++i) {
                set.remove(pcol.get(i).getName());
            }
        }
        this.validateInherite(vld, set);
        this.validFieldMapping(vld);
        this.validEnumExist(vld);
        return vld.getValidateList();
    }

    private void validEnumExist(ValidateMetaData vld) {
        PropertyCollection propCollection = this.getInheritedNoDuplicatedProperties();
        for (int i = propCollection.size() - 1; i >= 0; --i) {
            PropertyInfo prop = propCollection.get(i);
            if (!(prop instanceof OwnPropertyInfo) || !((OwnPropertyInfo)prop).getDataType().equals(DataType.ENUM)) continue;
            try {
                IBizEnumCtrl ctrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.BIZENUM);
                String mdr = ((OwnPropertyInfo)prop).getMetaDataRef();
                if (mdr == null) {
                    vld.addError(prop.getName() + " property's reference enumeration can't be null !");
                    continue;
                }
                BizEnumInfo bizenum = ctrl.getValue(MetaDataPK.create(mdr));
                if (bizenum != null) continue;
                vld.addError("Enum type '" + ((OwnPropertyInfo)prop).getMetaDataRef() + "' not found");
                continue;
            }
            catch (DataAccessException dataAccessE) {
                vld.addError("Enum type '" + ((OwnPropertyInfo)prop).getMetaDataRef() + "' not found");
                continue;
            }
            catch (Exception e) {
                vld.addError(" e = " + e.toString());
            }
        }
    }

    private void validFieldMapping(ValidateMetaData vld) {
        if (this.isAbstract()) {
            return;
        }
        PropertyInfo prop = null;
        PropertyCollection propCollection = this.getBaseEntity() != null && !this.getBaseEntity().isAbstract() ? this.getEntityProperties() : this.getInheritedNoDuplicatedProperties();
        DataTableInfo table = this.getTable();
        for (int i = propCollection.size() - 1; i >= 0; --i) {
            prop = propCollection.get(i);
            if (prop.getMappingField() == null) {
                vld.addWarning("property '" + prop.getName() + "' not define mapping field , sure? ");
                break;
            }
            if (table.getColumnByName(prop.getMappingField().getName()) != null) continue;
            vld.addWarning("property '" + prop.getName() + "' missed at table , sure?" + table.getName());
        }
    }

    private void validateProperty(ValidateMetaData vld, PropertyInfo prop) {
        vld.validateJavaIdentifier("Property: ", prop.getName());
        vld.addValidateList(prop.validate());
        if (!this.isAbstract() && prop instanceof OwnPropertyInfo) {
            String errMsg = "Property '" + prop.getName() + "': invalid mapping field.";
            if (prop.getMappingField() == null && prop.getExtendedField() == null) {
                return;
            }
            if (prop.getMappingField() != null && prop.getExtendedField() != null) {
                vld.addError(errMsg);
            }
            if (this.getTable() != null) {
                if (prop.getMappingField() != null && !this.getTable().existsColumn(prop.getMappingField())) {
                    vld.addError(errMsg);
                }
                if (prop.getExtendedField() != null) {
                    ExtendedTableInfo extTable = prop.getExtendedField().getExtendedTable();
                    ColumnInfo extColumn = prop.getExtendedField().getExtendedColumn();
                    if (extTable == null || extColumn == null) {
                        vld.addError(errMsg);
                    } else {
                        if (!this.getTable().existsExtendedTable(extTable)) {
                            vld.addError(errMsg);
                        }
                        if (!extTable.existsColumn(extColumn)) {
                            vld.addError(errMsg);
                        }
                    }
                }
            }
        }
        if (prop instanceof OwnPropertyInfo) {
            ColumnInfo column = null;
            if (this.getTable() != null) {
                if (prop.getMappingField() != null) {
                    column = prop.getMappingField();
                } else if (prop.getExtendedField() != null) {
                    column = prop.getExtendedField().getExtendedColumn();
                }
            }
            if (column != null && ((OwnPropertyInfo)prop).isMultilingual() != column.isMultilingual()) {
                vld.addError("OwnProperty '" + prop.getName() + "': Invalid 'isMultilingual'.");
            }
        } else if (prop instanceof LinkPropertyInfo) {
            RelationshipInfo rel = ((LinkPropertyInfo)prop).getRelationship();
            if (rel == null) {
                vld.addError("LinkProperty '" + prop.getName() + "': missing relationship.");
            } else {
                String clientName = null;
                String supplierName = null;
                if (rel.getClientObject() != null) {
                    clientName = rel.getClientObject().getFullName();
                }
                if (rel.getSupplierObject() != null) {
                    supplierName = rel.getSupplierObject().getFullName();
                }
                if (!this.getFullName().equals(clientName) && !this.getFullName().equals(supplierName)) {
                    vld.addError("LinkProperty '" + prop.getName() + "': invalid relationship.");
                }
            }
        } else assert (false);
    }

    private void validateInherite(ValidateMetaData vld, Set<String> set) {
        if (this.getBaseEntity() != null) {
            try {
                this.validateCircle();
                boolean isAbstract = this.isAbstract();
                LogicalKeyInfo logicalKey = null;
                for (EntityObjectInfo temp = this.getBaseEntity(); temp != null; temp = temp.getBaseEntity()) {
                    if (StringUtils.isEmpty((String)temp.getBusinessImplName())) {
                        vld.addError(temp.getFullName() + "'s BusinessImpl class name is empty.");
                    }
                    if (StringUtils.isEmpty((String)temp.getBusinessControllerName())) {
                        vld.addError(temp.getFullName() + "'s BusinessController class name is empty.");
                    }
                    for (int i = 0; i < temp.getProperties().size(); ++i) {
                        PropertyInfo prop = temp.getProperties().get(i);
                        if (set.contains(prop.getName())) {
                            vld.addError("Duplicated Property in inherited entity: " + prop.getName());
                            continue;
                        }
                        set.add(prop.getName());
                    }
                    if (temp.getLogicalKey() != null) {
                        PropertyCollection pcol = temp.getLogicalKey().getKeyPropertys();
                        for (int i = 0; i < pcol.size(); ++i) {
                            set.remove(pcol.get(i).getName());
                        }
                    }
                    if (isAbstract && !temp.isAbstract()) {
                        vld.addError(temp.getFullName() + " should be set to be 'isAbstract'");
                    }
                    if (isAbstract = temp.isAbstract()) continue;
                    if (logicalKey == null && (logicalKey = this.getLogicalKey()) != null && !logicalKey.supportsInherit()) {
                        vld.addError("LogicalKey cannot supports Inherit.");
                    }
                    if ((logicalKey = temp.getLogicalKey()) == null || logicalKey.supportsInherit()) continue;
                    vld.addError("LogicalKey cannot supports Inherit.");
                }
            }
            catch (BOSException bose) {
                vld.addError(bose.getMessage());
            }
        }
    }

    public static Hashtable<LinkPropertyInfo, EntityObjectInfo> getChildEntities(EntityObjectInfo node) {
        Hashtable<LinkPropertyInfo, EntityObjectInfo> table = new Hashtable<LinkPropertyInfo, EntityObjectInfo>();
        PropertyCollection props = node.getInheritedNoDuplicatedProperties();
        for (int i = 0; i < props.size(); ++i) {
            LinkPropertyInfo prop;
            if (!(props.get(i) instanceof LinkPropertyInfo) || !EntityObjectInfo.isAvalidateLinkProperty(prop = (LinkPropertyInfo)props.get(i), node)) continue;
            if (prop.getRelationship().isMultiRelation()) {
                if (prop.getRelationship().getClientObject().equals(node)) {
                    table.put(prop, prop.getRelationship().getSupplierObject());
                    continue;
                }
                table.put(prop, prop.getRelationship().getClientObject());
                continue;
            }
            table.put(prop, prop.getRelationship().getChildObject(node));
        }
        return table;
    }

    private static boolean isAvalidateLinkProperty(LinkPropertyInfo prop, EntityObjectInfo node) {
        RelationshipInfo relation = prop.getRelationship();
        EntityObjectInfo entity = relation.getSupplierObject();
        if (entity != null && node.isSubFrom(entity)) {
            return true;
        }
        entity = relation.getClientObject();
        return entity != null && node.isSubFrom(entity);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof EntityObjectInfo)) {
            return false;
        }
        String fullName = this.getFullName();
        if (StringUtils.isEmpty((String)fullName)) {
            return false;
        }
        return fullName.equals(((EntityObjectInfo)that).getFullName());
    }

    public String getFieldNameByRelationship(RelationshipInfo relation) {
        String relName = relation.getFullName();
        String fieldName = null;
        InnerCache cache = this.getCache();
        if (cache.relationshipFields != null && (fieldName = (String)cache.relationshipFields.get(relName)) != null) {
            return fieldName;
        }
        fieldName = this.innerGetFieldNameByRelationship(relation);
        if (cache.relationshipFields == null) {
            cache.relationshipFields = new HashMap(4);
        }
        cache.relationshipFields.put(relName, fieldName);
        return fieldName;
    }

    public String innerGetFieldNameByRelationship(RelationshipInfo relation) {
        assert (relation != null);
        PropertyCollection props = this.getPropertiesRuntime();
        int m = props.size();
        for (int n = 0; n < m; ++n) {
            PropertyInfo prop = props.get(n);
            if (!(prop instanceof LinkPropertyInfo) || !relation.equals(((LinkPropertyInfo)prop).getRelationship())) continue;
            return prop.getName();
        }
        return null;
    }

    public boolean isLogicalKey(PropertyInfo fld) throws InvalidDAOMetaDataException {
        return this.getLogicalKeyPropertiesRuntime().contains(fld);
    }

    public boolean isSelfField(String fieldName) {
        Boolean retVal;
        InnerCache cache = this.getCache();
        if (cache.selfFieldTags != null && (retVal = (Boolean)cache.selfFieldTags.get(fieldName)) != null) {
            return retVal;
        }
        retVal = this.innerIsSelfField(fieldName);
        if (cache.selfFieldTags == null) {
            cache.selfFieldTags = new HashMap();
        }
        cache.selfFieldTags.put(fieldName, retVal);
        return retVal;
    }

    private boolean innerIsSelfField(String fieldName) {
        PropertyCollection properties = this.getPropertiesRuntime();
        int propSize = properties.size();
        for (int i = 0; i < propSize; ++i) {
            PropertyInfo prop = properties.get(i);
            if (prop.getMappingField() == null || !prop.getMappingField().getName().equalsIgnoreCase(fieldName) && (!prop.getMappingField().isMultilingual() || !fieldName.startsWith(prop.getMappingField().getName() + "_"))) continue;
            return true;
        }
        return false;
    }

    public PropertyInfo getFieldByFullName(String fullName) throws InvalidDAOMetaDataException {
        PropertyInfo retVal;
        InnerCache cache = this.getCache();
        if (cache.fullNameProps != null && (retVal = (PropertyInfo)cache.fullNameProps.get(fullName)) != null) {
            return retVal.cvalue();
        }
        retVal = PropertyInfo.cnulls(this.innerGetFieldByFullName(fullName));
        if (cache.fullNameProps == null) {
            cache.fullNameProps = new ConcurrentHashMap();
        }
        cache.fullNameProps.put(fullName, retVal);
        return retVal.cvalue();
    }

    private PropertyInfo innerGetFieldByFullName(String fullName) throws InvalidDAOMetaDataException {
        EntityObjectInfo ibo = this;
        String[] fieldNames = StringUtils.split((String)fullName, (String)".");
        int nameLength = fieldNames.length;
        for (int i = 0; i < nameLength - 1; ++i) {
            String fieldName = fieldNames[i];
            PropertyInfo fld = ibo.getPropertyByNameRuntime(fieldName);
            if (!(fld instanceof LinkPropertyInfo)) {
                if (fld != null) {
                    throw new InvalidDAOMetaDataException(fieldName + " is not a link property,  fullname: " + fullName + ",  bo :" + ibo.getFullName());
                }
                throw new InvalidDAOMetaDataException("can't find column: " + fieldName + " fullname: " + fullName + ",  bo :" + ibo.getFullName());
            }
            ibo = ((LinkPropertyInfo)fld).getRelationship().getChildObject(ibo);
        }
        String fldName = fieldNames[fieldNames.length - 1];
        PropertyInfo prop = ibo.getPropertyByNameRuntime(fldName);
        if (prop == null) {
            throw new InvalidDAOMetaDataException("cannot find property: " + fullName + ",  bo:" + ibo.getFullName());
        }
        if (prop.getMappingField() == null) {
            throw new InvalidDAOMetaDataException("cannot find column, maybe you forget define the mapping field '" + prop.getName() + "'" + ",  bo:" + ibo.getFullName());
        }
        EntityObjectInfo.innerGetMappingFieldOfProperty(ibo, prop);
        return prop;
    }

    public ColumnInfo getMappingFieldOfProperty(PropertyInfo prop) {
        return EntityObjectInfo.innerGetMappingFieldOfProperty(this, prop);
    }

    private static ColumnInfo innerGetMappingFieldOfProperty(EntityObjectInfo bo, PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        ColumnInfo col = prop.getMappingField();
        if (col == null) {
            return null;
        }
        String colName = col.getName();
        if (col.containsKey("_state_") && (col = ColumnFactory.getColumn(bo, colName, prop.getName())) != null) {
            prop.setMappingField(col);
        }
        for (EntityObjectInfo boTemp = bo.getBaseEntity(); col == null && boTemp != null && !boTemp.isAbstract(); boTemp = boTemp.getBaseEntity()) {
            col = boTemp.getTable().getColumnByNameRuntime(colName);
        }
        if (col == null) {
            throw new IllegalStateException("can't find column in table. bo:" + bo.getFullName() + ", prop:" + prop.getName());
        }
        return col;
    }

    public PropertyInfo getInheritedPropertyByColName(String colName) {
        return this.getInheritedPropertyByColName(colName, null);
    }

    public PropertyInfo getInheritedPropertyByColName(String colName, String langFlag) {
        PropertyInfo retVal;
        String name = colName + langFlag;
        InnerCache cache = this.getCache();
        if (cache.colNameProps != null && (retVal = (PropertyInfo)cache.colNameProps.get(name)) != null) {
            return retVal.cvalue();
        }
        retVal = langFlag == null ? this.innerGetInheritedPropertyByColName(colName) : this.innerGetInheritedPropertyByColName(colName, langFlag);
        retVal = PropertyInfo.cnulls(retVal);
        if (cache.colNameProps == null) {
            cache.colNameProps = new HashMap();
        }
        cache.colNameProps.put(name, retVal);
        return retVal.cvalue();
    }

    public PropertyInfo innerGetInheritedPropertyByColName(String colName, String langFlag) {
        if (colName == null) {
            return null;
        }
        PropertyInfo linkFld = null;
        PropertyCollection props = this.getInheritedPropertiesRuntime();
        int propSize = props.size();
        for (int i = 0; i < propSize; ++i) {
            PropertyInfo fld = props.get(i);
            ColumnInfo mappingField = fld.getMappingField();
            if (mappingField == null || !mappingField.getName().equalsIgnoreCase(colName) && (!mappingField.isMultilingual() || !(mappingField.getName() + langFlag).equalsIgnoreCase(colName))) continue;
            if (fld instanceof OwnPropertyInfo) {
                return fld;
            }
            linkFld = fld;
        }
        return linkFld;
    }

    private PropertyInfo innerGetInheritedPropertyByColName(String colName) {
        if (colName == null) {
            return null;
        }
        PropertyInfo linkFld = null;
        PropertyCollection props = this.getInheritedPropertiesRuntime();
        int propSize = props.size();
        for (int i = 0; i < propSize; ++i) {
            PropertyInfo fld = props.get(i);
            if (fld.getMappingField() == null || !fld.getMappingField().getName().equalsIgnoreCase(colName) && (!fld.getMappingField().isMultilingual() || !colName.startsWith(fld.getMappingField().getName() + "_"))) continue;
            if (fld instanceof OwnPropertyInfo) {
                return fld;
            }
            linkFld = fld;
        }
        return linkFld;
    }

    private PropertyInfo innerGetEntitySelfPropByPropName(String propName) {
        PropertyCollection props = this.getPropertiesRuntime();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            if (!props.get(i).getName().equalsIgnoreCase(propName)) continue;
            return props.get(i);
        }
        return null;
    }

    private EntityObjectInfo innerGetSelfEntityObjectInfoByName(String propName) {
        EntityObjectInfo bo = this;
        while (!bo.isAbstract()) {
            PropertyInfo prop = bo.innerGetEntitySelfPropByPropName(propName);
            if (prop != null) {
                return bo;
            }
            bo = bo.getBaseEntity();
        }
        return null;
    }

    public EntityObjectInfo getSelfEntityObjectInfoByNameRuntime(String propName) {
        EntityObjectInfo entity;
        InnerCache cache = this.getCache();
        if (cache.selfEntityMap != null && (entity = (EntityObjectInfo)cache.selfEntityMap.get(propName)) != null) {
            return entity.cvalue();
        }
        entity = EntityObjectInfo.cnulls(this.innerGetSelfEntityObjectInfoByName(propName));
        if (cache.selfEntityMap == null) {
            cache.selfEntityMap = new HashMap();
        }
        cache.selfEntityMap.put(propName, entity);
        return entity.cvalue();
    }

    @Override
    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    @Override
    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setBizUnitPK(String bizUnitPK) {
        this.put("bizUnitPK", bizUnitPK);
    }

    public String getBizUnitPK() {
        return this.getString("bizUnitPK");
    }

    public PropertyCollection getSTProperties() {
        LinkedHashSet<PropertyInfo> c = new LinkedHashSet<PropertyInfo>();
        this.getInnerSTProperties(c);
        PropertyCollection pc = new PropertyCollection();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            pc.add((PropertyInfo)it.next());
        }
        return pc;
    }

    private void addST2Properties(PropertyCollection props) {
        PropertyCollection pc = this.getSTProperties();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo pi = pc.get(i);
            if (this.containtsProperty(props, pi)) continue;
            props.add(pi);
        }
    }

    private void getInnerSTProperties(Collection<PropertyInfo> c) {
        if (c == null) {
            throw new IllegalArgumentException("Param Collection is null.");
        }
        BusinessObjectCollection boc = this.getExtendStereoTypes();
        int size = boc.size();
        for (int i = 0; i < size; ++i) {
            BusinessObjectInfo bo = boc.get(i);
            if (!(bo instanceof EntityObjectInfo)) continue;
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            entity.getInnerSTProperties(c);
        }
        if (!this.isStereoType()) {
            return;
        }
        PropertyCollection pc = this.getProperties();
        int size2 = pc.size();
        for (int i = 0; i < size2; ++i) {
            c.add(pc.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InnerCache processComposition() {
        InnerCache cache = this.getCache();
        if (cache.compositions != null) {
            return cache;
        }
        InnerCache innerCache = cache;
        synchronized (innerCache) {
            if (cache.compositions != null) {
                return cache;
            }
            ArrayList<Name2PropMapping> propNamesMapping = new ArrayList<Name2PropMapping>();
            ArrayList<Prop2ChildBoMapping> one2one = new ArrayList<Prop2ChildBoMapping>(2);
            ArrayList<Prop2ChildBoMapping> one2many = new ArrayList<Prop2ChildBoMapping>(2);
            PropertyCollection flds = this.getPropertiesRuntime();
            int size = flds.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo fld = flds.get(i);
                String fullPropName = fld.getName();
                if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ((LinkPropertyInfo)fld).getRelationship();
                    boolean parentCardinality = CardinalityType.isOneORZero(relation.getParentCardinality(this));
                    boolean childCardinality = CardinalityType.isOneORZero(relation.getChildCardinality(this));
                    boolean compositionLink = RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(this));
                    EntityObjectInfo childObject = relation.getChildObject(this);
                    PropertyInfo childProp = relation.getChildProperty(this);
                    String childPropName = "";
                    if (childProp != null) {
                        childPropName = childProp.getName();
                    }
                    if (childCardinality) {
                        fullPropName = fullPropName + "." + childPropName;
                    }
                    if (compositionLink) {
                        Prop2ChildBoMapping pm = new Prop2ChildBoMapping(fld, childPropName, childObject);
                        if (childCardinality) {
                            one2one.add(pm);
                        } else if (parentCardinality) {
                            one2many.add(pm);
                        }
                    }
                }
                if (fld.getMappingField() == null) continue;
                propNamesMapping.add(new Name2PropMapping(fullPropName.toLowerCase(), fld));
            }
            cache.compositions = new Compositions(propNamesMapping, one2one, one2many);
        }
        return cache;
    }

    public Compositions getCompositions() {
        InnerCache cache = this.processComposition();
        return cache.compositions;
    }

    public boolean isBOSUuidCol(PropertyInfo prop) {
        Boolean retVal;
        if (prop == null) {
            return false;
        }
        String PropName = prop.getName();
        InnerCache cache = this.getCache();
        if (cache.bosUuidColTags != null && (retVal = (Boolean)cache.bosUuidColTags.get(PropName)) != null) {
            return retVal;
        }
        retVal = Boolean.FALSE;
        if (prop instanceof OwnPropertyInfo) {
            if (DataType.BOSUUID.equals(((OwnPropertyInfo)prop).getDataType())) {
                retVal = Boolean.TRUE;
            }
        } else if (prop instanceof LinkPropertyInfo) {
            PropertyInfo oneKey;
            PropertyCollection keys;
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            assert (relation != null);
            EntityObjectInfo otherPeer = relation.getClientObject();
            if (this.getFullName().equals(otherPeer.getFullName())) {
                otherPeer = relation.getSupplierObject();
            }
            if ((keys = otherPeer.getLogicalKeyPropertiesRuntime()).size() == 1 && (oneKey = keys.get(0)) instanceof OwnPropertyInfo && DataType.BOSUUID.equals(((OwnPropertyInfo)oneKey).getDataType())) {
                retVal = Boolean.TRUE;
            }
        }
        if (cache.bosUuidColTags == null) {
            cache.bosUuidColTags = new HashMap();
        }
        cache.bosUuidColTags.put(PropName, retVal);
        return retVal;
    }

    public boolean hasOneToOneCompsition() {
        boolean have;
        Compositions compositions = this.getCompositions();
        boolean bl = have = compositions.one2one.size() != 0;
        if (!have) {
            int size = compositions.one2many.size();
            for (int i = 0; i < size; ++i) {
                have = compositions.one2many.get((int)i).childBO.hasOneToOneCompsition();
                if (!have) continue;
                return have;
            }
        }
        return have;
    }

    public PropertyInfo getPropInfoByColumnName(String colName) {
        PropertyInfo prop;
        InnerCache cache = this.getCache();
        if (cache.colNameProps2 != null && (prop = (PropertyInfo)cache.colNameProps2.get(colName)) != null) {
            return prop.cvalue();
        }
        prop = PropertyInfo.cnulls(this.innerGetPropInfoByColumnName(colName));
        if (cache.colNameProps2 == null) {
            cache.colNameProps2 = new HashMap();
        }
        cache.colNameProps2.put(colName, prop);
        return prop.cvalue();
    }

    public PropertyInfo innerGetPropInfoByColumnName(String colName) {
        PropertyCollection props = this.getInheritedNoDuplicatedPropertiesRuntime();
        for (int i = props.size() - 1; i >= 0; --i) {
            PropertyInfo propTemp = props.get(i);
            if (!(propTemp.getMappingField() != null && propTemp instanceof OwnPropertyInfo ? (((OwnPropertyInfo)propTemp).isMultilingual() ? colName.indexOf(MutiLANGUAGE_FLAG) != -1 && colName.substring(0, colName.indexOf(MutiLANGUAGE_FLAG)).equalsIgnoreCase(propTemp.getMappingField().getName()) : colName.equalsIgnoreCase(propTemp.getMappingField().getName())) : propTemp.getMappingField() != null && colName.equalsIgnoreCase(propTemp.getMappingField().getName()))) continue;
            return propTemp;
        }
        return null;
    }

    public static final EntityObjectInfo cnulls(EntityObjectInfo entity) {
        return entity == null ? NULL : entity;
    }

    public final EntityObjectInfo cvalue() {
        return this == NULL ? null : this;
    }

    public boolean hasCompositeProp() {
        InnerCache cache = this.getCache();
        if (cache.hasCompositeProp != null) {
            return cache.hasCompositeProp;
        }
        Boolean hasCompositeProp = Boolean.FALSE;
        PropertyCollection flds = this.getInheritedNoDuplicatedPropertiesRuntime();
        int n = flds.size();
        for (int i = 0; i < n; ++i) {
            RelationshipInfo relation;
            PropertyInfo fld = flds.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)fld).getRelationship()).getLinkType(this))) continue;
            hasCompositeProp = Boolean.TRUE;
            break;
        }
        cache.hasCompositeProp = hasCompositeProp;
        return hasCompositeProp;
    }

    public PropertyCollection getConfiguredPropertiesRuntime() {
        InnerCache cache = this.getCache();
        if (cache.configuredProps != null) {
            return cache.configuredProps;
        }
        PropertyCollection configuredProps = new PropertyCollection();
        PropertyCollection pc = this.getPropertiesRuntime();
        Iterator iterator = pc.iterator();
        while (iterator.hasNext()) {
            PropertyInfo prop = (PropertyInfo)iterator.next();
            if (!prop.isConfigured()) continue;
            configuredProps.add(prop);
        }
        cache.configuredProps = configuredProps;
        return configuredProps;
    }

    @Override
    public BusinessObjectInfo getParent() {
        if (this.isStereoType()) {
            return null;
        }
        return this.getBaseEntity();
    }

    @Override
    public BusinessObjectCollection getExtendStereoTypes() {
        Object obj = this.get("extendStereoTypes");
        if (obj != null) {
            return (BusinessObjectCollection)((EntityObjectCollection)obj).cast(BusinessObjectCollection.class);
        }
        return new BusinessObjectCollection();
    }

    @Override
    public BusinessObjectCollection addExtendStereoType(BusinessObjectInfo st) {
        BusinessObjectCollection c = this.getExtendStereoTypes();
        c.add(st);
        this.put("extendStereoTypes", c.cast(EntityObjectCollection.class));
        return c;
    }

    public void setIsGenerateCode(boolean b) {
        super.setExtendedProperty(IS_GENERATE_CODE, String.valueOf(b));
        this.isGenerateCode = null;
    }

    public boolean getIsGenerateCode() {
        if (this.isGenerateCode == null) {
            String v;
            this.isGenerateCode = DYNAMIC_METADATA.equals(this.getFullName()) ? Boolean.TRUE : (this.isDynamic() ? Boolean.FALSE : ("false".equalsIgnoreCase(v = super.getExtendedProperty(IS_GENERATE_CODE)) ? Boolean.FALSE : Boolean.TRUE));
        }
        return this.isGenerateCode;
    }

    public void setTemplateEntityPK(String pk) {
        super.setExtendedProperty(TEMPLATE_ENTITY_PK, pk);
    }

    public String getTemplateEntityPK() {
        return super.getExtendedProperty(TEMPLATE_ENTITY_PK);
    }

    @Override
    public String getBusinessImplName() {
        if (this.businessImplName == null) {
            if (!this.getIsGenerateCode()) {
                String cn = CommonEntityManager.getCommonBusinessImplName(this);
                if (cn != null) {
                    this.businessImplName = cn;
                } else {
                    String be = EntityObjectInfo.getCommonBaseEntity(this);
                    if (be != null) {
                        int i = be.lastIndexOf(".app.");
                        if (i > 0) {
                            be = be.substring(0, i) + be.substring(i + 4);
                        }
                        this.businessImplName = be + "Common";
                    } else {
                        this.businessImplName = super.getBusinessImplName();
                    }
                }
            } else {
                this.businessImplName = super.getBusinessImplName();
            }
        }
        return this.businessImplName;
    }

    @Override
    public void setBusinessControllerName(String bizCtrlName) {
        super.setBusinessControllerName(bizCtrlName);
    }

    @Override
    public String getBusinessControllerName() {
        if (this.businessControllerName == null) {
            String be;
            String cn;
            this.businessControllerName = !this.getIsGenerateCode() ? ((cn = CommonEntityManager.getCommonControllerName(this)) != null ? cn : ((be = EntityObjectInfo.getCommonBaseEntity(this)) != null ? be + "CommonController" : super.getBusinessControllerName())) : super.getBusinessControllerName();
        }
        return this.businessControllerName;
    }

    private static String getCommonBaseEntity(EntityObjectInfo entity) {
        EntityObjectInfo base = entity.getBaseEntity();
        if (base != null) {
            String fn = base.getFullName();
            if (baseEnties.contains(fn)) {
                return fn;
            }
            return EntityObjectInfo.getCommonBaseEntity(base);
        }
        return null;
    }

    static {
        baseEnties.add("com.kingdee.eas.framework.app.BillBase");
        baseEnties.add("com.kingdee.eas.framework.app.BillEntryBase");
        baseEnties.add("com.kingdee.eas.framework.app.TreeBase");
        baseEnties.add("com.kingdee.eas.framework.app.CoreBillBase");
        baseEnties.add("com.kingdee.eas.framework.app.CoreBillEntryBase");
        baseEnties.add("com.kingdee.eas.framework.app.DataBase");
        baseEnties.add("com.kingdee.eas.framework.app.ObjectBase");
        baseEnties.add("com.kingdee.eas.framework.app.CoreBase");
    }

    private static class InnerCacheReference {
        private final Map<String, InnerCache> caches;
        private final EntityObjectInfo entity;
        private int i = 0;

        InnerCacheReference(EntityObjectInfo entity, int size) {
            this.caches = new HashMap<String, InnerCache>(size);
            this.entity = entity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InnerCache get(String ais) {
            InnerCache cache = this.caches.get(ais);
            if (cache != null) {
                ++this.i;
                if (this.i > 10) {
                    innerCacheFactory.get(ais, cache);
                    this.i = 0;
                }
                return cache;
            }
            Map<String, InnerCache> map = this.caches;
            synchronized (map) {
                cache = this.caches.get(ais);
                if (cache == null) {
                    cache = innerCacheFactory.getInnerCache(this.entity, ais);
                    this.caches.put(ais, cache);
                }
            }
            return cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(String ais) {
            Map<String, InnerCache> map = this.caches;
            synchronized (map) {
                this.caches.remove(ais);
            }
        }
    }

    private static class LRUMap
    extends LinkedHashMap<InnerCacheKey, InnerCache> {
        private static final long serialVersionUID = 4833270407706989195L;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final int MAX_SIZE;

        LRUMap(int maxsize) {
            super(16, 0.75f, true);
            this.MAX_SIZE = maxsize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<InnerCacheKey, InnerCache> eldest) {
            boolean isExceed;
            boolean bl = isExceed = this.size() > this.MAX_SIZE;
            if (isExceed) {
                eldest.getValue().entity.ref.remove(eldest.getKey().ais);
            }
            return isExceed;
        }
    }

    private static class InnerCacheFactory {
        final LRUMap lruMap;
        final AccessQueue<InnerCache> queue;

        InnerCacheFactory(int maxsize) {
            this.lruMap = new LRUMap(maxsize);
            this.queue = new AccessQueue();
            MDMonitor.getInstance().addMonitor(new Runnable(){

                @Override
                public void run() {
                    AccessQueue.Entry<InnerCache> getter = InnerCacheFactory.this.queue.clear();
                    while (getter != null) {
                        InnerCacheFactory.this.getInnerCache(getter.key, (InnerCache)getter.value);
                        getter = getter.previous;
                    }
                }
            }, 2000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InnerCache getInnerCache(String ais, InnerCache cache) {
            InnerCacheKey key = new InnerCacheKey(cache.entity, ais);
            LRUMap lRUMap = this.lruMap;
            synchronized (lRUMap) {
                InnerCache tmp = (InnerCache)this.lruMap.get(key);
                if (tmp == null) {
                    this.lruMap.put(key, cache);
                }
            }
            return cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InnerCache getInnerCache(EntityObjectInfo entity, String ais) {
            InnerCacheKey key = new InnerCacheKey(entity, ais);
            LRUMap lRUMap = this.lruMap;
            synchronized (lRUMap) {
                InnerCache cache = (InnerCache)this.lruMap.get(key);
                if (cache == null) {
                    cache = new InnerCache(entity);
                    this.lruMap.put(key, cache);
                }
                return cache;
            }
        }

        void get(String ais, InnerCache cache) {
            this.queue.access(ais, cache);
        }
    }

    private static class InnerCacheKey {
        final EntityObjectInfo entity;
        final String ais;

        InnerCacheKey(EntityObjectInfo entity, String ais) {
            this.entity = entity;
            this.ais = ais;
        }

        public boolean equals(Object x) {
            if (x == this) {
                return true;
            }
            if (x == null) {
                return false;
            }
            if (!(x instanceof InnerCacheKey)) {
                return false;
            }
            InnerCacheKey another = (InnerCacheKey)x;
            if (this.ais == null) {
                return another.ais == null && this.entity == another.entity;
            }
            return this.ais.equals(another.ais) && this.entity == another.entity;
        }

        public int hashCode() {
            if (this.ais == null) {
                return this.entity.hashCode();
            }
            return this.entity.hashCode() ^ this.ais.hashCode();
        }
    }

    private static class InnerCache {
        final EntityObjectInfo entity;
        private PropertyCollection inheritedNoDuplicatedProperties = null;
        private PropertyCollection inheritedDuplicatedProperties = null;
        private PropertyCollection selfAndAbstractParentproperties = null;
        private PropertyCollection logicalKeyProps = null;
        private transient Compositions compositions = null;
        private PropertyCollection configuredProps = null;
        private boolean hasSetSequence = false;
        private OwnPropertyInfo sequenceProperty = null;
        private Map<String, EntityObjectInfo> selfEntityMap = null;
        private Map<String, PropertyInfo> namePropMap = null;
        private String objectValueClass = null;
        private String objectCollectionClass = null;
        private Class<IObjectValue> objectValueClazz = null;
        private Class<IObjectCollection> objectCollectionClazz = null;
        private Map<String, Boolean> bosUuidColTags = null;
        private Map<String, PropertyInfo> colNameProps = null;
        private Map<String, PropertyInfo> fullNameProps = null;
        private Map<String, Boolean> selfFieldTags = null;
        private Map<String, String> relationshipFields = null;
        private Map<String, PropertyInfo> colNameProps2 = null;
        private Boolean hasCompositeProp = null;

        InnerCache(EntityObjectInfo entity) {
            this.entity = entity;
        }
    }

    public static final class Prop2ChildBoMapping {
        public final PropertyInfo prop;
        public final String childPropName;
        public final EntityObjectInfo childBO;

        Prop2ChildBoMapping(PropertyInfo prop, String childPropName, EntityObjectInfo childBO) {
            this.prop = prop;
            this.childPropName = childPropName;
            this.childBO = childBO;
        }
    }

    public static final class Name2PropMapping {
        public final String name;
        public final PropertyInfo prop;

        Name2PropMapping(String name, PropertyInfo prop) {
            this.name = name;
            this.prop = prop;
        }
    }

    public static final class Compositions {
        public final List<Name2PropMapping> allInstProp;
        public final List<Prop2ChildBoMapping> one2one;
        public final List<Prop2ChildBoMapping> one2many;

        public Compositions(List<Name2PropMapping> allInstProp, List<Prop2ChildBoMapping> one2one, List<Prop2ChildBoMapping> one2many) {
            this.allInstProp = allInstProp;
            this.one2one = one2one;
            this.one2many = one2many;
        }
    }
}

