/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.util.UniqueID;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class EntityUnitBaseInfo
extends AbstractMDElement
implements Serializable {
    private static final Logger logger = Logger.getLogger(EntityUnitBaseInfo.class);
    public final String EXPR_TEMPLATE = "exprTemplate";
    public final String FUNC_COL = "funcCol";
    public final String EXPR_RETURNTYPE = "exprReturnType";
    public final String FIELD_LIST = "fieldlist";

    public boolean isFuncCol() {
        return this.getBoolean("funcCol");
    }

    public void setFuncCol(boolean isFuncCol) {
        this.setBoolean("funcCol", isFuncCol);
    }

    public ConstDataType getExprReturnType() throws BOSException {
        String s = this.getString("exprReturnType");
        if (!StringUtils.isEmpty((String)s)) {
            return ConstDataType.getEnum(s);
        }
        return ConstDataType.OBJECT;
    }

    public void setExprReturnType(ConstDataType item) {
        this.setString("exprReturnType", item.getName());
    }

    protected void addField(String fieldName) {
        this.getFieldList().add(fieldName);
    }

    public List<String> getFieldList() {
        ArrayList fieldList = (ArrayList)this.get("fieldlist");
        if (fieldList == null) {
            fieldList = new ArrayList();
            this.put("fieldlist", fieldList);
        }
        return fieldList;
    }

    public Object[] getFieldsArray() {
        return this.getFieldList().toArray();
    }

    protected void clearFieldList() {
        ArrayList fieldList = new ArrayList();
        this.put("fieldlist", fieldList);
    }

    protected String getExprTemplate() {
        return this.getString("exprTemplate");
    }

    protected void setExprTemplate(String exprTemplate) {
        this.setString("exprTemplate", exprTemplate);
    }

    protected final void setPropertyName(String propertyName, boolean bParse) {
        this.setString("propertyName", propertyName);
        if (bParse && propertyName != null) {
            try {
                this.parsePropertyName(ViewParseUtils.parseFilterExpr(propertyName));
            }
            catch (ParserException e) {
                logger.error((Object)("propertyName[" + propertyName + "] Error. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void parsePropertyName(SqlExpr expr) throws ParserException {
        if (ViewParseUtils.isIdentifierExpr(expr)) {
            return;
        }
        if (expr instanceof SqlBinaryOpExpr || expr instanceof SqlMethodInvokeExpr) {
            this.setPropertyName(expr.toString(), false);
            this.setFuncCol(true);
            this.getFieldList().clear();
            UniqueID fieldIndex = new UniqueID(0L);
            SqlExpr expr2 = (SqlExpr)expr.clone();
            ViewParseUtils.readBinaryFilterExpr(this.getFieldList(), fieldIndex, expr2);
            StringBuffer sb = new StringBuffer();
            DrSQLFormater formater = new DrSQLFormater(sb);
            try {
                formater.formatExpr(expr2);
            }
            catch (FormaterException e) {
                logger.error((Object)("readFilterItem[" + expr2 + "] Error. " + e.getMessage()), (Throwable)e);
                throw new ParserException("readFilterItem[" + expr2 + "] Error.");
            }
            this.setExprTemplate(sb.toString());
        }
    }
}

