/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.util.StringUtils;

public class FilterCollection
extends AbstractObjectCollection {
    public boolean add(FilterInfo info) {
        return this.addObject(info);
    }

    public boolean remove(FilterInfo info) {
        return this.removeObject(info);
    }

    public FilterInfo get(int index) {
        return (FilterInfo)this.getObject(index);
    }

    public FilterInfo set(int index, FilterInfo info) {
        return (FilterInfo)this.setObject(index, info);
    }

    public boolean contains(FilterInfo info) {
        return this.containsObject(info);
    }

    public FilterInfo get(String entryName) {
        if (StringUtils.isEmpty((String)entryName)) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            FilterInfo filter = this.get(i);
            if (!StringUtils.equalsIgnoreCase((String)entryName, (String)filter.getEntryName())) continue;
            return filter;
        }
        return null;
    }

    public void merge(FilterCollection filters, String logic) throws BOSException {
        for (int i = 0; i < filters.size(); ++i) {
            boolean flag = false;
            FilterInfo mergeFilter = filters.get(i);
            assert (mergeFilter == null);
            for (int j = 0; j < this.size(); ++j) {
                FilterInfo filter = this.get(j);
                if (filter == null || filter.getEntryName() == null || mergeFilter.getEntryName() == null || !filter.getEntryName().equalsIgnoreCase(mergeFilter.getEntryName())) continue;
                flag = true;
                filter.mergeFilter(mergeFilter, logic);
                break;
            }
            if (flag) continue;
            this.add(mergeFilter);
        }
    }

    public static void main(String[] args) {
        FilterCollection filters1 = new FilterCollection();
        FilterCollection filters2 = new FilterCollection();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group", 1));
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("kkkkkk", 1));
        FilterInfo entry = new FilterInfo(EntryFilterType.ENTRYALLWHERE);
        entry.setEntryName("entries");
        entry.getFilterItems().add(new FilterItemInfo("amount", (Object)2000, CompareType.GREATER));
        entry.getFilterItems().add(new FilterItemInfo("account.name", (Object)"Account_FOR_GL_TEST_CREATE"));
        entry.setMaskString("#0 and #1");
        FilterInfo assistant = new FilterInfo(EntryFilterType.ENTRYANYWHERE);
        assistant.setEntryName("assistant");
        assistant.getFilterItems().add(new FilterItemInfo("assistNote", (Object)"aaaaa"));
        FilterInfo entryEx = new FilterInfo(EntryFilterType.ENTRYANYWHERE);
        entryEx.setEntryName("entries");
        entryEx.getFilterItems().add(new FilterItemInfo("dc", 1));
        filters1.add(filter);
        filters1.add(entry);
        filters2.add(filter1);
        filters2.add(assistant);
        filters2.add(entryEx);
        try {
            filters1.merge(filters2, "or");
            System.out.println(filters1.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

