/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.TypeReferenceFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.ConstraintInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.NumericConstraintInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RegexConstraintInfo;
import com.kingdee.bos.metadata.entity.ScriptConstraintInfo;
import com.kingdee.bos.metadata.resource.BizDataTypeInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class OwnPropertyInfo
extends PropertyInfo {
    private transient DataType dataType = null;
    private transient Map<MDHostType, BizEnumInfo> enumMap = new HashMap<MDHostType, BizEnumInfo>();

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("dataType".equals(key)) {
            this.dataType = null;
            return;
        }
    }

    public BizDataTypeInfo getBizDataType() {
        return (BizDataTypeInfo)this.get("bizDataType");
    }

    public void setBizDataType(BizDataTypeInfo bizDataType) {
        this.put("bizDataType", bizDataType);
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = DataType.getEnum(this.getString("dataType"));
            if (this.dataType == null) {
                this.dataType = DataType.STRING;
            }
        }
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        if (dataType != null) {
            this.setString("dataType", dataType.getName());
        }
    }

    public String getMetaDataRef() {
        return this.getString("metadataRef");
    }

    public void setMetadataRef(String metadataRef) {
        this.setString("metadataRef", metadataRef);
    }

    public String getJavaType() {
        return this.getDataType().getJavaTypeName();
    }

    public boolean isMultilingual() {
        return this.getBoolean("isMultilingual");
    }

    public void setMultilingual(boolean isMultilingual) {
        this.setBoolean("isMultilingual", isMultilingual);
    }

    public boolean isNullable() {
        return this.getBoolean("isNullable");
    }

    public void setNullable(boolean isNullable) {
        this.setBoolean("isNullable", isNullable);
    }

    public String getFormula() {
        return this.getString("formula");
    }

    public void setFormula(String formula) {
        this.setString("formula", formula);
    }

    public int getLength() {
        if (this.getBizDataType() != null && this.getBizDataType().getLength() != 0) {
            return this.getBizDataType().getLength();
        }
        return this.getInt("length");
    }

    public void setLength(int length) {
        this.setInt("length", length);
    }

    public int getPrecision() {
        if (this.getBizDataType() != null && this.getBizDataType().getPrecision() != 0) {
            return this.getBizDataType().getPrecision();
        }
        return this.getInt("precision");
    }

    public void setPrecision(int precision) {
        this.setInt("precision", precision);
    }

    public int getDecimalDigits() {
        if (this.getBizDataType() != null && this.getBizDataType().getDecimalDigits() != 0) {
            return this.getBizDataType().getDecimalDigits();
        }
        return this.getInt("decimalDigits");
    }

    public void setDecimalDigits(int decimalDigits) {
        this.setInt("decimalDigits", decimalDigits);
    }

    public String getDefaultValue() {
        return this.getDefaultValue(null);
    }

    public String getDefaultValue(Locale loc) {
        if (this.getBizDataType() != null && this.getBizDataType().getDefaultValue() != null) {
            return this.getBizDataType().getDefaultValue();
        }
        return (String)this.get("defaultValue", loc);
    }

    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, null);
    }

    public void setDefaultValue(String defaultValue, Locale loc) {
        this.put("defaultValue", defaultValue, loc);
    }

    public String getDisplayFormat() {
        if (this.getBizDataType() != null && this.getBizDataType().getFormat() == null) {
            return this.getBizDataType().getFormat();
        }
        return this.getString("displayFormat");
    }

    public void setDisplayFormat(String displayFormat) {
        this.setString("displayFormat", displayFormat);
    }

    public ConstraintInfo getConstraint() {
        if (this.getBizDataType() != null && this.getBizDataType().getConstraint() != null) {
            return this.getBizDataType().getConstraint();
        }
        if (this.getBizDataType() == null) {
            if (this.containsKey("numericConstraint") && this.get("numericConstraint") != null) {
                return (ConstraintInfo)this.get("numericConstraint");
            }
            if (this.containsKey("scriptConstraint") && this.get("scriptConstraint") != null) {
                return (ConstraintInfo)this.get("scriptConstraint");
            }
            if (this.containsKey("regextConstraint") && this.get("regextConstraint") != null) {
                return (ConstraintInfo)this.get("regextConstraint");
            }
            return null;
        }
        return null;
    }

    public void setConstraint(ConstraintInfo constraint) {
        if (constraint instanceof NumericConstraintInfo) {
            this.put("numericConstraint", constraint);
            this.remove("scriptConstraint");
            this.remove("regextConstraint");
        } else if (constraint instanceof ScriptConstraintInfo) {
            this.put("scriptConstraint", constraint);
            this.remove("numericConstraint");
            this.remove("regextConstraint");
        } else if (constraint instanceof RegexConstraintInfo) {
            this.put("regextConstraint", constraint);
            this.remove("numericConstraint");
            this.remove("scriptConstraint");
        }
    }

    public BizEnumInfo getEnumType() {
        return this.getEnumType(MDHostType.DESIGN);
    }

    public BizEnumInfo getEnumType(MDHostType host) {
        if (this.getDataType().equals(DataType.ENUM)) {
            BizEnumInfo bizEnmuInfo = this.enumMap.get(host);
            if (bizEnmuInfo == null) {
                bizEnmuInfo = TypeReferenceFactory.getInstance(host).createTypeReference(this.getDataType().toString(), this.getMetaDataRef()).getEnumInfo();
                this.enumMap.put(host, bizEnmuInfo);
            }
            return bizEnmuInfo;
        }
        return null;
    }

    public BizEnumInfo getEnumType(Project.Projects projects) {
        if (this.getDataType().equals(DataType.ENUM)) {
            return TypeReferenceFactory.getInstance(projects).createTypeReference(this.getDataType().toString(), this.getMetaDataRef()).getEnumInfo();
        }
        return null;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.OWN_PROP;
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        if (this.getConstraint() != null) {
            vld.addValidateList(this.getConstraint().validate());
        }
        DataType dataType = DataType.getEnum(this.getString("dataType"));
        if (this.getBizDataType() != null) {
            dataType = this.getBizDataType().getDataType();
        }
        if (dataType == null) {
            vld.addError("Property '" + this.getName() + "': Missing Type.");
        } else {
            if (!dataType.isValidPropertyType()) {
                vld.addError("Property '" + this.getName() + "': Invalid Type.");
            }
            if (dataType.isNeedMetaDataRef() && StringUtils.isEmpty((String)this.getMetaDataRef())) {
                vld.addWarning("Property '" + this.getName() + "': Missing MetaDataRef. sure? ");
            }
            if (!dataType.isNeedMetaDataRef() && !StringUtils.isEmpty((String)this.getMetaDataRef())) {
                vld.addError("Property '" + this.getName() + "': Invalid MetaDataRef.");
            }
        }
        return vld.getValidateList();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof OwnPropertyInfo)) {
            return false;
        }
        OwnPropertyInfo that = (OwnPropertyInfo)o;
        if (this.getMetaDataRef() != null) {
            return this.getMetaDataRef().equals(that.getMetaDataRef()) && super.equals(o);
        }
        return super.equals(o);
    }
}

