/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CompartExprParser;
import com.kingdee.bos.metadata.entity.CompartKeyWord;
import com.kingdee.bos.metadata.entity.RTQueryJoinInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinItemInfo;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.StringReader;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.parser.TokenList;
import java.util.ArrayList;

public class RTQueryJoinExprParser {
    private final TokenList _tokenList;
    ArrayList list = new ArrayList();
    static final Token TOKEN_INNERJOIN = new Token("INNERJOIN", 3, 0, 0);
    static final Token TOKEN_LEFTJOIN = new Token("LEFTJOIN", 3, 0, 0);
    static final Token TOKEN_LEFTOUTERJOIN = new Token("LEFTOUTERJOIN", 3, 0, 0);
    static final Token TOKEN_RIGHTOUTERJOIN = new Token("RIGHTOUTERJOIN", 3, 0, 0);
    static final Token TOKEN_FROM = new Token("FROM", 3, 0, 0);
    static final Token TOKEN_ON = new Token("ON", 3, 0, 0);
    static final Token TOKEN_AND = new Token("AND", 3, 0, 0);
    static final String INNERJOIN = "INNERJOIN";
    static final String LEFTINNERJOIN = "LEFTJOIN";
    static final String LEFTOUTERJOIN = "LEFTOUTERJOIN";
    static final String RIGHTOUTERJOIN = "RIGHTOUTERJOIN";

    public RTQueryJoinExprParser(TokenList tokList) {
        this._tokenList = tokList;
    }

    public RTQueryJoinExprParser(Lexer lexer) throws ParserException {
        this._tokenList = new TokenList(lexer);
    }

    public RTQueryJoinExprParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
    }

    private boolean checkTokenType(Token token) {
        return token != null && !token.equals(Token.PeriodToken) && !token.equals(Token.CommaToken) && token.type != 4;
    }

    public final ArrayList build() throws ParserException {
        this.list.clear();
        this.readRTQueryJoin();
        while (this._tokenList.lookup(0).equals(TOKEN_AND)) {
            this._tokenList.match();
            this.readRTQueryJoin();
        }
        return this.list;
    }

    public static String JoinType2String(JoinType joinType) {
        if (joinType.equals((Object)JoinType.INNERJOIN)) {
            return INNERJOIN;
        }
        if (joinType.equals((Object)JoinType.LEFTINNERJOIN)) {
            return LEFTINNERJOIN;
        }
        if (joinType.equals((Object)JoinType.LEFTJOIN)) {
            return LEFTOUTERJOIN;
        }
        if (joinType.equals((Object)JoinType.RIGHTJOIN)) {
            return RIGHTOUTERJOIN;
        }
        throw new IllegalArgumentException("Illegal JoinType :" + (Object)((Object)joinType));
    }

    public static JoinType JoinType4String(String joinType) {
        if (INNERJOIN.equals(joinType)) {
            return JoinType.INNERJOIN;
        }
        if (LEFTINNERJOIN.equals(joinType)) {
            return JoinType.LEFTINNERJOIN;
        }
        if (LEFTOUTERJOIN.equals(joinType)) {
            return JoinType.LEFTJOIN;
        }
        if (RIGHTOUTERJOIN.equals(joinType)) {
            return JoinType.RIGHTJOIN;
        }
        throw new IllegalArgumentException("Illegal JoinType :" + joinType);
    }

    private void readRTQueryJoin() throws ParserException {
        this._tokenList.match(Token.OpenBraceToken);
        JoinType joinType = null;
        RTQueryJoinInfo info = null;
        String sLeftEntity = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        if (!(this._tokenList.lookup(0).equals(TOKEN_INNERJOIN) || this._tokenList.lookup(0).equals(TOKEN_LEFTJOIN) || this._tokenList.lookup(0).equals(TOKEN_LEFTOUTERJOIN) || this._tokenList.lookup(0).equals(TOKEN_RIGHTOUTERJOIN))) {
            throw new ParserException("Parse RTQUeryJoinExpr faild. Token's value : " + this._tokenList.lookup((int)0).value + ", token's type : " + this._tokenList.lookup(0).typename() + ", line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
        }
        String sJoinType = this._tokenList.lookup((int)0).value;
        joinType = RTQueryJoinExprParser.JoinType4String(sJoinType);
        this._tokenList.match();
        String sRightEntity = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        this._tokenList.match(TOKEN_FROM);
        String sRightPKName = this._tokenList.lookup((int)0).value;
        MetaDataPK rightEntityPK = MetaDataPK.create(sRightPKName);
        info = new RTQueryJoinInfo(sLeftEntity, sRightEntity, rightEntityPK);
        info.setJoinType(joinType);
        this._tokenList.match();
        while (this._tokenList.lookup(0).equals(TOKEN_ON)) {
            this._tokenList.match();
            info.getRtQueryJoinItemInfos().add(this.readItem());
        }
        this._tokenList.match(Token.CloseBraceToken);
        this.list.add(info);
    }

    private RTQueryJoinItemInfo readItem() throws ParserException {
        String leftItem = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        String equalsType = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        String rightItem = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        String itemInfo = leftItem + equalsType + rightItem;
        return new RTQueryJoinItemInfo(itemInfo);
    }

    public static void main(String[] args) {
        try {
            String s = "select t1.a,t2.b,\"df_&4\" as \"te\" where (t1.a=10) and (t2.b='CompareKey' or t3.c='COMPARTKEY' and t3.c * 10 < -180 and t3.t + 10 != (-6 / 15) ) CompartKey aaa=111 COMPARTKEY ccc=112";
            System.out.println(s);
            StringReader strReader = new StringReader(s);
            Lexer lexer = new Lexer(CompartKeyWord.instance, null, strReader);
            TokenList tokList = new TokenList(lexer);
            CompartExprParser parser = new CompartExprParser(tokList);
            ArrayList list = parser.build();
            System.out.println("size=" + list.size());
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("   " + i + " : " + list.get(i));
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }
}

