/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.data.NLSSortType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.parser.OqlParser;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.parser.TokenList;
import java.util.List;

public class SorterItemCollection
extends AbstractObjectCollection {
    private static final long serialVersionUID = -4805333949906252579L;

    public SorterItemCollection(String oql) throws ParserException {
        this.parse(oql);
    }

    public SorterItemCollection() {
    }

    public boolean add(SorterItemInfo info) {
        return this.addObject(info);
    }

    public boolean remove(SorterItemInfo info) {
        return this.removeObject(info);
    }

    public SorterItemInfo get(int index) {
        return (SorterItemInfo)this.getObject(index);
    }

    public SorterItemInfo set(int index, SorterItemInfo info) {
        return (SorterItemInfo)this.setObject(index, info);
    }

    public boolean contains(SorterItemInfo info) {
        return this.containsObject(info);
    }

    public SorterItemCollection getSorter() {
        if (this == null) {
            return new SorterItemCollection();
        }
        return this;
    }

    public static SorterItemCollection getChildSorts(SorterItemCollection parentSorters, PropertyInfo prop, EntityObjectInfo childbo) {
        SorterItemCollection childSorter = null;
        if (parentSorters != null) {
            childSorter = new SorterItemCollection();
            for (int k = 0; k < parentSorters.size(); ++k) {
                SorterItemInfo sorterItem = parentSorters.get(k);
                int index = sorterItem.getPropertyName().indexOf(".");
                if (index <= 0 || !sorterItem.getPropertyName().substring(0, index).equalsIgnoreCase(prop.getName()) || sorterItem.getPropertyName().substring(index + 1).indexOf(".") >= 0) continue;
                sorterItem.setPropertyName(sorterItem.getPropertyName().substring(index + 1));
                childSorter.add(sorterItem);
            }
        }
        return childSorter;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.get(i).output(buf);
            if (i >= n - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public String toOQL() {
        StringBuffer buff = new StringBuffer();
        this.toOQL(buff);
        return buff.toString();
    }

    public void toOQL(StringBuffer buff) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buff.append(", ");
            }
            this.get(i).output(buff);
        }
    }

    public String encode() {
        return this.toOQL();
    }

    void parse(String oql) throws ParserException {
        this.clear();
        SqlSelect sqlSelect = null;
        SqlSelectBase selectBase = null;
        OqlParser partParser = new OqlParser(oql);
        selectBase = partParser.select();
        if (selectBase instanceof SqlSelect) {
            sqlSelect = (SqlSelect)selectBase;
            List orderList = sqlSelect.orderBy;
            int size = orderList.size();
            for (int i = 0; i < size; ++i) {
                SqlOrderByItem orderItem = (SqlOrderByItem)orderList.get(i);
                SqlExpr expr = orderItem.expr;
                SorterItemInfo item = null;
                item = expr instanceof SqlBinaryOpExpr ? new SorterItemInfo(QueryUtil.getOrgValueBySqlBinaryExpr((SqlBinaryOpExpr)expr)) : (expr instanceof SqlIdentifierExpr ? new SorterItemInfo(((SqlIdentifierExpr)expr).getOrgValue()) : new SorterItemInfo(expr.getOrgValue()));
                if (orderItem.chineseOrderByMode == 2) {
                    item.setNLSSortType(NLSSortType.SCHINESE_PINYIN);
                }
                if (orderItem.mode == 0) {
                    item.setSortType(SortType.ASCEND);
                } else {
                    item.setSortType(SortType.DESCEND);
                }
                this.add(item);
            }
        }
    }

    public void decode(String oql) throws ParserException {
        this.parse(oql);
    }

    void decode(TokenList tokList) throws ParserException {
        this.clear();
        if (!tokList.lookup((int)0).value.equalsIgnoreCase("order")) {
            throw new ParserException("parse oql error, must start with 'order'.");
        }
        tokList.match();
        if (!tokList.lookup((int)0).value.equalsIgnoreCase("by")) {
            throw new ParserException("parse oql error, after 'order' must be 'by'.");
        }
        tokList.match();
        StringBuffer propNameBuff = new StringBuffer();
        propNameBuff.append(tokList.lookup((int)0).value);
        tokList.match();
        while (tokList.lookup(0).equals(Token.PeriodToken)) {
            tokList.match();
            propNameBuff.append(".");
            propNameBuff.append(tokList.lookup((int)0).value);
            tokList.match();
        }
        SorterItemInfo soterItem = new SorterItemInfo(propNameBuff.toString());
        if (tokList.lookup((int)0).value.equalsIgnoreCase("SCHINESE_PINYIN")) {
            soterItem.setNLSSortType(NLSSortType.SCHINESE_PINYIN);
            tokList.match();
        }
        if (tokList.lookup(0).equals(Token.AscToken)) {
            soterItem.setSortType(SortType.ASCEND);
            tokList.match();
        } else if (tokList.lookup(0).equals(Token.DescToken)) {
            soterItem.setSortType(SortType.DESCEND);
            tokList.match();
        }
        this.add(soterItem);
        while (tokList.lookup(0).equals(Token.CommaToken)) {
            tokList.match();
            propNameBuff = new StringBuffer();
            propNameBuff.append(tokList.lookup((int)0).value);
            tokList.match();
            while (tokList.lookup(0).equals(Token.PeriodToken)) {
                tokList.match();
                propNameBuff.append(".");
                propNameBuff.append(tokList.lookup((int)0).value);
                tokList.match();
            }
            soterItem = new SorterItemInfo(propNameBuff.toString());
            if (tokList.lookup(0).equals(Token.AscToken)) {
                soterItem.setSortType(SortType.ASCEND);
                tokList.match();
            } else if (tokList.lookup(0).equals(Token.DescToken)) {
                soterItem.setSortType(SortType.DESCEND);
                tokList.match();
            }
            this.add(soterItem);
        }
    }

    @Override
    public Object clone() {
        SorterItemCollection cloned = new SorterItemCollection();
        for (int i = 0; i < this.size(); ++i) {
            cloned.add((SorterItemInfo)this.get(i).clone());
        }
        return cloned;
    }

    public static void main(String[] args) throws ParserException {
        String s1 = "";
        String s2 = "";
        SorterItemCollection newSorter = null;
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("note"));
        sorts.add(new SorterItemInfo("name"));
        s1 = sorts.encode();
        newSorter = new SorterItemCollection();
        newSorter.decode(s1);
        s2 = newSorter.toString();
        System.out.println("s1=" + s1);
        System.out.println("s2=" + s2);
        System.out.println("equals=" + s1.equals(s2));
    }
}

