/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.function;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.UIActionRefInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class OperationInfo
extends AbstractMDElement
implements Serializable {
    private final transient AtomicReference<RefInfo> ref = new AtomicReference();

    public OperationInfo() {
        this.setPKField("name");
        this.init();
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("entityObjectRef".equals(key) || "event".equals(key) || "eventMethod".equals(key)) {
            this.ref.set(null);
        }
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public String getAlias(Locale loc) {
        return (String)this.get("alias", loc);
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public UIActionRefInfo getUiActionRef() {
        return (UIActionRefInfo)this.get("uiActionRef");
    }

    public void setUiActionRef(UIActionRefInfo uiActionRef) {
        this.put("uiActionRef", uiActionRef);
    }

    public FacadeInfo getFacadeObjectRef() {
        return this.getRef().facade;
    }

    public MethodInfo getFacadeMethodRef() {
        RefInfo ref = this.getRef();
        return ref.facade == null ? null : ref.method;
    }

    public MethodInfo getEntityMethodRef() {
        RefInfo ref = this.getRef();
        return ref.facade == null ? ref.method : null;
    }

    public BusinessObjectInfo getBORef() {
        RefInfo ref = this.getRef();
        if (ref.eventMethod != null) {
            return ref.facade == null ? ref.entity : ref.facade;
        }
        return null;
    }

    public MethodInfo getMethodRef() {
        return this.getRef().method;
    }

    public void setEvent(String eventName) {
        this.setString("event", eventName);
    }

    public String getEvent() {
        return this.getString("event");
    }

    public void setEventRef(EventInfo event) {
        this.setString("event", event.getName());
    }

    public EventInfo getEventRef() {
        return this.getRef().event;
    }

    private RefInfo getRef() {
        EventCollection ec;
        RefInfo r = this.ref.get();
        if (r != null) {
            return r;
        }
        EntityObjectInfo entity = this.getEntityObjectRef();
        EventInfo event = null;
        String e = this.getEvent();
        if (!StringUtils.isEmpty((String)e) && entity != null && (ec = entity.getEvents()) != null) {
            event = (EventInfo)ec.getObject(e);
        }
        EventMethodInfo eventMethod = null;
        String em = this.getEventMethod();
        if (em != null && event != null) {
            eventMethod = (EventMethodInfo)event.getEventMethods().getObject(em);
        }
        MethodInfo method = null;
        FacadeInfo facade = null;
        if (eventMethod != null) {
            FacadeInfo f = eventMethod.getFacadeRef();
            MethodInfo m = eventMethod.getFacadeMethod();
            if (f != null || m != null) {
                facade = f;
                method = m;
            } else {
                method = eventMethod.getEntityMethod();
            }
        }
        this.ref.compareAndSet(null, new RefInfo(entity, event, eventMethod, method, facade));
        return this.ref.get();
    }

    public void setEntityObjectRef(EntityObjectInfo entity) {
        this.put("entityObjectRef", entity);
    }

    public EntityObjectInfo getEntityObjectRef() {
        RefInfo r = this.ref.get();
        if (r != null) {
            return r.entity;
        }
        return (EntityObjectInfo)this.get("entityObjectRef");
    }

    public void setEventMethod(String eventMethodName) {
        this.setString("eventMethod", eventMethodName);
    }

    public String getEventMethod() {
        return this.getString("eventMethod");
    }

    public String getReverseOperation() {
        return this.getString("reverseOperation");
    }

    public void setReverseOperation(OperationInfo operInfo) {
        this.setString("reverseOperation", operInfo.getName());
        if (!StringUtils.isEmpty((String)operInfo.getReverseOperation())) {
            return;
        }
        operInfo.setString("reverseOperation", this.getString("name"));
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"oper");
    }

    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        vld.validateMetaDataName(this.getName());
        return vld.getValidateList();
    }

    private static class RefInfo {
        final EntityObjectInfo entity;
        final EventInfo event;
        final EventMethodInfo eventMethod;
        final MethodInfo method;
        final FacadeInfo facade;

        public RefInfo(EntityObjectInfo entity, EventInfo event, EventMethodInfo eventMethod, MethodInfo method, FacadeInfo facade) {
            this.entity = entity;
            this.event = event;
            this.eventMethod = eventMethod;
            this.method = method;
            this.facade = facade;
        }
    }
}

