/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.function.upgrade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.event.ParameterMappingInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.IFunctionObjectCtrl;
import com.kingdee.bos.metadata.function.OperationInfo;

public class Upgrader {
    public static final String METADATA_PATH = "i:/metas";
    private IFunctionObjectCtrl _funcCtrl;
    private IEntityObjectCtrl _entityCtrl;
    private Context _context = new Context();

    public Upgrader() throws BOSException {
        this._context.put((Object)"current_mode", (Object)"DEBUG");
        this._context.put((Object)"METADATAPATH", (Object)METADATA_PATH);
        this._funcCtrl = (IFunctionObjectCtrl)BOSObjectFactory.createBOSObject(this._context, MetaDataTypeList.FUNCTION);
        this._entityCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this._context, MetaDataTypeList.ENTITY);
    }

    private FunctionObjectCollection getFunctions() {
        MetaDataLoaderFactory.setClientMetaDataPath(METADATA_PATH);
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunctions();
    }

    private void generateEvent(OperationInfo operation, FunctionObjectInfo funcion) throws BOSException {
        EventInfo event = new EventInfo();
        String name = operation.getName() + "Event";
        event.setName(name);
        MethodInfo method = null;
        EventMethodInfo eventMethod = null;
        if (operation.getEntityObjectRef() != null) {
            EntityObjectInfo entity = operation.getEntityObjectRef();
            method = operation.getEntityMethodRef();
            assert (entity != null && method != null);
            eventMethod = new EventMethodInfo();
            eventMethod.setName(operation.getName());
            eventMethod.setEntityMethod(method);
            for (int j = 0; j < method.getParameters().size(); ++j) {
                ParameterInfo param = (ParameterInfo)method.getParameters().get(j).clone();
                param.setName(param.getName());
                FormalParameterInfo fp = new FormalParameterInfo();
                fp.setParameter(param);
                event.getFormalParameters().add(fp);
                ParameterMappingInfo paramMapping = new ParameterMappingInfo();
                if (j == 0) {
                    paramMapping.setBOPK(true);
                }
                paramMapping.setActualParameterIndex(j);
                paramMapping.setFormalParameterInnerID(fp.getInnerID());
                eventMethod.getParameterMappings().add(paramMapping);
            }
            event.getEventMethods().add(eventMethod);
            operation.setEventRef(event);
            entity.getEvents().add(event);
            this._entityCtrl.update(MetaDataPK.create(entity.getPackage(), entity.getName()), entity);
            this._funcCtrl.update(MetaDataPK.create(funcion.getPackage(), funcion.getName()), funcion);
        }
    }

    private String computeEventName(String funcName, String operName) {
        int index;
        char[] cChars = funcName.toCharArray();
        int length = cChars.length;
        for (index = 1; index < length && cChars[index] > 'Z'; ++index) {
        }
        String name = funcName.substring(0, index);
        cChars = operName.toCharArray();
        length = cChars.length;
        for (index = 1; index < length && cChars[index] > 'Z'; ++index) {
        }
        name = name + operName.substring(index);
        name = name + "Event";
        return name;
    }

    private String computeEventMethodName(String operName) {
        int index;
        char[] cChars = operName.toCharArray();
        int length = cChars.length;
        for (index = 1; index < length && cChars[index] < 'A'; ++index) {
        }
        String name = operName.substring(index);
        return name;
    }

    public void doUpgrade() throws BOSException {
        FunctionObjectCollection functions = this.getFunctions();
        int length = functions.size();
        for (int i = 0; i < length; ++i) {
            FunctionObjectInfo function = functions.get(i);
            int len = function.getOperation().size();
            for (int j = 0; j < len; ++j) {
                OperationInfo oper = function.getOperation().get(j);
                this.generateEvent(oper, function);
            }
        }
    }

    public void doUpgrade1() throws BOSException {
        FunctionObjectInfo function = this._funcCtrl.getValue(MetaDataPK.create("com.kingdee.eas.fi.gl", "VoucherFunc"));
        int len = function.getOperation().size();
        for (int j = 0; j < len; ++j) {
            OperationInfo oper = function.getOperation().get(j);
            this.generateEvent(oper, function);
        }
    }

    public static void main(String[] args) throws BOSException {
        Upgrader upgrader = new Upgrader();
        upgrader.doUpgrade();
    }
}

