/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DeployAgentHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.management.DeployAgentHelper");
    public static final String STR_DEPLOY_AGENTS = "deployAgents";
    public static final String STR_DEPLOY_AGENT = "deployAgent";
    public static final String STR_TYPE = "type";
    public static final String STR_NAME = "name";
    public static final String STR_PACKAGE = "package";

    private DeployAgentHelper() {
    }

    public static List getAllDeployAgent(String configFileFullPath) throws Exception {
        if (StringUtils.isEmpty((String)configFileFullPath)) {
            return null;
        }
        File file = new File(configFileFullPath);
        if (!file.exists()) {
            return null;
        }
        ArrayList<MetaDataInfo> ret = new ArrayList<MetaDataInfo>();
        try {
            logger.debug((Object)("read config file: " + file.getAbsolutePath()));
            SAXBuilder builder = SAXBuilderFactory.create();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if (!root.getName().equals(STR_DEPLOY_AGENTS)) {
                throw new Exception(file.getName() + "is not a valid file,root tag must be 'deployAgents'");
            }
            List dobjects = root.getChildren();
            Iterator dObjs = dobjects.iterator();
            while (dObjs.hasNext()) {
                String type = "";
                String name = "";
                String pk = "";
                Element dobj = (Element)dObjs.next();
                List dobjContent = dobj.getChildren();
                for (Element content : dobjContent) {
                    String conName = content.getName();
                    if (conName.equals(STR_TYPE)) {
                        type = content.getText();
                        continue;
                    }
                    if (conName.equals(STR_NAME)) {
                        name = content.getText();
                        continue;
                    }
                    if (!conName.equals(STR_PACKAGE)) continue;
                    pk = content.getText();
                }
                MetaDataInfo info = new MetaDataInfo();
                info.setName(name);
                info.setPackage(pk);
                info.setMetaDataType(type);
                ret.add(info);
            }
        }
        catch (JDOMException e) {
            logger.debug((Object)"error", (Throwable)e);
            throw new JDOMException("parse file " + file.getAbsolutePath() + " error: " + e.getMessage());
        }
        catch (IOException e) {
            logger.debug((Object)"error", (Throwable)e);
            throw new IOException("read file " + file.getAbsolutePath() + " error: " + e.getMessage());
        }
        return ret;
    }
}

