/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management.application;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.AbstractMetaDataContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.management.application.ApplicationCollection;
import com.kingdee.bos.metadata.management.application.ApplicationInfo;
import com.kingdee.bos.metadata.management.application.DependenceCollection;
import com.kingdee.bos.metadata.management.application.IAppViewCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.management.application.ReferSubSystemCollection;
import com.kingdee.bos.metadata.management.application.ReferSubSystemInfo;
import com.kingdee.bos.metadata.management.application.SubSystemCollection;
import com.kingdee.bos.metadata.management.application.SubSystemInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;

public class AppViewCtrl
extends AbstractMetaDataContainer
implements IAppViewCtrl {
    public AppViewCtrl() {
        super.registerInterface(IAppViewCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management.application", "appview"));
    }

    public AppViewCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IAppViewCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management.application", "appview"));
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.APPVIEW;
    }

    @Override
    public void addnew(IMetaDataPK pk, AppViewInfo appViewInfo) throws BOSException {
        this.getDAO().addnew(pk, appViewInfo);
    }

    @Override
    public IMetaDataPK addnew(AppViewInfo appViewInfo) throws BOSException {
        return (IMetaDataPK)this.getDAO().addnew(appViewInfo);
    }

    @Override
    public void update(IMetaDataPK metaType, AppViewInfo appViewInfo) throws BOSException {
        this.getDAO().update(metaType, appViewInfo);
    }

    @Override
    public AppViewInfo getValue(IMetaDataPK metaType) throws BOSException {
        if (metaType == null) {
            return this.getValue();
        }
        return (AppViewInfo)this.getDAO().getValue(metaType);
    }

    @Override
    public ApplicationCollection getApplications() throws DataAccessException {
        try {
            AppViewInfo appView = this.getValue();
            ApplicationCollection apps = appView.getApplications();
            return apps;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getMetaDatas(String appName) throws DataAccessException {
        try {
            MetaDataCollection metaCols = new MetaDataCollection();
            ApplicationInfo appInfo = this.getApplicaton(appName);
            int length = appInfo.getSubSystems().size();
            for (int i = 0; i < length; ++i) {
                metaCols.addObjectCollection(appInfo.getSubSystems().get(i).getMetaDatas());
            }
            return metaCols;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getAllMetaDatas(String appName, String subSystemName) throws DataAccessException {
        try {
            ReferSubSystemCollection refers = this.getReferSubSystems(appName, subSystemName);
            MetaDataCollection metaCols = this.getMetaDatasFromSubSystem(appName, subSystemName);
            return this.getMetaDatasFromSubSystem(refers, metaCols);
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getAllMetaDatas(String appName) throws DataAccessException {
        try {
            ReferSubSystemCollection refers = this.getReferSubSystems(appName);
            MetaDataCollection metaCols = this.getMetaDatas(appName);
            return this.getMetaDatasFromSubSystem(refers, metaCols);
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getMetaDatasFromSubSystem(String appName, String subSystemName) throws DataAccessException {
        try {
            ApplicationInfo appInfo = this.getApplicaton(appName);
            SubSystemInfo subSystem = appInfo.getSubSystemFromName(subSystemName);
            return subSystem.getMetaDatas();
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type, String appName, String subSystemName) throws DataAccessException {
        try {
            ApplicationInfo appInfo = this.getApplicaton(appName);
            SubSystemInfo subSystem = appInfo.getSubSystemFromName(subSystemName);
            return subSystem.getMetaDatas(type);
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public ReferSubSystemCollection getDependedSubSystem(String appName, String subSystemName) throws DataAccessException {
        try {
            ReferSubSystemCollection referSubSystems = new ReferSubSystemCollection();
            AppViewInfo appView = this.getValue();
            DependenceCollection dependences = appView.getDependences();
            int length = dependences.size();
            block2: for (int i = 0; i < length; ++i) {
                int referSize = dependences.get(i).getReferingSubSystems().size();
                for (int j = 0; j < referSize; ++j) {
                    ReferSubSystemInfo referSub = dependences.get(i).getReferingSubSystems().get(j);
                    if (!StringUtils.equalsIgnoreCase((String)referSub.getRefApplication().getName(), (String)appName) || !StringUtils.equalsIgnoreCase((String)referSub.getSubSystemName(), (String)subSystemName)) continue;
                    referSubSystems.add(dependences.get(i).getReferedSubSystem());
                    continue block2;
                }
            }
            return referSubSystems;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public ReferSubSystemCollection getDependenceSubSystem(String appName, String subSystemName) throws DataAccessException {
        try {
            ReferSubSystemCollection referSubSystem = null;
            AppViewInfo appView = this.getValue();
            DependenceCollection dependences = appView.getDependences();
            int length = dependences.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)dependences.get(i).getReferedSubSystem().getRefApplication().getName(), (String)appName) || !StringUtils.equalsIgnoreCase((String)dependences.get(i).getReferedSubSystem().getSubSystemName(), (String)subSystemName)) continue;
                referSubSystem = dependences.get(i).getReferingSubSystems();
                break;
            }
            return referSubSystem;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getMetaDatas() throws DataAccessException {
        assert (false) : "Please call the method getMetaDatas(String appViewName)";
        return null;
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type) throws DataAccessException {
        assert (false) : "Please call the method getMetaDatasByType(String appViewName, BOSObjecttype type)";
        return null;
    }

    @Override
    public AppViewInfo getValue() throws BOSException {
        NetFileSource fileSrc = Utils.getMetaDataFileSrc(this.getContext());
        NetFileFactory fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        NetFile root = fileFactory.createNetFile("\\");
        String[] files = root.list();
        if (files == null) {
            throw new ObjectNotFoundException("Cannot found Appview");
        }
        String temp = null;
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            if (files[i].lastIndexOf(Utils.getMetaDataSuffix(MetaDataTypeList.APPVIEW)) == -1) continue;
            temp = files[i];
        }
        if (temp == null) {
            throw new ObjectNotFoundException("Cannot found solution");
        }
        String name = temp.substring(0, temp.indexOf(46));
        return this.getValue(MetaDataPK.create(null, name));
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type, String name) throws DataAccessException {
        try {
            MetaDataCollection metaCols = new MetaDataCollection();
            ApplicationInfo appInfo = this.getApplicaton(name);
            SubSystemCollection subSystems = appInfo.getSubSystems();
            int length = subSystems.size();
            for (int i = 0; i < length; ++i) {
                metaCols.addObjectCollection(subSystems.get(i).getMetaDatas(type));
            }
            return metaCols;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    private ReferSubSystemCollection getReferSubSystems(String appName) throws DataAccessException {
        try {
            ReferSubSystemCollection refers = new ReferSubSystemCollection();
            ApplicationInfo application = this.getApplicaton(appName);
            SubSystemCollection subs = application.getSubSystems();
            int length = subs.size();
            for (int i = 0; i < length; ++i) {
                refers.addObjectCollection(this.getReferSubSystems(appName, subs.get(i).getName()));
            }
            return refers;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    private ReferSubSystemCollection getReferSubSystems(String appName, String subName) throws DataAccessException {
        try {
            ReferSubSystemCollection refers = new ReferSubSystemCollection();
            ReferSubSystemCollection referSubSystems = this.getDependenceSubSystem(appName, subName);
            if (referSubSystems != null) {
                refers.addObjectCollection(referSubSystems);
                for (int i = 0; i < referSubSystems.size(); ++i) {
                    ReferSubSystemInfo refer = referSubSystems.get(i);
                    refers.addObjectCollection(this.getReferSubSystems(refer.getRefApplication().getName(), refer.getSubSystemName()));
                }
            }
            return refers;
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    private ApplicationInfo getApplicaton(String appName) throws DataAccessException {
        try {
            AppViewInfo appView = this.getValue();
            return appView.getApplicationFromName(appName);
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    private MetaDataCollection getMetaDatasFromSubSystem(ReferSubSystemCollection refers, MetaDataCollection metaCols) throws DataAccessException {
        MetaDataCollection returnMetaDatas = new MetaDataCollection();
        int length = refers.size();
        for (int i = 0; i < length; ++i) {
            metaCols.addObjectCollection(this.getMetaDatasFromSubSystem(refers.get(i).getRefApplication().getName(), refers.get(i).getSubSystemName()));
        }
        HashMap<String, MetaDataInfo> map = new HashMap<String, MetaDataInfo>();
        for (int j = 0; j < metaCols.size(); ++j) {
            String metaKey = metaCols.get(j).getPackage() + "." + metaCols.get(j).getName() + "." + metaCols.get(j).getMetaDataType().toString();
            if (map.containsKey(metaKey)) continue;
            map.put(metaKey, metaCols.get(j));
        }
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            returnMetaDatas.add((MetaDataInfo)it.next());
        }
        return returnMetaDatas;
    }
}

