/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management.application;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.application.ApplicationCollection;
import com.kingdee.bos.metadata.management.application.ApplicationInfo;
import com.kingdee.bos.metadata.management.application.DependenceCollection;
import com.kingdee.bos.metadata.management.application.DependenceInfo;
import com.kingdee.bos.metadata.management.application.ReferSubSystemCollection;
import com.kingdee.bos.metadata.management.application.ReferSubSystemInfo;
import com.kingdee.bos.metadata.management.application.SubSystemCollection;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;

public class AppViewInfo
extends AbstractMetaDataValue
implements Serializable,
IValidate {
    public static final String APP_VIEW_NAME = "bos";

    public AppViewInfo() {
        this.setString("name", APP_VIEW_NAME);
        this.put("applications", new ApplicationCollection());
        this.put("dependences", new DependenceCollection());
    }

    protected AppViewInfo(boolean init) {
        super(init);
        this.setString("name", APP_VIEW_NAME);
        this.put("applications", new ApplicationCollection());
        this.put("dependences", new DependenceCollection());
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    public ApplicationCollection getApplications() {
        return (ApplicationCollection)this.get("applications");
    }

    public DependenceCollection getDependences() {
        return (DependenceCollection)this.get("dependences");
    }

    public void addApplication(ApplicationInfo appInfo) {
        this.getApplications().add(appInfo);
    }

    public void addDependence(DependenceInfo depend) {
        this.getDependences().add(depend);
    }

    public void removeApplication(ApplicationInfo appInfo) {
        SubSystemCollection subSystems = appInfo.getSubSystems();
        int length = subSystems.size();
        for (int i = 0; i < length; ++i) {
            subSystems.get(i).getMetaDatas().removeAll();
        }
        this.getApplications().remove(appInfo);
    }

    public void remoceDependence(DependenceInfo depend) {
        this.getDependences().remove(depend);
    }

    public ApplicationInfo getApplicationFromName(String appName) {
        ApplicationCollection apps = this.getApplications();
        ApplicationInfo appInfo = null;
        int length = apps.size();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)apps.get(i).getName(), (String)appName)) continue;
            appInfo = apps.get(i);
            break;
        }
        return appInfo;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.APPVIEW;
    }

    @Override
    public ValidateList validate() {
        DependenceCollection depends;
        ValidateMetaData vld = new ValidateMetaData();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        ApplicationCollection appCol = this.getApplications();
        if (appCol != null) {
            map.clear();
            for (i = 0; i < appCol.size(); ++i) {
                String name = appCol.get(i).getName();
                if (map.containsKey(name)) {
                    vld.addError("Duplicated application name: " + name);
                } else {
                    map.put(name, name);
                }
                vld.addValidateList(appCol.get(i).validate());
            }
        }
        if ((depends = this.getDependences()) != null) {
            for (i = 0; i < depends.size(); ++i) {
                map.clear();
                DependenceInfo depend = depends.get(i);
                String subSystemKey = this.getKey(depend.getReferedSubSystem());
                map.put(subSystemKey, subSystemKey);
                ReferSubSystemCollection referSubs = depend.getReferingSubSystems();
                try {
                    this.compareSubSystem(referSubs, map, vld);
                    continue;
                }
                catch (Exception e) {
                    vld.addError(e.getMessage());
                    break;
                }
            }
        }
        return vld.getValidateList();
    }

    private String getKey(ReferSubSystemInfo referSub) {
        return referSub.getRefApplication().getName() + "." + referSub.getSubSystemName();
    }

    private ReferSubSystemCollection getReferSubSystems(String subSystemKey) {
        DependenceCollection depends = this.getDependences();
        ReferSubSystemCollection referSubs = null;
        for (int i = 0; i < depends.size(); ++i) {
            if (!StringUtils.equalsIgnoreCase((String)this.getKey(depends.get(i).getReferedSubSystem()), (String)subSystemKey)) continue;
            referSubs = depends.get(i).getReferingSubSystems();
            break;
        }
        return referSubs;
    }

    private void compareSubSystem(ReferSubSystemCollection referSubs, HashMap map, ValidateMetaData vld) throws BOSException {
        if (referSubs != null) {
            int length = referSubs.size();
            for (int j = 0; j < length; ++j) {
                ReferSubSystemInfo matchSubSystem = referSubs.get(j);
                String matchSubSystemKey = this.getKey(matchSubSystem);
                if (map.containsKey(matchSubSystemKey)) {
                    throw new BOSException("The inherited tree ia a circle![" + matchSubSystemKey + "]");
                }
                map.put(matchSubSystemKey, matchSubSystemKey);
                if (this.getReferSubSystems(matchSubSystemKey) == null) continue;
                this.compareSubSystem(this.getReferSubSystems(matchSubSystemKey), map, vld);
            }
        }
    }
}

