/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management.application;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class MetaDataInfo
extends AbstractMDElement
implements Serializable,
Comparable {
    private transient String name = null;
    private transient String pack = null;

    public MetaDataInfo() {
        this.init();
    }

    public MetaDataInfo(IMetaDataPK pk, BOSObjectType bosType) {
        this.setPackage(pk.getPackage());
        this.setName(pk.getName());
        this.setMetaDataType(bosType.toString());
        this.init();
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("package".equals(key)) {
            this.pack = null;
            return;
        }
        if ("name".equals(key)) {
            this.name = null;
            return;
        }
    }

    public String getPackage() {
        if (this.pack == null) {
            this.pack = this.getString("package");
        }
        return this.pack;
    }

    public void setPackage(String pgName) {
        if (pgName != null) {
            pgName = pgName.intern();
        }
        this.setString("package", pgName);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getString("name");
        }
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.intern();
        }
        this.setString("name", name);
    }

    public String getFullName() {
        String pkg = this.getPackage();
        String name = this.getName();
        if (StringUtils.isEmpty((String)pkg)) {
            return name;
        }
        return pkg + "." + name;
    }

    public String getMetaDataType() {
        return this.getString("bosType");
    }

    public void setMetaDataType(String bosType) {
        this.setString("bosType", bosType);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"meda");
    }

    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        vld.validateMetaDataName(this.getName());
        return vld.getValidateList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MetaDataInfo)) {
            return false;
        }
        MetaDataInfo meta = (MetaDataInfo)o;
        if (!meta.getName().equals(this.getName())) {
            return false;
        }
        if (!meta.getMetaDataType().equals(this.getMetaDataType())) {
            return false;
        }
        if (meta.getPackage() != null) {
            return meta.getPackage().equals(this.getPackage());
        }
        return this.getPackage() == null;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public String toString() {
        return this.getMetaDataType() + ":" + this.getPackage() + ":" + this.getName();
    }

    public static void main(String[] args) {
        MetaDataInfo meta = new MetaDataInfo();
        meta.setName("xxxx");
        meta.setMetaDataType("abcd");
        MetaDataInfo oldMeta = new MetaDataInfo();
        oldMeta.setName("xxxx");
        oldMeta.setMetaDataType("abcd");
        System.out.println(meta.equals(oldMeta));
    }
}

