/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mdquery;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.mdquery.DataSourceInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceType;
import com.kingdee.bos.metadata.mdquery.DimensionUsageCollection;
import com.kingdee.bos.metadata.mdquery.DimensionUsageInfo;
import com.kingdee.bos.metadata.mdquery.MeasureCollection;
import com.kingdee.bos.metadata.mdquery.MeasureInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashSet;

public class CubeInfo
extends AbstractMDElement
implements Serializable {
    public CubeInfo() {
        this.put("dimensionUsages", new DimensionUsageCollection());
        this.put("measures", new MeasureCollection());
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public DataSourceInfo getDataSource() {
        return (DataSourceInfo)this.get("dataSource");
    }

    public void setDataSource(DataSourceInfo info) {
        this.put("dataSource", info);
    }

    public DimensionUsageCollection getDimensionUsageCollection() {
        return (DimensionUsageCollection)this.get("dimensionUsages");
    }

    public MeasureCollection getMeasureCollection() {
        return (MeasureCollection)this.get("measures");
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"mqcu");
    }

    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        HashSet<String> set = new HashSet<String>();
        String name = this.getName();
        if (name == null || name.equals("")) {
            vld.addError("The name of the cube has not defined");
        }
        if (this.getDataSource() == null) {
            vld.addError("The dataSource of the cube has not been defined");
        } else {
            DataSourceInfo dataSourceInfo = this.getDataSource();
            DataSourceType sourceType = dataSourceInfo.getBaseType();
            if (sourceType != null && (sourceType.equals((Object)DataSourceType.JOINQUERY) || sourceType.equals((Object)DataSourceType.UNIONQUERY))) {
                PropertyUnitCollection dsPropUnits;
                if (sourceType.equals((Object)DataSourceType.JOINQUERY)) {
                    JoinQueryInfo joinQueryInfo = dataSourceInfo.getJoinQueryObject();
                    dsPropUnits = joinQueryInfo.getUnits();
                } else {
                    UnionQueryInfo unionQueryInfo = dataSourceInfo.getUnionQueryObject();
                    dsPropUnits = unionQueryInfo.getUnits();
                }
                DimensionUsageCollection dimensionUsages = this.getDimensionUsageCollection();
                int length = dimensionUsages.size();
                if (length == 0) {
                    vld.addError("DimensionUsages have not been defined in the cube.");
                }
                for (int i = 0; i < length; ++i) {
                    DimensionUsageInfo dimensionUsage = dimensionUsages.get(i);
                    name = dimensionUsage.getDimension().getName();
                    String foreignKey = dimensionUsage.getForeignKey();
                    if (foreignKey == null || foreignKey.equals("")) {
                        vld.addError("ForeignKey has not been defined in the dimensionUsage named: " + name);
                        continue;
                    }
                    if (dsPropUnits.contains(foreignKey)) continue;
                    vld.addError("ForeignKey does not exists in the fact-table. The ForeignKey's Name: " + foreignKey);
                }
                MeasureCollection measures = this.getMeasureCollection();
                length = measures.size();
                if (length == 0) {
                    vld.addError("Measures have not been defined in the cube.");
                }
                for (int i = 0; i < length; ++i) {
                    MeasureInfo measure = measures.get(i);
                    name = measure.getName();
                    if (name == null || name.equals("")) {
                        vld.addError("The name of the measure has not defined");
                    }
                    if (set.contains(name.toLowerCase())) {
                        vld.addError("Duplicated measure name: " + name);
                    } else {
                        set.add(name.toLowerCase());
                    }
                    String column = measure.getColumn();
                    if (column == null || column.equals("")) {
                        vld.addError("Column has not been defined in the measure named: " + name);
                        continue;
                    }
                    if (dsPropUnits.contains(column)) continue;
                    vld.addError("Column does not exists in the fact-table. The column's name: " + column);
                }
            } else {
                vld.addError("The type of the dataSource was wrong. ");
            }
        }
        return vld.getValidateList();
    }
}

