/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mdquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceType;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryCtrl;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;

public class DataSourceInfo
extends AbstractMDElement
implements Serializable {
    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public DataSourceType getBaseType() {
        return DataSourceType.getEnum(this.getString("baseType"));
    }

    public void setBaseType(DataSourceType baseType) {
        String typeString = baseType == null ? "" : baseType.toString();
        this.setString("baseType", typeString);
    }

    public JoinQueryInfo getJoinQueryObject() {
        return (JoinQueryInfo)this.get("joinQueryObjectRef");
    }

    public void setJoinQueryObject(JoinQueryInfo info) {
        this.put("joinQueryObjectRef", info);
    }

    public UnionQueryInfo getUnionQueryObject() {
        return (UnionQueryInfo)this.get("unionQueryObjectRef");
    }

    public void setUnionQueryObject(UnionQueryInfo info) {
        this.put("unionQueryObjectRef", info);
    }

    public EntityObjectInfo getEntityObject() {
        return (EntityObjectInfo)this.get("entityObjectRef");
    }

    public void setEntityObject(EntityObjectInfo info) {
        this.put("entityObjectRef", info);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"mqds");
    }

    public ValidateList validate() {
        ValidateMetaData vld;
        block16: {
            vld = new ValidateMetaData();
            DataSourceType type = this.getBaseType();
            if (type != null) {
                try {
                    if (type.equals((Object)DataSourceType.ENTITY)) {
                        EntityObjectInfo entityInfo = this.getEntityObject();
                        if (entityInfo != null) {
                            if (!new EntityObjectCtrl(ContextManager.getContext()).exists(MetaDataPK.create(entityInfo.getPackage(), entityInfo.getName()))) {
                                vld.addError("The entityObject does not exists in metadata. The entity's name: " + entityInfo.getName());
                            }
                        } else {
                            vld.addError("The object of the dataSource has not been defined");
                        }
                        break block16;
                    }
                    if (type.equals((Object)DataSourceType.JOINQUERY)) {
                        JoinQueryInfo joinQueryInfo = this.getJoinQueryObject();
                        if (joinQueryInfo != null) {
                            if (!new JoinQueryCtrl(ContextManager.getContext()).exists(MetaDataPK.create(joinQueryInfo.getPackage(), joinQueryInfo.getName()))) {
                                vld.addError("The joinQueryObject does not exist in metadata. The query's name: " + joinQueryInfo.getName());
                            }
                        } else {
                            vld.addError("The object of the dataSource has not been defined");
                        }
                        break block16;
                    }
                    if (type.equals((Object)DataSourceType.UNIONQUERY)) {
                        UnionQueryInfo unionQueryInfo = this.getUnionQueryObject();
                        if (unionQueryInfo != null) {
                            if (!new UnionQueryCtrl(ContextManager.getContext()).exists(MetaDataPK.create(unionQueryInfo.getPackage(), unionQueryInfo.getName()))) {
                                vld.addError("The unionQueryObject does not exist in metadata. The query's name: " + unionQueryInfo.getName());
                            }
                        } else {
                            vld.addError("The object of the dataSource has not been defined");
                        }
                        break block16;
                    }
                    vld.addError("This dataSource has not set any Entity or Query");
                }
                catch (BOSException e) {
                    vld.addError(e.getMessage());
                }
            } else {
                vld.addError("Base type of the dataSource has not been defined. dataSourceName: " + this.getName());
            }
        }
        return vld.getValidateList();
    }
}

