/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mr;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.mr.Ref;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;

public class MetadataParser {
    public static Ref getRefByObject(AbstractMetaDataValue info) {
        if (info == null) {
            return null;
        }
        BOSObjectType type = info.getBOSType();
        return new Ref(info.getFullName(), type.toString());
    }

    public static Ref[] getRefsByObjects(AbstractMetaDataValue[] infos) {
        if (infos == null) {
            return new Ref[0];
        }
        Ref[] refs = new Ref[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            refs[i] = MetadataParser.getRefByObject(infos[i]);
        }
        return refs;
    }

    public static AbstractMetaDataValue getObjectByRef(Context ctx, Ref ref) throws DataAccessException {
        if (ctx == null || ref == null) {
            return null;
        }
        return (AbstractMetaDataValue)XMLAccessEngine.load(ctx, BOSObjectType.create((String)ref.getType()), MetaDataPK.create(ref.getFullName()));
    }

    public static AbstractMetaDataValue[] getObjectsByRefs(Context ctx, Ref[] refs) throws DataAccessException {
        if (refs == null) {
            return new AbstractMetaDataValue[0];
        }
        AbstractMetaDataValue[] values = new AbstractMetaDataValue[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            values[i] = MetadataParser.getObjectByRef(ctx, refs[i]);
        }
        return values;
    }

    public static Ref[] getObjectLinkRefs(AbstractMetaDataValue info) {
        if (info == null) {
            return new Ref[0];
        }
        HashSet rtv = new HashSet();
        IdentityHashMap temp = new IdentityHashMap();
        MetadataParser.computeRefs(info, rtv, temp);
        rtv.remove(MetadataParser.getRefByObject(info));
        return rtv.toArray(new Ref[0]);
    }

    private static void computeRefs(IObjectValue info, Collection bag, Map hasChecked) {
        if (info == null) {
            return;
        }
        Enumeration keys = info.keys();
        while (keys.hasMoreElements()) {
            Object value = info.get((String)keys.nextElement());
            if (value instanceof IObjectCollection) {
                IObjectCollection vs = (IObjectCollection)value;
                for (int i = 0; i < vs.size(); ++i) {
                    IObjectValue v = vs.getObject(i);
                    MetadataParser.computRefs0(v, bag, hasChecked);
                }
                continue;
            }
            if (!(value instanceof IObjectValue)) continue;
            MetadataParser.computRefs0((IObjectValue)value, bag, hasChecked);
        }
    }

    private static void computRefs0(IObjectValue value, Collection bag, Map hasChecked) {
        if (value == null) {
            return;
        }
        if (value instanceof AbstractMetaDataValue) {
            Ref ref = MetadataParser.getRefByObject((AbstractMetaDataValue)value);
            bag.add(ref);
            return;
        }
        if (!hasChecked.containsKey(value)) {
            hasChecked.put(value, null);
            MetadataParser.computeRefs(value, bag, hasChecked);
        }
    }

    public static MetaDataInfo ref2info(Ref r) {
        MetaDataInfo info = new MetaDataInfo();
        info.setMetaDataType(r.getType());
        String fullName = r.getFullName();
        int i = fullName.lastIndexOf(46);
        if (i == -1) {
            info.setName(fullName);
        } else {
            info.setName(fullName.substring(i + 1, fullName.length()));
            info.setPackage(fullName.substring(0, i));
        }
        return info;
    }

    public static Ref info2ref(MetaDataInfo info) {
        Ref r = new Ref(info.getFullName(), info.getMetaDataType());
        return r;
    }

    public static MetaDataInfo[] ref2info(Ref[] refs) {
        if (refs == null) {
            return new MetaDataInfo[0];
        }
        MetaDataInfo[] rtv = new MetaDataInfo[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            rtv[i] = MetadataParser.ref2info(refs[i]);
        }
        return rtv;
    }

    public static Ref[] info2ref(MetaDataInfo[] infos) {
        if (infos == null) {
            return new Ref[0];
        }
        Ref[] rtv = new Ref[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            rtv[i] = MetadataParser.info2ref(infos[i]);
        }
        return rtv;
    }
}

