/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mr;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.PackageCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.mr.BOSTypeExp;
import com.kingdee.bos.metadata.mr.RefactorTask;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class RefactorManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.mr.RefactorManager");
    private static final String EX_PROP_KEY = "WeakReference";
    private final Context ctx;
    private final XMLLoader loader;

    public RefactorManager(Context ctx) throws DataAccessException {
        this.ctx = ctx;
        this.loader = XMLAccessEngine.getXMLLoader(ctx);
        this.loader.getContext().setLocale(BOSLocaleUtil.ZH_CN);
    }

    public synchronized void rename(MetaDataCollection dest, RefactorTask[] tasks) throws Exception {
        if (dest == null) {
            return;
        }
        if (tasks == null || tasks.length == 0) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Begin MetaData Refactor, Tasks: " + tasks));
        }
        for (int i = 0; i < dest.size(); ++i) {
            MetaDataInfo metaInfo = dest.get(i);
            try {
                AbstractMetaDataValue metaDoc = null;
                metaDoc = (AbstractMetaDataValue)this.loader.load(metaInfo.getMetaDataType(), (IObjectPK)MetaDataPK.create(metaInfo.getFullName()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MetaData Refactor Processing: " + metaInfo));
                }
                boolean isModify = false;
                if (!(isModify |= this.processVO(metaDoc, tasks))) continue;
                XMLAccessEngine.store(this.ctx, metaDoc.getBOSType(), metaDoc);
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("MetaData Refactor save Modified: " + metaInfo));
                continue;
            }
            catch (Exception _) {
                logger.error((Object)("Refactor error while process [" + metaInfo + "]"), (Throwable)_);
            }
        }
    }

    private boolean processVO(AbstractMDValue vo, RefactorTask[] tasks) throws MissingDAOMetaDataException {
        boolean isModify = false;
        BOSObjectType type = vo.getBOSType();
        EntityObjectInfo metameta = this.loader.loadMeta(type);
        String extendProp = metameta.getExtendedProperty(EX_PROP_KEY);
        if (extendProp != null && extendProp.length() > 0) {
            isModify |= this.execTasks(vo, extendProp, tasks);
        }
        PropertyCollection props = metameta.getInheritedNoDuplicatedPropertiesRuntime();
        for (int i = 0; i < props.size(); ++i) {
            LinkPropertyInfo linkProp;
            RelationshipInfo relation;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = (linkProp = (LinkPropertyInfo)prop).getRelationship()).getType())) continue;
            String propName = prop.getName();
            Object subObj = vo.get(propName);
            if (subObj instanceof AbstractMDElement) {
                isModify |= this.processVO((AbstractMDValue)subObj, tasks);
                continue;
            }
            if (!(subObj instanceof IObjectCollection)) continue;
            IObjectCollection coll = (IObjectCollection)subObj;
            for (int k = 0; k < coll.size(); ++k) {
                isModify |= this.processVO((AbstractMDValue)coll.getObject(k), tasks);
            }
        }
        return isModify;
    }

    private boolean execTasks(AbstractMDValue vo, String softRef, RefactorTask[] tasks) {
        boolean isModify = false;
        String[] tokens = softRef.split(";");
        for (int i = 0; i < tokens.length; ++i) {
            String refString = tokens[i];
            String[] exps = refString.split(",");
            assert (exps.length >= 2) : "Naming Reference Express error in MetaMeta Define.";
            String typeVarName = null;
            String typeFunction = null;
            String pkPropName = null;
            for (int j = 0; j < exps.length; ++j) {
                String[] kvs = exps[j].split("=");
                assert (kvs.length == 2) : "Naming Reference Express error in MetaMeta Define.";
                if ("type".equalsIgnoreCase(kvs[0])) {
                    typeVarName = kvs[1];
                    continue;
                }
                if ("pk".equalsIgnoreCase(kvs[0])) {
                    pkPropName = kvs[1];
                    continue;
                }
                if (!"typeFn".equalsIgnoreCase(kvs[0])) continue;
                typeFunction = kvs[1];
            }
            String pkValue = null;
            if (pkPropName.startsWith("$")) {
                pkPropName = pkPropName.substring(1);
                pkValue = vo.getString(pkPropName);
            } else assert (false) : "MetadaPK Ref must be begin with $.";
            BOSTypeExp typeExpValue = null;
            for (int num = 0; num < tasks.length; ++num) {
                RefactorTask task = tasks[num];
                if (!task.oldName.getFullName().equals(pkValue)) continue;
                if (typeExpValue == null) {
                    String typeStringValue = null;
                    typeStringValue = typeVarName.startsWith("$") ? vo.getString(typeVarName.substring(1)) : typeVarName;
                    typeExpValue = new BOSTypeExp(typeFunction, typeStringValue);
                }
                if (!typeExpValue.match(task.oldName.getMetaDataType())) continue;
                vo.put(pkPropName, task.expectName.getFullName());
                isModify = true;
            }
        }
        return isModify;
    }

    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"C:\\Documents and Settings\\Jerry\\runtime-New_configuration\\mp\\metadata");
        RefactorManager.foo(ctx);
        RefactorTask[] task = new RefactorTask[]{new RefactorTask(new MetaDataInfo(MetaDataPK.create("foo.EE"), MetaDataTypeList.BIZENUM), MetaDataPK.create("foo.EE2")), new RefactorTask(new MetaDataInfo(MetaDataPK.create("foo.E1"), MetaDataTypeList.ENTITY), MetaDataPK.create("foo.E2"))};
        PackageCtrl pc = new PackageCtrl(ctx);
        MetaDataCollection metas = pc.getMetaDatas();
        RefactorManager fm = new RefactorManager(ctx);
        fm.rename(metas, task);
        System.out.println("rename ok");
    }

    private static void foo(Context ctx) {
        String[] ctrls = new String[]{"com.kingdee.bos.metadata.data.DataTableCtrl", "com.kingdee.bos.metadata.data.AbstractTableCtrl", "com.kingdee.bos.metadata.data.CrossTableCtrl", "com.kingdee.bos.metadata.data.ExtendedTableCtrl", "com.kingdee.bos.metadata.management.SolutionCtrl", "com.kingdee.bos.metadata.management.application.AppViewCtrl", "com.kingdee.bos.metadata.resource.BizEnumCtrl", "com.kingdee.bos.metadata.resource.BizExceptionCtrl", "com.kingdee.bos.metadata.resource.BizDataTypeCtrl", "com.kingdee.bos.metadata.management.PackageCtrl", "com.kingdee.bos.metadata.entity.EntityObjectCtrl", "com.kingdee.bos.metadata.bizrule.RuleSetCtrl", "com.kingdee.bos.metadata.bizunit.BizUnitCtrl", "com.kingdee.bos.metadata.bizunit.BizTemplateCtrl", "com.kingdee.bos.metadata.bizunit.BizFieldTemplateSetCtrl", "com.kingdee.bos.metadata.datax.DataXCtrl", "com.kingdee.bos.metadata.report.ReportCtrl", "com.kingdee.bos.metadata.ui.UIObjectCtrl", "com.kingdee.bos.metadata.facade.FacadeCtrl", "com.kingdee.bos.workflow.wfdesigner.WorkFlowCtrl", "com.kingdee.bos.metadata.entity.RelationshipCtrl", "com.kingdee.bos.metadata.function.FunctionObjectCtrl", "com.kingdee.bos.metadata.query.JoinQueryCtrl", "com.kingdee.bos.metadata.query.QueryCtrl", "com.kingdee.bos.metadata.query.UnionQueryCtrl", "com.kingdee.bos.metadata.query.VirtualQueryCtrl", "com.kingdee.bos.metadata.rule.RuleCtrl", "com.kingdee.bos.metadata.bizdata.BusinessDataCtrl", "com.kingdee.bos.metadata.bizjob.BusinessJobCtrl", "com.kingdee.bos.metadata.resource.I18nResourceCtrl", "com.kingdee.bos.metadata.resource.ImageResourceCtrl", "com.kingdee.bos.service.permission.metadata.PermissionCtrl", "com.kingdee.bos.metadata.mdquery.MDQueryCtrl", "com.kingdee.bos.service.mutex.MutexCtrl", "com.kingdee.bos.metadata.event.EventCtrl", "com.kingdee.bos.service.log.define.LogCtrl", "com.kingdee.bos.metadata.bot.BOTMappingCtrl", "com.kingdee.bos.metadata.view.MetaDataBriefViewCtrl", "com.kingdee.bos.metadata.management.BaseTemplateRefSetCtrl", "com.kingdee.bos.metadata.bizrule.RuleSetCtrl", "com.kingdee.bos.metadata.bizunit.BizUnitCtrl", "com.kingdee.bos.metadata.bizunit.BizUnitCtrl", "com.kingdee.bos.metadata.eai.IntegrationCtrl", "com.kingdee.bos.metadata.eai.ApplicationCtrl", "com.kingdee.bos.metadata.eai.ApplicationNodeCtrl"};
        for (int i = 0; i < ctrls.length; ++i) {
            Class[] types = new Class[]{Context.class};
            Object[] paras = new Object[]{ctx};
            try {
                Class<?> clazz = Class.forName(ctrls[i]);
                Constructor<?> c = clazz.getConstructor(types);
                c.newInstance(paras);
                continue;
            }
            catch (Exception _) {
                System.out.println("Load Ctrl Error");
            }
        }
    }
}

