/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mr;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLDAO;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.mr.MetadataParser;
import com.kingdee.bos.metadata.mr.Ref;
import com.kingdee.bos.metadata.mr.TreeNode;
import java.util.Collection;
import java.util.LinkedList;

public class RenameManager {
    private final Context ctx;

    public RenameManager(Context ctx) {
        this.ctx = ctx;
    }

    public synchronized void rename(AbstractMetaDataValue vo, String newname) throws Exception {
        if (MetaDataTypeList.PACKAGE.equals((Object)vo.getBOSType())) {
            return;
        }
        boolean oldIsRM = RelationManager.isEnabled();
        RelationManager.setEnabled(true);
        RelationManager manager = XMLAccessEngine.getRelationManager(this.ctx);
        manager.loadRelation();
        Ref oldRef = MetadataParser.getRefByObject(vo);
        Collection otherRefs = manager.linked(vo);
        LinkedList<AbstractMetaDataValue> otherDocs = new LinkedList<AbstractMetaDataValue>();
        for (TreeNode node : otherRefs) {
            otherDocs.add(MetadataParser.getObjectByRef(this.ctx, node.ref));
        }
        MetaDataPK pk = MetaDataPK.create(newname);
        vo.setPackage(pk.getPackage());
        vo.setName(pk.getName());
        for (AbstractMetaDataValue md : otherDocs) {
            XMLAccessEngine.store(this.ctx, md.getBOSType(), md);
        }
        XMLAccessEngine.store(this.ctx, vo.getBOSType(), vo);
        if (!newname.equals(oldRef.getFullName())) {
            XMLDAO dao = new XMLDAO(vo.getBOSType(), this.ctx);
            dao.delete(MetaDataPK.create(oldRef.getFullName()));
        }
    }

    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)args[0]);
        RelationManager.setEnabled(true);
        RelationManager.setNeedInit(false);
        XMLAccessEngine.getRelationManager(ctx);
        int num = 4;
        AbstractMetaDataValue meta = (AbstractMetaDataValue)XMLAccessEngine.getXMLLoader(ctx).load(MetaDataTypeList.DATATABLE, (IObjectPK)MetaDataPK.create("foo.T_FOO_E1"));
        DataTableInfo dti = (DataTableInfo)meta;
        dti.getColumns().get(1).setName("fp1new");
        RenameManager rem = new RenameManager(ctx);
        System.out.println("pause");
        rem.rename(meta, "foo.T_FOO_E1");
    }
}

