/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mr;

import com.kingdee.bos.metadata.mr.Ref;
import com.kingdee.bos.metadata.mr.TreeNode;
import com.kingdee.bos.metadata.mr.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Tree
implements Serializable {
    private Map nodes = new HashMap();
    private transient Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefRelation(Ref ref, Ref[] reflinks) {
        TreeNode node;
        TreeNode treeNode = node = this.addTreeNode(ref);
        synchronized (treeNode) {
            for (int i = 0; i < reflinks.length; ++i) {
                TreeNode otherNode = this.addTreeNode(reflinks[i]);
                if (!node.addLink(otherNode)) continue;
                otherNode.addReLink(node);
            }
        }
        if (this.isAloneNode(node)) {
            this.pureAlone(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(TreeNode node) {
        if ((node = this.findTreeNode(node)) == null) {
            return;
        }
        TreeNode treeNode = node;
        synchronized (treeNode) {
            ArrayList<TreeNode> needRemove = new ArrayList<TreeNode>();
            Set links = node.links;
            for (TreeNode otherNode : links) {
                otherNode.reLinks.remove(node);
                if (!this.isAloneNode(otherNode)) continue;
                needRemove.add(otherNode);
            }
            this.pureAlone(needRemove);
            this.nodes.remove(node);
        }
    }

    public void deleteRefRelation(Ref ref) {
        this.deleteNode(this.findTreeNode(ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRefRelation(Ref ref, Ref[] newRefs) {
        TreeNode node = this.addTreeNode(ref);
        ArrayList<TreeNode> needRemove = new ArrayList<TreeNode>();
        TreeNode treeNode = node;
        synchronized (treeNode) {
            Set oldNodes = node.links;
            HashSet<TreeNode> newNodes = new HashSet<TreeNode>();
            for (int i = 0; i < newRefs.length; ++i) {
                newNodes.add(new TreeNode(newRefs[i]));
            }
            Collection add = Utils.collectionMinus(newNodes, oldNodes);
            Collection del = Utils.collectionMinus(oldNodes, newNodes);
            if (add.size() == 0 && del.size() == 0) {
                return false;
            }
            for (TreeNode otherNode : add) {
                if (!node.addLink(otherNode = this.addTreeNode(otherNode))) continue;
                otherNode.addReLink(node);
            }
            for (TreeNode otherNode : del) {
                otherNode.reLinks.remove(node);
                node.links.remove(otherNode);
                if (!this.isAloneNode(otherNode)) continue;
                needRemove.add(otherNode);
            }
            if (this.isAloneNode(node)) {
                needRemove.add(node);
            }
        }
        this.pureAlone(needRemove);
        return true;
    }

    protected TreeNode findTreeNode(Ref ref) {
        TreeNode node = new TreeNode(ref);
        return this.findTreeNode(node);
    }

    protected TreeNode findTreeNode(TreeNode node) {
        if (node == null) {
            return null;
        }
        return (TreeNode)this.nodes.get(node);
    }

    protected TreeNode addTreeNode(Ref ref) {
        return this.addTreeNode(new TreeNode(ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeNode addTreeNode(TreeNode node) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nodes.containsKey(node)) {
                node = (TreeNode)this.nodes.get(node);
            } else {
                this.nodes.put(node, node);
            }
        }
        return (TreeNode)this.nodes.get(node);
    }

    private boolean isAloneNode(TreeNode node) {
        return node != null && node.links.size() == 0 && node.reLinks.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pureAlone(Collection needRemove) {
        Map map = this.nodes;
        synchronized (map) {
            for (TreeNode alone : needRemove) {
                this.nodes.remove(alone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pureAlone(TreeNode node) {
        Map map = this.nodes;
        synchronized (map) {
            this.nodes.remove(node);
        }
    }

    public Collection getDirectLinking(Ref ref) {
        TreeNode node = this.findTreeNode(ref);
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        return node.links;
    }

    public Collection getDirectLinked(Ref ref) {
        TreeNode node = this.findTreeNode(ref);
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        return node.reLinks;
    }

    public Collection getAllLinking(Ref ref) {
        TreeNode node = this.findTreeNode(ref);
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet rtv = new HashSet();
        this.computeLinking(node, rtv);
        rtv.remove(node.ref);
        return rtv;
    }

    public Collection getAllLinked(Ref ref) {
        TreeNode node = this.findTreeNode(ref);
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet rtv = new HashSet();
        this.computeLinked(node, rtv);
        rtv.remove(node.ref);
        return rtv;
    }

    public Collection getAllLinking(Ref[] refs) {
        HashSet rtv = new HashSet();
        if (refs != null) {
            int i;
            for (i = 0; i < refs.length; ++i) {
                Ref ref = refs[i];
                TreeNode node = this.findTreeNode(ref);
                if (node == null) continue;
                this.computeLinking(node, rtv);
            }
            for (i = 0; i < refs.length; ++i) {
                rtv.remove(refs[i]);
            }
        }
        return rtv;
    }

    public Collection getAllLinked(Ref[] refs) {
        HashSet rtv = new HashSet();
        if (refs != null) {
            int i;
            for (i = 0; i < refs.length; ++i) {
                Ref ref = refs[i];
                TreeNode node = this.findTreeNode(ref);
                if (node == null) continue;
                this.computeLinked(node, rtv);
            }
            for (i = 0; i < refs.length; ++i) {
                rtv.remove(refs[i]);
            }
        }
        return rtv;
    }

    public Collection getAllRef() {
        HashSet<Ref> rtv = new HashSet<Ref>();
        for (TreeNode node : this.nodes.keySet()) {
            rtv.add(node.ref);
        }
        return rtv;
    }

    private void computeLinking(TreeNode node, Collection bag) {
        if (!bag.contains(node.ref)) {
            bag.add(node.ref);
            for (TreeNode otherNode : node.links) {
                if (bag.contains(otherNode.ref)) continue;
                this.computeLinking(otherNode, bag);
            }
        }
    }

    private void computeLinked(TreeNode node, Collection bag) {
        if (!bag.contains(node.ref)) {
            bag.add(node.ref);
            for (TreeNode otherNode : node.reLinks) {
                if (bag.contains(otherNode.ref)) continue;
                this.computeLinked(otherNode, bag);
            }
        }
    }

    private static void linkRefs(Tree tree, Ref r1, Ref r2) {
        TreeNode node1 = tree.addTreeNode(r1);
        TreeNode node2 = tree.addTreeNode(r2);
        node1.links.add(node2);
        node2.reLinks.add(node1);
    }

    public static Tree deserialize(InputStream is) throws IOException {
        Tree tree = new Tree();
        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF8"));
        String line = null;
        while ((line = r.readLine()) != null) {
            int pos = line.indexOf(" ");
            String str1 = line.substring(0, pos);
            String str2 = line.substring(pos + 1);
            Tree.linkRefs(tree, Tree.string2Ref(str1), Tree.string2Ref(str2));
        }
        return tree;
    }

    public static void serialize(Tree tree, OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF8"));
        for (TreeNode node : tree.nodes.keySet()) {
            String str1 = Tree.ref2String(node.ref) + " ";
            for (TreeNode node2 : node.links) {
                writer.write(str1);
                writer.write(Tree.ref2String(node2.ref));
                writer.newLine();
            }
        }
        writer.flush();
    }

    private static String ref2String(Ref r) {
        return r.getFullName() + "!" + r.getType();
    }

    private static Ref string2Ref(String str) {
        int pos = str.indexOf("!");
        return new Ref(str.substring(0, pos), str.substring(pos + 1));
    }
}

